/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActLadderMoneyFullReductionAtomService;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomReqBO;
import com.tydic.newretail.atom.bo.ActCalculationUniversalAtomRspBO;
import com.tydic.newretail.common.bo.ActDiscountSkuListBO;
import com.tydic.newretail.common.bo.ActTemplateAttrBO;
import com.tydic.newretail.common.bo.SkuCalculationActiveBO;
import com.tydic.newretail.constant.ActCommConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service(value="actLadderMoneyFullReductionAtomService")
public class ActLadderMoneyFullReductionAtomServiceImpl
implements ActLadderMoneyFullReductionAtomService {
    @Override
    public ActCalculationUniversalAtomRspBO calculateLadderMoneyFullReductionPrice(ActCalculationUniversalAtomReqBO atomReqBO) {
        ActCalculationUniversalAtomRspBO rsp = new ActCalculationUniversalAtomRspBO();
        ActDiscountSkuListBO actDiscountSkuListBO = new ActDiscountSkuListBO();
        BigDecimal totalSalePrice = new BigDecimal(0);
        BigDecimal oldDiscountMoney = new BigDecimal(0);
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            totalSalePrice = totalSalePrice.add(bo.getTotalPrice());
            if (null == bo.getDiscountPrice()) continue;
            oldDiscountMoney = oldDiscountMoney.add(bo.getDiscountPrice());
        }
        BigDecimal calculateMoney = totalSalePrice.subtract(oldDiscountMoney);
        BigDecimal discountMoney = new BigDecimal(0);
        if (calculateMoney.compareTo(BigDecimal.ZERO) <= 0) {
            actDiscountSkuListBO.setDiscountMoney(new BigDecimal(0));
            HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
            for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
                skuDiscountMap.put(bo.getSkuId(), new BigDecimal(0));
            }
            actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
            rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
            return rsp;
        }
        BigDecimal feeReachStar = new BigDecimal(0);
        BigDecimal feeReachEnd = new BigDecimal(0);
        BigDecimal feeReachDiscount = new BigDecimal(0);
        Integer isLoopAdd2 = ActCommConstant.isLoopAdd.NO;
        for (ActTemplateAttrBO bo : atomReqBO.getActTemplateBO().getActTemplateAttrBOS()) {
            if ("fee_reach_star".equals(bo.getAttrCode())) {
                feeReachStar = new BigDecimal(bo.getParaValue());
                continue;
            }
            if ("fee_reach_end".equals(bo.getAttrCode())) {
                feeReachEnd = new BigDecimal(bo.getParaValue());
                continue;
            }
            if (!"fee_reach_discount".equals(bo.getAttrCode())) continue;
            feeReachDiscount = new BigDecimal(bo.getParaValue());
        }
        if (calculateMoney.compareTo(feeReachStar) >= 0) {
            discountMoney = calculateMoney.subtract(feeReachStar).compareTo(feeReachDiscount) < 0 ? calculateMoney.subtract(feeReachStar) : feeReachDiscount;
        }
        actDiscountSkuListBO.setDiscountMoney(discountMoney);
        BigDecimal averageDiscountPrice = discountMoney.divide(new BigDecimal(atomReqBO.getSkuInfoList().size()), 2, RoundingMode.UP);
        HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
        BigDecimal alreadyDiscountPrice = discountMoney;
        for (int i = 0; i < atomReqBO.getSkuInfoList().size(); ++i) {
            if (i + 1 == atomReqBO.getSkuInfoList().size()) {
                skuDiscountMap.put(atomReqBO.getSkuInfoList().get(i).getSkuId(), alreadyDiscountPrice);
                break;
            }
            skuDiscountMap.put(atomReqBO.getSkuInfoList().get(i).getSkuId(), averageDiscountPrice);
            alreadyDiscountPrice = alreadyDiscountPrice.subtract(averageDiscountPrice);
        }
        actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
        rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
        return rsp;
    }
}

