/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActOrderJudgeAtomService;
import com.tydic.newretail.atom.bo.ActOrderJudgeAtomReqBO;
import com.tydic.newretail.atom.bo.ActOrderJudgeAtomRspBO;
import com.tydic.newretail.common.bo.SkuDetailBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveAttrMapper;
import com.tydic.newretail.dao.CouponAttrMapper;
import com.tydic.newretail.dao.po.ActiveAttrPO;
import com.tydic.newretail.dao.po.CouponAttrPO;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actOrderJudgeAtomService")
public class ActOrderJudgeAtomServiceImpl
implements ActOrderJudgeAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActOrderJudgeAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private ActiveAttrMapper activeAttrMapper;
    private CouponAttrMapper couponAttrMapper;

    @Autowired
    public ActOrderJudgeAtomServiceImpl(ActiveAttrMapper activeAttrMapper, CouponAttrMapper couponAttrMapper) {
        this.activeAttrMapper = activeAttrMapper;
        this.couponAttrMapper = couponAttrMapper;
    }

    @Override
    public ActOrderJudgeAtomRspBO judgeOrder(ActOrderJudgeAtomReqBO atomReqBO) {
        String preNotice = "\u6d3b\u52a8\u8ba1\u7b97\u8ba2\u5355\u6761\u4ef6\u5224\u65ad\u7ed3\u679c\uff1a";
        ActOrderJudgeAtomRspBO rsp = new ActOrderJudgeAtomRspBO();
        if (!ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID.equals(atomReqBO.getTemplateId())) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug(preNotice + "\u6682\u4e0d\u652f\u6301\u8be5\u6a21\u7248[" + atomReqBO.getTemplateId() + "]\uff01");
            }
            rsp.setRespCode("1008");
            rsp.setRespDesc(preNotice + "\u6682\u4e0d\u652f\u6301\u8be5\u6a21\u7248[" + atomReqBO.getTemplateId() + "]\uff01");
            return rsp;
        }
        if (atomReqBO.getTotalAmount() == null || BigDecimal.ZERO.compareTo(atomReqBO.getTotalAmount()) == 0) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (SkuDetailBO bo : atomReqBO.getSkuDetailList()) {
                totalAmount = totalAmount.add(bo.getSkuPrice().multiply(bo.getSkuNum()));
            }
            atomReqBO.setTotalAmount(totalAmount);
        }
        String attrValue = this.getAttrValue(atomReqBO.getActiveId(), atomReqBO.getAttrType());
        BigDecimal activeStandardValue = new BigDecimal(attrValue);
        BigDecimal mulNum = atomReqBO.getTotalAmount().divide(activeStandardValue, 0, 1);
        if (mulNum.compareTo(BigDecimal.ONE) >= 0) {
            Integer mulCount = mulNum.intValue();
            rsp.setMulCount(mulCount);
            rsp.setRespCode("0000");
            rsp.setRespDesc(preNotice + "\u6d3b\u52a8\u4e2d\u5fc3\u8ba2\u5355\u6761\u4ef6\u5224\u65ad\u539f\u5b50\u670d\u52a1\u6210\u529f\uff01");
            return rsp;
        }
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug(preNotice + "\u5f53\u524d\u8ba2\u5355\u4ef7\u683c\u4e0d\u8db3\u6d3b\u52a8\u914d\u7f6e\u91d1\u989d\u4e00\u500d, \u4e0d\u6ee1\u8db3\u6d3b\u52a8\u6761\u4ef6");
        }
        rsp.setMulCount(0);
        rsp.setRespCode("1011");
        rsp.setRespDesc(preNotice + "\u5f53\u524d\u8ba2\u5355\u4ef7\u683c\u4e0d\u8db3\u6d3b\u52a8\u914d\u7f6e\u91d1\u989d\u4e00\u500d,\u4e0d\u6ee1\u8db3\u6d3b\u52a8\u6761\u4ef6");
        return rsp;
    }

    private String getAttrValue(Long activeId, String attrType) {
        String attrValue;
        if ("coupon".equals(attrType)) {
            CouponAttrPO couponAttrPO = new CouponAttrPO();
            couponAttrPO.setFmId(activeId);
            couponAttrPO.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
            couponAttrPO.setParaCode("total_fee_reach");
            couponAttrPO = this.couponAttrMapper.getModelBy(couponAttrPO);
            if (null == couponAttrPO) {
                throw new BusinessException("1009", "\u6d3b\u52a8\u8ba1\u7b97\u8ba2\u5355\u6761\u4ef6\u5224\u65ad\u7ed3\u679c\uff1a\u672a\u67e5\u8be2\u5230\u6d3b\u52a8[" + activeId + "]\u7684\u6d3b\u52a8\u5c5e\u6027\u4fe1\u606f");
            }
            if (StringUtils.isBlank((CharSequence)couponAttrPO.getParaValue())) {
                throw new BusinessException("1009", "\u6d3b\u52a8\u8ba1\u7b97\u8ba2\u5355\u6761\u4ef6\u5224\u65ad\u7ed3\u679c\uff1a\u672a\u7ed9\u6d3b\u52a8[" + activeId + "]\u914d\u7f6e\u6d3b\u52a8\u5c5e\u6027\u503c");
            }
            attrValue = couponAttrPO.getParaValue();
        } else {
            ActiveAttrPO activeAttrPO = new ActiveAttrPO();
            activeAttrPO.setActiveId(activeId);
            activeAttrPO.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
            activeAttrPO.setParaCode("total_fee_reach");
            activeAttrPO = this.activeAttrMapper.getModelBy(activeAttrPO);
            if (null == activeAttrPO) {
                throw new BusinessException("1009", "\u6d3b\u52a8\u8ba1\u7b97\u8ba2\u5355\u6761\u4ef6\u5224\u65ad\u7ed3\u679c\uff1a\u672a\u67e5\u8be2\u5230\u6d3b\u52a8[" + activeId + "]\u7684\u6d3b\u52a8\u5c5e\u6027\u4fe1\u606f");
            }
            if (StringUtils.isBlank((CharSequence)activeAttrPO.getParaValue())) {
                throw new BusinessException("1009", "\u6d3b\u52a8\u8ba1\u7b97\u8ba2\u5355\u6761\u4ef6\u5224\u65ad\u7ed3\u679c\uff1a\u672a\u7ed9\u6d3b\u52a8[" + activeId + "]\u914d\u7f6e\u6d3b\u52a8\u5c5e\u6027\u503c");
            }
            attrValue = activeAttrPO.getParaValue();
        }
        return attrValue;
    }
}

