/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSON;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.ability.bo.TemplateMessageDataAbilityBO;
import com.tydic.newretail.busi.ActMessageSendBusiService;
import com.tydic.newretail.busi.bo.ActMessageSendBusiReqBO;
import com.tydic.newretail.busi.bo.ActMessageSendBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="actMessageSendBusiService")
public class ActMessageSendBusiServiceImpl
implements ActMessageSendBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActMessageSendBusiServiceImpl.class);
    private final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private static final String WX_FLAG = "wxgzh";
    private static final String SMS_FLAG = "sms";
    private static final String SUCCESS_RESP = "OK";
    private static final String TEMPLATE_PREFIX = "SMS_";
    @Value(value="${SMS_SIGN_NAME}")
    private String signName;
    @Value(value="${SMS_ACCESS_KEY_ID}")
    private String accessKeyId;
    @Value(value="${SMS_ACCESS_KEY_SECRET}")
    private String accessKeySecret;

    public ActMessageSendBusiRspBO sendMsg(ActMessageSendBusiReqBO actMessageSendBusiReqBo) {
        ActMessageSendBusiRspBO rspBo = new ActMessageSendBusiRspBO();
        try {
            if (null != actMessageSendBusiReqBo) {
                if (WX_FLAG.equals(actMessageSendBusiReqBo.getChannelType())) {
                    this.sendMsgByWx(actMessageSendBusiReqBo);
                }
                if (SMS_FLAG.equals(actMessageSendBusiReqBo.getChannelType())) {
                    SendSmsResponse resp = this.sendMsgBySms(actMessageSendBusiReqBo);
                    if (resp.getCode() != null && SUCCESS_RESP.equals(resp.getCode())) {
                        rspBo.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
                        rspBo.setRespCode("0000");
                        rspBo.setRespDesc("\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
                    } else {
                        if (this.isDebugEnabled) {
                            LOGGER.debug("\u7528\u6237" + actMessageSendBusiReqBo.getToUser() + "\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01");
                        }
                        rspBo.setStatus(ActCommConstant.ActivityState.STATE_INVALID);
                        rspBo.setErrMsg(resp.getMessage());
                        rspBo.setRespCode("2005");
                        rspBo.setRespDesc("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u7528\u6237" + actMessageSendBusiReqBo.getToUser() + "\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01" + e);
            throw new BusinessException("2005", "\u53d1\u9001\u6d88\u606f\u901a\u77e5\u670d\u52a1\u51fa\u9519\uff01");
        }
        return rspBo;
    }

    private void sendMsgByWx(ActMessageSendBusiReqBO actMessageSendBusiReqBo) {
    }

    private SendSmsResponse sendMsgBySms(ActMessageSendBusiReqBO actMessageSendBusiReqBo) throws Exception {
        if (this.isDebugEnabled) {
            LOGGER.debug("\u5f00\u59cb\u521d\u59cb\u5316\u963f\u91cc\u77ed\u4fe1\u670d\u52a1\u5165\u53c2=" + JSON.toJSONString((Object)actMessageSendBusiReqBo));
        }
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        String product = "Dysmsapi";
        String domain = "dysmsapi.aliyuncs.com";
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.accessKeyId, (String)this.accessKeySecret);
        DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)"Dysmsapi", (String)"dysmsapi.aliyuncs.com");
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        SendSmsRequest request = new SendSmsRequest();
        request.setMethod(MethodType.POST);
        request.setPhoneNumbers(actMessageSendBusiReqBo.getToUser());
        request.setSignName(new String(this.signName.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8));
        request.setTemplateCode(TEMPLATE_PREFIX + actMessageSendBusiReqBo.getTemplateId().toString());
        List paramList = actMessageSendBusiReqBo.getData();
        StringBuilder str = new StringBuilder();
        for (TemplateMessageDataAbilityBO noticeValueGroupBo : paramList) {
            str.append("\"").append(noticeValueGroupBo.getMessageKey()).append("\":");
            str.append("\"").append(noticeValueGroupBo.getMessageValue()).append("\",");
        }
        String templateParam = "{" + str.substring(0, str.length() - 1) + "}";
        request.setTemplateParam(templateParam);
        if (this.isDebugEnabled) {
            LOGGER.debug("\u5f00\u59cb\u8c03\u7528\u963f\u91cc\u77ed\u4fe1\u53d1\u9001\u670d\u52a1");
        }
        SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
        if (this.isDebugEnabled) {
            LOGGER.debug("\u8c03\u7528\u963f\u91cc\u77ed\u4fe1\u53d1\u9001\u670d\u52a1\u8fd4\u56de=" + JSON.toJSONString((Object)sendSmsResponse));
        }
        return sendSmsResponse;
    }
}

