/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.busi.ActActStartStopBusiService;
import com.tydic.newretail.busi.bo.ActActStartStopBusiReqBO;
import com.tydic.newretail.busi.bo.ActActStartStopBusiRspBO;
import com.tydic.newretail.common.bo.ChooseActivityBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.ShopActiveMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ActivityPO;
import com.tydic.newretail.dao.po.SkuActivePO;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actActStartStopBusiService")
public class ActActStartStopBusiServiceImpl
implements ActActStartStopBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActActStartStopBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    @Autowired
    private SkuActiveMapper skuActiveMapper;
    @Autowired
    private ShopActiveMapper shopActiveMapper;
    @Autowired
    private ActivityMapper activityMapper;

    public ActActStartStopBusiRspBO dealStartStop(ActActStartStopBusiReqBO busiReqBO) {
        ActActStartStopBusiRspBO rsp = new ActActStartStopBusiRspBO();
        for (ChooseActivityBO chooseActivityBO : busiReqBO.getStartStopActivityInfoList()) {
            ActivityPO activityPO = new ActivityPO();
            activityPO.setActiveCode(chooseActivityBO.getActiveCode());
            activityPO.setActiveId(chooseActivityBO.getActiveId());
            activityPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
            activityPO.setAdmOrgId(busiReqBO.getOrgIdIn());
            ActivityPO activity = this.activityMapper.getModelBy(activityPO);
            if (null == activity) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
                }
                throw new BusinessException("14003", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)chooseActivityBO.getSkuActIds())) {
                ActivityPO activePO = new ActivityPO();
                activePO.setActiveId(activity.getActiveId());
                activePO.setActiveStatus(this.startOrStop(busiReqBO.getOperType()));
                activePO.setAdmOrgId(busiReqBO.getOrgIdIn());
                int updateActResult = this.activityMapper.updateById(activePO);
                if (updateActResult >= 1) continue;
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
                }
                throw new BusinessException("14012", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
            }
            SkuActivePO skuActivePO = new SkuActivePO();
            skuActivePO.setActiveId(activity.getActiveId());
            skuActivePO.setSkuActIds(chooseActivityBO.getSkuActIds());
            skuActivePO.setStatus(this.startOrStop(busiReqBO.getOperType()));
            skuActivePO.setAdmOrgId(busiReqBO.getOrgIdIn());
            this.skuActiveMapper.updateByCondition(skuActivePO);
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private Integer startOrStop(Integer operType) {
        Integer status;
        switch (operType) {
            case 0: {
                status = ActCommConstant.ActivityState.STATE_EFFECTIVE;
                break;
            }
            case 1: {
                status = ActCommConstant.ActivityState.STATE_INVALID;
                break;
            }
            default: {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6ca1\u6709\u5bf9\u5e94\u7684\u64cd\u4f5c\u7c7b\u578b\uff01");
                }
                throw new BusinessException("14035", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6ca1\u6709\u5bf9\u5e94\u7684\u64cd\u4f5c\u7c7b\u578b\uff01");
            }
        }
        return status;
    }
}

