/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.comb.impl;

import com.tydic.newretail.busi.ActCouponCalculationBusiService;
import com.tydic.newretail.busi.ActCouponCalculationClassifyBusiService;
import com.tydic.newretail.busi.bo.ActCouponCalculationBusiReqBO;
import com.tydic.newretail.busi.bo.ActCouponCalculationBusiRspBO;
import com.tydic.newretail.busi.bo.ActCouponCalculationClassifyBusiReqBO;
import com.tydic.newretail.busi.bo.ActCouponCalculationClassifyBusiRspBO;
import com.tydic.newretail.comb.ActCouponRecommendCombService;
import com.tydic.newretail.comb.bo.ActCouponRecommendCombReqBO;
import com.tydic.newretail.comb.bo.ActCouponRecommendCombRspBO;
import com.tydic.newretail.common.bo.ActCouponNoRspBO;
import com.tydic.newretail.common.bo.SkuCalculationActiveBO;
import com.tydic.newretail.common.bo.SkuCouponChoiceBO;
import com.tydic.newretail.constant.ActCommConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCouponRecommendCombService")
public class ActCouponRecommendCombServiceImpl
implements ActCouponRecommendCombService {
    @Autowired
    private ActCouponCalculationClassifyBusiService actCouponCalculationClassifyBusiService;
    @Autowired
    private ActCouponCalculationBusiService actCouponCalculationBusiService;

    public ActCouponRecommendCombRspBO orderCouponRecommend(ActCouponRecommendCombReqBO combReqBO) {
        ActCouponRecommendCombRspBO rsp = new ActCouponRecommendCombRspBO();
        ArrayList<ActCouponNoRspBO> rows = new ArrayList<ActCouponNoRspBO>();
        ActCouponCalculationClassifyBusiReqBO actCouponCalculationClassifyBusiReqBO = new ActCouponCalculationClassifyBusiReqBO();
        actCouponCalculationClassifyBusiReqBO.setSkuInfoList(combReqBO.getSkuInfoList());
        actCouponCalculationClassifyBusiReqBO.setCouponNolist(combReqBO.getCouponNolist());
        ActCouponCalculationClassifyBusiRspBO actCouponCalculationClassifyBusiRspBO = this.actCouponCalculationClassifyBusiService.couponCalculatePriceClassify(actCouponCalculationClassifyBusiReqBO);
        if (CollectionUtils.isEmpty((Collection)actCouponCalculationClassifyBusiRspBO.getRows())) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u65e0\u53ef\u7528\u4f18\u60e0\u5377\uff01");
            return rsp;
        }
        ArrayList<SkuCouponChoiceBO> skuCouponChoiceBOList = new ArrayList<SkuCouponChoiceBO>();
        ArrayList<SkuCouponChoiceBO> commodityCouponChoiceBOList = new ArrayList<SkuCouponChoiceBO>();
        ArrayList<SkuCouponChoiceBO> categoryCouponChoiceBOList = new ArrayList<SkuCouponChoiceBO>();
        ArrayList<SkuCouponChoiceBO> shopCouponChoiceBOList = new ArrayList<SkuCouponChoiceBO>();
        ArrayList<SkuCouponChoiceBO> platFormCouponChoiceBOList = new ArrayList<SkuCouponChoiceBO>();
        for (SkuCouponChoiceBO bo : actCouponCalculationClassifyBusiRspBO.getRows()) {
            if (ActCommConstant.CouponLevel.LEVEL_SKU.equals(bo.getCouponLevel())) {
                skuCouponChoiceBOList.add(bo);
                continue;
            }
            if (ActCommConstant.CouponLevel.LEVEL_SHOP.equals(bo.getCouponLevel())) {
                shopCouponChoiceBOList.add(bo);
                continue;
            }
            if (ActCommConstant.CouponLevel.LEVEL_PLATFORM.equals(bo.getCouponLevel())) {
                platFormCouponChoiceBOList.add(bo);
                continue;
            }
            if (ActCommConstant.CouponLevel.SKU_COMMODITY.equals(bo.getCouponLevel())) {
                commodityCouponChoiceBOList.add(bo);
                continue;
            }
            categoryCouponChoiceBOList.add(bo);
        }
        List<ActCouponNoRspBO> skuRows = this.calculateSkuCouponChoice(skuCouponChoiceBOList, combReqBO.getSkuInfoList());
        List<ActCouponNoRspBO> commodityRows = this.calculateSkuCouponChoice(commodityCouponChoiceBOList, combReqBO.getSkuInfoList());
        List<ActCouponNoRspBO> shopRows = this.calculateSkuCouponChoice(shopCouponChoiceBOList, combReqBO.getSkuInfoList());
        List<ActCouponNoRspBO> categoryRows = this.calculateSkuCouponChoice(categoryCouponChoiceBOList, combReqBO.getSkuInfoList());
        List<ActCouponNoRspBO> platFormRows = this.calculateSkuCouponChoice(platFormCouponChoiceBOList, combReqBO.getSkuInfoList());
        rows.addAll(skuRows);
        rows.addAll(commodityRows);
        rows.addAll(shopRows);
        rows.addAll(categoryRows);
        rows.addAll(platFormRows);
        rsp.setRows(rows);
        rsp.setSkuCouponChoiceBOList(skuRows);
        rsp.setCommodityCouponChoiceBOList(commodityRows);
        rsp.setShopCouponChoiceBOList(shopRows);
        rsp.setCategoryCouponChoiceBOList(categoryRows);
        rsp.setPlatFormCouponChoiceBOList(platFormRows);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u8ba2\u5355\u6700\u4f18\u4f18\u60e0\u5238\u7ec4\u5408\u63a8\u8350\u7ec4\u5408\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private List<ActCouponNoRspBO> calculateSkuCouponChoice(List<SkuCouponChoiceBO> skuCouponChoiceBOList, List<SkuCalculationActiveBO> skuInfoList) {
        ArrayList<ActCouponNoRspBO> rows = new ArrayList<ActCouponNoRspBO>();
        for (SkuCouponChoiceBO bo : skuCouponChoiceBOList) {
            ArrayList<SkuCalculationActiveBO> newSkuInfoList = new ArrayList<SkuCalculationActiveBO>();
            for (SkuCalculationActiveBO bo2 : skuInfoList) {
                SkuCalculationActiveBO skuCalculationActiveBO = new SkuCalculationActiveBO();
                BeanUtils.copyProperties((Object)bo2, (Object)skuCalculationActiveBO);
                newSkuInfoList.add(skuCalculationActiveBO);
            }
            ActCouponCalculationBusiReqBO actCouponCalculationBusiReqBO = new ActCouponCalculationBusiReqBO();
            actCouponCalculationBusiReqBO.setSkuInfoList(newSkuInfoList);
            ArrayList<SkuCouponChoiceBO> singleSkuCouponChoiceBOList = new ArrayList<SkuCouponChoiceBO>();
            singleSkuCouponChoiceBOList.add(bo);
            actCouponCalculationBusiReqBO.setCouponSkuInfoBOList(singleSkuCouponChoiceBOList);
            ActCouponCalculationBusiRspBO actCouponCalculationBusiRspBO = this.actCouponCalculationBusiService.couponCalculatePrice(actCouponCalculationBusiReqBO);
            ActCouponNoRspBO actCouponNoRspBO = new ActCouponNoRspBO();
            actCouponNoRspBO.setDiscountType(bo.getDiscountType());
            actCouponNoRspBO.setDiscountValue(bo.getDiscountValue());
            actCouponNoRspBO.setConditionType(bo.getConditionType());
            actCouponNoRspBO.setConditionValue(bo.getConditionValue());
            actCouponNoRspBO.setFmId(((SkuCouponChoiceBO)actCouponCalculationBusiRspBO.getCouponSkuInfoBOList().get(0)).getFmId());
            actCouponNoRspBO.setCouponNo(((SkuCouponChoiceBO)actCouponCalculationBusiRspBO.getCouponSkuInfoBOList().get(0)).getCouponNo());
            if (!CollectionUtils.isEmpty((Collection)((SkuCouponChoiceBO)actCouponCalculationBusiRspBO.getCouponSkuInfoBOList().get(0)).getSkuIdList())) {
                ArrayList<SkuCalculationActiveBO> skuCalculationActiveBOList = new ArrayList<SkuCalculationActiveBO>();
                for (SkuCalculationActiveBO bo3 : actCouponCalculationBusiRspBO.getRows()) {
                    for (String skuId : ((SkuCouponChoiceBO)actCouponCalculationBusiRspBO.getCouponSkuInfoBOList().get(0)).getSkuIdList()) {
                        if (!skuId.equals(bo3.getSkuId())) continue;
                        skuCalculationActiveBOList.add(bo3);
                    }
                }
                actCouponNoRspBO.setSkuInfoList(skuCalculationActiveBOList);
            }
            actCouponNoRspBO.setIsChoice(Integer.valueOf(0));
            actCouponNoRspBO.setTotalDiscountPrice(((SkuCouponChoiceBO)actCouponCalculationBusiRspBO.getCouponSkuInfoBOList().get(0)).getTotalDiscountPrice());
            if (null == actCouponNoRspBO.getTotalDiscountPrice() || actCouponNoRspBO.getTotalDiscountPrice().compareTo(BigDecimal.ZERO) == 0) {
                actCouponNoRspBO.setIsAvailable(Integer.valueOf(0));
                if (CollectionUtils.isEmpty((Collection)actCouponNoRspBO.getSkuInfoList())) {
                    actCouponNoRspBO.setNotAvailableDesc("\u65e0\u53ef\u7528\u5546\u54c1\uff01");
                } else {
                    actCouponNoRspBO.setNotAvailableDesc("\u91d1\u989d\u6216\u6570\u91cf\u4e0d\u8fbe\u6807\uff01");
                }
            } else {
                actCouponNoRspBO.setIsAvailable(Integer.valueOf(1));
            }
            actCouponNoRspBO.setExpTime(bo.getExpTime());
            rows.add(actCouponNoRspBO);
        }
        ActCouponNoRspBO mostActCouponNoRspBO = new ActCouponNoRspBO();
        mostActCouponNoRspBO.setTotalDiscountPrice(new BigDecimal(0));
        for (ActCouponNoRspBO bo4 : rows) {
            if (null == bo4.getTotalDiscountPrice()) continue;
            if (bo4.getTotalDiscountPrice().compareTo(mostActCouponNoRspBO.getTotalDiscountPrice()) == 0 && mostActCouponNoRspBO.getTotalDiscountPrice().compareTo(BigDecimal.ZERO) != 0 && mostActCouponNoRspBO.getExpTime().getTime() > bo4.getExpTime().getTime()) {
                mostActCouponNoRspBO = bo4;
            }
            if (bo4.getTotalDiscountPrice().compareTo(mostActCouponNoRspBO.getTotalDiscountPrice()) <= 0) continue;
            mostActCouponNoRspBO = bo4;
        }
        if (mostActCouponNoRspBO.getTotalDiscountPrice().compareTo(BigDecimal.ZERO) != 0) {
            mostActCouponNoRspBO.setIsChoice(Integer.valueOf(1));
        }
        return rows;
    }
}

