/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheManager;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.active.external.api.umc.bo.ActUmcMemDetailInfoAbilityBO;
import com.tydic.active.external.api.umc.bo.ActUmcMemDetailQueryAbilityReqBO;
import com.tydic.active.external.api.umc.bo.ActUmcMemDetailQueryAbilityRspBO;
import com.tydic.active.external.api.umc.bo.ActUmcReceiveCouponAbilityReqBO;
import com.tydic.active.external.api.umc.bo.ActUmcReceiveCouponAbilityRspBO;
import com.tydic.newretail.busi.ActCouponReceiveBusiService;
import com.tydic.newretail.busi.bo.ActCouponReceiveBusiReqBO;
import com.tydic.newretail.busi.bo.ActCouponReceiveBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActActiveMemJoinNumMapper;
import com.tydic.newretail.dao.ActiveMemRangeMapper;
import com.tydic.newretail.dao.CouponFormMapper;
import com.tydic.newretail.dao.CouponInstMapper;
import com.tydic.newretail.dao.CouponNumMapper;
import com.tydic.newretail.dao.po.ActActiveMemJoinNumPO;
import com.tydic.newretail.dao.po.ActiveMemRangePO;
import com.tydic.newretail.dao.po.CouponFormAndInstPO;
import com.tydic.newretail.dao.po.CouponFormPO;
import com.tydic.newretail.dao.po.CouponInstPO;
import com.tydic.newretail.dao.po.CouponNumPO;
import com.tydic.newretail.facde.ActUmcServiceHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCouponReceiveBusiService")
public class ActCouponReceiveBusiServiceImpl
implements ActCouponReceiveBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCouponReceiveBusiServiceImpl.class);
    @Autowired
    private CouponFormMapper couponFormMapper;
    @Autowired
    private ActActiveMemJoinNumMapper actActiveMemJoinNumMapper;
    @Autowired
    private CouponNumMapper couponNumMapper;
    @Autowired
    private ActiveMemRangeMapper activeMemRangeMapper;
    @Autowired
    private CouponInstMapper couponInstMapper;
    @Autowired
    private ActUmcServiceHolder actUmcServiceHolder;
    @Resource(name="couponNoSequencePager")
    private OrderSequence couponNoSequencePager;
    @Autowired
    private CacheManager cacheManager;

    public ActCouponReceiveBusiRspBO couponReceive(ActCouponReceiveBusiReqBO busiReqBO) {
        ActCouponReceiveBusiRspBO busiRspBO = new ActCouponReceiveBusiRspBO();
        busiReqBO.setMemId(busiReqBO.getMemIdIn());
        CouponFormPO couponFormPO = this.checkcouponForm(busiReqBO);
        this.checkCouponUserRange(busiReqBO, couponFormPO);
        CouponNumPO couponNumPO = this.checkUserReceiveNum(busiReqBO);
        try {
            CouponInstPO couponInstPO = this.insertCouponInst(couponFormPO, busiReqBO.getMemId().toString());
            ActActiveMemJoinNumPO actActiveMemJoinNumPO = new ActActiveMemJoinNumPO();
            actActiveMemJoinNumPO.setMemId(busiReqBO.getMemId().toString());
            actActiveMemJoinNumPO.setActiveId(busiReqBO.getFmId());
            actActiveMemJoinNumPO.setMarketingType("11");
            actActiveMemJoinNumPO.setMemLimitNum(couponNumPO.getMemLimitNum());
            int count1 = this.actActiveMemJoinNumMapper.updateJoinNum(actActiveMemJoinNumPO);
            if (couponNumPO.getMemLimitNum() != null && couponNumPO.getMemLimitNum() != 0 && count1 < 1) {
                throw new BusinessException("14050", "\u4f1a\u5458\u9886\u53d6\u4f18\u60e0\u5238\u5df2\u8fbe\u4e0a\u9650");
            }
            this.callMemCouponReceiveService(couponFormPO, couponInstPO, busiReqBO);
        }
        catch (Exception e) {
            String redisKey = "COUPON_RECEIVE_NUM_PREX_" + couponNumPO.getFmId();
            this.cacheManager.decr(redisKey);
            throw e;
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4f18\u60e0\u5238\u9886\u53d6\u4e1a\u52a1\u670d\u52a1\u6210\u529f");
        return busiRspBO;
    }

    private void callMemCouponReceiveService(CouponFormPO couponFormPO, CouponInstPO couponInstPO, ActCouponReceiveBusiReqBO busiReqBO) {
        ActUmcReceiveCouponAbilityReqBO umcReqBO = new ActUmcReceiveCouponAbilityReqBO();
        umcReqBO.setMemId(busiReqBO.getMemId());
        umcReqBO.setCouponNo(couponInstPO.getCouponNo());
        umcReqBO.setCouponDesc(couponFormPO.getFmDesc());
        umcReqBO.setCouponType(couponInstPO.getCouponType());
        umcReqBO.setExpTime(DateUtils.dateToStrLong((Date)couponInstPO.getExpTime()));
        umcReqBO.setFmId(couponInstPO.getFmId());
        umcReqBO.setCouponValue(couponFormPO.getDiscountValue());
        umcReqBO.setCouponPicUrl(couponFormPO.getImageUrl());
        umcReqBO.setEffTime(DateUtils.dateToStrLong((Date)couponFormPO.getEffTime()));
        umcReqBO.setCouponName(couponFormPO.getFmName());
        umcReqBO.setCouponKind(couponFormPO.getCouponLevel());
        umcReqBO.setCouponMark(couponFormPO.getCouponMark());
        CouponFormAndInstPO couponFormAndInstPO = new CouponFormAndInstPO();
        BeanUtils.copyProperties((Object)couponFormPO, (Object)couponFormAndInstPO);
        couponFormAndInstPO.setCouponInstPO(couponInstPO);
        umcReqBO.setCouponJson(JSON.toJSONString((Object)couponFormAndInstPO));
        ActUmcReceiveCouponAbilityRspBO rspBO = this.actUmcServiceHolder.getActExternalUmcConponService().invokeReceiveCoupon(umcReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new BusinessException("0105", "\u4f18\u60e0\u5238\u9886\u53d6\u539f\u5b50\u670d\u52a1\u8c03\u7528\u5916\u90e8\u670d\u52a1\u5931\u8d25");
        }
    }

    private CouponInstPO insertCouponInst(CouponFormPO couponFormPO, String MemId) {
        CouponInstPO couponInstPO = new CouponInstPO();
        BeanUtils.copyProperties((Object)couponFormPO, (Object)couponInstPO);
        String couponNo = String.valueOf(Sequence.getInstance().nextId());
        couponInstPO.setCouponNo(couponFormPO.getCouponType() + couponNo);
        couponInstPO.setMemId(MemId);
        couponInstPO.setCreateTime(new Date());
        couponInstPO.setReceiveTime(new Date());
        couponInstPO.setAdmOrgId(couponFormPO.getAdmOrgId());
        if (couponFormPO.getDiscountValue() != null) {
            couponInstPO.setCouponValue(Integer.parseInt(couponFormPO.getDiscountValue()));
        }
        couponInstPO.setState(ActCommConstant.CouponState.TO_BE_USED);
        int count = this.couponInstMapper.insert(couponInstPO);
        if (count != 1) {
            throw new BusinessException("14010", "[" + couponInstPO.getCouponNo() + "]\u8be5\u4f18\u60e0\u5238\u5b9e\u4f8b\u521b\u5efa\u5931\u8d25");
        }
        return couponInstPO;
    }

    private CouponFormPO checkcouponForm(ActCouponReceiveBusiReqBO busiReqBO) {
        CouponFormPO reqPO = new CouponFormPO();
        reqPO.setFmId(busiReqBO.getFmId());
        reqPO.setAdmOrgId(busiReqBO.getOrgIdIn());
        CouponFormPO couponFormPO = this.couponFormMapper.selectByPrimaryKey(reqPO);
        if (couponFormPO == null) {
            throw new BusinessException("14003", "\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
        }
        if (new Date().compareTo(couponFormPO.getEffTime()) < 0) {
            throw new BusinessException("14053", "\u6d3b\u52a8\u672a\u5f00\u59cb");
        }
        if (new Date().compareTo(couponFormPO.getExpTime()) > 0) {
            throw new BusinessException("14054", "\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        if (couponFormPO.getState() != ActCommConstant.CouponFormState.AUDIT_PASS) {
            throw new BusinessException("14009", "\u4f18\u60e0\u5238\u72b6\u6001\u9519\u8bef");
        }
        return couponFormPO;
    }

    private CouponNumPO checkUserReceiveNum(ActCouponReceiveBusiReqBO busiReqBO) {
        CouponNumPO couponNumPO = this.couponNumMapper.selectByPrimaryKey(busiReqBO.getFmId());
        if (couponNumPO != null) {
            ActActiveMemJoinNumPO actActiveMemJoinNumPO = new ActActiveMemJoinNumPO();
            actActiveMemJoinNumPO.setActiveId(busiReqBO.getFmId());
            actActiveMemJoinNumPO.setMarketingType("11");
            actActiveMemJoinNumPO.setMemId(busiReqBO.getMemId().toString());
            actActiveMemJoinNumPO.setAdmOrgId(couponNumPO.getAdmOrgId());
            ActActiveMemJoinNumPO joinNumPO = this.actActiveMemJoinNumMapper.selectByRecord(actActiveMemJoinNumPO);
            if (joinNumPO == null) {
                actActiveMemJoinNumPO.setMemId(busiReqBO.getMemId().toString());
                actActiveMemJoinNumPO.setJoinNum(0);
                try {
                    this.actActiveMemJoinNumMapper.insert(actActiveMemJoinNumPO);
                }
                catch (Exception e) {
                    if (e instanceof DuplicateKeyException) {
                        LOGGER.debug("\u522b\u7684\u7ebf\u7a0b\u5df2\u65b0\u589e\u6570\u636e");
                    }
                }
            } else if (couponNumPO.getMemLimitNum() != null && couponNumPO.getMemLimitNum() != 0 && joinNumPO.getJoinNum() >= couponNumPO.getMemLimitNum()) {
                throw new BusinessException("14050", "\u4f1a\u5458\u9886\u53d6\u4f18\u60e0\u5238\u5df2\u8fbe\u4e0a\u9650");
            }
            if (couponNumPO.getTotalNum() != null && couponNumPO.getTotalNum() != 0L) {
                if (couponNumPO.getSendNum() != null && couponNumPO.getSendNum() >= couponNumPO.getTotalNum()) {
                    throw new BusinessException("14049", "\u4f18\u60e0\u5238\u5df2\u62a2\u5b8c");
                }
                String redisKey = "COUPON_RECEIVE_NUM_PREX_" + couponNumPO.getFmId();
                Long couponReceiveNum = this.cacheManager.incr(redisKey);
                if (couponReceiveNum > couponNumPO.getTotalNum()) {
                    this.cacheManager.decr(redisKey);
                    throw new BusinessException("14049", "\u4f18\u60e0\u5238\u5df2\u62a2\u5b8c");
                }
            }
        }
        return couponNumPO;
    }

    private void checkCouponUserRange(ActCouponReceiveBusiReqBO busiReqBO, CouponFormPO couponFormPO) {
        ActUmcMemDetailQueryAbilityReqBO actUmcMemDetailQueryAbilityReqBO = new ActUmcMemDetailQueryAbilityReqBO();
        actUmcMemDetailQueryAbilityReqBO.setMemId(busiReqBO.getMemId());
        ActUmcMemDetailQueryAbilityRspBO rsp = this.actUmcServiceHolder.getActExternalUmcMemBaseInfoService().invokeMemDetailQuery(actUmcMemDetailQueryAbilityReqBO);
        if (null == rsp || !"0000".equals(rsp.getRespCode())) {
            throw new BusinessException("0105", "\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u51fa\u9519");
        }
        ActUmcMemDetailInfoAbilityBO mem = rsp.getActUmcMemDetailInfoAbilityBO();
        if (null == mem) {
            throw new BusinessException("0105", "\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        ActiveMemRangePO activeMemRangePO = new ActiveMemRangePO();
        activeMemRangePO.setActiveId(busiReqBO.getFmId());
        activeMemRangePO.setMarketingType("11");
        List<ActiveMemRangePO> daoList = this.activeMemRangeMapper.getList(activeMemRangePO);
        ArrayList<String> memMark = new ArrayList<String>();
        ArrayList<String> memGroup = new ArrayList<String>();
        ArrayList<String> memLevel = new ArrayList<String>();
        ArrayList<String> newOldMem = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(daoList)) {
            for (ActiveMemRangePO po : daoList) {
                if (po.getMemParamType().equals("12")) {
                    memGroup.add(po.getParamInsCode());
                }
                if (po.getMemParamType().equals("10")) {
                    memLevel.add(po.getParamInsCode());
                }
                if (po.getMemParamType().equals("11")) {
                    memMark.add(po.getParamInsCode());
                }
                if (!po.getMemParamType().equals("13")) continue;
                newOldMem.add(po.getParamInsCode());
            }
        }
        if (!CollectionUtils.isEmpty(memMark)) {
            // empty if block
        }
        if (!CollectionUtils.isEmpty(memGroup)) {
            // empty if block
        }
        if (!CollectionUtils.isEmpty(newOldMem)) {
            if (null == mem.getMemNewOld()) {
                throw new BusinessException("14052", "\u5f53\u524d\u4f1a\u5458\u65e0\u6743\u9886\u53d6\u5f53\u524d\u4f18\u60e0\u5238");
            }
            String newOldMemStr = mem.getMemNewOld().toString();
            if (!newOldMem.contains(newOldMemStr)) {
                throw new BusinessException("14052", "\u5f53\u524d\u4f1a\u5458\u65e0\u6743\u9886\u53d6\u5f53\u524d\u4f18\u60e0\u5238");
            }
        }
        if (!CollectionUtils.isEmpty(memLevel)) {
            if (null == mem.getMemLevel()) {
                throw new BusinessException("14052", "\u5f53\u524d\u4f1a\u5458\u65e0\u6743\u9886\u53d6\u5f53\u524d\u4f18\u60e0\u5238");
            }
            String memLevel1 = mem.getMemLevel().toString();
            if (!memLevel.contains(memLevel1)) {
                throw new BusinessException("14052", "\u5f53\u524d\u4f1a\u5458\u65e0\u6743\u9886\u53d6\u5f53\u524d\u4f18\u60e0\u5238");
            }
        }
    }
}

