/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.timetask.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActDicDictionaryMapper;
import com.tydic.newretail.dao.CouponFormMapper;
import com.tydic.newretail.dao.po.CouponFormPO;
import com.tydic.newretail.dao.po.DicDictionaryPO;
import com.tydic.newretail.timetask.ActUpdateExpCouponTimeTaskService;
import com.tydic.newretail.timetask.bo.ActUpdateExpCouponTimeTaskReqBO;
import com.tydic.newretail.timetask.bo.ActUpdateExpCouponTimeTaskRspBO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actUpdateExpCouponTimeTaskService")
public class ActUpdateExpCouponTimeTaskServiceImpl
implements ActUpdateExpCouponTimeTaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActUpdateExpCouponTimeTaskServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final boolean IS_INFO_ENABLED = LOGGER.isInfoEnabled();
    @Autowired
    private CouponFormMapper couponFormMapper;
    @Autowired
    private ActDicDictionaryMapper actDicDictionaryMapper;
    @Autowired
    private CacheClient cacheService;

    public ActUpdateExpCouponTimeTaskRspBO execute(ActUpdateExpCouponTimeTaskReqBO actUpdateExpCouponTimeTaskReqBO) {
        ActUpdateExpCouponTimeTaskRspBO abilityRspBO = new ActUpdateExpCouponTimeTaskRspBO();
        abilityRspBO.setRespCode("0000");
        abilityRspBO.setRespDesc("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u6210\u529f");
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("==========\u5f00\u59cb\u6267\u884c\u8fc7\u671f\u4f18\u60e0\u5377\u72b6\u6001\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\uff0ccurrentShardValue:[" + actUpdateExpCouponTimeTaskReqBO.getShardingItem() + "]==========");
        }
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        dicDictionaryPO.setPCode("MSC_totalShardCount");
        dicDictionaryPO.setCode("1");
        DicDictionaryPO dictionaryPO = this.actDicDictionaryMapper.getModelByCondition(dicDictionaryPO);
        if (null == dictionaryPO) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u8fd8\u672a\u5728\u5b57\u5178\u4e2d\u914d\u7f6e\u603b\u5206\u7247\u503c");
            }
            return abilityRspBO;
        }
        List<CouponFormPO> couponFormPOList = this.couponFormMapper.selectUpdateExpCouponTimeTask(new Date(), dictionaryPO.getTitle(), actUpdateExpCouponTimeTaskReqBO.getShardingItem());
        if (!CollectionUtils.isEmpty(couponFormPOList)) {
            for (CouponFormPO po : couponFormPOList) {
                String redisKey = "COUPON_RECEIVE_NUM_PREX_" + po.getFmId();
                this.cacheService.delete(redisKey);
                po.setState(ActCommConstant.CouponFormState.ENDED);
                this.couponFormMapper.updateByPrimaryKeySelective(po);
            }
        }
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("==========\u4f18\u60e0\u5238\u8fc7\u671f\u4f18\u60e0\u5377\u72b6\u6001\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0ccurrentShardValue:[" + actUpdateExpCouponTimeTaskReqBO.getShardingItem() + "]==========");
        }
        return abilityRspBO;
    }
}

