/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Locale;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.io.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSessionReuseFTPSClient
extends FTPSClient {
    private static final Logger logger = LoggerFactory.getLogger(SSLSessionReuseFTPSClient.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _retrieveFile(String command, String remote, OutputStream local) throws IOException {
        Socket socket = this._openDataConnection_(command, remote);
        if (socket == null) {
            return false;
        }
        BufferedInputStream input = new BufferedInputStream(socket.getInputStream());
        try {
            Util.copyStream((InputStream)input, (OutputStream)local, (int)this.getBufferSize(), (long)-1L, null, (boolean)false);
        }
        finally {
            Util.closeQuietly((Closeable)input);
            Util.closeQuietly((Socket)socket);
        }
        boolean ok = this.completePendingCommand();
        return ok;
    }

    protected void _prepareDataSocket_(Socket socket) throws IOException {
        if (socket instanceof SSLSocket) {
            SSLSession session = ((SSLSocket)this._socket_).getSession();
            SSLSessionContext context = session.getSessionContext();
            try {
                Field sessionHostPortCache = context.getClass().getDeclaredField("sessionHostPortCache");
                sessionHostPortCache.setAccessible(true);
                Object cache = sessionHostPortCache.get(context);
                Method method = cache.getClass().getDeclaredMethod("put", Object.class, Object.class);
                method.setAccessible(true);
                String key = String.format("%s:%s", socket.getInetAddress().getHostName(), String.valueOf(socket.getPort())).toLowerCase(Locale.ROOT);
                method.invoke(cache, key, session);
            }
            catch (NoSuchFieldException e) {
                logger.warn("No field sessionHostPortCache in SSLSessionContext", (Throwable)e);
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
    }
}

