/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.SimpleColumnWidthStyleStrategy;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.toolkit.constant.ExportConstant;
import com.tydic.newretail.toolkit.util.TKFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TkExcelUtils {
    private static final Logger logger = LoggerFactory.getLogger(TkExcelUtils.class);

    public static List<XSSFRow> readXlsx(String path, int startSheet, int startRow) {
        FileInputStream is = null;
        XSSFWorkbook xssfWorkbook = null;
        ArrayList<XSSFRow> xssfRows = new ArrayList<XSSFRow>();
        try {
            is = new FileInputStream(path);
            xssfWorkbook = new XSSFWorkbook((InputStream)is);
            for (int numSheet = startSheet; numSheet < xssfWorkbook.getNumberOfSheets(); ++numSheet) {
                XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(numSheet);
                if (xssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= xssfSheet.getLastRowNum(); ++rowNum) {
                    XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                    if (xssfRow == null) continue;
                    xssfRows.add(xssfRow);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e.getLocalizedMessage());
            throw new ResourceException("0015", "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", e.getMessage());
        }
        finally {
            try {
                if (null != xssfWorkbook) {
                    xssfWorkbook.close();
                }
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return xssfRows;
    }

    public static List<XSSFRow> readXlsx(String path, int startSheet, int endSheet, int startRow) {
        FileInputStream is = null;
        XSSFWorkbook xssfWorkbook = null;
        ArrayList<XSSFRow> xssfRows = new ArrayList<XSSFRow>();
        try {
            is = new FileInputStream(path);
            xssfWorkbook = new XSSFWorkbook((InputStream)is);
            if (endSheet == 0) {
                endSheet = xssfWorkbook.getNumberOfSheets();
            }
            for (int numSheet = startSheet; numSheet < endSheet; ++numSheet) {
                XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(numSheet);
                if (xssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= xssfSheet.getLastRowNum(); ++rowNum) {
                    XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                    if (xssfRow == null) continue;
                    xssfRows.add(xssfRow);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e.getLocalizedMessage());
            throw new ResourceException("0015", "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", e.getMessage());
        }
        finally {
            try {
                if (null != xssfWorkbook) {
                    xssfWorkbook.close();
                }
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return xssfRows;
    }

    public static List<HSSFRow> readXls(String path, int startSheet, int startRow) {
        FileInputStream is = null;
        HSSFWorkbook hssfWorkbook = null;
        ArrayList<HSSFRow> hssfRows = new ArrayList<HSSFRow>();
        try {
            is = new FileInputStream(path);
            hssfWorkbook = new HSSFWorkbook((InputStream)is);
            for (int numSheet = startSheet; numSheet < hssfWorkbook.getNumberOfSheets(); ++numSheet) {
                HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
                if (hssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    if (hssfRow == null) continue;
                    hssfRows.add(hssfRow);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e.getLocalizedMessage());
            throw new ResourceException("0015", "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", e.getMessage());
        }
        finally {
            try {
                if (null != hssfWorkbook) {
                    hssfWorkbook.close();
                }
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return hssfRows;
    }

    public static List<HSSFRow> readXls(String path, int startSheet, int endSheet, int startRow) {
        FileInputStream is = null;
        HSSFWorkbook hssfWorkbook = null;
        ArrayList<HSSFRow> hssfRows = new ArrayList<HSSFRow>();
        try {
            is = new FileInputStream(path);
            hssfWorkbook = new HSSFWorkbook((InputStream)is);
            if (endSheet == 0) {
                endSheet = hssfWorkbook.getNumberOfSheets();
            }
            for (int numSheet = startSheet; numSheet < endSheet; ++numSheet) {
                HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
                if (hssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    if (hssfRow == null) continue;
                    hssfRows.add(hssfRow);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e.getLocalizedMessage());
            throw new ResourceException("0015", "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", e.getMessage());
        }
        finally {
            try {
                if (null != hssfWorkbook) {
                    hssfWorkbook.close();
                }
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return hssfRows;
    }

    public static String changeCellToString(Cell cell, Boolean isDecimal) {
        String returnValue = "";
        if (null != cell) {
            switch (cell.getCellType()) {
                case 0: {
                    String whatYourWant;
                    if (isDecimal.booleanValue()) {
                        String whatYourWant2;
                        DecimalFormat df = new DecimalFormat("0.00");
                        returnValue = whatYourWant2 = df.format(cell.getNumericCellValue());
                        break;
                    }
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        returnValue = formater.format(date);
                        break;
                    }
                    DecimalFormat df = new DecimalFormat("0");
                    returnValue = whatYourWant = df.format(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    returnValue = cell.getStringCellValue();
                    break;
                }
                case 4: {
                    Boolean booleanValue = cell.getBooleanCellValue();
                    returnValue = booleanValue.toString();
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    returnValue = cell.getCellFormula();
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    logger.error("\u672a\u77e5\u7c7b\u578b");
                }
            }
        }
        return returnValue;
    }

    public static String getSuffix(String path) {
        if (StringUtils.isBlank((String)path)) {
            return null;
        }
        if (path.contains(".")) {
            return path.substring(path.lastIndexOf(".") + 1, path.length());
        }
        return null;
    }

    public static File mergeXlsx(List<File> files) {
        File finalFile = TKFileUtils.createTempFile(".xlsx");
        int i = 0;
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>();
        List<Object> heads = new ArrayList();
        for (File file : files) {
            List list = ((ExcelReaderBuilder)EasyExcel.read((File)file).headRowNumber(Integer.valueOf(i))).sheet(Integer.valueOf(0)).doReadSync();
            if (i == 0) {
                LinkedHashMap linkedHashMap = (LinkedHashMap)list.get(0);
                heads = TkExcelUtils.getHeads(linkedHashMap);
                list.remove(linkedHashMap);
            }
            i = 1;
            datas.addAll(TkExcelUtils.getDatas(list));
        }
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)EasyExcel.write((File)finalFile).registerWriteHandler((WriteHandler)new SimpleColumnWidthStyleStrategy(ExportConstant.EXPORT_DEFAULT_CELL_WIDTH))).sheet().head(heads)).doWrite(datas);
        return finalFile;
    }

    private static List<List<Object>> getDatas(List<LinkedHashMap> list) {
        ArrayList<List<Object>> rspList = new ArrayList<List<Object>>();
        for (LinkedHashMap map : list) {
            ArrayList line = new ArrayList();
            for (Object key : map.keySet()) {
                line.add(map.get(key));
            }
            rspList.add(line);
        }
        return rspList;
    }

    private static Map<Integer, Integer> buildWidthMap(int size) {
        HashMap<Integer, Integer> widthMap = new HashMap<Integer, Integer>(size);
        for (int i = 0; i < size; ++i) {
            widthMap.put(i, ExportConstant.EXPORT_CELL_WIDTH);
        }
        return widthMap;
    }

    private static List<List<String>> getHeads(LinkedHashMap<Integer, String> hashMap) {
        ArrayList<List<String>> heads = new ArrayList<List<String>>();
        for (Integer key : hashMap.keySet()) {
            ArrayList<String> head = new ArrayList<String>();
            head.add(hashMap.get(key));
            heads.add(head);
        }
        return heads;
    }

    private static List<WriteHandler> getCustomWriteHaandlerList() {
        LinkedList list = Lists.newLinkedList();
        list.add(new SimpleColumnWidthStyleStrategy(Integer.valueOf(45)));
        return list;
    }

    public static void main(String[] args) {
        File file1 = new File("/Users/Ario/Desktop/\u91c7\u8d2d\u65e5\u62a5 (1).xlsx");
        File file2 = new File("/Users/Ario/Desktop/\u91c7\u8d2d\u65e5\u62a5 (1) 2.xlsx");
        ArrayList<File> list = new ArrayList<File>();
        list.add(file1);
        list.add(file2);
        File file = TkExcelUtils.mergeXlsx(list);
        System.out.println(file.getPath());
    }
}

