/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.tydic.newretail.toolkit.util.SSLSessionReuseFTPSClient;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import com.tydic.newretail.toolkit.util.TkFtpConfig;
import com.tydic.newretail.toolkit.util.TkNewOssFileUtils;
import com.tydic.newretail.toolkit.util.TkZipUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class TkFtpUtils {
    private static final Logger logger = LoggerFactory.getLogger(TkFtpUtils.class);
    private FTPSClient ftpClient;
    private static final String SEP_SLASH = "/";
    private static final String DOWN_FILE_NAME = "GJZJ_SALES_ALLPROVINCE_DAY_IMEI_RESULT";
    private TkFtpConfig config;
    @Value(value="${OSS_ENDPOINT}")
    private String endpoint;
    @Value(value="${OSS_ACCESSKEY}")
    private String accessKeyId;
    @Value(value="${OSS_ACCESSKEY_SECRET}")
    private String accessKeySecret;
    @Value(value="${OSS_BUCKETNAME}")
    private String bucketName;
    @Value(value="${OSS_ACCESS_URL}")
    private String accessUrl;

    public TkFtpUtils() {
        this.ftpClient = this.login(new TkFtpConfig());
    }

    public TkFtpUtils(TkFtpConfig ftpConfig) {
        this.ftpClient = this.login(ftpConfig);
    }

    private FTPSClient login(TkFtpConfig ftpConfig) {
        if (null != this.ftpClient && this.ftpClient.isConnected()) {
            return this.ftpClient;
        }
        this.config = ftpConfig;
        this.ftpClient = new SSLSessionReuseFTPSClient();
        try {
            this.ftpClient.setAuthValue("TLS");
            this.ftpClient.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
            this.ftpClient.setDefaultTimeout(60000);
            logger.info(">>>>\u5f00\u59cb\u8fde\u63a5ftp\u670d\u52a1\u5668>>>>" + ftpConfig.getHostname() + ":" + ftpConfig.getPort());
            long time1 = System.currentTimeMillis();
            this.ftpClient.connect(ftpConfig.getHostname(), Integer.parseInt(ftpConfig.getPort()));
            this.ftpClient.login(ftpConfig.getUsername(), ftpConfig.getPassword());
            int reply = this.ftpClient.getReplyCode();
            this.ftpClient.setFileTransferMode(10);
            this.ftpClient.setRemoteVerificationEnabled(false);
            this.ftpClient.execPBSZ(0L);
            this.ftpClient.execPROT("P");
            this.ftpClient.enterLocalPassiveMode();
            this.ftpClient.setDataTimeout(180000);
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftpClient.disconnect();
                logger.error(">>>>FTP\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff01>>>>");
                throw new IOException("FTP\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff01");
            }
            logger.info(">>>>ftp\u670d\u52a1\u5668\u8fde\u63a5\u6210\u529f>>>>\uff0c\u8017\u65f6=" + (System.currentTimeMillis() - time1));
        }
        catch (IOException e) {
            logger.error(">>>>FTP\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff01>>>>");
        }
        return this.ftpClient;
    }

    private void disconnectFtp() {
        if (this.ftpClient.isConnected()) {
            try {
                this.ftpClient.disconnect();
            }
            catch (IOException e) {
                logger.error("\u65ad\u5f00\u8fde\u63a5\u5931\u8d25\uff01");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String pathName, String fileName, String originFileName) {
        if (!this.ftpClient.isConnected()) {
            this.login(this.config);
        }
        boolean flag = false;
        InputStream inputStream = null;
        try {
            logger.info(">>>>>\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6>>>>>>");
            File file = new File(originFileName);
            inputStream = new FileInputStream(file);
            this.ftpClient.setFileType(2);
            if (this.CreateDirecroty(pathName)) {
                this.ftpClient.changeWorkingDirectory(pathName);
            }
            this.ftpClient.setBufferSize(0x2000000);
            this.ftpClient.storeFile(fileName, inputStream);
            inputStream.close();
            this.ftpClient.logout();
            flag = true;
            logger.info(">>>>>\u4e0a\u4f20\u6587\u4ef6\u6210\u529f>>>>>>");
            this.ftpUploadOss(file, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(">>>>>\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25>>>>>> {}", (Throwable)e);
        }
        finally {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException e) {
                    logger.error("error {}", (Throwable)e);
                }
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("error {}", (Throwable)e);
                }
            }
        }
        return flag;
    }

    public boolean CreateDirecroty(String remote) throws IOException {
        boolean success;
        block5: {
            success = true;
            String directory = remote;
            if (!remote.endsWith(SEP_SLASH)) {
                directory = directory + SEP_SLASH;
            }
            if (directory.equalsIgnoreCase(SEP_SLASH) || this.changeWorkingDirectory(directory)) break block5;
            success = false;
            int start = 0;
            int end = 0;
            start = directory.startsWith(SEP_SLASH) ? 1 : 0;
            end = directory.indexOf(SEP_SLASH, start);
            String path = "";
            String paths = "";
            while (true) {
                int count = 0;
                String subDirectory = new String(remote.substring(start, end).getBytes("GBK"), StandardCharsets.ISO_8859_1);
                path = path + SEP_SLASH + subDirectory;
                if (!this.changeWorkingDirectory(subDirectory)) {
                    if (this.makeDirectory(subDirectory)) {
                        this.changeWorkingDirectory(subDirectory);
                    } else {
                        logger.info("\u521b\u5efa\u76ee\u5f55[" + subDirectory + "]\u5931\u8d25");
                        if (++count < 4) continue;
                        throw new IOException("\u521b\u5efa\u76ee\u5f55[" + subDirectory + "]\u5931\u8d25");
                    }
                }
                paths = paths + SEP_SLASH + subDirectory;
                start = end + 1;
                if ((end = directory.indexOf(SEP_SLASH, start)) <= start) break;
            }
        }
        return success;
    }

    public boolean existFile(String path) throws IOException {
        boolean flag = false;
        FTPFile[] ftpFileArr = this.ftpClient.listFiles(path);
        if (ftpFileArr.length > 0) {
            flag = true;
        }
        return flag;
    }

    public boolean makeDirectory(String dir) {
        boolean flag = false;
        try {
            flag = this.ftpClient.makeDirectory(dir);
            if (flag) {
                logger.info("\u521b\u5efa\u6587\u4ef6\u5939" + dir + " \u6210\u529f\uff01");
            } else {
                logger.info("\u521b\u5efa\u6587\u4ef6\u5939" + dir + " \u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            logger.error("error {}", (Throwable)e);
        }
        return flag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean changeWorkingDirectory(String directory) {
        boolean flag = true;
        try {
            flag = this.ftpClient.changeWorkingDirectory(directory);
            if (!flag) return flag;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String pathName, String localPath, String fileName) {
        boolean flag = false;
        OutputStream os = null;
        if (fileName == null || "".equals(fileName.trim())) {
            return flag;
        }
        try {
            logger.info("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6");
            if (!this.ftpClient.isConnected()) {
                this.login(this.config);
            }
            this.ftpClient.changeWorkingDirectory(pathName);
            FTPFile[] ftpFiles = this.ftpClient.listFiles();
            System.out.println("\u5217\u51fa\u6587\u4ef6" + ftpFiles.length + "\u4e2a");
            for (FTPFile file : ftpFiles) {
                if (!file.getName().equals(fileName)) continue;
                File localFile = null;
                try {
                    localFile = new File(localPath + SEP_SLASH + file.getName());
                    os = new FileOutputStream(localFile);
                    this.ftpClient.setBufferSize(0x2000000);
                    this.ftpClient.retrieveFile(file.getName(), os);
                    os.close();
                }
                catch (IOException e) {
                    logger.error("\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519 + " + e);
                }
                this.ftpUploadOss(localFile, false);
                break;
            }
            this.ftpClient.logout();
            flag = true;
            logger.info("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25error {}", (Throwable)e);
        }
        finally {
            this.disconnectFtp();
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error("error {}", (Throwable)e);
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String pathName, String localPath) {
        boolean flag = false;
        OutputStream os = null;
        try {
            FTPFile[] ftpFiles;
            logger.info("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6");
            if (!this.ftpClient.isConnected()) {
                this.login(this.config);
            }
            this.ftpClient.changeWorkingDirectory(pathName);
            for (FTPFile file : ftpFiles = this.ftpClient.listFiles()) {
                if (!this.ftpClient.isConnected()) {
                    this.login(this.config);
                }
                File localFile = null;
                try {
                    localFile = new File(localPath + SEP_SLASH + file.getName());
                    os = new FileOutputStream(localFile);
                    this.ftpClient.setBufferSize(0x2000000);
                    this.ftpClient.retrieveFile(file.getName(), os);
                    os.close();
                }
                catch (IOException e) {
                    logger.error("\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519 + " + e);
                }
                this.ftpUploadOss(localFile, false);
            }
            this.ftpClient.logout();
            flag = true;
            logger.info("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25error {}", (Throwable)e);
        }
        finally {
            this.disconnectFtp();
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error("error {}", (Throwable)e);
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPFile[] getFtpFile(String pathName) {
        OutputStream os = null;
        FTPFile[] ftpFiles = null;
        try {
            logger.info("\u5f00\u59cb\u83b7\u53d6\u6587\u4ef6");
            if (!this.ftpClient.isConnected()) {
                this.login(this.config);
            }
            this.ftpClient.changeWorkingDirectory(pathName);
            ftpFiles = this.ftpClient.listFiles();
            logger.info("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25error {}", (Throwable)e);
        }
        finally {
            this.disconnectFtp();
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error("error {}", (Throwable)e);
                }
            }
        }
        return ftpFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(String pathName, String fileName) {
        boolean flag = false;
        try {
            logger.info("\u5f00\u59cb\u5220\u9664\u6587\u4ef6");
            this.ftpClient.changeWorkingDirectory(pathName);
            this.ftpClient.dele(fileName);
            this.ftpClient.logout();
            flag = true;
            logger.info("\u5220\u9664\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25error\uff1a{}", (Throwable)e);
        }
        finally {
            this.disconnectFtp();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFileBatch(String pathName, String fileName) {
        boolean flag = false;
        try {
            logger.info("\u5f00\u59cb\u5220\u9664\u6587\u4ef6");
            this.ftpClient.changeWorkingDirectory(pathName);
            this.ftpClient.dele(fileName);
            flag = true;
            logger.info("\u5220\u9664\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25error\uff1a{}", (Throwable)e);
        }
        return flag;
    }

    public FileOutputStream getOutputStream(String localBaseDir, String remoteFilePath) throws Exception {
        FileOutputStream outputStream = new FileOutputStream(localBaseDir + remoteFilePath);
        this.ftpClient.enterLocalPassiveMode();
        this.ftpClient.retrieveFile(remoteFilePath, (OutputStream)outputStream);
        return outputStream;
    }

    public void startDownFile(String localBaseDir, String remoteFilePath) throws Exception {
        if (this.ftpClient != null) {
            try {
                FileOutputStream outputStream = new FileOutputStream(localBaseDir + remoteFilePath);
                this.ftpClient.enterLocalPassiveMode();
                this.ftpClient.retrieveFile(remoteFilePath, (OutputStream)outputStream);
                outputStream.flush();
                outputStream.close();
            }
            catch (Exception e) {
                logger.error("error {}", (Throwable)e);
            }
        } else {
            logger.info("\u8fde\u63a5FTP\u670d\u52a1\u5668\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String pathName, String fileName, InputStream inputStream) {
        boolean flag = false;
        try {
            this.ftpClient.setFileType(2);
            if (this.CreateDirecroty(pathName)) {
                this.ftpClient.changeWorkingDirectory(pathName);
            }
            this.ftpClient.setBufferSize(0x2000000);
            this.ftpClient.storeFile(fileName, inputStream);
            inputStream.close();
            this.ftpClient.logout();
            flag = true;
            logger.info(">>>>>\u4e0a\u4f20\u6587\u4ef6\u6210\u529f>>>>>>" + pathName + SEP_SLASH + fileName);
        }
        catch (Exception e) {
            logger.error(">>>>>\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25>>>>>>error {}", (Throwable)e);
        }
        finally {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException e) {
                    logger.error("error {}", (Throwable)e);
                }
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("error {}", (Throwable)e);
                }
            }
        }
        return flag;
    }

    public static void main(String[] args) throws Exception {
        try {
            TkFtpConfig ftpConfig = new TkFtpConfig("192.168.20.252", "21", "tyls", "T4tzQh6p7hEZ");
            TkFtpUtils ftp = new TkFtpUtils(ftpConfig);
            long time2 = System.currentTimeMillis();
            ftp.downloadFile("/dm_xls_putin", "/home/admin/tool-kit", "i_20003_DM_01005_20210317_00_000.dat.encryption");
            long time3 = System.currentTimeMillis();
            System.out.println("\u4e0b\u8f7d\u8017\u65f6=" + (time3 - time2));
        }
        catch (Exception e) {
            logger.error("error {}", (Throwable)e);
        }
    }

    private void ftpUploadOss(File file, boolean isUpload) {
        new Thread(() -> {
            logger.info(">>>>>\u5f00\u542fOSS\u4e0a\u4f20\u7ebf\u7a0b>>>>>>");
            try {
                boolean isDelete;
                String date = TkDateUtils.dateToDateStr(new Date());
                String day = date.substring(8);
                String month = date.substring(0, 7);
                String uploadPath = "resfile/fileBack/" + (isUpload ? "upload" : "download") + SEP_SLASH + month + SEP_SLASH + day + SEP_SLASH;
                ArrayList<File> files = new ArrayList<File>();
                files.add(file);
                TkZipUtils.toZips(files, null);
                File zipFile = new File(file.getParent() + SEP_SLASH + file.getName().substring(0, file.getName().lastIndexOf(46)) + ".zip");
                TkNewOssFileUtils.uploadFileToPath(zipFile, uploadPath, TkNewOssFileUtils.getOssConfig());
                if (zipFile.exists() && (isDelete = zipFile.delete())) {
                    System.out.println("\u5220\u9664\u672c\u5730\u6587\u4ef6\u538b\u7f29\u6587\u4ef6\u6210\u529f\uff01");
                }
            }
            catch (Exception e) {
                logger.error(">>>>>OSS\u4e0a\u4f20\u5931\u8d25>>>>>>\u6587\u4ef6\u540d\uff1a" + file.getName() + e);
            }
            logger.info(">>>>>OSS\u4e0a\u4f20\u7ed3\u675f>>>>>>\u6587\u4ef6\u540d\uff1a" + file.getName());
        }).start();
    }

    private boolean ftpUploadPathOss(File file, String Filepath) {
        AtomicBoolean result = new AtomicBoolean(true);
        try {
            boolean isDelete;
            String date = TkDateUtils.dateToDateStr(new Date());
            String day = date.substring(8);
            String month = date.substring(0, 7);
            String uploadPath = "resfile/fileBack/" + Filepath + SEP_SLASH + month + SEP_SLASH + day + SEP_SLASH;
            ArrayList<File> files = new ArrayList<File>();
            files.add(file);
            TkZipUtils.toZips(files, null);
            File zipFile = new File(file.getParent() + SEP_SLASH + file.getName().substring(0, file.getName().lastIndexOf(46)) + ".zip");
            TkNewOssFileUtils.uploadFileToPath(zipFile, uploadPath, TkNewOssFileUtils.getOssConfig());
            if (zipFile.exists() && (isDelete = zipFile.delete())) {
                System.out.println("\u5220\u9664\u672c\u5730\u6587\u4ef6\u538b\u7f29\u6587\u4ef6\u6210\u529f\uff01" + Filepath);
            }
        }
        catch (Exception e) {
            logger.error(">>>>>OSS\u4e0a\u4f20\u5931\u8d25>>>>>>\u6587\u4ef6\u540d\uff1a" + file.getName() + e);
            result.set(false);
        }
        logger.info(">>>>>OSS\u4e0a\u4f20\u7ed3\u675f>>>>>>\u6587\u4ef6\u540d\uff1a" + file.getName());
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean backupDownloadFile(String pathName, final String localPath) {
        boolean flag = false;
        OutputStream os = null;
        try {
            if (!this.ftpClient.isConnected()) {
                this.login(this.config);
            }
            logger.info("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6");
            this.ftpClient.setBufferSize(0x100000);
            this.ftpClient.changeWorkingDirectory(pathName);
            final FTPFile[] ftpFiles = this.ftpClient.listFiles();
            logger.info("\u672c\u6b21\u4e0b\u8f7d\u6587\u4ef6\u6570\u91cf\uff1a" + ftpFiles.length);
            boolean isSud = false;
            boolean allDown = false;
            for (FTPFile file : ftpFiles) {
                if (isSud) {
                    this.login(this.config);
                }
                logger.info("\u4ef6\u540d\u79f0\uff1a{},\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)file.getName(), (Object)pathName);
                System.out.println("\u6587\u4ef6\u540d\u79f0\uff1a" + file.getName());
                if (pathName.contains("xls_putin") && !file.getName().contains(DOWN_FILE_NAME)) continue;
                File localFile = null;
                try {
                    localFile = new File(localPath + SEP_SLASH + file.getName());
                    logger.info("localFile\uff1a" + localFile);
                    os = new FileOutputStream(localFile);
                    this.ftpClient.retrieveFile(file.getName(), os);
                    isSud = false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.error("\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519 + " + e);
                    isSud = true;
                    allDown = true;
                    throw new Exception("\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519");
                }
            }
            logger.info("ftp\u4e0b\u8f7d\u6587\u4ef6\u5b8c\u6bd5,\u672c\u5730\u6587\u4ef6\u5f00\u59cb\u4e0a\u4f20\u5230oss\uff0c\u5e76\u5220\u9664\u672c\u5730\u6587\u4ef6");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (FTPFile file : ftpFiles) {
                        File localFile = new File(localPath + TkFtpUtils.SEP_SLASH + file.getName());
                        if (!TkFtpUtils.this.ftpUploadPathOss(localFile, "backup") || !localFile.exists()) continue;
                        localFile.delete();
                    }
                }
            }).start();
            if (!allDown) {
                logger.info("\u5f00\u59cb\u5220\u9664ftp\u670d\u52a1\u5668\u6587\u4ef6");
                for (FTPFile file : ftpFiles) {
                    this.deleteFileBatch(pathName, file.getName());
                }
            }
            flag = true;
            logger.info("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25error {}", (Throwable)e);
        }
        finally {
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error("error {}", (Throwable)e);
                }
            }
        }
        return flag;
    }

    public void closeFtp() {
        try {
            if (null != this.ftpClient) {
                this.ftpClient.logout();
            }
            this.disconnectFtp();
        }
        catch (IOException e) {
            logger.error("ftp\u5173\u95ed\u5931\u8d25:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

