/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.alibaba.fastjson.JSONObject;
import com.tydic.newretail.toolkit.bo.LocationBO;
import com.tydic.newretail.toolkit.util.TkHttpRequestUtils;
import com.tydic.newretail.toolkit.util.TkPropertiesUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TkMapUtils {
    private static final Logger logger = LoggerFactory.getLogger(TkMapUtils.class);
    private static String url = null;
    private static String key = null;
    private static int i = -1;

    public static LocationBO getLocation(String address) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return null;
        }
        if (null == url) {
            url = TkPropertiesUtils.getProperty("tx.location.url");
        }
        if (null == key) {
            TkMapUtils.locationKey();
        }
        if (StringUtils.isBlank((CharSequence)url) || StringUtils.isBlank((CharSequence)key)) {
            logger.error("\u672a\u914d\u7f6e\u8bf7\u6c42URL\u6216\u5bc6\u94a5");
            return null;
        }
        String reqUrl = url + address + "&key=" + key;
        String rsp = TkHttpRequestUtils.conn("UTF-8", null, null, reqUrl, null, null);
        if (null == rsp) {
            logger.error("\u672a\u83b7\u53d6\u5730\u5740\u89e3\u6790\u54cd\u5e94\u53c2\u6570");
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)rsp);
        if (jsonObject.containsKey((Object)"status") && "121".equals(jsonObject.getString("status"))) {
            TkMapUtils.locationKey();
        }
        if (jsonObject.containsKey((Object)"status") && "120".equals(jsonObject.getString("status"))) {
            LocationBO locationBO = new LocationBO();
            locationBO.setIsOften("00000");
            return locationBO;
        }
        if (!jsonObject.containsKey((Object)"status") || !"0".equals(jsonObject.getString("status"))) {
            logger.error("\u5730\u5740\u89e3\u6790\u5931\u8d25\uff0c\u89e3\u6790\u51fa\u53c2" + jsonObject);
            return null;
        }
        JSONObject jsonRsp = jsonObject.getJSONObject("result");
        LocationBO locationBO = new LocationBO();
        JSONObject location = jsonRsp.getJSONObject("location");
        locationBO.setLat(location.getDouble("lat"));
        locationBO.setLng(location.getDouble("lng"));
        JSONObject adInfo = jsonRsp.getJSONObject("ad_info");
        locationBO.setAdcode(adInfo.getString("adcode"));
        JSONObject addr = jsonRsp.getJSONObject("address_components");
        locationBO.setCity(addr.getString("city"));
        locationBO.setDistrict(addr.getString("district"));
        locationBO.setProvince(addr.getString("province"));
        locationBO.setStreet(addr.getString("street"));
        locationBO.setStreetNumber(addr.getString("street_number"));
        return locationBO;
    }

    public static LocationBO getLocation(String lat, String lng) {
        if (null == url) {
            url = TkPropertiesUtils.getProperty("tx.inverse.location.url");
        }
        if (null == key) {
            TkMapUtils.locationKey();
        }
        JSONObject json = new JSONObject();
        json.put("location", (Object)(lat + "," + lng));
        json.put("key", (Object)key);
        String rsp = TkHttpRequestUtils.httpPost(url, json.toJSONString());
        if (null == rsp) {
            logger.error("\u672a\u83b7\u53d6\u5730\u5740\u89e3\u6790\u54cd\u5e94\u53c2\u6570");
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)rsp);
        if (jsonObject.containsKey((Object)"status") && "121".equals(jsonObject.getString("status"))) {
            TkMapUtils.locationKey();
        }
        if (!jsonObject.containsKey((Object)"status") || !"0".equals(jsonObject.getString("status"))) {
            logger.error("\u5730\u5740\u89e3\u6790\u5931\u8d25\uff0c\u89e3\u6790\u51fa\u53c2" + jsonObject);
            return null;
        }
        JSONObject jsonRsp = jsonObject.getJSONObject("result");
        LocationBO locationBO = new LocationBO();
        JSONObject location = jsonRsp.getJSONObject("location");
        locationBO.setLat(location.getDouble("lat"));
        locationBO.setLng(location.getDouble("lng"));
        JSONObject adInfo = jsonRsp.getJSONObject("ad_info");
        locationBO.setAdcode(adInfo.getString("adcode"));
        JSONObject addr = jsonRsp.getJSONObject("address_component");
        locationBO.setCity(addr.getString("city"));
        locationBO.setDistrict(addr.getString("district"));
        locationBO.setProvince(addr.getString("province"));
        locationBO.setStreet(addr.getString("street"));
        locationBO.setStreetNumber(addr.getString("street_number"));
        return locationBO;
    }

    private static void locationKey() {
        String txLocationKey = TkPropertiesUtils.getProperty("tx.location.key");
        String[] split = txLocationKey.split("\\|");
        if (++i >= split.length) {
            i = 0;
        }
        key = split[i];
    }

    public static void main(String[] args) {
        url = "https://apis.map.qq.com/ws/geocoder/v1/?address=";
        key = "3FSBZ-PEB6V-ZCXPS-UYO5V-HYVIF-IOFIC";
        LocationBO locationBO = TkMapUtils.getLocation("\u798f\u5dde\u4ed3\u5c71\u533a\u9996\u5c71\u8def\u6ee8\u6d77\u5609\u5e74\u534e\u78a7\u6d77\u56edB2\u533a3\u53f7\u697c");
        System.out.println(locationBO);
    }
}

