/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;

public class TkZipUtils {
    private static final int BUFFER_SIZE = 2048;

    public static void toZip(String sourceDir) {
        TkZipUtils.toZip(sourceDir, null, true);
    }

    public static void toZip(String sourceDir, String target) {
        String fileName = new File(sourceDir).getName();
        target = target + "/" + fileName.substring(0, fileName.lastIndexOf(46)) + ".zip";
        TkZipUtils.toZip(sourceDir, target, true);
    }

    public static void toZip(String sourceDir, String targetDir, boolean KeepDirStructure) throws RuntimeException {
        File sourceFile = new File(sourceDir);
        String sourcePath = sourceFile.getParentFile().toString();
        String fileName = sourceFile.getName();
        long start = System.currentTimeMillis();
        ZipOutputStream zos = null;
        try {
            FileOutputStream out = null;
            out = StringUtils.isEmpty((CharSequence)targetDir) ? (sourceFile.isDirectory() ? new FileOutputStream(new File(sourcePath + "/" + fileName + ".zip")) : new FileOutputStream(new File(sourcePath + "/" + fileName.substring(0, fileName.lastIndexOf(46)) + ".zip"))) : new FileOutputStream(new File(targetDir));
            zos = new ZipOutputStream(out);
            TkZipUtils.compress(sourceFile, zos, sourceFile.getName(), KeepDirStructure);
            long end = System.currentTimeMillis();
            System.out.println("\u538b\u7f29\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (end - start) + " ms");
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void toZips(List<File> srcFiles, String targetDir) throws RuntimeException {
        long start = System.currentTimeMillis();
        FileOutputStream out = null;
        String targetName = "";
        String sourcePath = srcFiles.get(0).getParent();
        ZipOutputStream zos = null;
        try {
            if (StringUtils.isEmpty((CharSequence)targetDir)) {
                if (srcFiles.size() > 0 && srcFiles != null) {
                    targetName = srcFiles.get(srcFiles.size() - 1).getName();
                    targetName = targetName.substring(0, targetName.lastIndexOf(46));
                }
                out = new FileOutputStream(new File(sourcePath + "/" + targetName + ".zip"));
            } else {
                out = new FileOutputStream(new File(targetDir));
            }
            zos = new ZipOutputStream(out);
            for (File srcFile : srcFiles) {
                TkZipUtils.compress(srcFile, zos, srcFile.getName(), true);
            }
            long end = System.currentTimeMillis();
            System.out.println("\u538b\u7f29\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (end - start) + " ms");
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean KeepDirStructure) throws Exception {
        byte[] buf = new byte[2048];
        if (sourceFile.isFile()) {
            int len;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream in = new FileInputStream(sourceFile);
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (KeepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (KeepDirStructure) {
                        TkZipUtils.compress(file, zos, name + "/" + file.getName(), KeepDirStructure);
                        continue;
                    }
                    TkZipUtils.compress(file, zos, file.getName(), KeepDirStructure);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        FileOutputStream fos1 = new FileOutputStream(new File("D:/test.zip"));
        TkZipUtils.toZip("D:/test/\u4ea4\u63a5", null, true);
        ArrayList<File> fileList = new ArrayList<File>();
        fileList.add(new File("D:\\test\\\u4ea4\u63a5"));
        fileList.add(new File("D:\\test\\111.txt"));
        TkZipUtils.toZips(fileList, "D:\\test1111.zip");
    }
}

