/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util.jedis;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Component
public class TkRedisUtils {
    private static final Logger logger = LoggerFactory.getLogger(TkRedisUtils.class);
    private static JedisPool pool;
    private static ObjectMapper objectMapper;
    @Value(value="${redis.host:}")
    private String host;
    @Value(value="${redis.pwd:}")
    private String password;
    @Value(value="${redis.port:6379}")
    private int port;
    @Value(value="${redis.timeout:3000}")
    private int timeout;
    @Value(value="${redis.database:1}")
    private Integer database;
    @Value(value="${redis.pool.maxTotal:20}")
    private Integer maxTotal;
    @Value(value="${redis.pool.maxIdle:20}")
    private Integer maxIdle;
    @Value(value="${redis.pool.maxWaitMillis:3000}")
    private Long maxWaitMillis;
    @Value(value="${redis.pool.testOnBorrow:false}")
    private Boolean testOnBorrow;
    @Value(value="${redis.pool.testOnReturn:false}")
    private Boolean testOnReturn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String key) {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = pool.getResource();
            String string = jedis.get(key);
            return string;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            broken = true;
        }
        finally {
            if (broken) {
                pool.returnBrokenResource((Object)jedis);
            } else if (jedis != null) {
                pool.returnResource(jedis);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getMap(String key) {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = pool.getResource();
            String str = jedis.get(key);
            Map map = (Map)objectMapper.readValue(str, Map.class);
            return map;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            broken = true;
        }
        finally {
            if (broken) {
                pool.returnBrokenResource((Object)jedis);
            } else if (jedis != null) {
                pool.returnResource(jedis);
            }
        }
        return null;
    }

    @PostConstruct
    private void init() {
        if (null != pool) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.host) || StringUtils.isBlank((CharSequence)this.password)) {
            logger.info("\u672a\u914d\u7f6e\u7f13\u5b58\u53c2\u6570");
            return;
        }
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(this.maxIdle.intValue());
        config.setMaxTotal(this.maxTotal.intValue());
        config.setTestOnBorrow(this.testOnBorrow.booleanValue());
        config.setTestOnReturn(this.testOnReturn.booleanValue());
        config.setMaxWaitMillis(this.maxWaitMillis.longValue());
        pool = new JedisPool((GenericObjectPoolConfig)config, this.host, this.port, this.timeout, this.password, this.database.intValue());
        System.out.println("\u521d\u59cb\u5316tk-redis\u5b8c\u6210");
    }

    static {
        objectMapper = new ObjectMapper();
    }
}

