/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util.mq;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.tydic.newretail.toolkit.execption.TkBusinessException;
import com.tydic.newretail.toolkit.util.mq.TkConsumerBService;
import com.tydic.newretail.toolkit.util.mq.TkConsumerConfig;
import com.tydic.newretail.toolkit.util.mq.TkMqConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TkConsumerBUtil {
    private static Logger log = LoggerFactory.getLogger(TkConsumerBUtil.class);
    @Value(value="${tk.mq.enable.b:false}")
    private Boolean enable = null;
    @Value(value="${mq.accessKey.b:}")
    private String ak = null;
    @Value(value="${mq.secretKey.b:}")
    private String sk = null;
    @Value(value="${mq.onsAddr.b:}")
    private String nameServ = null;
    @Value(value="${mq.sendMsgTimeoutMillis.b:}")
    private String timeOut = null;
    private static TkMqConfig tkMqConfig = null;
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public TkMqConfig tkMqBConfig() {
        log.info("----\u521d\u59cb\u5316\u6d88\u8d39\u8005----");
        this.initMqConfig();
        this.init();
        log.info("----\u521d\u59cb\u5316\u6d88\u8d39\u8005\u5b8c\u6210----");
        return tkMqConfig;
    }

    public static TkMqConfig getTkMqConfig() {
        return tkMqConfig;
    }

    private void initMqConfig() {
        if (!this.enable.booleanValue()) {
            log.info("\u672a\u914d\u7f6etk.mq.enable.b\u6216tk.mq.enable.b=false\uff0c\u6d88\u8d39\u8005\u521d\u59cb\u5316\u53d6\u6d88");
            return;
        }
        tkMqConfig = new TkMqConfig(this.enable, this.ak, this.sk, this.nameServ, this.timeOut);
    }

    public void init() {
        if (null == tkMqConfig) {
            log.error("\u672a\u83b7\u53d6mq\u914d\u7f6e\uff0c\u6d88\u8d39\u8005\u521d\u59cb\u5316\u53d6\u6d88");
            return;
        }
        if (null == this.applicationContext) {
            log.error("\u672a\u83b7\u53d6\u4e0a\u4e0b\u6587\uff0c\u6d88\u8d39\u8005\u521d\u59cb\u5316\u53d6\u6d88");
            return;
        }
        Map consumerServiceMap = this.applicationContext.getBeansOfType(TkConsumerBService.class);
        if (MapUtils.isEmpty((Map)consumerServiceMap)) {
            log.error("\u672a\u627e\u5230\u6d88\u8d39\u8005\uff0c\u6d88\u8d39\u8005\u521d\u59cb\u5316\u53d6\u6d88");
            return;
        }
        Iterator consumers = consumerServiceMap.values().iterator();
        HashMap<String, TkConsumerBService> consumerMap = new HashMap<String, TkConsumerBService>();
        final HashMap<String, String> gidMap = new HashMap<String, String>();
        final HashMap<String, String> tagMap = new HashMap<String, String>();
        while (consumers.hasNext()) {
            TkConsumerBService consumer = (TkConsumerBService)consumers.next();
            TkConsumerConfig consumerConfig = consumer.getConsumerConfig();
            if (null == consumerConfig || StringUtils.isBlank((CharSequence)consumerConfig.getGid()) || StringUtils.isBlank((CharSequence)consumerConfig.getTopic())) {
                log.error("\u672a\u83b7\u53d6TOPIC\u6216GID\u914d\u7f6e\uff0c\u672c\u6b21\u521d\u59cb\u5316\u53d6\u6d88");
                continue;
            }
            log.info("GID=" + consumerConfig.getGid() + "\uff0cTOPIC=" + consumerConfig.getTopic());
            consumerMap.put(consumerConfig.getGid(), consumer);
            gidMap.put(consumerConfig.getGid(), consumerConfig.getTopic());
            tagMap.put(consumerConfig.getGid(), consumerConfig.getTag());
        }
        Properties properties = new Properties();
        properties.put("AccessKey", this.ak);
        properties.put("SecretKey", this.sk);
        properties.put("NAMESRV_ADDR", this.nameServ);
        for (final Map.Entry map : consumerMap.entrySet()) {
            properties.put("GROUP_ID", map.getKey());
            properties.put("ConsumerId", map.getKey());
            Consumer consumer = ONSFactory.createConsumer((Properties)properties);
            String tag = (String)tagMap.get(map.getKey());
            if (StringUtils.isEmpty((CharSequence)tag)) {
                tag = "*";
            }
            consumer.subscribe((String)gidMap.get(map.getKey()), tag, new MessageListener(){

                public Action consume(Message message, ConsumeContext context) {
                    try {
                        TkConsumerConfig config = new TkConsumerConfig((String)map.getKey(), (String)gidMap.get(map.getKey()), (String)tagMap.get(map.getKey()));
                        config.setMessageId(message.getMsgID());
                        ((TkConsumerBService)map.getValue()).execute(message.getTag(), TkConsumerBUtil.deserialize(message.getBody()), config);
                    }
                    catch (Exception e) {
                        log.error("\u6d88\u8d39\u8005\u6d88\u8d39\u5f02\u5e38\uff1a", (Throwable)e);
                        throw new TkBusinessException("0033", "\u6d88\u8d39\u5f02\u5e38");
                    }
                    return Action.CommitMessage;
                }
            });
            consumer.start();
        }
    }

    public static Object deserialize(byte[] bytes) {
        if (TkConsumerBUtil.isEmpty(bytes)) {
            return null;
        }
        try {
            return new String(bytes);
        }
        catch (Exception e) {
            log.error("\u53c2\u6570\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
    }

    public static boolean isEmpty(byte[] data) {
        return data == null || data.length == 0;
    }
}

