/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util.mq;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.tydic.newretail.toolkit.bo.TkLogBO;
import com.tydic.newretail.toolkit.execption.TkBusinessException;
import com.tydic.newretail.toolkit.util.mq.TkConsumerUtil;
import com.tydic.newretail.toolkit.util.mq.TkMqConfig;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TkProducerUtil {
    private static final Logger logger = LoggerFactory.getLogger(TkProducerUtil.class);
    private static final Boolean isDebug = logger.isDebugEnabled();
    private static Producer producer = null;

    public static SendResult send(TkMqConfig tkMqConfig, String topic, String gid, String tag, Object obj) {
        if (null == tkMqConfig) {
            tkMqConfig = TkConsumerUtil.getTkMqConfig();
        }
        if (null == tkMqConfig) {
            logger.error("\u672a\u914d\u7f6emq\u4fe1\u606f");
            throw new TkBusinessException("9999", "\u672a\u914d\u7f6emq\u4fe1\u606f");
        }
        if (StringUtils.isBlank((CharSequence)gid)) {
            logger.error("\u751f\u4ea7\u8005\u5165\u53c2GID\u4e3a\u7a7a");
            throw new TkBusinessException("9999", "\u751f\u4ea7\u8005\u5165\u53c2GID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)topic)) {
            logger.error("\u751f\u4ea7\u8005\u5165\u53c2TOPIC\u4e3a\u7a7a");
            throw new TkBusinessException("9999", "\u751f\u4ea7\u8005\u5165\u53c2TOPIC\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)tag)) {
            tag = "*";
        }
        if (isDebug.booleanValue()) {
            logger.debug("mq\u751f\u4ea7\u8005\u914d\u7f6e\u83b7\u53d6\u6210\u529f\uff0cTOPIC=" + topic + "\uff0cGID=" + gid + "\uff0cTAG=" + tag + "\uff0cACCESS_KEY=" + tkMqConfig.getMqAccessKey() + "\uff0cSECRET_KEY=" + tkMqConfig.getMqSecretKey() + "\uff0cNAME_SERV=" + tkMqConfig.getMqNameServ());
        }
        if (null == producer) {
            TkProducerUtil.setProducer(tkMqConfig);
        }
        if (isDebug.booleanValue()) {
            logger.debug("send start---");
        }
        SendResult sendResult = new SendResult();
        Message msg = new Message(topic, tag, TkProducerUtil.serialize(obj));
        try {
            sendResult = producer.send(msg);
            if (isDebug.booleanValue()) {
                logger.debug(sendResult.toString());
            }
            if (sendResult != null && isDebug.booleanValue()) {
                logger.debug(new Date() + " Send mq message success. Topic is:" + msg.getTopic() + " msgId is: " + sendResult.getMessageId());
            }
        }
        catch (Exception e) {
            logger.error(new Date() + " Send mq message failed. Topic is:" + msg.getTopic() + "\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            throw new TkBusinessException("9999", "\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        }
        return sendResult;
    }

    public static SendResult send(TkMqConfig tkMqConfig, String topic, String gid, String tag, Object obj, Long delayTime) {
        if (null == tkMqConfig) {
            tkMqConfig = TkConsumerUtil.getTkMqConfig();
        }
        if (null == tkMqConfig) {
            logger.error("\u672a\u914d\u7f6emq\u4fe1\u606f");
            throw new TkBusinessException("9999", "\u672a\u914d\u7f6emq\u4fe1\u606f");
        }
        if (StringUtils.isBlank((CharSequence)gid)) {
            logger.error("\u751f\u4ea7\u8005\u5165\u53c2GID\u4e3a\u7a7a");
            throw new TkBusinessException("9999", "\u751f\u4ea7\u8005\u5165\u53c2GID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)topic)) {
            logger.error("\u751f\u4ea7\u8005\u5165\u53c2TOPIC\u4e3a\u7a7a");
            throw new TkBusinessException("9999", "\u751f\u4ea7\u8005\u5165\u53c2TOPIC\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)tag)) {
            tag = "*";
        }
        if (isDebug.booleanValue()) {
            logger.debug("mq\u751f\u4ea7\u8005\u914d\u7f6e\u83b7\u53d6\u6210\u529f\uff0cTOPIC=" + topic + "\uff0cGID=" + gid + "\uff0cTAG=" + tag + "\uff0cACCESS_KEY=" + tkMqConfig.getMqAccessKey() + "\uff0cSECRET_KEY=" + tkMqConfig.getMqSecretKey() + "\uff0cNAME_SERV=" + tkMqConfig.getMqNameServ());
        }
        if (null == producer) {
            TkProducerUtil.setProducer(tkMqConfig);
        }
        if (isDebug.booleanValue()) {
            logger.debug("send start---");
        }
        SendResult sendResult = new SendResult();
        Message msg = new Message(topic, tag, TkProducerUtil.serialize(obj));
        msg.setStartDeliverTime(System.currentTimeMillis() + delayTime);
        try {
            sendResult = producer.send(msg);
            if (isDebug.booleanValue()) {
                logger.debug(sendResult.toString());
            }
            if (sendResult != null && isDebug.booleanValue()) {
                logger.debug(new Date() + " Send mq message success. Topic is:" + msg.getTopic() + " msgId is: " + sendResult.getMessageId());
            }
        }
        catch (Exception e) {
            logger.error(new Date() + " Send mq message failed. Topic is:" + msg.getTopic() + "\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            throw new TkBusinessException("9999", "\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        }
        return sendResult;
    }

    public static SendResult send(TkMqConfig tkMqConfig, String topic, String gid, String tag, Object obj, Date appointTime) {
        if (null == tkMqConfig) {
            tkMqConfig = TkConsumerUtil.getTkMqConfig();
        }
        if (null == tkMqConfig) {
            logger.error("\u672a\u914d\u7f6emq\u4fe1\u606f");
            throw new TkBusinessException("9999", "\u672a\u914d\u7f6emq\u4fe1\u606f");
        }
        if (StringUtils.isBlank((CharSequence)gid)) {
            logger.error("\u751f\u4ea7\u8005\u5165\u53c2GID\u4e3a\u7a7a");
            throw new TkBusinessException("9999", "\u751f\u4ea7\u8005\u5165\u53c2GID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)topic)) {
            logger.error("\u751f\u4ea7\u8005\u5165\u53c2TOPIC\u4e3a\u7a7a");
            throw new TkBusinessException("9999", "\u751f\u4ea7\u8005\u5165\u53c2TOPIC\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)tag)) {
            tag = "*";
        }
        if (isDebug.booleanValue()) {
            logger.debug("mq\u751f\u4ea7\u8005\u914d\u7f6e\u83b7\u53d6\u6210\u529f\uff0cTOPIC=" + topic + "\uff0cGID=" + gid + "\uff0cTAG=" + tag + "\uff0cACCESS_KEY=" + tkMqConfig.getMqAccessKey() + "\uff0cSECRET_KEY=" + tkMqConfig.getMqSecretKey() + "\uff0cNAME_SERV=" + tkMqConfig.getMqNameServ());
        }
        if (null == producer) {
            TkProducerUtil.setProducer(tkMqConfig);
        }
        if (isDebug.booleanValue()) {
            logger.debug("send start---");
        }
        SendResult sendResult = new SendResult();
        Message msg = new Message(topic, tag, TkProducerUtil.serialize(obj));
        msg.setStartDeliverTime(appointTime.getTime());
        try {
            sendResult = producer.send(msg);
            if (isDebug.booleanValue()) {
                logger.debug(sendResult.toString());
            }
            if (sendResult != null && isDebug.booleanValue()) {
                logger.debug(new Date() + " Send mq message success. Topic is:" + msg.getTopic() + " msgId is: " + sendResult.getMessageId());
            }
        }
        catch (Exception e) {
            logger.error(new Date() + " Send mq message failed. Topic is:" + msg.getTopic() + "\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            throw new TkBusinessException("9999", "\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        }
        return sendResult;
    }

    private static void setProducer(TkMqConfig tkMqConfig) {
        Properties properties = new Properties();
        String accessKey = tkMqConfig.getMqAccessKey();
        String secretKey = tkMqConfig.getMqSecretKey();
        String nameServ = tkMqConfig.getMqNameServ();
        String sendMsgTimeoutMillis = tkMqConfig.getMqSendMsgTimeout();
        properties.put("AccessKey", accessKey);
        properties.put("SecretKey", secretKey);
        properties.setProperty("SendMsgTimeoutMillis", sendMsgTimeoutMillis);
        properties.put("NAMESRV_ADDR", nameServ);
        producer = ONSFactory.createProducer((Properties)properties);
        producer.start();
    }

    public static byte[] serialize(Object object) {
        byte[] result = null;
        if (object == null) {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(128);
            try {
                if (!(object instanceof Serializable)) {
                    throw new TkBusinessException("9999", " requires a Serializable payload but received an object of type [" + object.getClass().getName() + "]");
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                result = byteStream.toByteArray();
            }
            catch (Throwable var4) {
                throw new Exception("Failed to serialize", var4);
            }
        }
        catch (Exception var5) {
            logger.error("Failed to serialize", (Throwable)var5);
        }
        return result;
    }

    public static void main(String[] args) {
        TkMqConfig tkMqConfig = new TkMqConfig(true, "LTAI38CH6izuczTV", "ZWtqh1cXrxqFhv2MD9gWltJgvCIqyL", "http://onsaddr.mq-internet-access.mq-internet.aliyuncs.com:80", "1000");
        TkLogBO tkLogBO = new TkLogBO();
        tkLogBO.setBrowser("CHROME");
        tkLogBO.setBusiName("testService");
        tkLogBO.setClassName("com.test.TestService");
        tkLogBO.setIsBusi("1");
        tkLogBO.setIp("127.0.0.1");
        tkLogBO.setMacOs("MACOSX");
        tkLogBO.setOperat("lyj");
        tkLogBO.setReqData("{}");
        tkLogBO.setRspData("{}");
        tkLogBO.setTenantId(Long.valueOf(1L));
        TkProducerUtil.send(tkMqConfig, "UATCAMERA_BODY_ANALYSIS", "GID_UAT_CAMERA_BODY_ANALYSIS_2", "*", tkLogBO);
    }
}

