/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util.snow;

import com.ohaotian.plugin.cache.CacheClient;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;

@Component
public class ShortSequenceUtils
implements ApplicationRunner,
ApplicationListener<ContextRefreshedEvent> {
    private static Long dataWorkId = null;
    private static long sequence = 0L;
    private static long lastTimestamp = -1L;
    @Autowired
    private CacheClient tkRedis;
    private static Long dataCenterId;

    @Value(value="${snow.flake.center.id:0}")
    public void setDataCenterId(Long dataCenterId) {
        ShortSequenceUtils.dataCenterId = dataCenterId;
    }

    public static synchronized long nextId() {
        long timestamp = ShortSequenceUtils.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("\u751f\u6210ID\u5e76\u53d1\u65f6\u95f4\u5c0f\u4e8e\u9600\u503c.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & 0xFL) == 0L) {
                timestamp = ShortSequenceUtils.tilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        lastTimestamp = timestamp;
        return timestamp - 1480166465631L << 10 | ShortSequenceUtils.randomCenterId() << 8 | dataWorkId << 4 | sequence;
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = ShortSequenceUtils.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = ShortSequenceUtils.timeGen();
        }
        return timestamp;
    }

    private static long timeGen() {
        return System.currentTimeMillis();
    }

    public static long randomCenterId() {
        return 0L;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() == null) {
            this.initWorkId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWorkId() {
        if (null != dataWorkId) {
            return;
        }
        String workIdKey = "TK_WORK_ST_ID_" + ShortSequenceUtils.getLinuxLocalIp();
        String workIdCountKey = "TK_WORK_ID_ST_COUNT_" + dataCenterId;
        try (Jedis jedis = null;){
            jedis = this.tkRedis.getJedisPool().getResource();
            long workId = jedis.incrBy(workIdCountKey, 1L);
            jedis.set(workIdKey, String.valueOf(workId));
            System.out.println("\u77ed\u96ea\u82b1\u5e8f\u5217\u5f97\u5230\u7684\u673a\u5668\u7801=" + workId);
            dataWorkId = workId;
            if (workId >= 31L) {
                jedis.del(workIdCountKey);
            }
        }
    }

    public static String getLinuxLocalIp() {
        String ip = "";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                String name = intf.getName();
                if (name.contains("docker") || name.contains("lo")) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String ipaddress;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress().toString()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                    ip = ipaddress;
                    System.out.println(ipaddress);
                }
            }
        }
        catch (SocketException ex) {
            ip = "127.0.0.1";
            ex.printStackTrace();
        }
        return ip;
    }

    public void run(ApplicationArguments args) throws Exception {
        this.initWorkId();
    }
}

