/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.im.bo;

import com.tydic.nicc.common.eums.im.ChatSilentType;
import com.tydic.nicc.common.msg.ImMessage;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;

public class ChatSessionContext
implements Serializable {
    private String tenantCode;
    private String channelCode;
    private int silentLevel;
    private int csSilentLevel;
    private int userSilentLevel;
    private String sessionId;
    private Date startTime;
    private String chatKey;
    private String userId;
    private String csId;
    private Long lastActiveTime;
    private ImMessage lastUserMsg;
    private ImMessage lastCsMsg;

    public SilentInfo getSilentInfo() {
        long nowTime = System.currentTimeMillis();
        long timeout = nowTime - this.lastActiveTime;
        if (ObjectUtils.allNotNull((Object[])new Object[]{this.lastUserMsg, this.lastCsMsg})) {
            if (this.lastUserMsg.getMsgTime() > this.lastCsMsg.getMsgTime()) {
                return new SilentInfo(ChatSilentType.CHAT_CS_SILENT.getType(), timeout);
            }
            return new SilentInfo(ChatSilentType.CHAT_USER_SILENT.getType(), timeout);
        }
        timeout = nowTime - this.startTime.getTime();
        if (this.lastUserMsg != null) {
            return new SilentInfo(ChatSilentType.CHAT_CS_SILENT.getType(), timeout);
        }
        if (this.lastCsMsg != null) {
            return new SilentInfo(ChatSilentType.CHAT_USER_SILENT.getType(), timeout);
        }
        return new SilentInfo(ChatSilentType.CHAT_SILENT.getType(), timeout);
    }

    ChatSessionContext(String tenantCode, String channelCode, int silentLevel, int csSilentLevel, int userSilentLevel, String sessionId, Date startTime, String chatKey, String userId, String csId, Long lastActiveTime, ImMessage lastUserMsg, ImMessage lastCsMsg) {
        this.tenantCode = tenantCode;
        this.channelCode = channelCode;
        this.silentLevel = silentLevel;
        this.csSilentLevel = csSilentLevel;
        this.userSilentLevel = userSilentLevel;
        this.sessionId = sessionId;
        this.startTime = startTime;
        this.chatKey = chatKey;
        this.userId = userId;
        this.csId = csId;
        this.lastActiveTime = lastActiveTime;
        this.lastUserMsg = lastUserMsg;
        this.lastCsMsg = lastCsMsg;
    }

    public static ChatSessionContextBuilder builder() {
        return new ChatSessionContextBuilder();
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public int getSilentLevel() {
        return this.silentLevel;
    }

    public int getCsSilentLevel() {
        return this.csSilentLevel;
    }

    public int getUserSilentLevel() {
        return this.userSilentLevel;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getChatKey() {
        return this.chatKey;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCsId() {
        return this.csId;
    }

    public Long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public ImMessage getLastUserMsg() {
        return this.lastUserMsg;
    }

    public ImMessage getLastCsMsg() {
        return this.lastCsMsg;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public void setSilentLevel(int silentLevel) {
        this.silentLevel = silentLevel;
    }

    public void setCsSilentLevel(int csSilentLevel) {
        this.csSilentLevel = csSilentLevel;
    }

    public void setUserSilentLevel(int userSilentLevel) {
        this.userSilentLevel = userSilentLevel;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setChatKey(String chatKey) {
        this.chatKey = chatKey;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setCsId(String csId) {
        this.csId = csId;
    }

    public void setLastActiveTime(Long lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    public void setLastUserMsg(ImMessage lastUserMsg) {
        this.lastUserMsg = lastUserMsg;
    }

    public void setLastCsMsg(ImMessage lastCsMsg) {
        this.lastCsMsg = lastCsMsg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatSessionContext)) {
            return false;
        }
        ChatSessionContext other = (ChatSessionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSilentLevel() != other.getSilentLevel()) {
            return false;
        }
        if (this.getCsSilentLevel() != other.getCsSilentLevel()) {
            return false;
        }
        if (this.getUserSilentLevel() != other.getUserSilentLevel()) {
            return false;
        }
        Long this$lastActiveTime = this.getLastActiveTime();
        Long other$lastActiveTime = other.getLastActiveTime();
        if (this$lastActiveTime == null ? other$lastActiveTime != null : !((Object)this$lastActiveTime).equals(other$lastActiveTime)) {
            return false;
        }
        String this$tenantCode = this.getTenantCode();
        String other$tenantCode = other.getTenantCode();
        if (this$tenantCode == null ? other$tenantCode != null : !this$tenantCode.equals(other$tenantCode)) {
            return false;
        }
        String this$channelCode = this.getChannelCode();
        String other$channelCode = other.getChannelCode();
        if (this$channelCode == null ? other$channelCode != null : !this$channelCode.equals(other$channelCode)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        String this$chatKey = this.getChatKey();
        String other$chatKey = other.getChatKey();
        if (this$chatKey == null ? other$chatKey != null : !this$chatKey.equals(other$chatKey)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$csId = this.getCsId();
        String other$csId = other.getCsId();
        if (this$csId == null ? other$csId != null : !this$csId.equals(other$csId)) {
            return false;
        }
        ImMessage this$lastUserMsg = this.getLastUserMsg();
        ImMessage other$lastUserMsg = other.getLastUserMsg();
        if (this$lastUserMsg == null ? other$lastUserMsg != null : !this$lastUserMsg.equals(other$lastUserMsg)) {
            return false;
        }
        ImMessage this$lastCsMsg = this.getLastCsMsg();
        ImMessage other$lastCsMsg = other.getLastCsMsg();
        return !(this$lastCsMsg == null ? other$lastCsMsg != null : !this$lastCsMsg.equals(other$lastCsMsg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatSessionContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSilentLevel();
        result = result * 59 + this.getCsSilentLevel();
        result = result * 59 + this.getUserSilentLevel();
        Long $lastActiveTime = this.getLastActiveTime();
        result = result * 59 + ($lastActiveTime == null ? 43 : ((Object)$lastActiveTime).hashCode());
        String $tenantCode = this.getTenantCode();
        result = result * 59 + ($tenantCode == null ? 43 : $tenantCode.hashCode());
        String $channelCode = this.getChannelCode();
        result = result * 59 + ($channelCode == null ? 43 : $channelCode.hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        String $chatKey = this.getChatKey();
        result = result * 59 + ($chatKey == null ? 43 : $chatKey.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $csId = this.getCsId();
        result = result * 59 + ($csId == null ? 43 : $csId.hashCode());
        ImMessage $lastUserMsg = this.getLastUserMsg();
        result = result * 59 + ($lastUserMsg == null ? 43 : $lastUserMsg.hashCode());
        ImMessage $lastCsMsg = this.getLastCsMsg();
        result = result * 59 + ($lastCsMsg == null ? 43 : $lastCsMsg.hashCode());
        return result;
    }

    public String toString() {
        return "ChatSessionContext(tenantCode=" + this.getTenantCode() + ", channelCode=" + this.getChannelCode() + ", silentLevel=" + this.getSilentLevel() + ", csSilentLevel=" + this.getCsSilentLevel() + ", userSilentLevel=" + this.getUserSilentLevel() + ", sessionId=" + this.getSessionId() + ", startTime=" + this.getStartTime() + ", chatKey=" + this.getChatKey() + ", userId=" + this.getUserId() + ", csId=" + this.getCsId() + ", lastActiveTime=" + this.getLastActiveTime() + ", lastUserMsg=" + this.getLastUserMsg() + ", lastCsMsg=" + this.getLastCsMsg() + ")";
    }

    public class SilentInfo {
        private int type;
        private long timeout;

        public int getType() {
            return this.type;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SilentInfo)) {
                return false;
            }
            SilentInfo other = (SilentInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getType() != other.getType()) {
                return false;
            }
            return this.getTimeout() == other.getTimeout();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SilentInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getType();
            long $timeout = this.getTimeout();
            result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
            return result;
        }

        public String toString() {
            return "ChatSessionContext.SilentInfo(type=" + this.getType() + ", timeout=" + this.getTimeout() + ")";
        }

        public SilentInfo(int type, long timeout) {
            this.type = type;
            this.timeout = timeout;
        }
    }

    public static class ChatSessionContextBuilder {
        private String tenantCode;
        private String channelCode;
        private int silentLevel;
        private int csSilentLevel;
        private int userSilentLevel;
        private String sessionId;
        private Date startTime;
        private String chatKey;
        private String userId;
        private String csId;
        private Long lastActiveTime;
        private ImMessage lastUserMsg;
        private ImMessage lastCsMsg;

        ChatSessionContextBuilder() {
        }

        public ChatSessionContextBuilder tenantCode(String tenantCode) {
            this.tenantCode = tenantCode;
            return this;
        }

        public ChatSessionContextBuilder channelCode(String channelCode) {
            this.channelCode = channelCode;
            return this;
        }

        public ChatSessionContextBuilder silentLevel(int silentLevel) {
            this.silentLevel = silentLevel;
            return this;
        }

        public ChatSessionContextBuilder csSilentLevel(int csSilentLevel) {
            this.csSilentLevel = csSilentLevel;
            return this;
        }

        public ChatSessionContextBuilder userSilentLevel(int userSilentLevel) {
            this.userSilentLevel = userSilentLevel;
            return this;
        }

        public ChatSessionContextBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public ChatSessionContextBuilder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public ChatSessionContextBuilder chatKey(String chatKey) {
            this.chatKey = chatKey;
            return this;
        }

        public ChatSessionContextBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public ChatSessionContextBuilder csId(String csId) {
            this.csId = csId;
            return this;
        }

        public ChatSessionContextBuilder lastActiveTime(Long lastActiveTime) {
            this.lastActiveTime = lastActiveTime;
            return this;
        }

        public ChatSessionContextBuilder lastUserMsg(ImMessage lastUserMsg) {
            this.lastUserMsg = lastUserMsg;
            return this;
        }

        public ChatSessionContextBuilder lastCsMsg(ImMessage lastCsMsg) {
            this.lastCsMsg = lastCsMsg;
            return this;
        }

        public ChatSessionContext build() {
            return new ChatSessionContext(this.tenantCode, this.channelCode, this.silentLevel, this.csSilentLevel, this.userSilentLevel, this.sessionId, this.startTime, this.chatKey, this.userId, this.csId, this.lastActiveTime, this.lastUserMsg, this.lastCsMsg);
        }

        public String toString() {
            return "ChatSessionContext.ChatSessionContextBuilder(tenantCode=" + this.tenantCode + ", channelCode=" + this.channelCode + ", silentLevel=" + this.silentLevel + ", csSilentLevel=" + this.csSilentLevel + ", userSilentLevel=" + this.userSilentLevel + ", sessionId=" + this.sessionId + ", startTime=" + this.startTime + ", chatKey=" + this.chatKey + ", userId=" + this.userId + ", csId=" + this.csId + ", lastActiveTime=" + this.lastActiveTime + ", lastUserMsg=" + this.lastUserMsg + ", lastCsMsg=" + this.lastCsMsg + ")";
        }
    }
}

