/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.user.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.tydic.nicc.common.bo.user.OtherUserAuthReqBO;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.eums.user.UserAuthType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.user.mapper.po.UserAuthConfig;
import com.tydic.nicc.user.service.OtherAuthService;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

@Service
public class DicCustAuthService
implements OtherAuthService {
    private static final Logger log = LoggerFactory.getLogger(DicCustAuthService.class);
    @Resource
    private RestApiHelper restApiHelper;

    @Override
    public String authType() {
        return UserAuthType.DIC_CUST.getCode();
    }

    @Override
    public Rsp<UserAuthInfo> otherAuthApi(OtherUserAuthReqBO authReqBO, UserAuthConfig authConfig) {
        if (StringUtils.isNotEmpty((CharSequence)authConfig.getAuthApi())) {
            JSONObject authObj;
            HttpHeaders headers = new HttpHeaders();
            headers.add("auth-token", authReqBO.getExtraData());
            log.info("\u8fea\u6613\u91c7\u7528\u6237\u8ba4\u8bc1:api = {},headers = {}", (Object)authConfig.getAuthApi(), (Object)headers);
            String authResult = this.restApiHelper.get(authConfig.getAuthApi(), "", new HashMap(), headers, new MediaType[0]);
            log.info("\u8fea\u6613\u91c7\u7528\u6237\u8ba4\u8bc1:authResult = {}", (Object)authConfig.getAuthApi(), (Object)headers);
            if (JSONValidator.from((String)authResult).validate() && (authObj = JSONObject.parseObject((String)authResult)).getString("code").equals("0") && authObj.getJSONObject("data") != null) {
                String extUid = authObj.getJSONObject("data").getString("userId");
                if (authReqBO.getExtUid().equals(extUid)) {
                    UserAuthInfo authInfo = new UserAuthInfo();
                    BeanUtils.copyProperties((Object)authReqBO, (Object)authInfo);
                    return BaseRspUtils.createSuccessRsp((Object)authInfo);
                }
            }
        }
        return BaseRspUtils.createErrorRsp((String)"\u8fea\u6613\u91c7\u7528\u6237\u8ba4\u8bc1\u5931\u8d25");
    }
}

