/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.user.util;

import com.tydic.nicc.common.bo.rocketmq.ImUserContext;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.constants.RedisCacheKeyConstant;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.eums.im.ImOnlineStatus;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import com.tydic.nicc.user.config.NiccUserConfigPropertiesBean;
import com.tydic.nicc.user.mapper.po.ImUserInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class ImUserOpHelper {
    private static final Logger log = LoggerFactory.getLogger(ImUserOpHelper.class);
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private KKMqProducerHelper kkMqProducerHelper;
    @Resource
    private NiccUserConfigPropertiesBean niccUserConfigProperties;

    public Map<String, String> getUserStatus(List<String> userIds) {
        LinkedHashMap<String, String> userStatusMap = new LinkedHashMap<String, String>();
        if (userIds != null) {
            for (String userId : userIds) {
                userStatusMap.put(userId, this.getOnlineStatus(userId));
            }
        }
        return userStatusMap;
    }

    public synchronized String getGuestNickName() {
        String startName = this.niccUserConfigProperties.getGuestStartName();
        Integer guestNoCount = this.niccUserConfigProperties.getGuestNoCount();
        Integer count = (Integer)this.redisHelper.get("user:guest:count");
        if (null == count) {
            count = 0;
        }
        int len = String.valueOf(guestNoCount).length();
        int lenNow = String.valueOf(count).length();
        String zero = "";
        for (int i = 0; i < len - lenNow; ++i) {
            zero = zero + "0";
        }
        if (count > this.niccUserConfigProperties.getGuestNoCount()) {
            this.redisHelper.set("user:guest:count", (Object)1);
        } else {
            count = count + 1;
            this.redisHelper.set("user:guest:count", (Object)count);
        }
        return startName + zero + count;
    }

    public void pushUserChange(ImUserInfo userInfo) {
        ImUserContext userContext = new ImUserContext();
        BeanUtils.copyProperties((Object)userInfo, (Object)userContext);
        userContext.setUserSource(userInfo.getCreateSource());
        userContext.setChannel(userInfo.getChannelCode());
        log.info("\u63a8\u9001im\u7528\u6237\u4fe1\u606f\u53d8\u66f4\u6d88\u606f:{}", (Object)userContext);
        this.kkMqProducerHelper.sendMsg("IM_USER_MODIFY", (Object)userContext);
    }

    public void addOnlineGroup(String tenantCode, String group, String userId) {
        String cacheKey = RedisCacheKeyConstant.getUserOnlineGroupKey((String)tenantCode, (String)group);
        this.redisHelper.sSet(cacheKey, new Object[]{userId});
    }

    public void removeOnlineGroup(String tenantCode, String group, String userId) {
        String cacheKey = RedisCacheKeyConstant.getUserOnlineGroupKey((String)tenantCode, (String)group);
        this.redisHelper.setRemove(cacheKey, new Object[]{userId});
    }

    public Set<Object> getOnlineUsers(String tenantCode, String group) {
        String cacheKey = RedisCacheKeyConstant.getUserOnlineGroupKey((String)tenantCode, (String)group);
        return this.redisHelper.sGet(cacheKey);
    }

    public void setDelay(String userId, Integer timeSec) {
        String cacheKey = RedisCacheKeyConstant.getUserDenyStateKey((String)userId);
        if (timeSec != null && timeSec > 0) {
            this.redisHelper.set(cacheKey, (Object)EntityValidType.DELAY.getCode(), (long)timeSec.intValue());
        } else {
            this.redisHelper.set(cacheKey, (Object)EntityValidType.DELAY.getCode());
        }
        this.setOffline("", userId, UserTypeField.COMP_USER.getCode());
    }

    public void setAllow(String userId) {
        String cacheKey = RedisCacheKeyConstant.getUserDenyStateKey((String)userId);
        this.redisHelper.del(new String[]{cacheKey});
    }

    public UserAuthInfo getUser(String userId) {
        String cacheKey = RedisCacheKeyConstant.getUserInfoCacheKey((String)"", (String)userId);
        return (UserAuthInfo)this.redisHelper.get(cacheKey);
    }

    public void cacheUser(UserAuthInfo authInfo) {
        String cacheKey = RedisCacheKeyConstant.getUserInfoCacheKey((String)"", (String)authInfo.getUserId());
        this.redisHelper.set(cacheKey, (Object)authInfo, (long)RedisCacheKeyConstant.USER_INFO_CACHE_TIME.intValue());
    }

    public void clearUserCache(String userId) {
        String infoCacheKey = RedisCacheKeyConstant.getUserInfoCacheKey((String)"", (String)userId);
        this.redisHelper.del(new String[]{infoCacheKey});
    }

    public void setOnline(String tenantCode, String userId, String userType) {
        String cacheKey = RedisCacheKeyConstant.getUserStatusKey((String)"", (String)userId);
        this.redisHelper.set(cacheKey, (Object)ImOnlineStatus.ONLINE.getCode(), 15L);
        if (UserTypeField.COMP_USER.getCode().equals(userType)) {
            this.addOnlineGroup(tenantCode, userType, userId);
        }
    }

    public void setOffline(String tenantCode, String userId, String userType) {
        String cacheKey = RedisCacheKeyConstant.getUserStatusKey((String)"", (String)userId);
        this.redisHelper.del(new String[]{cacheKey});
        if (UserTypeField.COMP_USER.getCode().equals(userType)) {
            this.removeOnlineGroup(tenantCode, userType, userId);
        }
    }

    public String getOnlineStatus(String userId) {
        String cacheKey = RedisCacheKeyConstant.getUserStatusKey((String)"", (String)userId);
        String status = (String)this.redisHelper.get(cacheKey);
        if (StringUtils.isEmpty((CharSequence)status)) {
            status = ImOnlineStatus.OFFLINE.getCode();
        }
        return status;
    }
}

