/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.user.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.common.bo.user.OtherUserAuthReqBO;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.eums.user.UserAuthType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.user.mapper.po.UserAuthConfig;
import com.tydic.nicc.user.service.OtherAuthService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="restApiAuthService")
public class RestApiAuthService
implements OtherAuthService {
    private static final Logger log = LoggerFactory.getLogger(RestApiAuthService.class);
    @Resource
    private RestApiHelper restApiHelper;

    @Override
    public String authType() {
        return UserAuthType.HTTP.getCode();
    }

    public Rsp otherAuthApi(OtherUserAuthReqBO authReqBO, UserAuthConfig authConfig) {
        log.info("\u7b2c\u4e09\u65b9\u8ba4\u8bc1-\u5f00\u59cb:authReqBO = {},authConfig = {}", (Object)authReqBO, (Object)authConfig);
        long startTime = System.currentTimeMillis();
        try {
            String rsp = this.restApiHelper.post(authConfig.getAuthApi(), (Object)authReqBO);
            if (JSONObject.isValid((String)rsp)) {
                JSONObject obj = JSONObject.parseObject((String)rsp);
                long endTime = System.currentTimeMillis();
                if ("0000".equals(obj.getString("rspCode"))) {
                    log.info("\u7b2c\u4e09\u65b9\u8ba4\u8bc1-\u901a\u8fc7:{} ms , {}", (Object)(endTime - startTime), (Object)obj);
                    UserAuthInfo authInfo = (UserAuthInfo)JSONObject.parseObject((String)obj.getString("data"), UserAuthInfo.class);
                    return BaseRspUtils.createSuccessRsp((Object)authInfo, (String)"\u8ba4\u8bc1\u901a\u8fc7");
                }
                log.warn("\u7b2c\u4e09\u65b9\u8ba4\u8bc1-\u5931\u8d25:{} ms , {}", (Object)(endTime - startTime), (Object)rsp);
                return BaseRspUtils.createErrorRsp((String)"\u7b2c\u4e09\u65b9\u8ba4\u8bc1\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u7b2c\u4e09\u65b9\u8ba4\u8bc1-\u5f02\u5e38:{}|{}", new Object[]{authReqBO, authConfig, e});
        }
        return BaseRspUtils.createErrorRsp((String)"\u8ba4\u8bc1\u5931\u8d25:\u670d\u52a1\u5668\u9519\u8bef");
    }
}

