/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.bo.im.core.ImUserAllowReqBO;
import com.tydic.nicc.common.bo.im.core.ImUserDenyReqBO;
import com.tydic.nicc.common.bo.rocketmq.CsImStateChangeContext;
import com.tydic.nicc.common.bo.rocketmq.CsmUserQueueExitContext;
import com.tydic.nicc.common.bo.user.BatchUserAddReqBO;
import com.tydic.nicc.common.bo.user.BatchUserAddRspBO;
import com.tydic.nicc.common.bo.user.GuestUserAddReqBO;
import com.tydic.nicc.common.bo.user.SaveUserInfoReqBO;
import com.tydic.nicc.common.bo.user.UserAccessLogSaveReqBO;
import com.tydic.nicc.common.bo.user.UserAccessLogUpdateReqBO;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.bo.user.UserConditionQueryReqBO;
import com.tydic.nicc.common.bo.user.UserConnectReqBO;
import com.tydic.nicc.common.bo.user.UserOfflineReqBO;
import com.tydic.nicc.common.bo.user.UserOnlineReqBO;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.eums.im.ImChangeStatus;
import com.tydic.nicc.common.eums.im.ImJoinType;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.framework.utils.DesensitizationUtil;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import com.tydic.nicc.user.api.UserAccessLogService;
import com.tydic.nicc.user.api.UserOptionService;
import com.tydic.nicc.user.config.NiccUserConfigPropertiesBean;
import com.tydic.nicc.user.mapper.ImUserInfoMapper;
import com.tydic.nicc.user.mapper.UserConnectRecordMapper;
import com.tydic.nicc.user.mapper.po.ImUserInfo;
import com.tydic.nicc.user.mapper.po.ImUserInfoQueryCondition;
import com.tydic.nicc.user.mapper.po.UserConnectRecord;
import com.tydic.nicc.user.util.ImUserOpHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;

@DS(value="nicc-user")
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class UserOptionServiceImpl
implements UserOptionService {
    private static final Logger log = LoggerFactory.getLogger(UserOptionServiceImpl.class);
    @Resource
    private ImUserOpHelper imUserOpHelper;
    @Resource
    private UserConnectRecordMapper userConnectRecordMapper;
    @Resource
    private ImUserInfoMapper imUserInfoMapper;
    @Resource
    private NiccUserConfigPropertiesBean niccUserConfigPropertiesBean;
    @Resource
    private KKMqProducerHelper kkMqProducerHelper;
    @Resource
    private UserAccessLogService userAccessLogService;

    @MethodParamVerifyEnable
    public Rsp setUserAllow(ImUserAllowReqBO allowReqBO) {
        log.info("\u89e3\u9664im\u7528\u6237\u7981\u7528:{}", (Object)allowReqBO);
        try {
            this.imUserOpHelper.setAllow(allowReqBO.getUserId());
            ImUserInfo update = new ImUserInfo();
            update.setTenantCode(allowReqBO.getTenantCode());
            update.setUpdateTime(new Date());
            update.setUserId(allowReqBO.getUserId());
            update.setStatus(EntityValidType.NORMAL.getIntCode());
            int isUpdate = this.imUserInfoMapper.updateByPrimaryKeySelective(update);
            if (isUpdate > 0) {
                this.imUserOpHelper.pushUserChange(update);
            }
            return BaseRspUtils.createSuccessRsp((Object)allowReqBO.getUserId(), (String)"\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            log.error("\u89e3\u9664im\u7528\u6237\u7981\u7528\u5f02\u5e38:", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        }
    }

    @MethodParamVerifyEnable
    public Rsp setUserDeny(ImUserDenyReqBO denyReqBO) {
        log.info("\u7981\u7528im\u7528\u6237:{}", (Object)denyReqBO);
        try {
            this.imUserOpHelper.setDelay(denyReqBO.getUserId(), denyReqBO.getDenyTimeSec());
            ImUserInfo update = new ImUserInfo();
            update.setTenantCode(denyReqBO.getTenantCode());
            update.setUpdateTime(new Date());
            update.setUserId(denyReqBO.getUserId());
            update.setStatus(EntityValidType.DELAY.getIntCode());
            int isUpdate = this.imUserInfoMapper.updateByPrimaryKeySelective(update);
            if (isUpdate > 0) {
                this.imUserOpHelper.pushUserChange(update);
            }
            return BaseRspUtils.createSuccessRsp((Object)denyReqBO.getUserId(), (String)"\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            log.error("\u7981\u7528im\u7528\u6237\u5f02\u5e38:", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        }
    }

    public void userConnect(UserConnectReqBO connectReqBO) {
        log.info("\u4fdd\u5b58\u7528\u6237\u8fde\u63a5\u4fe1\u606f:{}", (Object)connectReqBO);
        if (connectReqBO.getConnectId() != null) {
            UserConnectRecord record = new UserConnectRecord();
            BeanUtils.copyProperties((Object)connectReqBO, (Object)record);
            record.setPid(connectReqBO.getConnectId());
            this.userConnectRecordMapper.insertSelective(record);
        }
    }

    public Rsp userOnline(UserOnlineReqBO userOnlineReqBO) {
        log.info("\u7528\u6237\u4e0a\u7ebf:{}", (Object)userOnlineReqBO);
        this.imUserOpHelper.clearUserCache(userOnlineReqBO.getUserId());
        this.imUserOpHelper.setOnline(userOnlineReqBO.getTenantCode(), userOnlineReqBO.getUserId(), userOnlineReqBO.getUserType());
        if (userOnlineReqBO.getConnectId() != null) {
            UserConnectRecord record = new UserConnectRecord();
            BeanUtils.copyProperties((Object)userOnlineReqBO, (Object)record);
            record.setPid(userOnlineReqBO.getConnectId());
            record.setOnlineTime(userOnlineReqBO.getOnlineTime());
            record.setAuthRsp(userOnlineReqBO.getAuthRsp());
            this.userConnectRecordMapper.updateSelective(record);
            UserAccessLogSaveReqBO saveReqBO = new UserAccessLogSaveReqBO();
            saveReqBO.setTenantCode(userOnlineReqBO.getTenantCode());
            saveReqBO.setUserId(userOnlineReqBO.getUserId());
            saveReqBO.setUserType(userOnlineReqBO.getUserType());
            this.userAccessLogService.saveAccessLog(saveReqBO);
            if (UserTypeField.COMP_USER.getCode().equals(userOnlineReqBO.getUserType()) && !ImJoinType.MONITOR.getCode().equals(userOnlineReqBO.getJoinType())) {
                CsImStateChangeContext csImStateChangeContext = CsImStateChangeContext.builder().tenantCode(userOnlineReqBO.getTenantCode()).changeState(ImChangeStatus.ONLINE.getCode()).changeTime(new Date()).csId(userOnlineReqBO.getUserId()).build();
                log.info("\u901a\u77e5csm\u5750\u5e2d\u72b6\u6001\u53d8\u66f4-\u4e0a\u7ebf:{}", (Object)csImStateChangeContext);
                this.kkMqProducerHelper.sendMsg("DEV_COMMON", "GID_UAT_CSM_CS_IM_STATE_CHANGE", (Object)csImStateChangeContext);
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u7528\u6237\u4e0a\u7ebf");
    }

    public Rsp userOffline(UserOfflineReqBO userOfflineReqBO) {
        log.info("\u7528\u6237\u4e0b\u7ebf:{}", (Object)userOfflineReqBO);
        this.imUserOpHelper.clearUserCache(userOfflineReqBO.getUserId());
        if (userOfflineReqBO.getConnectId() != null) {
            UserConnectRecord record = new UserConnectRecord();
            record.setPid(userOfflineReqBO.getConnectId());
            record.setTenantCode(userOfflineReqBO.getTenantCode());
            record.setOfflineTime(userOfflineReqBO.getOfflineTime());
            this.userConnectRecordMapper.updateSelective(record);
        }
        if (userOfflineReqBO.getReload() != null && !userOfflineReqBO.getReload().booleanValue()) {
            UserAccessLogUpdateReqBO updateReqBO = new UserAccessLogUpdateReqBO();
            updateReqBO.setTenantCode(userOfflineReqBO.getTenantCode());
            updateReqBO.setOfflineTime(userOfflineReqBO.getOfflineTime());
            updateReqBO.setUserId(userOfflineReqBO.getUserId());
            this.userAccessLogService.updateOfflineTime(updateReqBO);
            if (UserTypeField.COMP_USER.getCode().equals(userOfflineReqBO.getUserType())) {
                CsImStateChangeContext csImStateChangeContext = CsImStateChangeContext.builder().tenantCode(userOfflineReqBO.getTenantCode()).changeState(ImChangeStatus.OFFLINE.getCode()).changeTime(new Date()).csId(userOfflineReqBO.getUserId()).build();
                log.info("\u901a\u77e5csm\u5750\u5e2d\u72b6\u6001\u53d8\u66f4-\u4e0b\u7ebf:{}", (Object)csImStateChangeContext);
                this.kkMqProducerHelper.sendMsg("DEV_COMMON", "GID_UAT_CSM_CS_IM_STATE_CHANGE", (Object)csImStateChangeContext);
            } else {
                CsmUserQueueExitContext queueExitContext = CsmUserQueueExitContext.builder().tenantCode(userOfflineReqBO.getTenantCode()).userId(userOfflineReqBO.getUserId()).build();
                this.kkMqProducerHelper.sendDelayMsg("DEV_COMMON", "GID_UAT_CSM_USER_EXIT_QUEUE", (Object)queueExitContext, this.niccUserConfigPropertiesBean.getOfflineExitQueueDelay());
            }
            this.imUserOpHelper.setOffline(userOfflineReqBO.getTenantCode(), userOfflineReqBO.getUserId(), userOfflineReqBO.getUserType());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u7528\u6237\u4e0b\u7ebf");
    }

    public Rsp getOnlineStatus(String tenantCode, String userId) {
        return BaseRspUtils.createSuccessRsp((Object)this.imUserOpHelper.getOnlineStatus(userId));
    }

    public Rsp getUserAuthInfo(String tenantCode, String userId) {
        Rsp<UserAuthInfo> userInfoRsp = this.getUserInfo("", userId, false);
        if (userInfoRsp.isSuccess()) {
            this.userInfoMasking((UserAuthInfo)userInfoRsp.getData(), this.niccUserConfigPropertiesBean.getUserDataMaskEnable());
        }
        return userInfoRsp;
    }

    public Rsp<UserAuthInfo> getUserAuthInfoByEuid(String tenantCode, String extUid, Integer userType) {
        if (StringUtils.isEmpty((CharSequence)extUid)) {
            return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u67e5\u8be2\u5931\u8d25:exuId\u4e0d\u5f97\u4e3a\u7a7a!");
        }
        ImUserInfo record = new ImUserInfo();
        record.setUserType(userType);
        record.setExtUid(extUid);
        record.setTenantCode(tenantCode);
        ImUserInfo imUser = this.imUserInfoMapper.selectByExUidAndTCode(record);
        if (imUser == null && userType != null) {
            extUid = extUid + "_" + userType;
            record.setExtUid(extUid);
            imUser = this.imUserInfoMapper.selectByExUidAndTCode(record);
        }
        if (imUser != null) {
            UserAuthInfo authInfo = new UserAuthInfo();
            BeanUtils.copyProperties((Object)imUser, (Object)authInfo);
            authInfo.setCallNum(imUser.getCallNum1());
            authInfo.setUserSource(imUser.getCreateSource());
            authInfo.setUserType(String.valueOf(imUser.getUserType()));
            if (StringUtils.isBlank((CharSequence)imUser.getUserAvatar())) {
                if (UserTypeField.COMP_USER.getCode().equals(authInfo.getUserType())) {
                    authInfo.setUserAvatar(this.niccUserConfigPropertiesBean.getCsAvatar());
                } else if (UserTypeField.SYSTEM.getCode().equals(authInfo.getUserType())) {
                    authInfo.setUserAvatar(this.niccUserConfigPropertiesBean.getRobotAvatar());
                } else {
                    authInfo.setUserAvatar(this.niccUserConfigPropertiesBean.getDefaultAvatar());
                }
            }
            if (StringUtils.isEmpty((CharSequence)authInfo.getNickName())) {
                authInfo.setNickName(authInfo.getUserName());
            }
            Rsp onlineRsp = this.getOnlineStatus(tenantCode, imUser.getUserId());
            authInfo.setOnlineStatus((String)onlineRsp.getData());
            return BaseRspUtils.createSuccessRsp((Object)authInfo);
        }
        return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u67e5\u8be2\u5931\u8d25:extUid\u4e0d\u5b58\u5728");
    }

    public Rsp<UserAuthInfo> getUserAuthInfo(String userId, Boolean isMark) {
        return this.getUserAuthInfo(userId, isMark, false);
    }

    public Rsp<UserAuthInfo> getUserAuthInfo(String userId, Boolean isMark, Boolean ignoreStatus) {
        Rsp<UserAuthInfo> userInfoRsp = this.getUserInfo("", userId, ignoreStatus);
        if (userInfoRsp.isSuccess()) {
            this.userInfoMasking((UserAuthInfo)userInfoRsp.getData(), isMark);
        }
        return userInfoRsp;
    }

    private Rsp<UserAuthInfo> getUserInfo(String tenantCode, String userId, Boolean ignoreStatus) {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u67e5\u8be2\u5931\u8d25:userId\u4e0d\u5f97\u4e3a\u7a7a!");
        }
        try {
            Rsp onlineRsp = this.getOnlineStatus(tenantCode, userId);
            UserAuthInfo authInfo = this.imUserOpHelper.getUser(userId);
            if (authInfo == null) {
                ImUserInfo record = new ImUserInfo();
                record.setUserId(userId);
                record.setTenantCode(tenantCode);
                ImUserInfo imUser = this.imUserInfoMapper.selectByUserIdAndTCode(record);
                if (imUser != null) {
                    authInfo = new UserAuthInfo();
                    BeanUtils.copyProperties((Object)imUser, (Object)authInfo);
                    authInfo.setCallNum(imUser.getCallNum1());
                    authInfo.setUserType(String.valueOf(imUser.getUserType()));
                    authInfo.setUserSource(imUser.getCreateSource());
                    if (StringUtils.isBlank((CharSequence)imUser.getUserAvatar())) {
                        if (UserTypeField.COMP_USER.getCode().equals(authInfo.getUserType())) {
                            authInfo.setUserAvatar(this.niccUserConfigPropertiesBean.getCsAvatar());
                        } else if (UserTypeField.SYSTEM.getCode().equals(authInfo.getUserType())) {
                            authInfo.setUserAvatar(this.niccUserConfigPropertiesBean.getRobotAvatar());
                        } else {
                            authInfo.setUserAvatar(this.niccUserConfigPropertiesBean.getDefaultAvatar());
                        }
                    }
                    if (StringUtils.isEmpty((CharSequence)authInfo.getNickName())) {
                        authInfo.setNickName(authInfo.getUserName());
                    }
                    authInfo.setOnlineStatus((String)onlineRsp.getData());
                    this.imUserOpHelper.cacheUser(authInfo);
                }
            } else {
                authInfo.setOnlineStatus((String)onlineRsp.getData());
            }
            if (authInfo != null) {
                if (ignoreStatus.booleanValue()) {
                    return BaseRspUtils.createSuccessRsp((Object)authInfo);
                }
                if (EntityValidType.NORMAL.matchCode(authInfo.getStatus())) {
                    return BaseRspUtils.createSuccessRsp((Object)authInfo);
                }
            }
            return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u5931\u8d25:", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u5931\u8d25:" + e.getMessage()));
        }
    }

    public RspList batchAddUsers(BatchUserAddReqBO batchUserAddReqBO) {
        log.info("\u6279\u91cf\u6dfb\u52a0\u7528\u6237\uff1a{}", (Object)JSON.toJSONString((Object)batchUserAddReqBO));
        if (StringUtils.isBlank((CharSequence)batchUserAddReqBO.getTenantCode())) {
            return BaseRspUtils.createErrorRspList((String)"\u65b0\u589e\u5931\u8d25:\u79df\u6237\u7f16\u7801\u4e0d\u5f97\u4e3a\u7a7a!");
        }
        ArrayList batchList = Lists.newArrayList();
        if (batchUserAddReqBO.getUsers() != null && !batchUserAddReqBO.getUsers().isEmpty()) {
            for (SaveUserInfoReqBO user : batchUserAddReqBO.getUsers()) {
                BatchUserAddRspBO addRspBO = new BatchUserAddRspBO();
                if (StringUtils.isEmpty((CharSequence)user.getExtUid()) || StringUtils.isEmpty((CharSequence)user.getUserId())) {
                    addRspBO.setResult(Boolean.valueOf(false));
                    addRspBO.setResultDesc("extUid|userId \u4e0d\u5f97\u540c\u65f6\u4e3a\u7a7a!");
                }
                ImUserInfo imUserInfo = null;
                if (StringUtils.isBlank((CharSequence)user.getUserId())) {
                    ImUserInfo select = new ImUserInfo();
                    select.setTenantCode(batchUserAddReqBO.getTenantCode());
                    select.setExtUid(user.getExtUid());
                    select.setUserType(user.getUserType());
                    imUserInfo = this.imUserInfoMapper.selectByExUidAndTCode(select);
                } else {
                    imUserInfo = this.imUserInfoMapper.selectByPrimaryKey(user.getUserId());
                }
                int isUpdate = 0;
                if (imUserInfo != null) {
                    ImUserInfo update = new ImUserInfo();
                    BeanUtils.copyProperties((Object)user, (Object)update);
                    update.setUpdateTime(new Date());
                    update.setUserName(user.getName());
                    update.setNickName(user.getNickname());
                    update.setExtData(user.getExtData());
                    update.setExpTime(user.getExpTime());
                    update.setUserId(imUserInfo.getUserId());
                    update.setCreateSource(user.getUserSource());
                    log.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)update));
                    isUpdate = this.imUserInfoMapper.updateByPrimaryKeySelective(update);
                    if (isUpdate > 0) {
                        update.setUserType(imUserInfo.getUserType());
                        update.setTenantCode(imUserInfo.getTenantCode());
                        update.setCreateTime(update.getUpdateTime());
                        this.imUserOpHelper.pushUserChange(update);
                    }
                    addRspBO.setResult(Boolean.valueOf(false));
                    addRspBO.setExtUid(user.getExtUid());
                    addRspBO.setUserId(imUserInfo.getUserId());
                    addRspBO.setExpTime(imUserInfo.getExpTime());
                    addRspBO.setResultDesc("update success!");
                } else {
                    if (StringUtils.isNotBlank((CharSequence)UserTypeField.getNameByCode((String)String.valueOf(user.getUserType())))) {
                        addRspBO.setResult(Boolean.valueOf(false));
                        addRspBO.setResultDesc("userType\u4e0d\u5f97\u4e3a\u7a7a!");
                    }
                    if (StringUtils.isNotBlank((CharSequence)user.getNickname())) {
                        addRspBO.setResult(Boolean.valueOf(false));
                        addRspBO.setResultDesc("nickName\u4e0d\u5f97\u4e3a\u7a7a!");
                    }
                    ImUserInfo save = new ImUserInfo();
                    BeanUtils.copyProperties((Object)user, (Object)save);
                    String userId = NiccCommonUtil.createImUserId((boolean)this.niccUserConfigPropertiesBean.getUidMaskEnable());
                    save.setUserId(userId);
                    save.setTenantCode(batchUserAddReqBO.getTenantCode());
                    save.setCreateTime(new Date());
                    save.setUpdateTime(new Date());
                    save.setStatus(EntityValidType.NORMAL.getIntCode());
                    save.setExpTime(DateTimeUtil.convertAsDate((String)"2099-01-01"));
                    save.setUserName(user.getName());
                    save.setNickName(user.getNickname());
                    save.setCreateSource(user.getUserSource());
                    try {
                        addRspBO.setUserId(userId);
                        addRspBO.setExtUid(user.getExtUid());
                        addRspBO.setResultDesc("add success!");
                        addRspBO.setResult(Boolean.valueOf(true));
                        addRspBO.setExpTime(save.getExpTime());
                        isUpdate = this.imUserInfoMapper.insertSelective(save);
                        if (isUpdate > 0) {
                            this.imUserOpHelper.pushUserChange(save);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u7528\u6237\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25:", (Throwable)e);
                        addRspBO.setExtUid(user.getExtUid());
                        addRspBO.setResultDesc("add error:" + e.getMessage());
                        addRspBO.setResult(Boolean.valueOf(false));
                        addRspBO.setExpTime(save.getExpTime());
                    }
                }
                batchList.add(addRspBO);
            }
        }
        return BaseRspUtils.createSuccessRspList((List)batchList);
    }

    public Rsp updateUserInfo(SaveUserInfoReqBO reqBO) {
        log.info("\u66f4\u65b0im\u7528\u6237\u4fe1\u606f:{}", (Object)reqBO);
        ImUserInfo imUserInfo = null;
        if (!ObjectUtils.anyNotNull((Object[])new Object[]{reqBO.getUserId(), reqBO.getExtUid()})) {
            return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25:userId|extUid\u4e0d\u5f97\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getUserId())) {
            ImUserInfo select = new ImUserInfo();
            select.setTenantCode(reqBO.getTenantCode());
            select.setExtUid(reqBO.getExtUid());
            imUserInfo = this.imUserInfoMapper.selectByExUidAndTCode(select);
        } else {
            imUserInfo = this.imUserInfoMapper.selectByPrimaryKey(reqBO.getUserId());
        }
        if (ObjectUtils.anyNotNull((Object[])new Object[]{imUserInfo})) {
            this.imUserOpHelper.clearUserCache(imUserInfo.getUserId());
            ImUserInfo update = new ImUserInfo();
            BeanUtils.copyProperties((Object)reqBO, (Object)update);
            update.setUpdateTime(new Date());
            update.setUserName(reqBO.getName());
            update.setNickName(reqBO.getNickname());
            update.setUserId(imUserInfo.getUserId());
            update.setCreateSource(reqBO.getUserSource());
            int i = this.imUserInfoMapper.updateByPrimaryKeySelective(update);
            if (i > 0) {
                update.setUserType(imUserInfo.getUserType());
                this.imUserOpHelper.pushUserChange(update);
                return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f!");
            }
        }
        return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25:\u7528\u6237\u4e0d\u5b58\u5728");
    }

    @Transactional
    @MethodParamVerifyEnable
    public Rsp createGuestUser(GuestUserAddReqBO guestUserAddReqBO) {
        String guestId = NiccCommonUtil.createGuestUID((boolean)this.niccUserConfigPropertiesBean.getUidMaskEnable());
        ImUserInfo record = new ImUserInfo();
        UserAuthInfo authInfo = new UserAuthInfo();
        record.setTenantCode(guestUserAddReqBO.getTenantCode());
        record.setChannelCode(guestUserAddReqBO.getChannelCode());
        record.setUserId(guestId);
        record.setExtUid(guestId);
        String nickName = this.imUserOpHelper.getGuestNickName();
        record.setNickName(nickName);
        record.setUserName(nickName);
        record.setUserType(UserTypeField.USER.getIntCode());
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        record.setStatus(EntityValidType.NORMAL.getIntCode());
        record.setExpTime(DateTimeUtil.convertAsDate((String)"2099-01-01"));
        log.info("\u521b\u5efa\u6e38\u5ba2\u8d26\u6237:{}", (Object)record);
        try {
            int update = this.imUserInfoMapper.insertSelective(record);
            if (update > 0) {
                this.imUserOpHelper.pushUserChange(record);
                BeanUtils.copyProperties((Object)record, (Object)authInfo);
                authInfo.setUserType(String.valueOf(record.getUserType()));
                return BaseRspUtils.createSuccessRsp((Object)authInfo);
            }
            return BaseRspUtils.createErrorRsp((String)"\u6e38\u5ba2\u521b\u5efa\u5931\u8d25!");
        }
        catch (Exception exception) {
            return BaseRspUtils.createSuccessRsp((Object)authInfo);
        }
    }

    public Rsp getGuestName(GuestUserAddReqBO guestUserAddReqBO) {
        return BaseRspUtils.createSuccessRsp((Object)this.imUserOpHelper.getGuestNickName());
    }

    public RspList<UserAuthInfo> getUsers(UserConditionQueryReqBO queryReqBO) {
        ArrayList userAuthInfos = Lists.newArrayList();
        ImUserInfoQueryCondition condition = new ImUserInfoQueryCondition();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)condition);
        log.info("\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u4fe1\u606f:condition = {},page = {}, limit = {}", new Object[]{condition, queryReqBO.getPage(), queryReqBO.getLimit()});
        Page imUserInfoPage = PageHelper.startPage((int)queryReqBO.getPage(), (int)queryReqBO.getLimit());
        this.imUserInfoMapper.selectByCondition(condition);
        if (imUserInfoPage.getResult() != null) {
            for (ImUserInfo user : imUserInfoPage.getResult()) {
                UserAuthInfo authInfo = new UserAuthInfo();
                BeanUtils.copyProperties((Object)user, (Object)authInfo);
                authInfo.setCallNum(user.getCallNum1());
                authInfo.setUserSource(user.getCreateSource());
                userAuthInfos.add(authInfo);
            }
        }
        return BaseRspUtils.createSuccessRspList((List)userAuthInfos, (long)imUserInfoPage.getTotal());
    }

    public Rsp<Set<Object>> getOnlineUsers(String tenantCode, String group) {
        try {
            Set<Object> set = this.imUserOpHelper.getOnlineUsers(tenantCode, group);
            return BaseRspUtils.createSuccessRsp(set);
        }
        catch (Exception e) {
            return BaseRspUtils.createErrorRsp((String)("\u5206\u7ec4\u67e5\u8be2\u5728\u7ebf\u7528\u6237-\u5f02\u5e38:" + e.getMessage()));
        }
    }

    private void userInfoMasking(UserAuthInfo authInfo, boolean userDataMark) {
        if (userDataMark && UserTypeField.USER.getCode().equals(authInfo.getUserType())) {
            if (!authInfo.getNickName().startsWith(this.niccUserConfigPropertiesBean.getGuestStartName())) {
                authInfo.setNickName(DesensitizationUtil.markName((String)authInfo.getNickName()));
                authInfo.setUserName(DesensitizationUtil.markName((String)authInfo.getUserName()));
            }
            authInfo.setCallNum(DesensitizationUtil.commonDisplay((String)authInfo.getCallNum()));
        }
    }
}

