/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.user.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.tydic.nicc.common.bo.user.OtherUserAuthReqBO;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.bo.user.UserJoinInfoBO;
import com.tydic.nicc.common.constants.RedisCacheKeyConstant;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.eums.SystemModelType;
import com.tydic.nicc.common.eums.im.ImOnlineStatus;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.DesensitizationUtil;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.user.api.UserAuthService;
import com.tydic.nicc.user.config.NiccUserConfigPropertiesBean;
import com.tydic.nicc.user.mapper.ImUserInfoMapper;
import com.tydic.nicc.user.mapper.UserAuthMapper;
import com.tydic.nicc.user.mapper.po.ImUserInfo;
import com.tydic.nicc.user.mapper.po.UserAuthConfig;
import com.tydic.nicc.user.service.AuthStrategyFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@DS(value="nicc-user")
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=10000)
public class UserAuthServiceImpl
implements UserAuthService {
    private static final Logger log = LoggerFactory.getLogger(UserAuthServiceImpl.class);
    @Resource
    private NiccUserConfigPropertiesBean niccUserConfigPropertiesBean;
    @Resource
    private UserAuthMapper userAuthMapper;
    @Resource
    private ImUserInfoMapper imUserInfoMapper;
    @Resource
    private AuthStrategyFactory authStrategyFactory;
    @Resource
    private RedisHelper redisHelper;

    public UserAuthConfig initUserAuthConfig(String tenantCode, String channelCode) {
        String key = "user:auth-config:" + tenantCode + channelCode;
        UserAuthConfig authConfig = new UserAuthConfig();
        authConfig.setTenantCode(tenantCode);
        UserAuthConfig config = null;
        try {
            config = (UserAuthConfig)this.redisHelper.get(key);
            if (config == null && (config = this.userAuthMapper.selectByTenantCode(authConfig)) != null) {
                this.redisHelper.set(key, (Object)config, TimeUnit.MINUTES.toSeconds(10L));
                return config;
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7528\u6237\u8ba4\u8bc1\u914d\u7f6e\u5f02\u5e38:{}", (Object)e.getMessage());
            return this.userAuthMapper.selectByTenantCode(authConfig);
        }
        return config;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rsp<UserAuthInfo> authUser(String connectParam) {
        String jsonData = null;
        try {
            jsonData = URLDecoder.decode(connectParam, "UTF-8");
            UserJoinInfoBO userJoinInfoBO = (UserJoinInfoBO)JSONObject.parseObject((String)jsonData, UserJoinInfoBO.class);
            log.info("\u7528\u6237\u53c2\u6570:{}", (Object)userJoinInfoBO);
            if (SystemModelType.TENANT.getCode().equals(this.niccUserConfigPropertiesBean.getSystemModel()) && StringUtils.isEmpty((CharSequence)userJoinInfoBO.getTenantCode())) {
                return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u6a21\u5f0f\u4e0btenantCode\u4e0d\u5f97\u4e3a\u7a7a!");
            }
            if (StringUtils.isEmpty((CharSequence)userJoinInfoBO.getUserId())) {
                if (this.niccUserConfigPropertiesBean.getAllowGuest().booleanValue()) {
                    UserAuthInfo authInfo = new UserAuthInfo();
                    authInfo.setTenantCode(userJoinInfoBO.getTenantCode());
                    authInfo.setChannelCode(userJoinInfoBO.getChannelCode());
                    authInfo.setUserId(NiccCommonUtil.createGuestUID((boolean)this.niccUserConfigPropertiesBean.getUidMaskEnable()));
                    authInfo.setNickName(NiccCommonUtil.createGuestNickName());
                    authInfo.setUserType(UserTypeField.GUEST.getCode());
                    authInfo.setUserAvatar(this.niccUserConfigPropertiesBean.getGuestAvatar());
                    authInfo.setOnlineStatus(ImOnlineStatus.ONLINE.getCode());
                    return BaseRspUtils.createSuccessRsp((Object)authInfo, (String)"\u6e38\u5ba2\u8bbf\u95ee\u8ba4\u8bc1\u901a\u8fc7!");
                }
                log.warn("\u5f53\u524d\u7cfb\u7edf\u4e0d\u5141\u8bb8\u6e38\u5ba2\u8bbf\u95ee\uff0c\u8bf7\u4f20\u5165\u7528\u6237ID!");
                return BaseRspUtils.createErrorRsp((String)"\u5f53\u524d\u7cfb\u7edf\u4e0d\u5141\u8bb8\u6e38\u5ba2\u8bbf\u95ee\uff0c\u8bf7\u4f20\u5165\u7528\u6237ID!");
            }
            long nowTime = System.currentTimeMillis();
            if (this.niccUserConfigPropertiesBean.getAuthEnable().booleanValue() && !userJoinInfoBO.getUserId().startsWith("guest_")) {
                UserAuthConfig authConfig = this.initUserAuthConfig(userJoinInfoBO.getTenantCode(), userJoinInfoBO.getChannelCode());
                if (authConfig == null) return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u8ba4\u8bc1\u5931\u8d25,\u9274\u6743\u914d\u7f6e\u5f02\u5e38!");
                OtherUserAuthReqBO authReqBO = new OtherUserAuthReqBO();
                authReqBO.setExtraData(userJoinInfoBO.getExtraData());
                authReqBO.setExtUid(userJoinInfoBO.getExtUid());
                authReqBO.setTenantCode(userJoinInfoBO.getTenantCode());
                authReqBO.setChannelCode(userJoinInfoBO.getChannelCode());
                authReqBO.setUserId(userJoinInfoBO.getUserId());
                log.info("\u7528\u6237\u8ba4\u8bc1-\u5f00\u59cb:{}", (Object)JSONObject.toJSONString((Object)authReqBO));
                Rsp authInfoRsp = this.authStrategyFactory.handlerAuthMethod(authConfig.getAuthType(), authReqBO, authConfig);
                log.info("\u7528\u6237\u8ba4\u8bc1-\u5b8c\u6210:{}|{}", (Object)JSONObject.toJSONString((Object)authReqBO), (Object)authInfoRsp);
                if (authInfoRsp.isSuccess()) {
                    userJoinInfoBO.setUserId(((UserAuthInfo)authInfoRsp.getData()).getUserId());
                    userJoinInfoBO.setExtUid(((UserAuthInfo)authInfoRsp.getData()).getExtUid());
                } else {
                    log.warn("\u7528\u6237\u8ba4\u8bc1-\u5931\u8d25:{}", (Object)authInfoRsp);
                    return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u8ba4\u8bc1\u5931\u8d25,\u975e\u6cd5\u7528\u6237!");
                }
            }
            if (this.checkSign(userJoinInfoBO)) {
                ImUserInfo record = new ImUserInfo();
                record.setTenantCode(userJoinInfoBO.getTenantCode());
                record.setUserId(userJoinInfoBO.getUserId());
                ImUserInfo imUser = this.imUserInfoMapper.selectByUserIdAndTCode(record);
                if (imUser == null) return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u7528\u6237!");
                boolean denyFlag = this.checkUserDeny(imUser.getUserId());
                if (denyFlag) {
                    log.warn("\u7528\u6237\u5df2\u88ab\u7981\u6b62\u8fde\u63a5im: userId = {}", (Object)imUser.getUserId());
                    return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u5df2\u88ab\u7981\u6b62\u8fde\u63a5im!");
                }
                UserAuthInfo authInfo = new UserAuthInfo();
                BeanUtils.copyProperties((Object)imUser, (Object)authInfo);
                authInfo.setUserId(userJoinInfoBO.getUserId());
                authInfo.setTenantCode(userJoinInfoBO.getTenantCode());
                authInfo.setChannelCode(userJoinInfoBO.getChannelCode());
                authInfo.setUserType(String.valueOf(imUser.getUserType()));
                authInfo.setCallNum(imUser.getCallNum1());
                authInfo.setUserSource(imUser.getCreateSource());
                if (StringUtils.isEmpty((CharSequence)imUser.getUserAvatar())) {
                    authInfo.setUserAvatar(this.niccUserConfigPropertiesBean.getDefaultAvatar());
                }
                authInfo.setOnlineStatus(ImOnlineStatus.ONLINE.getCode());
                String cacheKey = RedisCacheKeyConstant.getUserInfoCacheKey((String)"", (String)authInfo.getUserId());
                this.redisHelper.set(cacheKey, (Object)authInfo, (long)RedisCacheKeyConstant.USER_INFO_CACHE_TIME.intValue());
                if (!EntityValidType.NORMAL.matchCode(imUser.getStatus())) return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u5df2\u88ab\u7981\u7528\u6216\u5df2\u5220\u9664!");
                if (imUser.getExpTime() == null || imUser.getExpTime().getTime() < nowTime) {
                    return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u8eab\u4efd\u5df2\u8fc7\u671f!");
                }
                this.userInfoMasking(authInfo);
                this.saveLastLogin(authInfo);
                return BaseRspUtils.createSuccessRsp((Object)authInfo, (String)"\u7528\u6237\u8ba4\u8bc1\u901a\u8fc7");
            }
            log.error("\u7528\u6237\u7b7e\u540d\u8ba4\u8bc1\u5931\u8d25:{}", (Object)userJoinInfoBO);
            return BaseRspUtils.createErrorRsp((String)"\u7b7e\u540d\u8ba4\u8bc1\u5931\u8d25!");
        }
        catch (UnsupportedEncodingException e) {
            return BaseRspUtils.createErrorRsp((String)("\u8fde\u63a5\u53c2\u6570\u89e3\u7801\u9519\u8bef:" + e.getMessage()));
        }
    }

    private void saveLastLogin(UserAuthInfo authInfo) {
        if (this.niccUserConfigPropertiesBean.getSaveLastLogin().booleanValue()) {
            ImUserInfo record = new ImUserInfo();
            record.setUserId(authInfo.getUserId());
            if (UserTypeField.USER.getCode().equals(authInfo.getUserType())) {
                record.setChannelCode(authInfo.getChannelCode());
            }
            record.setLastLogin(new Date());
            this.imUserInfoMapper.updateByPrimaryKeySelective(record);
        }
    }

    private boolean checkUserDeny(String userId) {
        String key = RedisCacheKeyConstant.getUserDenyStateKey((String)userId);
        Object deny = this.redisHelper.get(key);
        return ObjectUtils.anyNotNull((Object[])new Object[]{deny});
    }

    private boolean checkSign(UserJoinInfoBO userJoinInfoBO) {
        return true;
    }

    private void userInfoMasking(UserAuthInfo authInfo) {
        if (this.niccUserConfigPropertiesBean.getUserDataMaskEnable().booleanValue() && UserTypeField.USER.getCode().equals(authInfo.getUserType())) {
            if (!authInfo.getNickName().startsWith(this.niccUserConfigPropertiesBean.getGuestStartName())) {
                authInfo.setNickName(DesensitizationUtil.markName((String)authInfo.getNickName()));
                authInfo.setUserName(DesensitizationUtil.markName((String)authInfo.getUserName()));
            }
            authInfo.setCallNum(DesensitizationUtil.commonDisplay((String)authInfo.getCallNum()));
        }
    }
}

