/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.user.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.bo.user.UserQueryReqBO;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.user.api.UserManageService;
import com.tydic.nicc.user.mapper.ImUserInfoMapper;
import com.tydic.nicc.user.mapper.po.ImUserInfo;
import com.tydic.nicc.user.mapper.po.ImUserInfoQueryCondition;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@DS(value="nicc-user")
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class UserManageServiceImpl
implements UserManageService {
    private static final Logger log = LoggerFactory.getLogger(UserManageServiceImpl.class);
    @Resource
    private ImUserInfoMapper imUserInfoMapper;

    public RspList<UserAuthInfo> getUserList(UserQueryReqBO reqBO) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{reqBO.getUserId(), reqBO.getExtUid(), reqBO.getUserPhone(), reqBO.getNickName(), reqBO.getUserName()})) {
            return BaseRspUtils.createErrorRspList((String)"\u53c2\u6570\u5f02\u5e38");
        }
        long start = System.currentTimeMillis();
        ArrayList<UserAuthInfo> users = new ArrayList<UserAuthInfo>();
        ImUserInfoQueryCondition condition = new ImUserInfoQueryCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        condition.setStatus(EntityValidType.NORMAL.getIntCode());
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.imUserInfoMapper.selectByCondition(condition);
        for (ImUserInfo imUserInfo : page.getResult()) {
            UserAuthInfo authInfo = new UserAuthInfo();
            BeanUtils.copyProperties((Object)imUserInfo, (Object)authInfo);
            authInfo.setCallNum(imUserInfo.getCallNum1());
            authInfo.setUserType(String.valueOf(imUserInfo.getUserType()));
            users.add(authInfo);
        }
        long end = System.currentTimeMillis();
        log.info("\u67e5\u8be2\u7528\u6237\u5217\u8868:{} \u6761, {} ms", (Object)page.getTotal(), (Object)(end - start));
        return BaseRspUtils.createSuccessRspList(users, (long)page.getTotal());
    }
}

