/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.user.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.tydic.nicc.common.bo.user.UserAccessLogBO;
import com.tydic.nicc.common.bo.user.UserAccessLogQueryReqBO;
import com.tydic.nicc.common.bo.user.UserAccessLogSaveReqBO;
import com.tydic.nicc.common.bo.user.UserAccessLogUpdateReqBO;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.user.api.UserAccessLogService;
import com.tydic.nicc.user.mapper.UserAccessLogMapper;
import com.tydic.nicc.user.mapper.po.UserAccessLog;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;

@DS(value="nicc-user")
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class UserAccessLogServiceImpl
implements UserAccessLogService {
    private static final Logger log = LoggerFactory.getLogger(UserAccessLogServiceImpl.class);
    @Resource
    private UserAccessLogMapper userAccessLogMapper;

    @MethodParamVerifyEnable
    @Transactional
    public Rsp saveAccessLog(UserAccessLogSaveReqBO saveReqBO) {
        log.info("\u4fdd\u5b58\u7528\u6237\u8bbf\u95ee\u65e5\u5fd7:{}", (Object)saveReqBO);
        UserAccessLog record = new UserAccessLog();
        BeanUtils.copyProperties((Object)saveReqBO, (Object)record);
        int update = 0;
        String accessId = "";
        if (StringUtils.isEmpty((CharSequence)saveReqBO.getAccessId())) {
            Date leastDate = DateTimeUtil.DateAddHour((int)-24);
            UserAccessLog accessLog = this.userAccessLogMapper.selectLastAccessLog(saveReqBO.getTenantCode(), saveReqBO.getUserId(), leastDate);
            if (accessLog == null || accessLog != null && accessLog.getOfflineTime() != null) {
                record.setAccessId(IdWorker.nextAutoIdStr());
                record.setAccessTime(new Date());
                if (accessLog != null) {
                    if (StringUtils.isEmpty((CharSequence)saveReqBO.getIpAddr())) {
                        record.setIpAddr(accessLog.getIpAddr());
                    }
                    if (StringUtils.isEmpty((CharSequence)saveReqBO.getRegion())) {
                        record.setRegion(accessLog.getRegion());
                    }
                    if (StringUtils.isEmpty((CharSequence)saveReqBO.getExtInfo())) {
                        record.setExtInfo(accessLog.getExtInfo());
                    }
                    if (StringUtils.isEmpty((CharSequence)saveReqBO.getSip())) {
                        record.setSip(accessLog.getSip());
                    }
                    if (StringUtils.isEmpty((CharSequence)saveReqBO.getCity())) {
                        record.setCity(accessLog.getCity());
                    }
                }
                log.info("\u4fdd\u5b58\u7528\u6237\u8bbf\u95ee\u65e5\u5fd7-\u65b0\u589e:{}", (Object)record);
                update = this.userAccessLogMapper.insertSelective(record);
                accessId = record.getAccessId();
            }
            if (accessLog != null && accessLog.getOfflineTime() == null) {
                accessId = accessLog.getAccessId();
                if (StringUtils.isNotEmpty((CharSequence)saveReqBO.getIpAddr()) || StringUtils.isNotEmpty((CharSequence)saveReqBO.getRegion()) || StringUtils.isNotEmpty((CharSequence)saveReqBO.getExtInfo())) {
                    record.setAccessId(accessId);
                    log.info("\u4fdd\u5b58\u7528\u6237\u8bbf\u95ee\u65e5\u5fd7-\u589e\u91cf\u66f4\u65b0:{}", (Object)record);
                    update = this.userAccessLogMapper.updateByPrimaryKeySelective(record);
                }
            }
        } else {
            log.info("\u4fdd\u5b58\u7528\u6237\u8bbf\u95ee\u65e5\u5fd7-\u4e3b\u952e\u66f4\u65b0:{}", (Object)record);
            update = this.userAccessLogMapper.updateByPrimaryKeySelective(record);
        }
        if (update > 0) {
            accessId = record.getAccessId();
        }
        return BaseRspUtils.createSuccessRsp((Object)accessId);
    }

    public Rsp updateOfflineTime(UserAccessLogUpdateReqBO updateReqBO) {
        Date leastDate = DateTimeUtil.DateAddHour((int)-24);
        UserAccessLog accessLog = this.userAccessLogMapper.selectLastAccessLog(updateReqBO.getTenantCode(), updateReqBO.getUserId(), leastDate);
        int update = 0;
        if (accessLog != null) {
            UserAccessLog record = new UserAccessLog();
            BeanUtils.copyProperties((Object)updateReqBO, (Object)record);
            record.setAccessId(accessLog.getAccessId());
            update = this.userAccessLogMapper.updateOfflineTime(record);
        }
        return BaseRspUtils.createSuccessRsp((Object)update);
    }

    @MethodParamVerifyEnable
    public Rsp getAccessLog(UserAccessLogQueryReqBO queryReqBO) {
        log.info("\u67e5\u8be2\u7528\u6237\u6700\u8fd1\u8bbf\u95ee\u65e5\u5fd7:{}", (Object)queryReqBO);
        UserAccessLog accessLog = null;
        if (StringUtils.isNotEmpty((CharSequence)queryReqBO.getAccessId())) {
            accessLog = this.userAccessLogMapper.selectByPrimaryKey(queryReqBO.getAccessId());
        }
        if (!ObjectUtils.anyNotNull((Object[])new Object[]{accessLog})) {
            accessLog = this.userAccessLogMapper.selectLastAccessLog(queryReqBO.getTenantCode(), queryReqBO.getUserId(), queryReqBO.getAccessDay());
        }
        UserAccessLogBO accessLogBO = new UserAccessLogBO();
        if (ObjectUtils.anyNotNull((Object[])new Object[]{accessLog})) {
            BeanUtils.copyProperties((Object)accessLog, (Object)accessLogBO);
            return BaseRspUtils.createSuccessRsp((Object)accessLogBO);
        }
        return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e!");
    }
}

