var cashierDeskInfo = null;
var edList = [
  /*{
    "corpCoreName": "中核测试环境核心",
    "corpNameSource": "中核测试环境核心",
    "corpIdCodeSource": "430102000106369111",
    "corpIdTypeSource": "BUSINESS_LICENSE_SZ",
    "productType": "0",
    "limitTotal": "10000000000.00",
    "limitAvailable": "576.00",
    "limitMaxPer": "100000000.00",
    "effectDate": "2021-11-25T00:00:00.000+08:00",
    "expiryDate": "2024-11-25T00:00:00.000+08:00",
    "limitType": "SOURCE_SELF",
    "issueMaxterm": "2022-12-24T07:09:34.410+00:00",
    "issueMinterm": "2022-01-08T07:09:34.410+00:00"
  },{
    "corpCoreName": "中核测试环境核心1",
    "corpNameSource": "中核测试环境核心1",
    "corpIdCodeSource": "430102000106369112",
    "corpIdTypeSource": "BUSINESS_LICENSE_S2",
    "productType": "0",
    "limitTotal": "10000000000.00",
    "limitAvailable": "576.00",
    "limitMaxPer": "100000000.00",
    "effectDate": "2021-11-25T00:00:00.000+08:00",
    "expiryDate": "2024-11-25T00:00:00.000+08:00",
    "limitType": "SOURCE_SELF",
    "issueMaxterm": "2022-12-24T07:09:34.410+00:00",
    "issueMinterm": "2022-01-08T07:09:34.410+00:00"
  }*/
];//额度来源企业列表
var maturityDate = '';//承诺付款日期
var selectItem = null;//选中项
var payOrderInfo = JSON.parse(sessionStorage.getItem('payOrderInfo'));
$(document).ready(function () {
  // 返回收银台
  $("#payment_a").on("click", function () {
    window.history.back();
  });
  //隐藏弹框
  $("#edBtn").on("click", function () {
    $("#edBox").css("display", "none");
  });
  $("#corpNameSource").on("click", function () {
    $("#edBox").css("display", "block");
  });
  $("#maturityDateBox").css("display", "none");//隐藏承诺付款日期
  $('#maturityDate').on('change',function (e) {//获取选中的承诺付款日期
    let maturityDate = $(this).val().replace('T'," ");//将时间中的T替换成空格
  })
  qryEdList();
  init();
  $("#payerAcctNo").focus();
  $('#submitBtn').on('click', paySubmit);//立即付款按钮
});

var init = function () {
  $('#orderId').text(payOrderInfo.orderId);//支付订单编号
  $('#realFee').text(payOrderInfo.realFee / 100.00);//付款金额

  var data = {};
  data.params = {
    orderId: payOrderInfo.orderId
  };
  data.params.service = '/cashierDesk/queryCashierDesk';
  data.successF = function (returnData) {
    cashierDeskInfo = returnData;
    util.countdown('#remainingTime', returnData.payTimeLeft, function (timeLeft) {
      if (timeLeft <= 0) {
        util.dialog.alert('订单已超时，点击确定返回重新下单', function () {
          window.history.back();
        });
      }
    });
    qryName()
  };
  loadingMask('正在获取支付信息...');
  util.ajax(data);
};

var paySubmit = function () {
  var corpNameSource = $('#corpNameSource').text();
  var corpIdTypeSource = selectItem.corpIdTypeSource
  var corpIdCodeSource = selectItem.corpIdCodeSource
  var maturityDate =  $('#maturityDate').val()?$('#maturityDate').val().replace('T'," "):'';
  if (corpNameSource == '请选择' || corpNameSource == '') {
    util.dialog.alert('请选择额度来源企业');
    return;
  }
  if (maturityDate == '') {
    util.dialog.alert('请选择承诺付款日期');
    return;
  }
  var busiReqData = {
    corpNameSource:corpNameSource,
    corpIdTypeSource:corpIdTypeSource,
    corpIdCodeSource:corpIdCodeSource,
    maturityDate:maturityDate
  };
  var data = {};
  data.params = {
    busiCode: cashierDeskInfo.busiCode,
    merchantId: cashierDeskInfo.merchantId,
    outOrderId: cashierDeskInfo.outOrderId,
    totalFee: parseInt(cashierDeskInfo.totalFee),
    payMethod: payOrderInfo.payMethod,
    reqWay: cashierDeskInfo.reqWay,
    detailName: cashierDeskInfo.detailName,
    channelId: cashierDeskInfo.channelId,
    cityId: cashierDeskInfo.cityId,
    createOperId: cashierDeskInfo.createOperId,
    // createOperIdName: cashierDeskInfo.createOperIdName,
    districtId: cashierDeskInfo.districtId,
    provinceId: cashierDeskInfo.provinceId,
    notifyUrl: cashierDeskInfo.notifyUrl,
    redirectUrl: cashierDeskInfo.redirectUrl,
    busiReqData: JSON.stringify(busiReqData)
  };
  data.params.service = '/payPro/dealOrder';
  data.contentType = 'json';
  data.successF = function (returnData) {
    var busiRspData = JSON.parse(returnData.busiRspData);
    location.href = cashierDeskInfo.redirectUrl;
    loadingMask("正在跳转...");
    setTimeout(function() {
      hideLoadingMask();
    }, 10000);
  };
  loadingMask("等待支付结果...");
  util.ajax(data);

  //调用会员中心接口 存储付款方相关信息
};

var qryEdList = function () {//查询表格数据
  var data = {};
  data.params = {
    orderId: payOrderInfo.orderId
  };
  data.params.service = '/hcx/query/quota';
  data.successF = function (returnData) {
    console.log(returnData)
    edList = returnData.data.corpLimitDetail;
    console.log(edList)
    createTable()
  };
  util.ajax(data);

};
var createTable = function () {//生成表格
  //循环生成额度表格
  var html = ''
  $.each(edList, function (i, item) {
    html += '<tr data-index='+i+'>' +
        '                <td>'+item.limitAvailable+'</td>' +
        '                <td>'+item.corpNameSource+'</td>' +
        '                <td>'+item.corpCoreName+'</td>' +
        '                <td>'+item.limitMaxPer+'</td>' +
        '                <td>'+item.effectDate+'</td>' +
        '                <td>'+item.expiryDate+'</td>' +
        '                <td>'+item.limitType+'</td>' +
        '                <td>'+item.corpIdTypeSource+'</td>' +
        '                <td>'+item.corpIdCodeSource+'</td>' +
        '                <td>'+item.productType+'</td>' +
        '                <td>'+item.limitTotal+'</td>' +
        '                <td width="4%">' +
        '                  <div style="color:  #009DD9;cursor: pointer">使用</div>' +
        '                </td>' +
        '              </tr>'
  })
  var thead = '<thead class="eb-thead" id="edThead">' +
      '              <tr>' +
      '                <th>剩余可用额度</th>' +
      '                <th>额度来源方企业名称</th>' +
      '                <th>核心企业全称</th>' +
      '                <th>单笔最高金额</th>' +
      '                <th>额度起始日期</th>' +
      '                <th>额度到期日期</th>' +
      '                <th>额度类型</th>' +
      '                <th>额度来源方企业证件类型</th>' +
      '                <th>额度来源方企业证件编号</th>' +
      '                <th>平台产品</th>' +
      '                <th>平台额度</th>' +
      '                <th width="4%">操作</th>' +
      '              </tr>' +
      '            </thead>'
  var tbody = '<tbody id="edTbody">'+html+'</tbody>'
  var table = '<table border="1" class="ed-table" id="edTable">'+thead+tbody+'</table>'
  $('#edTable').html(table)
  //点击获取表格中的某一行数据
  $('#edTable').on('click','tr',function () {
    console.log($(this).attr('data-index'))
    let item = edList[$(this).attr('data-index')]
    selectItem = item
    //设置承诺付款日期的上下限
    $('#maturityDate').attr('max',item.issueMaxterm.replace(' ','T'))
    $('#maturityDate').attr('min',item.issueMinterm.replace(' ','T'))
    console.log(item.issueMaxterm.replace(' ','T'),item.issueMinterm.replace(' ','T'))
    $('#issueMaxterm').text(item.issueMaxterm)//承诺付款时间上限
    $('#issueMinterm').text(item.issueMinterm)//承诺付款时间下限
    $('#corpNameSource').text(item.corpNameSource)//额度来源企业
    $("#maturityDateBox").css("display", "block");//显示承诺付款日期
    $("#edBox").css("display", "none");
  })
}
var qryName = function () {//核心企业全称、供应商企业全称查询
  var data = {};
  data.params = {
    merchantId:cashierDeskInfo.merchantId,
    orderId: payOrderInfo.orderId
  };
  data.params.service = '/hcx/query/merchantAndPurchaserInfo';
  data.successF = function (returnData) {
    console.log(returnData)
    $('#corpNameCore').text(returnData.data.corpNameCore)//核心企业全称
    $('#corpNameAccept').text(returnData.data.corpNameAccept)//供应商企业全称
  };
  util.ajax(data);
}

