/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.controller.rest.dataexport;

import com.tydic.pfscext.common.ExcelFile;
import com.tydic.pfscext.controller.utils.FscFileUtils;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FscExportInvoiceMailTemplateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscExportInvoiceMailTemplateService.class);
    private String[] sheetNames = new String[]{"\u53d1\u7968\u4fe1\u606f"};

    public void exportTemplate(HttpServletRequest request, HttpServletResponse response) {
        ExcelFile excel = new ExcelFile();
        int sheetIndex = 0;
        excel.createSheet(this.sheetNames[sheetIndex]);
        Object[] titles = new String[]{"\u53d1\u7968\u7f16\u53f7"};
        Object[] cellFormat = new String[1];
        excel.setArrayValueByNames(cellFormat, "S,,", new String[]{"A"});
        excel.setCellsFormat(sheetIndex, (String[])cellFormat);
        excel.setColumnsWidth(sheetIndex, new Integer[]{14});
        excel.addRow(sheetIndex, titles, 14);
        String filename = FscFileUtils.processFilename(request, "\u5f85\u90ae\u5bc4\u53d1\u7968");
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".xls");
            response.setContentType("application/x-download");
            excel.saveAsOutStream((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            LOGGER.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
        }
        excel.close();
    }
}

