/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.controller.rest.dataexport;

import com.tydic.pfscext.api.busi.QueryBillApplyForMailService;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyForMailReqBO;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyForMailRspBO;
import com.tydic.pfscext.api.busi.vo.InvoiceForMailVO;
import com.tydic.pfscext.api.busi.vo.PurchaseNoListVO;
import com.tydic.pfscext.common.ExcelFile;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FscExportInvoiceSentService {
    private static final Logger log = LoggerFactory.getLogger(FscExportInvoiceSentService.class);
    public final int MAX_NUM = 10000;
    @Autowired
    private QueryBillApplyForMailService queryBillApplyForMailService;

    public void exportInvoiceSent(HttpServletRequest request, HttpServletResponse response) {
        String source;
        String companyId;
        String mailDateStart;
        String mailDateEnd;
        String invoiceDateStart;
        String invoiceDateEnd;
        String receiverLike;
        String jdAssignStatus;
        String invoiceNoEnd;
        String invoiceNoStart;
        String invoceName;
        String expressNo;
        QueryBillApplyForMailReqBO reqBO = new QueryBillApplyForMailReqBO();
        String applyNoLike = request.getParameter("applyNoLike");
        if (StringUtils.isNotBlank((String)applyNoLike)) {
            reqBO.setApplyNoLike(applyNoLike);
        }
        if (StringUtils.isNotBlank((String)(expressNo = request.getParameter("expressNo")))) {
            reqBO.setExpressNo(expressNo);
        }
        if (StringUtils.isNotBlank((String)(invoceName = request.getParameter("invoceName")))) {
            reqBO.setInvoceName(invoceName);
        }
        if (StringUtils.isNotBlank((String)(invoiceNoStart = request.getParameter("invoiceNoStart")))) {
            reqBO.setInvoiceNoStart(invoiceNoStart);
        }
        if (StringUtils.isNotBlank((String)(invoiceNoEnd = request.getParameter("invoiceNoEnd")))) {
            reqBO.setInvoiceNoEnd(invoiceNoEnd);
        }
        if (StringUtils.isNotBlank((String)(jdAssignStatus = request.getParameter("jdAssignStatus")))) {
            reqBO.setJdAssignStatus(jdAssignStatus);
        }
        if (StringUtils.isNotBlank((String)(receiverLike = request.getParameter("receiverLike")))) {
            reqBO.setReceiverLike(receiverLike);
        }
        if (StringUtils.isNotBlank((String)(invoiceDateEnd = request.getParameter("invoiceDateEnd")))) {
            reqBO.setInvoiceDateEnd(this.transferDate(invoiceDateEnd));
        }
        if (StringUtils.isNotBlank((String)(invoiceDateStart = request.getParameter("invoiceDateStart")))) {
            reqBO.setInvoiceDateStart(this.transferDate(invoiceDateStart));
        }
        if (StringUtils.isNotBlank((String)(mailDateEnd = request.getParameter("mailDateEnd")))) {
            reqBO.setMailDateEnd(this.transferDate(mailDateEnd));
        }
        if (StringUtils.isNotBlank((String)(mailDateStart = request.getParameter("mailDateStart")))) {
            reqBO.setMailDateStart(this.transferDate(mailDateStart));
        }
        if (StringUtils.isNotBlank((String)(companyId = request.getParameter("companyId")))) {
            reqBO.setCompanyId(Long.valueOf(Long.parseLong(companyId)));
        }
        if (StringUtils.isNotBlank((String)(source = request.getParameter("source")))) {
            reqBO.setSource(source);
        }
        reqBO.setPageNo(Integer.valueOf(reqBO.getPageNo() == 0 ? 1 : reqBO.getPageNo()));
        reqBO.setOrderBy("CREATE_DATE asc");
        QueryBillApplyForMailRspBO rspBO = null;
        try {
            rspBO = this.queryBillApplyForMailService.queryInvoiceSent(reqBO);
        }
        catch (Exception e) {
            log.error("\u5931\u8d25", (Throwable)e);
            this.failedMsg(response, e.getMessage());
            return;
        }
        if (!"0000".equals(rspBO.getRespCode())) {
            this.failedMsg(response, rspBO.getRespDesc());
            return;
        }
        if (rspBO.getRows() != null) {
            int detailNum = 0;
            for (PurchaseNoListVO mail : rspBO.getRows()) {
                if (mail.getInvoiceForMailList() == null) continue;
                detailNum += mail.getInvoiceForMailList().size();
            }
            if (detailNum > 10000) {
                this.failedMsg(response, "\u6570\u636e\u91cf\u592a\u5927\uff0c\u53d1\u7968\u660e\u7ec6\u4e0d\u80fd\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5f55\u5165\u67e5\u8be2\u6761\u4ef6\u540e\u5bfc\u51fa");
                return;
            }
        }
        ExcelFile excel = new ExcelFile();
        String[] sheetNames = new String[]{"\u5df2\u90ae\u5bc4"};
        int sheetIdx = 0;
        excel.createSheet(sheetNames[sheetIdx]);
        Object[] title1 = new String[]{"\u53d1\u7968\u5df2\u90ae\u5bc4\u4fe1\u606f\u5217\u8868"};
        Object[] title2 = new String[]{"\u90ae\u5bc4\u65e5\u671f", "\u5e8f\u53f7", "\u5feb\u9012\u5355\u53f7", "\u53d1\u7968\u62ac\u5934", "\u6536\u4ef6\u4eba", "\u8054\u7cfb\u7535\u8bdd", "\u6536\u4ef6\u5730\u5740", "\u5305\u542b\u53d1\u7968\u6570\u91cf", "\u5907\u6ce8", "\u5bc4\u65b9\u5730\u5740", "\u5bc4\u4ef6\u4eba", "\u5bc4\u4ef6\u4eba\u7535\u8bdd"};
        String[] title3 = new String[]{"", "", "", "\u53d1\u7968\u53f7\u7801", "\u53d1\u7968\u62ac\u5934", "\u53d1\u7968\u91d1\u989d", "\u5f00\u7968\u65e5\u671f", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7"};
        String[][] fields2 = new String[][]{{"createDateString", "A", "S"}, {"", "B", "S"}, {"mailTicketNo", "C", "S"}, {"invoceName", "D", "S"}, {"name", "E", "S"}, {"mobile", "F", "S"}, {"detailAddress", "G", "S"}, {"count", "H", "N"}, {"failReason", "I", "S"}, {"senderAddress", "J", "S"}, {"sender", "K", "S"}, {"senderTel", "L", "S"}};
        String[][] fields3 = new String[][]{{"", "A", "S"}, {"", "B", "S"}, {"", "C", "S"}, {"invoiceNo", "D", "S"}, {"invoceName", "E", "S"}, {"amt", "F", "N"}, {"invoiceDateString", "G", "S"}, {"applyNo", "H", "S"}};
        Object[] cellFormat = new String[title1.length];
        excel.setArrayValueByNames(cellFormat, ",C,,\u9ed1\u4f53:20", new String[0]);
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.setColumnsWidth(sheetIdx, new Integer[]{10, 4, 16, 40, 40, 14, 40, 22, 20, 40, 6, 14});
        excel.addRow(sheetIdx, title1, 22);
        excel.mergeCell(sheetIdx, 0, "A", 0, "L");
        cellFormat = new String[title2.length];
        excel.setArrayValueByNames(cellFormat, ",C,,\u9ed1\u4f53:12", new String[0]);
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.addRow(sheetIdx, title2, 14);
        cellFormat = new String[title2.length];
        excel.setArrayValueByNames(cellFormat, ",C,", new String[0]);
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        for (int k = 0; k < rspBO.getRows().size(); ++k) {
            PurchaseNoListVO mail = (PurchaseNoListVO)rspBO.getRows().get(k);
            Object[] fieldsData = new String[title2.length];
            for (int i = 0; i < fields2.length; ++i) {
                String fieldName = fields2[i][0];
                String cellName = fields2[i][1];
                int idx = ExcelFile.cellNameToIndex((String)cellName);
                fieldsData[idx] = this.getProp(mail, fieldName);
            }
            fieldsData[1] = String.valueOf(k + 1);
            excel.addRow(sheetIdx, fieldsData, 14);
            List invoices = mail.getInvoiceForMailList();
            if (invoices == null) continue;
            for (int j = 0; j < invoices.size(); ++j) {
                if (j == 0) {
                    fieldsData = title3;
                    excel.addRow(sheetIdx, fieldsData, 14);
                }
                InvoiceForMailVO invoice = (InvoiceForMailVO)invoices.get(j);
                fieldsData = new String[title3.length];
                for (int i = 0; i < fields3.length; ++i) {
                    String fieldName = fields3[i][0];
                    String cellName = fields3[i][1];
                    int idx = ExcelFile.cellNameToIndex((String)cellName);
                    fieldsData[idx] = this.getProp(invoice, fieldName);
                }
                excel.addRow(sheetIdx, fieldsData, 14);
            }
        }
        String filename = this.processFilename(request, "\u5df2\u90ae\u5bc4");
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".xls");
            response.setContentType("application/x-download");
            excel.saveAsOutStream((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
        }
        excel.close();
    }

    private void failedMsg(HttpServletResponse response, String msg) {
        response.setContentType("text/html;charset=utf-8");
        try {
            msg = String.format("<html><head><meta charset=\"utf-8\"><script language='javascript'>alert(\"%s\");window.history.back();</script></head><body><textarea>%s</textarea></body></html>", msg, msg);
            response.getWriter().print(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Object getProp(Object bean, String name) {
        String v = null;
        try {
            if (name != null && !"".equals(name)) {
                v = BeanUtils.getProperty((Object)bean, (String)name);
                return v;
            }
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6Bean\u5c5e\u6027\u5230Excel\u6570\u636e\u5217\u5931\u8d25,name=" + name, (Throwable)e);
        }
        return null;
    }

    private String processFilename(HttpServletRequest request, String filename) {
        String newFilename = "1";
        String head = request.getHeader("User-Agent");
        if (head.toLowerCase().indexOf("msie") >= 0) {
            try {
                newFilename = URLEncoder.encode(filename, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("url\u7f16\u7801\u9519\u8bef\uff0c\u6587\u4ef6\u540d\uff1a" + filename, (Throwable)e);
            }
        } else {
            newFilename = new String(filename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        }
        return newFilename;
    }

    private Date transferDate(String dateStr) {
        SimpleDateFormat simdate1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return simdate1.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

