/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.controller.rest.dataimport;

import com.tydic.pfscext.api.busi.BusiProcessInvoiceDataInOutService;
import com.tydic.pfscext.api.busi.bo.BusiProcessInvoiceInOutReqBO;
import com.tydic.pfscext.api.busi.bo.BusiProcessInvoiceInOutRspBO;
import com.tydic.pfscext.api.busi.vo.BillNotificationInfoVO;
import com.tydic.pfscext.api.busi.vo.BusiProcessInvoiceInOutVO;
import com.tydic.pfscext.api.busi.vo.InvoiceDetailVO;
import com.tydic.pfscext.api.busi.vo.InvoiceInfoVO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.common.ExcelFile;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FscImportInvoiceDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(FscImportInvoiceDlzqService.class);
    private BusiProcessInvoiceDataInOutService busiProcessInvoiceDataInOutService;
    private String[] sheetNames = new String[]{"\u586b\u5199\u8bf4\u660e", "\u5f00\u7968\u901a\u77e5\u5355\u4fe1\u606f", "\u5f00\u7968\u660e\u7ec6", "\u90ae\u5bc4\u4fe1\u606f"};
    private String[][] notifiInMap = new String[][]{{"name", "C", "S"}, {"bankAcctNo", "H", "S"}, {"bankAcNo", "H", "S"}, {"address", "E", "S"}};
    private String[][] ivDetailInMap = new String[][]{{"invoiceCode", "B", "S"}, {"invoiceNo", "C", "S"}, {"invoiceDate", "D", "T"}, {"priceUntax", "M", "D"}, {"untaxAmt", "O", "D"}, {"taxRate", "Q", "D"}};
    private String[][] notifiOutMap = new String[][]{{"notificationNo", "A", "S"}, {"invoiceTypeDescr", "B", ""}, {"invoceName", "C", "S"}, {"taxNo", "D", "S"}, {"addr", "E", "S"}, {"phone", "F", "S"}, {"bankName", "G", "S"}, {"bankAccNo", "H", "S"}, {"amt", "I", "D"}};
    private String[][] ivDetailOutMap = new String[][]{{"notificationNo", "A", "S"}, {"invoiceCode", "B", "S"}, {"invoiceNo", "C", "S"}, {"invoiceDate", "D", "T"}, {"orderId", "E", "L"}, {"identify", "F", "L"}, {"skuId", "G", "L"}, {"itemName", "H", "S"}, {"specModelFigureNo", "I", "S"}, {"itemUnit", "J", "S"}, {"quantity", "K", "D"}, {"priceIntax", "L", "D"}, {"priceUntax", "M", "D"}, {"amount", "N", "D"}, {"untaxAmt", "O", "D"}, {"taxAmt", "P", "D"}, {"taxRate", "Q", "D"}};

    public PfscExtRspBaseBO importInvoice(HttpServletRequest request, HttpServletResponse response, MultipartFile file) {
        PfscExtRspBaseBO respBO = new PfscExtRspBaseBO();
        String operateType = request.getParameter("operate");
        String notificationNo = request.getParameter("notificationNo");
        String supNo = request.getParameter("supNo");
        String companyId = request.getParameter("companyId");
        String filename = "";
        if (file != null) {
            filename = file.getOriginalFilename();
        }
        logger.debug("\u53d1\u7968\u5bfc\u5165\u5bfc\u51fa\u5904\u7406,operate=" + operateType + ",notificationNo=" + notificationNo + ",supNo=" + supNo + ",companyId=" + companyId + ",filename=[" + filename + "]");
        BusiProcessInvoiceInOutReqBO reqBo = new BusiProcessInvoiceInOutReqBO();
        BusiProcessInvoiceInOutVO vo = new BusiProcessInvoiceInOutVO();
        reqBo.setData(vo);
        if (notificationNo == null || notificationNo.length() == 0) {
            respBO.setRespCode("18000");
            respBO.setRespDesc("\u7f3a\u5c11\u53c2\u6570,\u8bf7\u6307\u5b9a\u901a\u77e5\u53f7(notificationNo)");
            return respBO;
        }
        if (supNo == null || supNo.length() == 0) {
            respBO.setRespCode("18000");
            respBO.setRespDesc("\u7f3a\u5c11\u53c2\u6570,\u8bf7\u6307\u5b9a\u4f9b\u5e94\u5546(supNo)");
            return respBO;
        }
        if (companyId == null || companyId.length() == 0) {
            respBO.setRespCode("18000");
            respBO.setRespDesc("\u7f3a\u5c11\u53c2\u6570,\u8bf7\u6307\u5b9a\u4e13\u4e1a\u516c\u53f8ID(companyId)");
            return respBO;
        }
        if (file == null) {
            respBO.setRespCode("18000");
            respBO.setRespDesc("\u65e0\u6cd5\u5f97\u5230\u6587\u4ef6\u6570\u636e,\u8bf7\u5c1d\u8bd5\u7528POST\u65b9\u5f0f\u63d0\u4ea4\u8bf7\u6c42");
            return respBO;
        }
        int idx = filename.toLowerCase().lastIndexOf(".xls");
        if (idx == -1 || filename.length() - idx != 4) {
            respBO.setRespCode("18000");
            respBO.setRespDesc("\"Excel\u6587\u4ef6\u540d\"+filename+\"\u4e0d\u5408\u6cd5,\u7684\u6269\u5c55\u540d\u5fc5\u987b\u4e3a.xls\"");
            return respBO;
        }
        reqBo.setCompanyId(Long.valueOf(companyId));
        reqBo.getData().setSupplierNo(Long.valueOf(supNo));
        InputStream is = null;
        try {
            is = file.getInputStream();
        }
        catch (IOException e) {
            respBO.setRespCode("18000");
            respBO.setRespDesc("\u65e0\u6cd5\u5f97\u5230\u6587\u4ef6\u6570\u636e,\u8bf7\u5c1d\u8bd5\u7528POST\u65b9\u5f0f\u63d0\u4ea4\u8bf7\u6c42");
            return respBO;
        }
        respBO = this.uploadExcel(notificationNo, is, filename, reqBo, request, response);
        return respBO;
    }

    private PfscExtRspBaseBO uploadExcel(String notificationNo, InputStream is, String fileName, BusiProcessInvoiceInOutReqBO reqBo, HttpServletRequest request, HttpServletResponse response) {
        PfscExtRspBaseBO respBO = new PfscExtRspBaseBO();
        ExcelFile excel = new ExcelFile(is);
        if (!excel.isReady()) {
            respBO.setRespCode("18000");
            respBO.setRespDesc("\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6" + fileName + "," + excel.getErrMsg());
            return respBO;
        }
        if (excel.getSheetCount() == 4) {
            if (!"\u90ae\u5bc4\u4fe1\u606f".equals(excel.getSheetName(3)) && excel.getSheetCount() != 3) {
                respBO.setRespCode("18000");
                respBO.setRespDesc("\u4e0a\u4f20\u7684Excel\u5e94\u67093\u9875");
                return respBO;
            }
        } else if (excel.getSheetCount() != 3) {
            respBO.setRespCode("18000");
            respBO.setRespDesc("\u4e0a\u4f20\u7684Excel\u5e94\u67093\u9875");
            return respBO;
        }
        int i = 0;
        while (i < 3) {
            if (!this.sheetNames[i].equals(excel.getSheetName(i))) {
                respBO.setRespCode("18000");
                respBO.setRespDesc("\u7b2c" + (i + 1) + "\u4e2a\u6570\u636e\u9875\u7684\u540d\u79f0[" + excel.getSheetName(i) + "]\u4e0e\u9884\u671f\u4e0d\u7b26\u5408,\u8bf7\u4e0d\u8981\u4fee\u6539\u6a21\u677f\u6587\u4ef6\u7684\u9875\u540d\u79f0");
                return respBO;
            }
            ++i;
        }
        BillNotificationInfoVO bill = new BillNotificationInfoVO();
        reqBo.getData().setNotification(bill);
        InvoiceInfoVO invoice = new InvoiceInfoVO();
        StringBuilder errorCollection = new StringBuilder();
        List dataRows = excel.readRows(1, 0, -1);
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i2 = 1;
        while (i2 < dataRows.size()) {
            String[] fields = (String[])dataRows.get(i2);
            map.clear();
            StringBuilder errorMsg = this.arrayToMap(fields, this.notifiInMap, map);
            if (!this.isNullOrEmpty(errorMsg)) {
                errorCollection.append(errorMsg.toString());
                break;
            }
            errorMsg = this.arrayToMap(fields, this.notifiOutMap, map);
            if (!this.isNullOrEmpty(errorMsg)) {
                errorCollection.append(errorMsg.toString());
                break;
            }
            this.mapToBean(map, invoice);
            this.mapToBean(map, bill);
            ++i2;
        }
        if (!this.isNullOrEmpty(errorCollection)) {
            respBO.setRespCode("18000");
            respBO.setRespDesc(errorCollection.toString());
            return respBO;
        }
        logger.debug("Excel\u8f7d\u5165\u7684\u901a\u77e5\u5355\u4fe1\u606f=" + bill);
        logger.debug("Excel\u8f7d\u5165\u7684\u9500\u65b9\u53d1\u7968\u8d44\u6599=" + invoice);
        if (!notificationNo.equals(bill.getNotificationNo())) {
            respBO.setRespCode("18000");
            respBO.setRespDesc("\u5bfc\u5165\u7684\u901a\u77e5\u5355\u53f7\u4e0d\u7b26\u5408,\u8bf7\u5bfc\u5165" + notificationNo + "\u7684\u53d1\u7968\u6570\u636e");
            return respBO;
        }
        ArrayList<InvoiceInfoVO> invoices = new ArrayList<InvoiceInfoVO>();
        reqBo.getData().setInvoices(invoices);
        HashMap<String, InvoiceInfoVO> existInvoiceMap = new HashMap<String, InvoiceInfoVO>();
        try {
            dataRows = excel.readRows(2, 0, -1);
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6" + fileName + ",\u53d1\u751f\u9519\u8bef\u7684\u4f4d\u7f6e" + excel.getLastCellLocation(), (Throwable)e);
            excel.close();
            respBO.setRespCode("18000");
            respBO.setRespDesc("\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6,\u53d1\u751f\u9519\u8bef\u7684\u4f4d\u7f6e" + excel.getLastCellLocation() + e.getMessage());
            return respBO;
        }
        InvoiceInfoVO iv = null;
        StringBuilder nullErrorMsg = new StringBuilder();
        int i3 = 1;
        while (i3 < dataRows.size()) {
            String[] fields = (String[])dataRows.get(i3);
            if (fields[0].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i3 + 1) + "\u884c\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[1].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i3 + 1) + "\u884c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[2].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i3 + 1) + "\u884c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[3].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i3 + 1) + "\u884c\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (!this.isNullOrEmpty(nullErrorMsg)) {
                errorCollection.append(nullErrorMsg.toString());
                break;
            }
            map.clear();
            StringBuilder errorMsg = this.arrayToMap(fields, this.ivDetailInMap, map);
            if (!this.isNullOrEmpty(errorMsg)) {
                errorCollection.append(errorMsg.toString());
                break;
            }
            this.mapToBean(map, invoice);
            String ivNo = String.valueOf(invoice.getInvoiceCode()) + "-" + invoice.getInvoiceNo();
            if (!existInvoiceMap.containsKey(ivNo)) {
                iv = new InvoiceInfoVO();
                invoices.add(iv);
                BeanUtils.copyProperties((Object)invoice, (Object)iv);
                existInvoiceMap.put(ivNo, iv);
                iv.setInvoiceDetails(new ArrayList());
            }
            if (!this.isNullOrEmpty(errorMsg = this.arrayToMap(fields, this.ivDetailOutMap, map))) {
                errorCollection.append(errorMsg.toString());
                break;
            }
            InvoiceDetailVO ivDetail = new InvoiceDetailVO();
            iv.getInvoiceDetails().add(ivDetail);
            this.mapToBean(map, ivDetail);
            ++i3;
        }
        if (!this.isNullOrEmpty(errorCollection)) {
            respBO.setRespCode("18000");
            respBO.setRespDesc(errorCollection.toString());
            return respBO;
        }
        excel.close();
        reqBo.getData().setProcessType(Integer.valueOf(2));
        reqBo.getData().setNotificationNo(bill.getNotificationNo());
        logger.debug("\u53d1\u7968\u901a\u77e5\u5355\u6570\u636e\u5bfc\u5165reqBo:" + reqBo);
        try {
            BusiProcessInvoiceInOutRspBO resp = this.busiProcessInvoiceDataInOutService.processInvoiceInOut(reqBo);
            if (resp == null || !"0000".equals(resp.getRespCode())) {
                respBO.setRespCode("18000");
                respBO.setRespDesc(resp == null ? "\u65e0\u6cd5\u83b7\u53d6\u8fd4\u56de\u6570\u636e" : resp.getRespDesc());
                return respBO;
            }
            logger.debug("\u53d1\u7968\u901a\u77e5\u5355\u5bfc\u5165\u901a\u77e5\u5355\u4fe1\u606f\u8fd4\u56de,resp=" + resp);
            logger.debug("Excel \u6587\u4ef6" + fileName + "\u7684\u6570\u636e\u5bfc\u5165\u7cfb\u7edf\u5b8c\u6210");
            respBO.setRespCode("0000");
            respBO.setRespDesc("\u53d1\u7968\u6570\u636e\u5df2\u6210\u529f\u5bfc\u5165\u7cfb\u7edf");
            return respBO;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528Excel\u53d1\u7968\u901a\u77e5\u5355\u6570\u636e\u5bfc\u5165\u63a5\u53e3\u5931\u8d25,file=" + fileName, (Throwable)e);
            respBO.setRespCode("0000");
            respBO.setRespDesc("\u53d1\u7968\u6570\u636e\u5bfc\u5165\u63a5\u53e3\u8c03\u7528\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5.");
            return respBO;
        }
    }

    private boolean isNullOrEmpty(Object str) {
        return str == null || "".equals(str.toString());
    }

    private StringBuilder arrayToMap(String[] datasource, String[][] fieldDefine, Map<String, Object> targetMap) {
        StringBuilder errorMsg = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int j = 0;
        while (j < fieldDefine.length) {
            String type = fieldDefine[j][2];
            if (type.length() != 0) {
                int idx = ExcelFile.cellNameToIndex((String)fieldDefine[j][1]);
                String fName = fieldDefine[j][0];
                if (type.equals("D") && datasource[idx] != null) {
                    if (datasource[idx].length() == 0) {
                        datasource[idx] = "0";
                    }
                    targetMap.put(fName, new BigDecimal(datasource[idx]));
                } else if (type.equals("T")) {
                    Date dt = null;
                    try {
                        dt = sdf.parse(datasource[idx]);
                    }
                    catch (Exception e) {
                        errorMsg.append("\u65e5\u671f" + datasource[idx] + "\u683c\u5f0f\u6709\u8bef\u3002");
                        break;
                    }
                    if (dt != null) {
                        targetMap.put(fName, dt);
                    }
                } else {
                    targetMap.put(fName, datasource[idx]);
                }
            }
            ++j;
        }
        if (errorMsg != null && errorMsg.length() <= 0) {
            errorMsg = null;
        }
        return errorMsg;
    }

    private void mapToBean(Map<String, Object> map, Object bean) {
        try {
            org.apache.commons.beanutils.BeanUtils.populate((Object)bean, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

