/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.controller.rest.dataexport;

import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.file.FileProcessing;
import com.tydic.pfscext.api.busi.BusiExportApplyPayInfoService;
import com.tydic.pfscext.api.busi.BusiGetYuanGuangAttachmentNameService;
import com.tydic.pfscext.api.busi.bo.BusiExportApplyPayInfo4DlzqItemRspBO;
import com.tydic.pfscext.api.busi.bo.BusiExportApplyPayInfo4DlzqRspBO;
import com.tydic.pfscext.api.busi.bo.BusiExportApplyPayInfo4DzcsRspBO;
import com.tydic.pfscext.api.busi.bo.BusiExportApplyPayInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiExportApplyPayInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetYuanGuangAttachmentNameReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetYuanGuangAttachmentNameRspBO;
import com.tydic.pfscext.common.PDFShowPageFooterEvent;
import com.tydic.pfscext.controller.utils.FscFileUtils;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.YuanGuangBillType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class FscExportApplyPayInfoService {
    private static final Logger log = LoggerFactory.getLogger(FscExportApplyPayInfoService.class);
    @Autowired
    private BusiExportApplyPayInfoService busiExportApplyPayInfoService;
    @Autowired
    private BusiGetYuanGuangAttachmentNameService busiGetYuanGuangAttachmentNameService;

    public void export(HttpServletResponse response, BusiExportApplyPayInfoReqBO reqBO) throws Exception {
        block27: {
            if (log.isDebugEnabled()) {
                log.debug("\u5bfc\u51fa\u4ed8\u6b3e\u7533\u8bf7\u5355\u5165\u53c2\uff1a" + reqBO);
            }
            if (reqBO.getId() == 0L) {
                log.error("\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7[id]\u4e0d\u80fd\u4e3a\u7a7a\u3002reqBO=" + reqBO);
                this.failedMsg(response, "\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7[id]\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            BusiExportApplyPayInfoRspBO rspBO = null;
            try {
                rspBO = this.busiExportApplyPayInfoService.queryForExport(reqBO);
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u6570\u636e\u6e90\u67e5\u8be2\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
                this.failedMsg(response, "\u8c03\u7528\u6570\u636e\u6e90\u67e5\u8be2\u51fa\u9519");
                return;
            }
            if (rspBO == null) {
                log.error("\u67e5\u8be2\u65e0\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002reqBO=" + reqBO);
                this.failedMsg(response, "\u67e5\u8be2\u65e0\u6570\u636e");
                return;
            }
            if (!"0000".equals(rspBO.getRespCode())) {
                log.error("\u67e5\u8be2\u51fa\u9519\uff0c\u6e05\u67e5\u770b\u652f\u4ed8\u4e2d\u5fc3\u65e5\u5fd7\u3002reqBO=" + reqBO);
                this.failedMsg(response, "\u7cfb\u7edf\u9519\u8bef\u3002\u9519\u8bef\u539f\u56e0:" + rspBO.getRespDesc());
                return;
            }
            if (OrderSource.ELECTRIC_AREA.getCode().equals(rspBO.getSource()) || OrderSource.COAL_AREA.getCode().equals(rspBO.getSource()) || OrderSource.CONSULT_PRICE.getCode().equals(rspBO.getSource())) {
                this.export2(response, reqBO, rspBO.getDlzqRspBO());
                return;
            }
            BusiExportApplyPayInfo4DzcsRspBO dzcsRspBO = rspBO.getDzcsRspBO();
            BaseFont baseFont = null;
            try {
                baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (Exception e) {
                log.error("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
                this.failedMsg(response, "\u751f\u6210pdf\u51fa\u9519");
                return;
            }
            Font titleFont = new Font(baseFont, 14.0f, 1);
            Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
            String file_name = "\u8d44\u91d1\u4f7f\u7528\u5ba1\u6279\u5355";
            file_name = new String(file_name.getBytes(), "ISO-8859-1");
            response.setHeader("Content-Disposition", "attachment;filename=" + file_name + ".pdf");
            response.setContentType("application/x-download");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)response.getOutputStream());
                PdfWriter.getInstance((Document)document, (OutputStream)baos);
                PDFShowPageFooterEvent event = new PDFShowPageFooterEvent(PageSize.A4.rotate(), titleFont, titleFont);
                writer.setPageEvent((PdfPageEvent)event);
            }
            catch (Exception e) {
                log.error("\u628apdf\u5199\u5230\u8f93\u51fa\u6d41\u51fa\u9519\u3002reqBO=" + reqBO);
                this.failedMsg(response, "\u751f\u6210pdf\u51fa\u9519");
                return;
            }
            document.open();
            BaseFont bf = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font title1 = new Font(bf, 18.0f, 1);
            Font title2 = new Font(bf, 14.0f, 1);
            Font content = new Font(bf, 12.0f, 0);
            PdfPTable table = new PdfPTable(3);
            PdfPCell cell = new PdfPCell(new Phrase(dzcsRspBO.getCompanyName(), title1));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(6);
            cell.setFixedHeight(45.0f);
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(""));
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u8d44\u91d1\u4f7f\u7528\u5ba1\u6279\u5355", title2));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(""));
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u6240\u5c5e\u90e8\u95e8  " + dzcsRspBO.getOrgName(), content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(4);
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(""));
            cell.setHorizontalAlignment(2);
            cell.setBorder(0);
            table.addCell(cell);
            Date applyDate = dzcsRspBO.getApplyDate();
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            String applyDateStr = "";
            if (applyDate != null) {
                applyDateStr = sf.format(applyDate);
            }
            cell = new PdfPCell(new Phrase("\u7f16\u53f7\uff1a" + dzcsRspBO.getPayNo() + "  \u53d1\u8d77\u65e5\u671f\uff1a " + applyDateStr, content));
            cell.setHorizontalAlignment(2);
            cell.setBorder(0);
            table.addCell(cell);
            document.add((Element)table);
            table = new PdfPTable(11);
            cell = new PdfPCell(new Phrase("\u9879\u76ee\u540d\u79f0", content));
            cell.setColspan(2);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dzcsRspBO.getSupplierName(), content));
            cell.setColspan(9);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5408\u540c\u672c\u6b21\u652f\u4ed8\u60c5\u51b5", content));
            cell.setRowspan(4);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(120.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u7533\u8bf7\u91d1\u989d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(String.valueOf(String.valueOf(dzcsRspBO.getApplyAmt())) + "\u5143", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5408\u540c\u7d2f\u8ba1\u6536\u4ed8\u60c5\u51b5\uff08\u4e0d\u542b\u672c\u6b21\uff09", content));
            cell.setRowspan(4);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u9500\u552e\u5408\u540c", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("", content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5408\u540c\u91d1\u989d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("", content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u672c\u6b21\u7533\u8bf7\u652f\u4ed8\u6bd4\u4f8b", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("100%", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u7d2f\u8ba1\u6536\u6b3e", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("", content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u6536\u6b3e\u6bd4\u4f8b", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("", content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u4ed8\u6b3e\u6027\u8d28", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u7ed3\u7b97\u6b3e", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u91c7\u8d2d\u5408\u540c", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dzcsRspBO.getContractNo(), content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5408\u540c\u91d1\u989d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("", content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u6700\u8fdf\u4ed8\u6b3e\u671f", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            Date expectPaidDate = dzcsRspBO.getExpectPaidDate();
            SimpleDateFormat sf1 = new SimpleDateFormat("yyyy-MM-dd");
            String expectPaidDateStr = "";
            if (expectPaidDate != null) {
                expectPaidDateStr = sf1.format(expectPaidDate);
            }
            cell = new PdfPCell(new Phrase(expectPaidDateStr, content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u7d2f\u8ba1\u4ed8\u6b3e", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("", content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u4ed8\u6b3e\u6bd4\u4f8b", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("", content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u6536\u5f00\u7968\u60c5\u51b5", content));
            cell.setRowspan(2);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(60.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u9500\u552e\u5408\u540c", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("", content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5f00\u7968\u91d1\u989d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("", content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(3);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5f00\u7968\u6bd4\u4f8b", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("", content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u91c7\u8d2d\u5408\u540c", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dzcsRspBO.getContractNo(), content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u6536\u7968\u91d1\u989d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(String.valueOf(dzcsRspBO.getRecInvoiceAmt() == null ? "" : dzcsRspBO.getRecInvoiceAmt() + "\u5143"), content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(3);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u6536\u7968\u6bd4\u4f8b", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("100%", content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u6536\u6b3e\u4eba\u5355\u4f4d\u4fe1\u606f", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(120.0f);
            cell.setRowspan(4);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u6536\u6b3e\u4eba", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dzcsRspBO.getReciever(), content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(6);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u652f\u4ed8\u65b9\u5f0f", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dzcsRspBO.getPayMethod(), content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u6536\u6b3e\u884c", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dzcsRspBO.getRecOpenBankName(), content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(9);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u8d26  \u53f7", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dzcsRspBO.getRecAcctNo(), content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(9);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u652f\u4ed8\u91d1\u989d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dzcsRspBO.getAmt() + "\u5143", content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5927\u5199", content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u4eba\u6c11\u5e01 " + dzcsRspBO.getAmtUpper(), content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(6);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5907\u6ce8", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dzcsRspBO.getRemark(), content));
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setColspan(10);
            table.addCell(cell);
            document.add((Element)table);
            table = new PdfPTable(3);
            cell = new PdfPCell(new Phrase("\u4e1a\u52a1\u7ecf\u529e\u4eba\uff1a" + dzcsRspBO.getOperName(), content));
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u9879\u76ee\u7ecf\u7406\uff1a" + dzcsRspBO.getProjectManagerName(), content));
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u90e8\u95e8\u7ecf\u7406\uff1a" + dzcsRspBO.getDepartmentManagerName(), content));
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u8425\u4e1a\u90e8\u7ecf\u7406\uff1a" + dzcsRspBO.getOperatorManagerName(), content));
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5206\u7ba1\u9886\u5bfc\uff1a" + dzcsRspBO.getDevisionBossName(), content));
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u603b\u7ecf\u7406\uff1a" + dzcsRspBO.getCheifManagerName(), content));
            cell.setBorder(0);
            table.addCell(cell);
            document.add((Element)table);
            document.close();
            InputStream inputStream = null;
            try {
                try {
                    inputStream = FscFileUtils.outputStreamToInputStream(baos);
                    if (inputStream != null) {
                        BusiGetYuanGuangAttachmentNameReqBO nameReqBO = new BusiGetYuanGuangAttachmentNameReqBO();
                        nameReqBO.setBillTypeCode(YuanGuangBillType.PAYMNET_APPROVAL_MATERIAL.getCode());
                        nameReqBO.setBillNo(dzcsRspBO.getPayNo().toString());
                        nameReqBO.setCompanyId(reqBO.getCompanyId());
                        nameReqBO.setSuffixName(".pdf");
                        BusiGetYuanGuangAttachmentNameRspBO nameRspBO = this.busiGetYuanGuangAttachmentNameService.query(nameReqBO);
                        String newFileName = FileProcessing.uploadFileByInputStream((String)nameRspBO.getAttachmentName(), (InputStream)inputStream, (String)"", (String)"PAY", (boolean)false);
                        if (StringUtils.hasText((String)newFileName)) {
                            log.debug("\u4e0a\u4f20\u6587\u4ef6" + nameRspBO.getAttachmentName() + "\u5230OSS\u6210\u529f");
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25", (Throwable)e);
                    if (inputStream == null) break block27;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        log.error("\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519", (Throwable)e2);
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error("\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519", (Throwable)e);
                    }
                }
            }
        }
    }

    public void export2(HttpServletResponse response, BusiExportApplyPayInfoReqBO reqBO, BusiExportApplyPayInfo4DlzqRspBO dlzqRspBO) throws Exception {
        block19: {
            BaseFont baseFont = null;
            try {
                baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (Exception e) {
                log.error("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
                this.failedMsg(response, "\u751f\u6210pdf\u51fa\u9519");
                return;
            }
            Font titleFont = new Font(baseFont, 14.0f, 1);
            Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
            String fileName = new String("\u8d44\u91d1\u4f7f\u7528\u5ba1\u6279\u5355".getBytes(), "ISO-8859-1");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".pdf");
            response.setContentType("application/x-download");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)response.getOutputStream());
                PdfWriter.getInstance((Document)document, (OutputStream)baos);
                PDFShowPageFooterEvent event = new PDFShowPageFooterEvent(PageSize.A4.rotate(), titleFont, titleFont);
                writer.setPageEvent((PdfPageEvent)event);
            }
            catch (Exception e) {
                log.error("\u628apdf\u5199\u5230\u8f93\u51fa\u6d41\u51fa\u9519\u3002reqBO=" + reqBO);
                this.failedMsg(response, "\u751f\u6210pdf\u51fa\u9519");
                return;
            }
            document.open();
            BaseFont bf = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font title1 = new Font(bf, 18.0f, 1);
            Font title2 = new Font(bf, 14.0f, 1);
            Font content = new Font(bf, 12.0f, 0);
            PdfPTable table = new PdfPTable(3);
            PdfPCell cell = new PdfPCell(new Phrase(dlzqRspBO.getCompanyName(), title1));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(6);
            cell.setFixedHeight(45.0f);
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(""));
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u8d44\u91d1\u4f7f\u7528\u5ba1\u6279\u5355", title2));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(""));
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(""));
            cell.setHorizontalAlignment(2);
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(""));
            cell.setHorizontalAlignment(2);
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u4ed8\u6b3e\u5355\u7f16\u53f7\uff1a" + dlzqRspBO.getPayNo(), content));
            cell.setHorizontalAlignment(2);
            cell.setBorder(0);
            table.addCell(cell);
            document.add((Element)table);
            table = new PdfPTable(12);
            cell = new PdfPCell(new Phrase("\u586b\u62a5\u5355\u4f4d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getCompanyName(), content));
            cell.setColspan(3);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5236\u5355\u4eba", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getOperName(), content));
            cell.setColspan(3);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5236\u5355\u65e5\u671f", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getApplyDate(), content));
            cell.setColspan(3);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u4f9b\u8d27\u5355\u4f4d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getSupplierName(), content));
            cell.setColspan(3);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u4ed8\u6b3e\u7c7b\u578b", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getPayTypeName(), content));
            cell.setColspan(3);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u672c\u6b21\u4ed8\u6b3e", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getAmt(), content));
            cell.setColspan(3);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u7ed3\u7b97\u91d1\u989d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getSettleAmt(), content));
            cell.setColspan(3);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5e94\u4ed8\u91d1\u989d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getPayableAmt(), content));
            cell.setColspan(3);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5df2\u4ed8\u91d1\u989d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getPaidAmt(), content));
            cell.setColspan(3);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5f00\u6237\u884c", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getRecOpenBankName(), content));
            cell.setColspan(3);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u94f6\u884c\u8d26\u53f7", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getRecAcctNo(), content));
            cell.setColspan(3);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5e01\u79cd", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getCurrency(), content));
            cell.setColspan(3);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u6458\u8981", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getRemark(), content));
            cell.setColspan(11);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            document.add((Element)table);
            table = new PdfPTable(11);
            cell = new PdfPCell(new Phrase("\u8ba2\u5355\u7f16\u53f7", content));
            cell.setColspan(2);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5408\u540c\u7f16\u53f7", content));
            cell.setColspan(2);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u4ed8\u6b3e\u65b9\u5f0f", content));
            cell.setColspan(2);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5408\u540c/\u8ba2\u5355\u91d1\u989d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u7ed3\u7b97\u91d1\u989d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5e94\u4ed8\u91d1\u989d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5df2\u4ed8\u91d1\u989d", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u672c\u6b21\u4ed8\u6b3e", content));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            List items = dlzqRspBO.getItems();
            for (BusiExportApplyPayInfo4DlzqItemRspBO item : items) {
                cell = new PdfPCell(new Phrase(item.getPlaAgreementName(), content));
                cell.setColspan(2);
                cell.setHorizontalAlignment(1);
                cell.setVerticalAlignment(5);
                cell.setFixedHeight(30.0f);
                table.addCell(cell);
                cell = new PdfPCell(new Phrase(item.getPlaAgreementCode(), content));
                cell.setColspan(2);
                cell.setHorizontalAlignment(1);
                cell.setVerticalAlignment(5);
                table.addCell(cell);
                cell = new PdfPCell(new Phrase(item.getPayTypeName(), content));
                cell.setColspan(2);
                cell.setHorizontalAlignment(1);
                cell.setVerticalAlignment(5);
                table.addCell(cell);
                cell = new PdfPCell(new Phrase(item.getPurchaseOrderMoney(), content));
                cell.setHorizontalAlignment(2);
                cell.setVerticalAlignment(5);
                table.addCell(cell);
                cell = new PdfPCell(new Phrase(item.getSettleAmt(), content));
                cell.setHorizontalAlignment(2);
                cell.setVerticalAlignment(5);
                table.addCell(cell);
                cell = new PdfPCell(new Phrase(item.getPayableAmt(), content));
                cell.setHorizontalAlignment(2);
                cell.setVerticalAlignment(5);
                table.addCell(cell);
                cell = new PdfPCell(new Phrase(item.getPaidAmt(), content));
                cell.setHorizontalAlignment(2);
                cell.setVerticalAlignment(5);
                table.addCell(cell);
                cell = new PdfPCell(new Phrase(item.getAmt(), content));
                cell.setHorizontalAlignment(2);
                cell.setVerticalAlignment(5);
                table.addCell(cell);
            }
            cell = new PdfPCell(new Phrase("\u5408\u8ba1\uff1a", content));
            cell.setColspan(2);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setFixedHeight(30.0f);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("", content));
            cell.setColspan(8);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(String.valueOf(dlzqRspBO.getAmt()), content));
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            document.add((Element)table);
            table = new PdfPTable(12);
            cell = new PdfPCell(new Phrase("\u516c\u53f8\u9886\u5bfc\uff1a", content));
            cell.setColspan(2);
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("", content));
            cell.setBorder(0);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u8d22\u52a1\u90e8\uff1a", content));
            cell.setColspan(2);
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("", content));
            cell.setBorder(0);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u7ecf\u529e\u4eba\u90e8\u95e8\u8d1f\u8d23\u4eba\uff1a", content));
            cell.setColspan(2);
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getProjectManagerName(), content));
            cell.setBorder(0);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("\u7ecf\u529e\u4eba\uff1a", content));
            cell.setColspan(2);
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(dlzqRspBO.getOperName(), content));
            cell.setBorder(0);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
            document.add((Element)table);
            document.close();
            InputStream inputStream = null;
            try {
                try {
                    inputStream = FscFileUtils.outputStreamToInputStream(baos);
                    if (inputStream != null) {
                        BusiGetYuanGuangAttachmentNameReqBO nameReqBO = new BusiGetYuanGuangAttachmentNameReqBO();
                        nameReqBO.setBillTypeCode(YuanGuangBillType.PAYMNET_APPROVAL_MATERIAL.getCode());
                        nameReqBO.setBillNo(dlzqRspBO.getPayNo().toString());
                        nameReqBO.setCompanyId(reqBO.getCompanyId());
                        nameReqBO.setSuffixName(".pdf");
                        BusiGetYuanGuangAttachmentNameRspBO nameRspBO = this.busiGetYuanGuangAttachmentNameService.query(nameReqBO);
                        String newFileName = FileProcessing.uploadFileByInputStream((String)nameRspBO.getAttachmentName(), (InputStream)inputStream, (String)"", (String)"PAY", (boolean)false);
                        if (StringUtils.hasText((String)newFileName)) {
                            log.debug("\u4e0a\u4f20\u6587\u4ef6" + nameRspBO.getAttachmentName() + "\u5230OSS\u6210\u529f");
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25", (Throwable)e);
                    if (inputStream == null) break block19;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        log.error("\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519", (Throwable)e2);
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error("\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519", (Throwable)e);
                    }
                }
            }
        }
    }

    private boolean failedMsg(HttpServletResponse response, String msg) {
        response.setContentType("text/html;charset=utf-8");
        try {
            msg = String.format("<html><head><meta charset=\"utf-8\"><script language='javascript'>alert(\"%s\");window.history.back();</script></head><body><textarea>%s</textarea></body></html>", msg, msg);
            response.getWriter().print(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

