/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.controller.utils;

import com.tydic.pfscext.common.ExcelFile;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FscExcelUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscExcelUtils.class);
    private static final Integer DCIMAL_DIGITS = 2;

    public static void arrayToMap(String[] datasource, String[][] fieldDefine, Map<String, Object> targetMap) {
        String[][] stringArray = fieldDefine;
        int n = fieldDefine.length;
        int n2 = 0;
        while (n2 < n) {
            String[] strings = stringArray[n2];
            String type = strings[2];
            if (type.length() != 0) {
                int idx = ExcelFile.cellNameToIndex((String)strings[1]);
                String fName = strings[0];
                if ("D".equals(type) && datasource[idx] != null) {
                    if (datasource[idx].length() == 0) {
                        datasource[idx] = "0";
                    }
                    targetMap.put(fName, new BigDecimal(datasource[idx]));
                } else if ("T".equals(type)) {
                    Date dt = FscExcelUtils.formatDate(datasource[idx]);
                    if (dt != null) {
                        targetMap.put(fName, dt);
                    }
                } else {
                    targetMap.put(fName, datasource[idx]);
                }
            }
            ++n2;
        }
    }

    private static Date formatDate(String dt) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date result = null;
        try {
            result = sdf.parse(dt);
        }
        catch (ParseException e) {
            LOGGER.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
        return result;
    }

    public static String getValue(Cell cell) {
        DecimalFormat df = new DecimalFormat("0.####");
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String val = null;
        if (cell != null) {
            switch (cell.getCellType()) {
                case NUMERIC: {
                    int dcimalDigits;
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        val = fmt.format(cell.getDateCellValue());
                        break;
                    }
                    val = df.format(cell.getNumericCellValue());
                    int indexOf = val.indexOf(".");
                    if (indexOf <= 0 || (dcimalDigits = val.length() - 1 - indexOf) <= DCIMAL_DIGITS) break;
                    val = new BigDecimal(val).setScale(2, 1).toString();
                    break;
                }
                case STRING: {
                    val = cell.getStringCellValue();
                    break;
                }
                case BOOLEAN: {
                    val = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case BLANK: {
                    val = cell.getStringCellValue();
                    break;
                }
                case ERROR: {
                    val = "\u9519\u8bef";
                    break;
                }
                case FORMULA: {
                    try {
                        val = String.valueOf(cell.getStringCellValue());
                    }
                    catch (IllegalStateException e) {
                        val = String.valueOf(cell.getNumericCellValue());
                    }
                    break;
                }
                default: {
                    val = cell.getRichStringCellValue() == null ? null : cell.getRichStringCellValue().toString();
                }
            }
        }
        return val;
    }

    public static Workbook createWorkbook(MultipartFile file) throws IOException {
        boolean isE2007 = false;
        String e07Suffix = "xlsx";
        if (file.getOriginalFilename().endsWith(e07Suffix)) {
            isE2007 = true;
        }
        InputStream input = file.getInputStream();
        Object wb = isE2007 ? new XSSFWorkbook(input) : new HSSFWorkbook(input);
        return wb;
    }
}

