/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.controller.rest.dataexport;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.file.FileProcessing;
import com.tydic.pfscext.api.busi.BusiExportListReceiptInfoService;
import com.tydic.pfscext.api.busi.BusiExportReceiptInfoService;
import com.tydic.pfscext.api.busi.BusiGetYuanGuangAttachmentNameService;
import com.tydic.pfscext.api.busi.bo.BusiExportHeadReceiptInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiExportListReceiptInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiExportListReceiptInfoRsqBO;
import com.tydic.pfscext.api.busi.bo.BusiExportReceiptInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiExportReceiptInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiExportRowReceiptInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetYuanGuangAttachmentNameReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetYuanGuangAttachmentNameRspBO;
import com.tydic.pfscext.common.PDFShowPageFooterEvent;
import com.tydic.pfscext.controller.utils.FscFileUtils;
import com.tydic.pfscext.enums.YuanGuangBillType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class FscExportReceiptInfoService {
    private static final Logger log = LoggerFactory.getLogger(FscExportReceiptInfoService.class);
    @Autowired
    private BusiExportReceiptInfoService busiExportReceiptInfoService;
    @Autowired
    private BusiExportListReceiptInfoService busiExportListReceiptInfoService;
    @Autowired
    private BusiGetYuanGuangAttachmentNameService busiGetYuanGuangAttachmentNameService;

    public void exportList(HttpServletResponse response, BusiExportListReceiptInfoReqBO reqBO) {
        block46: {
            if (log.isDebugEnabled()) {
                log.debug("reqBO=" + reqBO);
            }
            if (reqBO.getApplyNo() == null) {
                log.error("\u6c47\u603b\u5355\u53f7[applyNo]\u4e0d\u80fd\u4e3a\u7a7a\u3002reqBO=" + reqBO);
                this.failedMsg(response, "\u6c47\u603b\u5355\u53f7[applyNo]\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            List busiExportListReceiptInfoRsqBO = null;
            busiExportListReceiptInfoRsqBO = this.busiExportListReceiptInfoService.exportListReceiptInfo(reqBO);
            Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
            BaseFont baseFont = null;
            try {
                baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (Exception e) {
                log.error("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519\u3002reqBO=" + reqBO);
                this.failedMsg(response, "\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519");
                return;
            }
            Font titleFont = new Font(baseFont, 14.0f, 1);
            int COLUMNS = 22;
            response.setHeader("Content-Disposition", "attachment;filename=receiptPDF.pdf");
            response.setContentType("application/x-download");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)response.getOutputStream());
                PdfWriter.getInstance((Document)document, (OutputStream)baos);
                PDFShowPageFooterEvent event = new PDFShowPageFooterEvent(PageSize.A4.rotate(), titleFont, titleFont);
                writer.setPageEvent((PdfPageEvent)event);
            }
            catch (Exception e) {
                log.error("\u628apdf\u5199\u5230\u8f93\u51fa\u6d41\u51fa\u9519\u3002reqBO=" + reqBO);
                this.failedMsg(response, "\u628apdf\u5199\u5230\u8f93\u51fa\u6d41\u51fa\u9519\u3002");
                return;
            }
            document.open();
            int i = 0;
            while (i < busiExportListReceiptInfoRsqBO.size()) {
                BusiExportReceiptInfoReqBO busiExportReceiptInfoReqBO = new BusiExportReceiptInfoReqBO();
                BeanUtils.copyProperties(busiExportListReceiptInfoRsqBO.get(i), (Object)busiExportReceiptInfoReqBO);
                BusiExportReceiptInfoRspBO rspBO = null;
                try {
                    rspBO = this.busiExportReceiptInfoService.exportReceiptInfo(busiExportReceiptInfoReqBO);
                    if (rspBO == null || !"0000".equals(rspBO.getRespCode())) {
                        this.failedMsg(response, rspBO == null ? "\u67e5\u8be2\u5165\u5e93\u6570\u636e\u5931\u8d25," : rspBO.getRespDesc());
                        return;
                    }
                }
                catch (Exception e) {
                    log.error("\u67e5\u8be2\u65e0\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002reqBO=" + reqBO, (Throwable)e);
                    this.failedMsg(response, "\u67e5\u8be2\u65e0\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                    return;
                }
                BusiExportHeadReceiptInfoRspBO head = rspBO.getHead();
                List rows = rspBO.getRows();
                Font contentFont = null;
                contentFont = "4".equals(head.getSource()) ? new Font(baseFont, 10.0f, 0) : new Font(baseFont, 8.0f, 0);
                PdfPTable titleTablex = new PdfPTable(3);
                PdfPCell titleCellx = new PdfPCell();
                titleCellx.setPhrase(new Phrase(head.getCompanyName(), contentFont));
                titleCellx.setRowspan(1);
                titleCellx.setColspan(1);
                titleCellx.setBorder(0);
                titleCellx.setFixedHeight(8.0f);
                titleCellx.setHorizontalAlignment(1);
                titleCellx.setVerticalAlignment(5);
                titleTablex.addCell(titleCellx);
                titleCellx.setPhrase(null);
                titleTablex.addCell(titleCellx);
                titleCellx.setPhrase(new Phrase("\u7269\u8d44\u91c7\u8d2d\u9a8c\u6536\u5165\u5e93\u5355", titleFont));
                titleCellx.setRowspan(1);
                titleCellx.setColspan(1);
                titleCellx.setBorder(0);
                titleCellx.setFixedHeight(20.0f);
                titleCellx.setHorizontalAlignment(1);
                titleCellx.setVerticalAlignment(6);
                titleTablex.addCell(titleCellx);
                titleCellx.setPhrase(null);
                titleTablex.addCell(titleCellx);
                titleCellx.setPhrase(new Phrase(head.getEntryDate(), contentFont));
                titleCellx.setRowspan(1);
                titleCellx.setColspan(1);
                titleCellx.setBorder(0);
                titleCellx.setFixedHeight(8.0f);
                titleCellx.setHorizontalAlignment(1);
                titleCellx.setVerticalAlignment(5);
                titleTablex.addCell(titleCellx);
                titleCellx.setPhrase(null);
                titleTablex.addCell(titleCellx);
                try {
                    document.add((Element)titleTablex);
                }
                catch (DocumentException e) {
                    log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO);
                    this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
                    return;
                }
                PdfPTable table1 = new PdfPTable(6);
                PdfPCell cell1 = new PdfPCell();
                cell1.setColspan(0);
                cell1.setBorder(0);
                cell1.setHorizontalAlignment(2);
                cell1.setVerticalAlignment(2);
                table1.addCell(cell1);
                cell1.setPhrase(new Phrase("\u5165\u5e93\u5355\u53f7\uff1a" + head.getEntryNo(), contentFont));
                cell1.setColspan(2);
                cell1.setHorizontalAlignment(0);
                table1.addCell(cell1);
                cell1.setPhrase(new Phrase("\u5165\u5e93\u6c47\u603b\u5355\u53f7\uff1a" + reqBO.getApplyNo(), contentFont));
                cell1.setColspan(2);
                table1.addCell(cell1);
                cell1.setPhrase(new Phrase("\u5355\u4f4d\uff1a\u5143", contentFont));
                cell1.setColspan(2);
                table1.addCell(cell1);
                try {
                    document.add((Element)table1);
                }
                catch (DocumentException e) {
                    log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO);
                    this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
                    return;
                }
                PdfPTable table2 = new PdfPTable(22);
                PdfPCell cell2 = new PdfPCell(new Phrase("\u5382\u5546\u540d\u79f0", contentFont));
                cell2.setColspan(1);
                cell2.setHorizontalAlignment(1);
                cell2.setVerticalAlignment(5);
                table2.addCell(cell2);
                cell2.setPhrase(new Phrase(head.getPurchaseName(), contentFont));
                cell2.setColspan(12);
                table2.addCell(cell2);
                cell2.setPhrase(new Phrase("\u5408\u540c\u53f7", contentFont));
                cell2.setColspan(1);
                table2.addCell(cell2);
                cell2.setPhrase(new Phrase(head.getNotificationNo(), contentFont));
                cell2.setColspan(8);
                table2.addCell(cell2);
                try {
                    document.add((Element)table2);
                }
                catch (DocumentException e) {
                    log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO);
                    this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
                    return;
                }
                PdfPTable table3 = new PdfPTable(22);
                PdfPCell cell3 = new PdfPCell(new Phrase("\u9700\u7528\u5355\u4f4d", contentFont));
                cell3.setColspan(1);
                cell3.setHorizontalAlignment(1);
                cell3.setVerticalAlignment(5);
                table3.addCell(cell3);
                cell3.setPhrase(new Phrase("", contentFont));
                cell3.setColspan(12);
                table3.addCell(cell3);
                cell3.setPhrase(new Phrase("\u5408\u540c\u53f7", contentFont));
                cell3.setColspan(1);
                table3.addCell(cell3);
                cell3.setPhrase(new Phrase("", contentFont));
                cell3.setColspan(8);
                table3.addCell(cell3);
                try {
                    document.add((Element)table3);
                }
                catch (DocumentException e) {
                    log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO);
                    this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
                    return;
                }
                PdfPTable headTable = new PdfPTable(22);
                PdfPCell headCell = new PdfPCell(new Phrase("\u5e8f\u53f7", contentFont));
                headCell.setColspan(1);
                headCell.setHorizontalAlignment(1);
                headCell.setVerticalAlignment(5);
                headTable.addCell(headCell);
                headCell.setPhrase(new Phrase("\u53d1\u7968\u53f7\u7801", contentFont));
                headCell.setColspan(2);
                headTable.addCell(headCell);
                headCell.setPhrase(new Phrase("\u7269\u8d44\u540d\u79f0", contentFont));
                headCell.setColspan(8);
                headTable.addCell(headCell);
                headCell.setPhrase(new Phrase("\u89c4\u683c ", contentFont));
                headCell.setColspan(1);
                headTable.addCell(headCell);
                headCell.setPhrase(new Phrase("\u578b\u53f7 ", contentFont));
                headCell.setColspan(1);
                headTable.addCell(headCell);
                headCell.setPhrase(new Phrase("\u5355\u4f4d", contentFont));
                headCell.setColspan(1);
                headTable.addCell(headCell);
                headCell.setPhrase(new Phrase("\u6570\u91cf", contentFont));
                headCell.setColspan(1);
                headTable.addCell(headCell);
                headCell.setPhrase(new Phrase("\u5355\u4ef7", contentFont));
                headCell.setColspan(2);
                headTable.addCell(headCell);
                headCell.setPhrase(new Phrase("\u8d27\u6b3e", contentFont));
                headCell.setColspan(2);
                headTable.addCell(headCell);
                headCell.setPhrase(new Phrase("\u7a0e\u7387", contentFont));
                headCell.setColspan(1);
                headTable.addCell(headCell);
                headCell.setPhrase(new Phrase("\u7a0e\u91d1", contentFont));
                headCell.setColspan(2);
                headTable.addCell(headCell);
                try {
                    document.add((Element)headTable);
                }
                catch (DocumentException e) {
                    log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO);
                    this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
                    return;
                }
                int count = 1;
                for (BusiExportRowReceiptInfoRspBO row : rows) {
                    PdfPTable detailTable = new PdfPTable(22);
                    PdfPCell detailCell = new PdfPCell(new Phrase("" + count++, contentFont));
                    detailCell.setColspan(1);
                    detailCell.setHorizontalAlignment(1);
                    detailCell.setVerticalAlignment(5);
                    detailTable.addCell(detailCell);
                    detailCell.setPhrase(new Phrase(row.getInvoiceNo(), contentFont));
                    detailCell.setColspan(2);
                    detailCell.setHorizontalAlignment(1);
                    detailTable.addCell(detailCell);
                    detailCell.setPhrase(new Phrase(row.getItemName(), contentFont));
                    detailCell.setColspan(8);
                    detailCell.setHorizontalAlignment(0);
                    detailTable.addCell(detailCell);
                    detailCell.setPhrase(new Phrase(row.getSpec(), contentFont));
                    detailCell.setColspan(1);
                    detailCell.setHorizontalAlignment(1);
                    detailTable.addCell(detailCell);
                    detailCell.setPhrase(new Phrase(row.getModel(), contentFont));
                    detailCell.setColspan(1);
                    detailCell.setHorizontalAlignment(1);
                    detailTable.addCell(detailCell);
                    detailCell.setPhrase(new Phrase(row.getUnitName(), contentFont));
                    detailCell.setColspan(1);
                    detailCell.setHorizontalAlignment(1);
                    detailTable.addCell(detailCell);
                    detailCell.setPhrase(new Phrase("" + row.getQuantity(), contentFont));
                    detailCell.setColspan(1);
                    detailCell.setHorizontalAlignment(1);
                    detailTable.addCell(detailCell);
                    detailCell.setPhrase(new Phrase(row.getPurchaseUnitPrice(), contentFont));
                    detailCell.setColspan(2);
                    detailCell.setHorizontalAlignment(2);
                    detailTable.addCell(detailCell);
                    detailCell.setPhrase(new Phrase(row.getNotTaxAmt(), contentFont));
                    detailCell.setColspan(2);
                    detailCell.setHorizontalAlignment(2);
                    detailTable.addCell(detailCell);
                    detailCell.setPhrase(new Phrase("" + row.getTaxPercent(), contentFont));
                    detailCell.setColspan(1);
                    detailCell.setHorizontalAlignment(2);
                    detailTable.addCell(detailCell);
                    detailCell.setPhrase(new Phrase(row.getTaxAmt(), contentFont));
                    detailCell.setColspan(2);
                    detailCell.setHorizontalAlignment(2);
                    detailTable.addCell(detailCell);
                    try {
                        document.add((Element)detailTable);
                    }
                    catch (DocumentException e) {
                        log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO);
                        this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
                        return;
                    }
                }
                PdfPTable table5 = new PdfPTable(22);
                PdfPCell cell5 = new PdfPCell(new Phrase("\u6210\u672c\u5c0f\u8ba1", contentFont));
                cell5.setColspan(17);
                cell5.setHorizontalAlignment(1);
                cell5.setVerticalAlignment(5);
                table5.addCell(cell5);
                cell5.setPhrase(new Phrase(head.getSumNotTaxAmt(), contentFont));
                cell5.setColspan(2);
                cell5.setHorizontalAlignment(2);
                table5.addCell(cell5);
                cell5.setPhrase(new Phrase("", contentFont));
                cell5.setColspan(1);
                cell5.setHorizontalAlignment(2);
                table5.addCell(cell5);
                cell5.setPhrase(new Phrase(head.getSumTaxAmt(), contentFont));
                cell5.setColspan(2);
                table5.addCell(cell5);
                try {
                    document.add((Element)table5);
                }
                catch (DocumentException e) {
                    log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO);
                    this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
                    return;
                }
                PdfPTable table6 = new PdfPTable(22);
                PdfPCell cell6 = new PdfPCell(new Phrase("\u6210\u672c\u5408\u8ba1", contentFont));
                cell6.setColspan(17);
                cell6.setHorizontalAlignment(1);
                cell6.setVerticalAlignment(5);
                table6.addCell(cell6);
                cell6.setPhrase(new Phrase(head.getSum(), contentFont));
                cell6.setColspan(5);
                table6.addCell(cell6);
                try {
                    document.add((Element)table6);
                }
                catch (DocumentException e) {
                    log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO);
                    this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
                    return;
                }
                if ("4".equals(head.getSource())) {
                    PdfPTable table7 = new PdfPTable(9);
                    PdfPCell cell7 = new PdfPCell(new Phrase("", contentFont));
                    cell7.setColspan(1);
                    cell7.setBorder(0);
                    cell7.setFixedHeight(30.0f);
                    cell7.setHorizontalAlignment(0);
                    cell7.setVerticalAlignment(5);
                    table7.addCell(cell7);
                    cell7.setPhrase(new Phrase("\u5ba1\u6838\u4eba\uff1a", contentFont));
                    cell7.setColspan(6);
                    table7.addCell(cell7);
                    cell7.setPhrase(new Phrase("\u5236\u5355\u4eba\uff1a" + head.getCreateUserName(), contentFont));
                    cell7.setColspan(2);
                    table7.addCell(cell7);
                    try {
                        document.add((Element)table7);
                    }
                    catch (DocumentException e) {
                        log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO);
                        response.setContentType("text/html;charset=utf-8");
                        try {
                            response.getWriter().print("\u751f\u6210pdf\u51fa\u9519");
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        return;
                    }
                }
                if (busiExportListReceiptInfoRsqBO.size() == i + 1) break;
                document.newPage();
                ++i;
            }
            document.close();
            InputStream inputStream = null;
            try {
                try {
                    inputStream = FscFileUtils.outputStreamToInputStream(baos);
                    if (inputStream != null) {
                        BusiGetYuanGuangAttachmentNameReqBO nameReqBO = new BusiGetYuanGuangAttachmentNameReqBO();
                        nameReqBO.setBillTypeCode(YuanGuangBillType.ENTRY_MATERIAL_PURCHASE_ENTRY_DETAIL.getCode());
                        nameReqBO.setBillNo(reqBO.getApplyNo());
                        nameReqBO.setCompanyId(((BusiExportListReceiptInfoRsqBO)busiExportListReceiptInfoRsqBO.get(0)).getCompanyId());
                        nameReqBO.setSuffixName(".pdf");
                        BusiGetYuanGuangAttachmentNameRspBO nameRspBO = this.busiGetYuanGuangAttachmentNameService.query(nameReqBO);
                        String newFileName = FileProcessing.uploadFileByInputStream((String)nameRspBO.getAttachmentName(), (InputStream)inputStream, (String)"", (String)"PAY", (boolean)false);
                        if (StringUtils.hasText((String)newFileName)) {
                            log.debug("\u4e0a\u4f20\u6587\u4ef6" + nameRspBO.getAttachmentName() + "\u5230OSS\u6210\u529f");
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25:" + e.getMessage());
                    if (inputStream == null) break block46;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        log.error("\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519:" + e2.getMessage());
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error("\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519:" + e.getMessage());
                    }
                }
            }
        }
    }

    private void failedMsg(HttpServletResponse response, String msg) {
        response.setContentType("text/html;charset=utf-8");
        try {
            msg = String.format("<html><head><meta charset=\"utf-8\"><script language='javascript'>alert(\"%s\");window.history.back();</script></head><body><textarea>%s</textarea></body></html>", msg, msg);
            response.getWriter().print(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

