/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.controller.rest.dataimport;

import com.ohaotian.plugin.file.FileClient;
import com.tydic.pfscext.api.busi.BusiReceiptUploadService;
import com.tydic.pfscext.api.busi.bo.BusiReceiptUploadReqBO;
import com.tydic.pfscext.api.busi.bo.BusiReceiptUploadRspBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FscReceiptUploadService {
    private static final Logger logger = LoggerFactory.getLogger(FscReceiptUploadService.class);
    private BusiReceiptUploadService busiReceiptUploadService;
    private FileClient fileClient;
    private static final String path = "pay";
    @Value(value="${oss.accessUrl}")
    private String baseUrl;

    public FscReceiptUploadService(FileClient fileClient) {
        this.fileClient = fileClient;
    }

    public PfscExtRspBaseBO receiptUpload(HttpServletResponse response, @RequestParam(value="hwFile") MultipartFile file, BusiReceiptUploadReqBO reqBO) {
        Long seq;
        PfscExtRspBaseBO rspBo = new PfscExtRspBaseBO();
        if (logger.isDebugEnabled()) {
            logger.debug("\u4e0a\u4f20\u6587\u4ef6\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if ((seq = reqBO.getSeq()) == null) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u94f6\u884c\u56de\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        String originalFilename = file.getOriginalFilename();
        reqBO.setIsUpdate(Boolean.valueOf(false));
        reqBO.setOriginalFilename(originalFilename);
        BusiReceiptUploadRspBO rspBO = this.busiReceiptUploadService.process(reqBO);
        if (rspBO == null || !"0000".equals(rspBO.getRespCode())) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc(rspBO.getRespDesc());
            return rspBo;
        }
        String ossFilename = rspBO.getOssFilename();
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String filepath = null;
        try {
            filepath = String.valueOf(this.baseUrl) + "/" + this.fileClient.uploadFileByInputStream(path, ossFilename, inputStream);
            logger.info("filepath=" + filepath);
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25\u3002\u6587\u4ef6\u540d\uff1a" + ossFilename, (Throwable)e);
        }
        if (!StringUtils.hasText(filepath)) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
            return rspBo;
        }
        reqBO.setIsUpdate(Boolean.valueOf(true));
        rspBO = this.busiReceiptUploadService.process(reqBO);
        if (rspBO == null || !"0000".equals(rspBO.getRespCode())) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc(rspBO.getRespDesc());
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u5bfc\u5165\u64cd\u4f5c\u6210\u529f");
        return rspBo;
    }
}

