/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.controller.rest.dataimport;

import com.tydic.pfscext.api.busi.BusiApplyMailImportInvoiceService;
import com.tydic.pfscext.api.busi.bo.BusiApplyMailImportInvoiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyMailImportInvoiceRowReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.common.ExcelFile;
import com.tydic.pfscext.controller.utils.FscExcelUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FscApplyMailImportInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(FscApplyMailImportInvoiceService.class);
    private String[][] columns = new String[][]{{"invoiceNo", "A", "S"}};
    private BusiApplyMailImportInvoiceService busiApplyMailImportInvoiceService;

    public PfscExtRspBaseBO importInvoice(@RequestParam(value="file") MultipartFile file) {
        PfscExtRspBaseBO rspBO = new PfscExtRspBaseBO();
        if (file == null) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25");
            return rspBO;
        }
        String fileName = file.getOriginalFilename();
        boolean isE2007 = false;
        String e07Suffix = "xlsx";
        if (fileName.endsWith(e07Suffix)) {
            isE2007 = true;
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream inputStream = file.getInputStream();){
                ExcelFile excel = new ExcelFile(inputStream, isE2007);
                if (!excel.isReady()) {
                    rspBO.setRespCode("18000");
                    rspBO.setRespDesc("\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6");
                    return rspBO;
                }
                BusiApplyMailImportInvoiceReqBO reqBO = new BusiApplyMailImportInvoiceReqBO();
                ArrayList<BusiApplyMailImportInvoiceRowReqBO> rows = new ArrayList<BusiApplyMailImportInvoiceRowReqBO>();
                reqBO.setRows(rows);
                String readData = this.readData(excel, fileName, rows);
                if (StringUtils.hasText((String)readData)) {
                    rspBO.setRespCode("18000");
                    rspBO.setRespDesc(readData);
                    return rspBO;
                }
                excel.close();
                if (rows.size() == 0) {
                    rspBO.setRespCode("18000");
                    rspBO.setRespDesc("\u672a\u8bfb\u53d6\u5230\u53d1\u7968\u6570\u636e");
                    return rspBO;
                }
                PfscExtRspBaseBO resp = this.busiApplyMailImportInvoiceService.process(reqBO);
                if (resp == null || !"0000".equals(resp.getRespCode())) {
                    rspBO.setRespCode("18000");
                    rspBO.setRespDesc(resp == null ? "\u5931\u8d25" : resp.getRespDesc());
                    return rspBO;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\u3002\u6587\u4ef6\u540d\uff1a" + fileName, (Throwable)e);
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String readData(ExcelFile excel, String filename, List<BusiApplyMailImportInvoiceRowReqBO> rows) {
        List dataRows = excel.readRows(0, 0, -1);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        int i = 0;
        while (i < dataRows.size()) {
            BusiApplyMailImportInvoiceRowReqBO row = new BusiApplyMailImportInvoiceRowReqBO();
            String[] fields = (String[])dataRows.get(i);
            map.clear();
            FscExcelUtils.arrayToMap(fields, this.columns, map);
            try {
                BeanUtils.populate((Object)row, map);
            }
            catch (Exception e) {
                logger.error("populate error\u3002\u6587\u4ef6\u540d\uff1a" + filename, (Throwable)e);
            }
            if (i == 0) {
                if (!StringUtils.hasText((String)row.getInvoiceNo()) || Pattern.matches("[0-9]*", row.getInvoiceNo())) {
                    return "\u8bf7\u52ff\u5220\u9664\u7b2c\u4e00\u884c\u8868\u5934";
                }
            } else if (StringUtils.hasText((String)row.getInvoiceNo())) {
                if (row.getInvoiceNo().contains(".")) {
                    row.setInvoiceNo(row.getInvoiceNo().replace(".0", ""));
                }
                rows.add(row);
            }
            ++i;
        }
        return null;
    }
}

