/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.annotation.log;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.annotation.constant.LogConstant;
import com.tydic.pfscext.annotation.log.FscExtSysLog;
import com.tydic.pfscext.annotation.log.FscExtSysLogManager;
import com.tydic.pfscext.annotation.log.FscExtSysLogTaskFactory;
import com.tydic.pfscext.api.busi.log.bo.FscExtSystemLogBusiReqBO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.FscRu;
import java.lang.reflect.Method;
import java.util.Date;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FscExtSysLogAspect {
    private static final Logger log = LoggerFactory.getLogger(FscExtSysLogAspect.class);

    @Pointcut(value="@annotation(com.tydic.pfscext.annotation.log.FscExtSysLog)")
    public void fscExtSysLogPointcut() {
    }

    @Around(value="fscExtSysLogPointcut()")
    public Object fscExtSysLogAround(ProceedingJoinPoint joinPoint) {
        if (!(joinPoint.getSignature() instanceof MethodSignature)) {
            throw new IllegalArgumentException("\u8be5\u6ce8\u89e3\u53ea\u80fd\u7528\u4e8e\u65b9\u6cd5");
        }
        Object[] args = joinPoint.getArgs();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        FscExtSysLog fscExtSysLog = method.getAnnotation(FscExtSysLog.class);
        try {
            Object proceed = joinPoint.proceed();
            this.saveLog(proceed, method, fscExtSysLog, args);
            return proceed;
        }
        catch (PfscExtBusinessException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PfscExtBusinessException("8888", e.getMessage());
        }
    }

    private void saveLog(Object proceed, Method method, FscExtSysLog fscExtSysLog, Object[] args) {
        try {
            FscExtSystemLogBusiReqBO logReqBo = new FscExtSystemLogBusiReqBO();
            logReqBo.setBusinessNo(this.businessNo(fscExtSysLog.params(), args));
            logReqBo.setBusinessType(fscExtSysLog.businessType().getCode());
            logReqBo.setSourceSystem(fscExtSysLog.source().name());
            logReqBo.setTargetSystem(fscExtSysLog.target().name());
            logReqBo.setContent(JSON.toJSONString((Object)args));
            String operateType = StrUtil.isBlank((CharSequence)fscExtSysLog.operateType()) ? method.getName() : fscExtSysLog.operateType();
            logReqBo.setOperateType(operateType);
            if (proceed != null) {
                JSONObject rspBo = FscRu.js(proceed, JSONObject.class);
                if (rspBo != null) {
                    logReqBo.setResponse(rspBo.toJSONString());
                    LogConstant.RspBase rspBase = fscExtSysLog.rspBase();
                    logReqBo.setErrorMsg(rspBo.getString(rspBase.getFieldDesc()));
                    if (rspBase.getSuccessCode().equals(rspBo.getString(rspBase.getFieldCode()))) {
                        logReqBo.setPushStatus("2");
                    } else {
                        logReqBo.setPushStatus("3");
                    }
                }
            } else {
                logReqBo.setPushStatus("3");
                logReqBo.setErrorMsg("\u5207\u9762\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38");
            }
            logReqBo.setCallTime(new Date());
            FscExtSysLogManager.me().executeLog(FscExtSysLogTaskFactory.businessLog(logReqBo));
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private String businessNo(String[] params, Object[] args) {
        StringBuilder paramBuilder = new StringBuilder();
        if (params == null || params.length == 0) {
            paramBuilder.append(UUID.randomUUID().toString().replace("-", ""));
            return paramBuilder.toString();
        }
        if (args == null || args.length < 1) {
            paramBuilder.append(UUID.randomUUID().toString().replace("-", ""));
            return paramBuilder.toString();
        }
        JSONObject reqJson = JSON.parseObject((String)JSON.toJSONString((Object)args[0]));
        for (String paramName : params) {
            Object paramValue = reqJson.get((Object)paramName);
            if (paramValue == null) continue;
            paramBuilder.append(paramValue).append("_");
        }
        if (paramBuilder.toString().endsWith("_")) {
            paramBuilder.deleteCharAt(paramBuilder.length() - 1);
        }
        return paramBuilder.toString();
    }
}

