/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;

class FscAopUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String SEPARATOR = "|";
    private static final String EXCLUDE_METHODS = "subscribe";
    private static final String CLASS_METHOD_SEPARATOR = ".";
    private static final String START_IDENTIFICATION = "START";
    private static final String END_IDENTIFICATION = "END";
    private static final String ERROR_IDENTIFICATION = "ERROR";

    FscAopUtils() {
    }

    private static String getThrowableStrRep(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        StringBuilder sb = new StringBuilder();
        try (LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));){
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append("\r\n");
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            sb.append(ex.toString());
        }
        return sb.toString();
    }

    static String getLogInfoByStrings(String[] infos) {
        StringBuilder stb = new StringBuilder();
        for (String info : infos) {
            if (StringUtils.isBlank((CharSequence)info)) {
                info = "";
            }
            stb.append(info).append(SEPARATOR);
        }
        if (stb.length() > 1) {
            stb.setLength(stb.length() - 1);
        }
        return stb.toString();
    }

    static void putCodeToRsp(Object object, String code, String desc, boolean fource) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field;
        if (object == null) {
            return;
        }
        if (object instanceof PfscExtRspBaseBO) {
            field = PfscExtRspBaseBO.class.getDeclaredField("respCode");
            field.setAccessible(true);
            if (!fource && field.get(object) == null) {
                field.set(object, code);
                field = PfscExtRspBaseBO.class.getDeclaredField("respDesc");
                field.setAccessible(true);
                field.set(object, desc);
            } else if (fource && field.get(object) == null) {
                field.set(object, code);
                field = PfscExtRspBaseBO.class.getDeclaredField("respDesc");
                field.setAccessible(true);
                field.set(object, desc);
            }
        } else {
            try {
                field = object.getClass().getDeclaredField("respCode");
                field.setAccessible(true);
                if (field.get(object) == null) {
                    field.set(object, code);
                    field = object.getClass().getDeclaredField("respDesc");
                    field.setAccessible(true);
                    field.set(object, desc);
                }
            }
            catch (Exception field2) {
                // empty catch block
            }
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = object.getClass(); tempClass != null && !tempClass.getName().toLowerCase().equals("java.lang.object"); tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        for (Field f : fieldList) {
            boolean annotationPresent2 = f.isAnnotationPresent(JSONField.class);
            if (!annotationPresent2) continue;
            JSONField name = f.getAnnotation(JSONField.class);
            InvocationHandler h = Proxy.getInvocationHandler(name);
            Field hField = h.getClass().getDeclaredField("memberValues");
            hField.setAccessible(true);
            Map memberValues = (Map)hField.get(h);
            memberValues.put("serialize", true);
        }
    }

    static String[] buildAopStartLog(ProceedingJoinPoint pjp, String traceId) {
        long nowTime = System.currentTimeMillis();
        StringBuilder commonHead = new StringBuilder(traceId + SEPARATOR);
        String className = pjp.getTarget().getClass().getName();
        String methodString = pjp.getSignature().getName();
        if (EXCLUDE_METHODS.equals(methodString)) {
            return null;
        }
        commonHead.append(className);
        commonHead.append(CLASS_METHOD_SEPARATOR);
        commonHead.append(methodString);
        String[] infos = new String[8];
        infos[0] = commonHead.toString();
        infos[1] = START_IDENTIFICATION;
        infos[2] = Long.toString(nowTime);
        infos[3] = "";
        Object[] params = pjp.getArgs();
        if (params != null && params.length > 0) {
            if (params.length == 1) {
                try {
                    infos[4] = MAPPER.writeValueAsString(params[0]);
                }
                catch (JsonProcessingException e) {
                    infos[4] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + params[0]).replace("\r\n", "");
                }
            } else {
                StringBuilder paramsStr = new StringBuilder();
                paramsStr.append("[");
                for (Object obj : params) {
                    String objStr = null;
                    if (obj != null) {
                        try {
                            objStr = MAPPER.writeValueAsString(obj);
                        }
                        catch (JsonProcessingException e) {
                            objStr = null;
                        }
                    }
                    if (objStr == null) continue;
                    paramsStr.append(objStr);
                    paramsStr.append(",");
                }
                paramsStr.setLength(paramsStr.length() - 1);
                paramsStr.append("]");
            }
        }
        return infos;
    }

    static void buildAopEndLog(String[] infos, Object object) {
        long nowTime = System.currentTimeMillis();
        infos[1] = END_IDENTIFICATION;
        infos[3] = Long.toString(nowTime);
        if (object instanceof PfscExtRspBaseBO) {
            PfscExtRspBaseBO resp = (PfscExtRspBaseBO)object;
            infos[4] = resp.getRespCode();
            infos[5] = resp.getRespDesc();
            infos[6] = "\u7528\u65f6\uff1a" + (Long.parseLong(infos[3]) - Long.parseLong(infos[2])) + "ms";
            infos[7] = JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        } else if (object instanceof RspBaseBO) {
            RspBaseBO resp = (RspBaseBO)object;
            infos[4] = resp.getCode();
            infos[5] = resp.getMessage();
            infos[6] = "\u7528\u65f6\uff1a" + (Long.parseLong(infos[3]) - Long.parseLong(infos[2])) + "ms";
            infos[7] = JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        } else {
            infos[4] = "";
            infos[5] = "";
            infos[6] = "\u7528\u65f6\uff1a" + (Long.parseLong(infos[3]) - Long.parseLong(infos[2])) + "ms";
            infos[7] = JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        }
    }

    static void buildAopErrorLog(String[] infos, Throwable e) {
        long nowTime = System.currentTimeMillis();
        infos[1] = ERROR_IDENTIFICATION;
        infos[3] = Long.toString(nowTime);
        if (null != FscAopUtils.getThrowableStrRep(e)) {
            infos[5] = FscAopUtils.getThrowableStrRep(e);
        }
    }
}

