/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=20)
public class FscServiceLogAdvice {
    private static final Logger log = LoggerFactory.getLogger(FscServiceLogAdvice.class);
    private static final String SEPARATOR = "|";
    private static final String CLASS_METHOD_SEPARATOR = ".";
    private static final String TRACE_IDENTIFICATION = "TRACE_ID";
    private static final String START_IDENTIFICATION = "START";
    private static final String ERROR_IDENTIFICATION = "ERROR";
    private static final String END_IDENTIFICATION = "END";
    private static final InheritableThreadLocal<Map<String, String>> THREAD_MAP = new InheritableThreadLocal();
    @Autowired
    private SqlSessionFactory sqlSessionFactory;

    @Pointcut(value="(execution(* com.tydic.pfscext..impl..*(..)))")
    public void pointCut() {
    }

    @Pointcut(value="(execution(* com.tydic.pfscext.*.ability.impl..*(..)))")
    public void abilityPointCut() {
    }

    @Before(value="pointCut()")
    public void deBefore(JoinPoint jp) {
        if (THREAD_MAP.get() == null) {
            HashMap mapInfo = Maps.newHashMapWithExpectedSize((int)2);
            UUID uuid = UUID.randomUUID();
            mapInfo.put(TRACE_IDENTIFICATION, uuid.toString().replace("-", ""));
            mapInfo.put(START_IDENTIFICATION, Long.toString(System.currentTimeMillis()));
            THREAD_MAP.set(mapInfo);
        }
        String[] infos = new String[3];
        infos[0] = this.getLogHeadInfo(jp);
        infos[1] = START_IDENTIFICATION;
        Object[] params = jp.getArgs();
        if (params != null && params.length > 0) {
            if (params.length == 1) {
                infos[2] = JSON.toJSONString((Object)params[0]);
            } else {
                StringBuilder paramsStr = new StringBuilder();
                paramsStr.append("[");
                for (Object obj : params) {
                    String objStr = null;
                    if (obj != null) {
                        objStr = JSON.toJSONString((Object)obj);
                    }
                    paramsStr.append(objStr);
                    paramsStr.append(",");
                }
                paramsStr.setLength(paramsStr.length() - 1);
                paramsStr.append("]");
                infos[2] = paramsStr.toString();
            }
        }
        log.info(this.getLogInfoByStrings(infos));
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        Object rspObj;
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> rspClass = method.getReturnType();
        try {
            rspObj = pjp.proceed();
        }
        catch (PfscExtBusinessException e) {
            this.printAopErrorLog(e, "\u4e1a\u52a1\u8c03\u7528\u5931\u8d25\u539f\u56e0\uff1a", (JoinPoint)pjp);
            if (rspClass.isInterface()) {
                throw new PfscExtBusinessException("8888", "\u5931\u8d25");
            }
            rspObj = rspClass.newInstance();
            String msgCode = e.getMsgCode();
            String desc = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)msgCode)) {
                msgCode = "8888";
            }
            if (StringUtils.isEmpty((CharSequence)desc)) {
                desc = "\u5931\u8d25";
            }
            this.putCodeToRsp(rspObj, msgCode, desc);
        }
        catch (DataAccessException e) {
            this.printAopErrorLog(e, "\u6570\u636e\u5f02\u5e38\u4fe1\u606f\uff1a", (JoinPoint)pjp);
            if (rspClass.isInterface()) {
                throw new PfscExtBusinessException("8888", "\u6570\u636e\u5f02\u5e38\u4fe1\u606f");
            }
            rspObj = rspClass.newInstance();
            this.putCodeToRsp(rspObj, "8888", "\u5931\u8d25");
        }
        catch (Throwable e) {
            this.printAopErrorLog(e, "\u670d\u52a1\u8c03\u7528\u5f02\u5e38\u4fe1\u606f\uff1a", (JoinPoint)pjp);
            if (rspClass.isInterface()) {
                throw new PfscExtBusinessException("8888", "\u670d\u52a1\u8c03\u7528\u5f02\u5e38\u4fe1\u606f");
            }
            rspObj = rspClass.newInstance();
            this.putCodeToRsp(rspObj, "8888", "\u5931\u8d25:" + e.getMessage());
        }
        return rspObj;
    }

    @AfterReturning(returning="rspObj", pointcut="pointCut() && abilityPointCut()")
    public void doAfterCall(JoinPoint jp, Object rspObj) {
        this.doAfterReturning(jp, rspObj);
        THREAD_MAP.remove();
    }

    @AfterReturning(returning="rspObj", pointcut="pointCut() && !abilityPointCut()")
    public void doAfterReturning(JoinPoint jp, Object rspObj) {
        if (null == jp) {
            return;
        }
        String[] infos = new String[5];
        infos[0] = this.getLogHeadInfo(jp);
        long nowTime = System.currentTimeMillis();
        infos[1] = END_IDENTIFICATION;
        if (rspObj != null) {
            if (rspObj instanceof PfscExtRspBaseBO) {
                PfscExtRspBaseBO resp = (PfscExtRspBaseBO)rspObj;
                if (StringUtils.isBlank((CharSequence)resp.getRespCode())) {
                    resp.setRespCode("0000");
                }
                if (StringUtils.isBlank((CharSequence)resp.getRespDesc())) {
                    resp.setRespDesc("\u6210\u529f");
                }
                infos[2] = JSON.toJSONString((Object)rspObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                infos[3] = resp.getRespCode() + SEPARATOR + resp.getRespDesc();
                try {
                    infos[4] = "\u7528\u65f6\uff1a" + (nowTime - Long.parseLong((String)((Map)THREAD_MAP.get()).get(START_IDENTIFICATION))) + "ms";
                }
                catch (NullPointerException e) {
                    infos[4] = "\u7528\u65f6\uff1a ? ms";
                }
            } else if (rspObj instanceof RspBaseBO) {
                RspBaseBO resp = (RspBaseBO)rspObj;
                if (StringUtils.isBlank((CharSequence)resp.getCode())) {
                    resp.setCode("0000");
                }
                if (StringUtils.isBlank((CharSequence)resp.getMessage())) {
                    resp.setMessage("\u6210\u529f");
                }
                infos[2] = JSON.toJSONString((Object)rspObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                infos[3] = resp.getCode() + SEPARATOR + resp.getMessage();
                try {
                    infos[4] = "\u7528\u65f6\uff1a" + (nowTime - Long.parseLong((String)((Map)THREAD_MAP.get()).get(START_IDENTIFICATION))) + "ms";
                }
                catch (NullPointerException e) {
                    infos[4] = "\u7528\u65f6\uff1a ? ms";
                }
            } else {
                infos[2] = JSON.toJSONString((Object)rspObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                infos[3] = "0000|\u6210\u529f";
                try {
                    infos[4] = "\u7528\u65f6\uff1a" + (nowTime - Long.parseLong((String)((Map)THREAD_MAP.get()).get(START_IDENTIFICATION))) + "ms";
                }
                catch (NullPointerException e) {
                    infos[4] = "\u7528\u65f6\uff1a ? ms";
                }
            }
        } else {
            infos[2] = JSON.toJSONString((Object)rspObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            infos[3] = "0000|\u6210\u529f";
            try {
                infos[4] = "\u7528\u65f6\uff1a" + (nowTime - Long.parseLong((String)((Map)THREAD_MAP.get()).get(START_IDENTIFICATION))) + "ms";
            }
            catch (NullPointerException e) {
                infos[4] = "\u7528\u65f6\uff1a ? ms";
            }
        }
        log.info(this.getLogInfoByStrings(infos));
    }

    @AfterThrowing(throwing="ex", pointcut="pointCut()")
    public void doAfterThrowing(JoinPoint jp, Throwable ex) {
        this.printAopErrorLog(ex, "\u73af\u7ed5\u901a\u77e5\u5f02\u5e38\u4fe1\u606f\uff1a", jp);
    }

    private String getLogHeadInfo(JoinPoint jp) {
        StringBuilder logHead;
        try {
            logHead = new StringBuilder((String)((Map)THREAD_MAP.get()).get(TRACE_IDENTIFICATION) + SEPARATOR);
        }
        catch (NullPointerException e) {
            logHead = new StringBuilder(" ? |");
        }
        String className = jp.getTarget().getClass().getName();
        String methodString = jp.getSignature().getName();
        logHead.append(className);
        logHead.append(CLASS_METHOD_SEPARATOR);
        logHead.append(methodString);
        return logHead.toString();
    }

    private String getLogInfoByStrings(String[] infos) {
        StringBuilder str = new StringBuilder();
        for (String info : infos) {
            if (StringUtils.isBlank((CharSequence)info)) {
                info = "";
            }
            str.append(info).append(SEPARATOR);
        }
        if (str.length() > 1) {
            str.setLength(str.length() - 1);
        }
        return str.toString();
    }

    private void printAopErrorLog(Throwable e, String desc, JoinPoint jp) {
        String[] infos = new String[]{this.getLogHeadInfo(jp), ERROR_IDENTIFICATION, desc + e.getMessage()};
        log.error("\u5f02\u5e38\u6d4b\u8bd5" + e);
        log.error(this.getLogInfoByStrings(infos), e);
    }

    private void putCodeToRsp(Object object, String code, String desc) throws NoSuchFieldException, IllegalAccessException {
        if (object == null) {
            return;
        }
        if (object instanceof PfscExtRspBaseBO) {
            Field field = PfscExtRspBaseBO.class.getDeclaredField("respCode");
            field.setAccessible(true);
            if (field.get(object) == null) {
                field.set(object, code);
                field = PfscExtRspBaseBO.class.getDeclaredField("respDesc");
                field.setAccessible(true);
                field.set(object, desc);
            }
        } else {
            try {
                Field field = object.getClass().getDeclaredField("respCode");
                field.setAccessible(true);
                if (field.get(object) == null) {
                    field.set(object, code);
                    field = object.getClass().getDeclaredField("respDesc");
                    field.setAccessible(true);
                    field.set(object, desc);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

