/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.order.extend.bo.order.PebExtPayResultReqBO;
import com.tydic.order.extend.bo.order.PebExtPayResultRspBO;
import com.tydic.pfscext.api.busi.FscEsSyncTodoTemporaryBusiService;
import com.tydic.pfscext.api.busi.bo.FscEsSyncTodoTemporaryBusiReqBO;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.external.uoc.api.FscPebExtFscPayResultExternalService;
import com.tydic.pfscext.external.uoc.api.FscUocPushPayableApplyDateExternalService;
import com.tydic.pfscext.external.uoc.bo.FscUocPushPayableApplyDateExternalInfoBO;
import com.tydic.pfscext.external.uoc.bo.FscUocPushPayableApplyDateExternalReqBO;
import com.tydic.pfscext.external.uoc.bo.FscUocPushPayableApplyDateExternalRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class FscApplyPayResultUocCallbackConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscApplyPayResultUocCallbackConsumer.class);
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private FscPebExtFscPayResultExternalService fscPebExtFscPayResultExternalService;
    @Autowired
    private FscUocPushPayableApplyDateExternalService fscUocPushPayableApplyDateExternalService;
    @Autowired
    private FscEsSyncTodoTemporaryBusiService fscEsSyncTodoTemporaryBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            log.debug("\u5f00\u59cb\u6d88\u8d39:{}", (Object)message.getContent());
            JSONObject data = JSON.parseObject((String)message.getContent());
            String type = data.getString("type");
            if ("PRO".equals(type)) {
                return this.dealApplyPayPro(message, data);
            }
            if ("SUP".equals(type)) {
                return this.dealApplyPaySup(message, data);
            }
            if ("ORDER_SYNC_ES".equals(type)) {
                return this.dealOrderSyncEs(message, data);
            }
            log.debug("\u5165\u53c2\u7c7b\u578btype\u9519\u8bef:{}", (Object)type);
        }
        catch (Exception e) {
            log.debug("\u6d88\u8d39\u5f02\u5e38:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private ProxyConsumerStatus dealOrderSyncEs(ProxyMessage message, JSONObject data) {
        Long uocEsSyncVersionId = data.getLong("uocEsSyncVersionId");
        FscEsSyncTodoTemporaryBusiReqBO reqBo = new FscEsSyncTodoTemporaryBusiReqBO();
        reqBo.setUocEsSyncVersionId(uocEsSyncVersionId);
        this.fscEsSyncTodoTemporaryBusiService.dealUocEsSyncTemporary(reqBo);
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private ProxyConsumerStatus dealApplyPaySup(ProxyMessage message, JSONObject data) {
        String posJson = data.getString("payableDetailPos");
        Date payApplyDate = Optional.ofNullable(data.getDate("payApplyDate")).orElse(new Date());
        List payableDetailPos = JSON.parseArray((String)posJson, PayableDetailPO.class);
        if (!CollectionUtils.isEmpty((Collection)payableDetailPos)) {
            Date startTime = new Date();
            List payableNoList = payableDetailPos.stream().map(PayableDetailPO::getPayableNo).distinct().collect(Collectors.toList());
            log.debug("\u4f9b\u5e94\u5546\u56de\u6b3e\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5f00\u59cb\u65f6\u95f4\uff1a{}.\u5e94\u4ed8\u5355\u53f7:{}", (Object)startTime, payableNoList);
            for (PayableDetailPO payableDetailPO : payableDetailPos) {
                if (StringUtils.hasText((String)payableDetailPO.getNotificationNo())) {
                    PayPurchaseOrderInfo payPurchaseOrderInfoQry = new PayPurchaseOrderInfo();
                    payPurchaseOrderInfoQry.setNotificationNo(payableDetailPO.getNotificationNo());
                    List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.getListByNotificationNo(payPurchaseOrderInfoQry);
                    if (CollectionUtils.isEmpty(payPurchaseOrderInfos)) continue;
                    for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
                        if (payPurchaseOrderInfo == null || payPurchaseOrderInfo.getOrderId() == null) continue;
                        FscUocPushPayableApplyDateExternalInfoBO info = new FscUocPushPayableApplyDateExternalInfoBO();
                        info.setInspectionId(payPurchaseOrderInfo.getInspectionId());
                        info.setOrderId(payPurchaseOrderInfo.getOrderId());
                        info.setOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
                        info.setPayApplyDate(payApplyDate);
                        info.setPayableType(payableDetailPO.getPayableType().toString());
                        FscUocPushPayableApplyDateExternalReqBO externalReqBo = new FscUocPushPayableApplyDateExternalReqBO();
                        externalReqBo.setInfoBos(Collections.singletonList(info));
                        FscUocPushPayableApplyDateExternalRspBO externalRspBo = this.fscUocPushPayableApplyDateExternalService.dealPaymentVoucherCallBack(externalReqBo);
                        PebExtPayResultReqBO pebExtPayResultReqBo = new PebExtPayResultReqBO();
                        pebExtPayResultReqBo.setInspectionVoucherId(payPurchaseOrderInfo.getInspectionId());
                        pebExtPayResultReqBo.setOrderId(payPurchaseOrderInfo.getOrderId().toString());
                        pebExtPayResultReqBo.setPayMethod(PayMethod.OFFLINE_PAY.getCode());
                        pebExtPayResultReqBo.setPaymentFinishTime(payApplyDate);
                        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + JSON.toJSONString((Object)pebExtPayResultReqBo));
                        PebExtPayResultRspBO pebExtPayResultRspBo = this.fscPebExtFscPayResultExternalService.dealPayResult(pebExtPayResultReqBo);
                        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + JSON.toJSONString((Object)pebExtPayResultRspBo));
                    }
                    continue;
                }
                if (payableDetailPO.getOrderId() != null) {
                    FscUocPushPayableApplyDateExternalInfoBO info = new FscUocPushPayableApplyDateExternalInfoBO();
                    info.setInspectionId(payableDetailPO.getInspectionId());
                    info.setOrderId(payableDetailPO.getOrderId());
                    info.setOrderCode(payableDetailPO.getPurchaseOrderCode());
                    info.setPayApplyDate(payApplyDate);
                    info.setPayableType(payableDetailPO.getPayableType().toString());
                    FscUocPushPayableApplyDateExternalReqBO externalReqBo = new FscUocPushPayableApplyDateExternalReqBO();
                    externalReqBo.setInfoBos(Collections.singletonList(info));
                    FscUocPushPayableApplyDateExternalRspBO externalRspBo = this.fscUocPushPayableApplyDateExternalService.dealPaymentVoucherCallBack(externalReqBo);
                    String payableNo = payableDetailPO.getPayableNo();
                    PebExtPayResultReqBO extPayResultReqBO = new PebExtPayResultReqBO();
                    extPayResultReqBO.setPayableNos(Collections.singletonList(payableNo));
                    payableDetailPO.setOrderIdList(Stream.of(payableDetailPO.getOrderId()).collect(Collectors.toList()));
                    List<PayableDetailPO> payableDetailSum = this.payableDetailMapper.querysumAmtByOrderId(payableDetailPO);
                    PaymentFlowInfo paymentFlowInfoRefund = this.paymentFlowInfoMapper.selectByOrderCodeRefund(payableDetailPO.getPurchaseOrderCode());
                    log.info("\u8ba1\u7b97\u9000\u6b3e" + paymentFlowInfoRefund);
                    extPayResultReqBO.setTotalFee(payableDetailSum.get(0).getPayableAmt().subtract(paymentFlowInfoRefund == null ? BigDecimal.ZERO : paymentFlowInfoRefund.getOrderAmt()).toString());
                    extPayResultReqBO.setOrderId(payableDetailPO.getOrderId().toString());
                    extPayResultReqBO.setInspectionVoucherId(payableDetailPO.getInspectionId());
                    extPayResultReqBO.setPaymentFinishTime(payApplyDate);
                    extPayResultReqBO.setPayMethod(PayMethod.OFFLINE_PAY.getCode());
                    log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + extPayResultReqBO);
                    PebExtPayResultRspBO pebExtPayResultRspBO = this.fscPebExtFscPayResultExternalService.dealPayResult(extPayResultReqBO);
                    log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + pebExtPayResultRspBO);
                    continue;
                }
                log.error("\u4f9b\u5e94\u5546\u56de\u6b3e\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25\uff1a\u5e94\u4ed8\u5355[{}]\u7684\u8ba2\u5355ID\u548c\u5f00\u7968\u901a\u77e5\u5355\u7f16\u53f7\u5747\u4e3a\u7a7a", (Object)payableDetailPO.getPayableNo());
            }
            Date endTime = new Date();
            log.debug("\u4f9b\u5e94\u5546\u56de\u6b3e\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u7ed3\u675f\u65f6\u95f4\uff1a{},\u7528\u65f6\uff1a{} ms.\u5e94\u4ed8\u5355\u53f7:{}", new Object[]{endTime, endTime.getTime() - startTime.getTime(), payableNoList});
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private ProxyConsumerStatus dealApplyPayPro(ProxyMessage message, JSONObject data) {
        String posJson = data.getString("payableDetailPos");
        Date payApplyDate = Optional.ofNullable(data.getDate("payApplyDate")).orElse(new Date());
        List payableDetailPos = JSON.parseArray((String)posJson, PayableDetailPO.class);
        if (!CollectionUtils.isEmpty((Collection)payableDetailPos)) {
            List payableNoList = payableDetailPos.stream().map(PayableDetailPO::getPayableNo).distinct().collect(Collectors.toList());
            Date startTime = new Date();
            log.debug("\u8fd0\u8425\u56de\u6b3e\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5f00\u59cb\u65f6\u95f4\uff1a{},\u5e94\u6536\u5355\u53f7\uff1a{}", (Object)startTime, payableNoList);
            for (PayableDetailPO payableDetailPo : payableDetailPos) {
                if (StringUtils.hasText((String)payableDetailPo.getApplyNo())) {
                    SaleOrderInfoVO saleOrderInfoQry = new SaleOrderInfoVO();
                    saleOrderInfoQry.setApplyNo(payableDetailPo.getApplyNo());
                    List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getList(saleOrderInfoQry);
                    if (!CollectionUtils.isEmpty(saleOrderInfos)) {
                        for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                            if (saleOrderInfo.getOrderId() != null) {
                                FscUocPushPayableApplyDateExternalInfoBO info = new FscUocPushPayableApplyDateExternalInfoBO();
                                info.setInspectionId(saleOrderInfo.getInspectionId());
                                info.setOrderId(saleOrderInfo.getOrderId());
                                info.setOrderCode(saleOrderInfo.getSaleOrderCode());
                                info.setPayApplyDate(payApplyDate);
                                info.setPayableType(payableDetailPo.getPayableType().toString());
                                FscUocPushPayableApplyDateExternalReqBO externalReqBo = new FscUocPushPayableApplyDateExternalReqBO();
                                externalReqBo.setInfoBos(Collections.singletonList(info));
                                FscUocPushPayableApplyDateExternalRspBO externalRspBo = this.fscUocPushPayableApplyDateExternalService.dealPaymentVoucherCallBack(externalReqBo);
                                PebExtPayResultReqBO pebExtPayResultReqBO = new PebExtPayResultReqBO();
                                pebExtPayResultReqBO.setInspectionVoucherId(saleOrderInfo.getInspectionId());
                                pebExtPayResultReqBO.setOrderId(saleOrderInfo.getOrderId().toString());
                                pebExtPayResultReqBO.setPayMethod(PayMethod.OFFLINE_PAY.getCode());
                                pebExtPayResultReqBO.setPaymentFinishTime(payApplyDate);
                                this.fscPebExtFscPayResultExternalService.dealPayResult(pebExtPayResultReqBO);
                                continue;
                            }
                            log.error("\u8fd0\u8425\u56de\u6b3e\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25\uff1a\u5e94\u4ed8\u5355[{}]\u6839\u636e\u5f00\u7968\u7533\u8bf7\u5355\u7f16\u53f7[{}]\u67e5\u8be2\u8ba2\u5355\u6570\u636e\u7684\u8ba2\u5355ID\u4e3a\u7a7a:{}", new Object[]{payableDetailPo.getPayableNo(), payableDetailPo.getApplyNo(), JSON.toJSONString((Object)saleOrderInfo)});
                        }
                        continue;
                    }
                    log.error("\u8fd0\u8425\u56de\u6b3e\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25\uff1a\u5e94\u4ed8\u5355[{}]\u6839\u636e\u5f00\u7968\u7533\u8bf7\u5355\u7f16\u53f7[{}]\u67e5\u8be2\u8ba2\u5355\u6570\u636e\u4e3a\u7a7a", (Object)payableDetailPo.getPayableNo(), (Object)payableDetailPo.getApplyNo());
                    continue;
                }
                if (payableDetailPo.getOrderId() != null) {
                    FscUocPushPayableApplyDateExternalInfoBO info = new FscUocPushPayableApplyDateExternalInfoBO();
                    info.setInspectionId(payableDetailPo.getInspectionId());
                    info.setOrderId(payableDetailPo.getOrderId());
                    info.setOrderCode(payableDetailPo.getPurchaseOrderCode());
                    info.setPayApplyDate(payApplyDate);
                    info.setPayableType(payableDetailPo.getPayableType().toString());
                    FscUocPushPayableApplyDateExternalReqBO externalReqBo = new FscUocPushPayableApplyDateExternalReqBO();
                    externalReqBo.setInfoBos(Collections.singletonList(info));
                    FscUocPushPayableApplyDateExternalRspBO externalRspBo = this.fscUocPushPayableApplyDateExternalService.dealPaymentVoucherCallBack(externalReqBo);
                    PebExtPayResultReqBO pebExtPayResultReqBO = new PebExtPayResultReqBO();
                    pebExtPayResultReqBO.setInspectionVoucherId(payableDetailPo.getInspectionId());
                    pebExtPayResultReqBO.setOrderId(payableDetailPo.getOrderId().toString());
                    pebExtPayResultReqBO.setPayMethod(PayMethod.OFFLINE_PAY.getCode());
                    pebExtPayResultReqBO.setPaymentFinishTime(payApplyDate);
                    pebExtPayResultReqBO.setPayableNos(Collections.singletonList(payableDetailPo.getPayableNo()));
                    payableDetailPo.setOrderIdList(Stream.of(payableDetailPo.getOrderId()).collect(Collectors.toList()));
                    List<PayableDetailPO> payableDetailSum = this.payableDetailMapper.querysumAmtByOrderId(payableDetailPo);
                    PaymentFlowInfo paymentFlowInfoRefund = this.paymentFlowInfoMapper.selectByOrderCodeRefund(payableDetailPo.getPurchaseOrderCode());
                    log.info("\u8ba1\u7b97\u9000\u6b3e" + paymentFlowInfoRefund);
                    pebExtPayResultReqBO.setTotalFee(payableDetailSum.get(0).getPayableAmt().subtract(paymentFlowInfoRefund == null ? BigDecimal.ZERO : paymentFlowInfoRefund.getOrderAmt()).toString());
                    this.fscPebExtFscPayResultExternalService.dealPayResult(pebExtPayResultReqBO);
                    continue;
                }
                log.error("\u8fd0\u8425\u56de\u6b3e\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25\uff1a\u5e94\u4ed8\u5355[{}]\u7684\u8ba2\u5355ID\u548c\u5f00\u7968\u7533\u8bf7\u5355\u7f16\u53f7\u5747\u4e3a\u7a7a", (Object)payableDetailPo.getPayableNo());
            }
            Date endTime = new Date();
            log.debug("\u8fd0\u8425\u56de\u6b3e\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5f00\u59cb\u65f6\u95f4\uff1a{},\u7ed3\u675f\u65f6\u95f4\uff1a{},\u7528\u65f6\uff1a{} ms\uff0c\u5e94\u6536\u5355\u53f7\uff1a{}", new Object[]{startTime, endTime, endTime.getTime() - startTime.getTime(), payableNoList});
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

