/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.pfscext.api.busi.bo.BusiSaleInvoiceInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiSaleInvoiceInfoRspBO;
import com.tydic.pfscext.service.busi.FscBillApplyInfoBusiService;
import com.tydic.pfscext.service.busi.bo.FscBillApplyManualInvoiceUpdateBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscBillApplyManualInvoiceUpdateBusiRspBO;
import com.tydic.pfscext.service.comb.api.FscSaleInvoiceInfoCombService;
import com.tydic.pfscext.service.comb.api.FscSaleInvoiceInfoExportCombService;
import com.tydic.pfscext.service.comb.bo.FscSaleInvoiceInfoExportExcelCombReqBO;
import com.tydic.pfscext.service.comb.bo.FscSaleInvoiceInfoExportExcelCombRspBO;
import com.tydic.pfscext.utils.DateUtil;
import com.tydic.pfscext.utils.FscRu;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class FscBillApplyInvoicingConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscBillApplyInvoicingConsumer.class);
    @Autowired
    private FscSaleInvoiceInfoExportCombService fscSaleInvoiceInfoExportCombService;
    @Autowired
    private FscSaleInvoiceInfoCombService fscSaleInvoiceInfoCombService;
    @Autowired
    private FscBillApplyInfoBusiService fscBillApplyInfoBusiService;
    @Autowired
    private CacheClient cacheClient;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            JSONObject redisKeyData = JSON.parseObject((String)message.getContent());
            if (redisKeyData != null) {
                String actionCategory = redisKeyData.getString("ACTION_CATEGORY");
                if ("export".equals(actionCategory)) {
                    String redisKey = redisKeyData.getString("REDIS_KEY");
                    if (StringUtils.hasText((String)redisKey)) {
                        FscSaleInvoiceInfoExportExcelCombReqBO combReqBo = (FscSaleInvoiceInfoExportExcelCombReqBO)((Object)this.cacheClient.get(redisKey, FscSaleInvoiceInfoExportExcelCombReqBO.class));
                        if (combReqBo == null) {
                            log.error("\u624b\u52a8\u5f00\u7968\u5f02\u6b65\u5bfc\u51fa\u53d1\u7968MQ\u6d88\u8d39\u5931\u8d25\uff0c\u7f13\u5b58\u4e3a\u7a7a.content:{}", (Object)message.getContent());
                            this.cacheClient.delete(redisKey);
                        } else {
                            Date startTime = new Date();
                            log.info("\u624b\u52a8\u5f00\u7968\u5f02\u6b65\u5bfc\u51fa\u53d1\u7968.\u5f00\u7968\u7533\u8bf7\u5355\u53f7\uff1a{}.\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)combReqBo.getApplyNo(), (Object)DateUtil.dateToStrLong(startTime));
                            FscSaleInvoiceInfoExportExcelCombRspBO combRspBo = this.fscSaleInvoiceInfoExportCombService.dealManualInvoiceExportExcel(combReqBo);
                            log.info("\u624b\u52a8\u5f00\u7968\u5f02\u6b65\u5bfc\u51fa\u53d1\u7968.\u5f00\u7968\u7533\u8bf7\u5355\u53f7\uff1a{}.\u5f00\u59cb\u65f6\u95f4\uff1a{}.\u7ed3\u675f\uff1a{}.\u6267\u884c\u7ed3\u679c\uff1a{}", new Object[]{combReqBo.getApplyNo(), DateUtil.dateToStrLong(startTime), DateUtil.dateToStrLong(new Date()), JSON.toJSONString((Object)((Object)combRspBo))});
                        }
                        this.cacheClient.delete(redisKey);
                    }
                } else if ("import".equals(actionCategory)) {
                    String redisKey = redisKeyData.getString("REDIS_KEY");
                    BusiSaleInvoiceInfoReqBO busiReqBo = (BusiSaleInvoiceInfoReqBO)redisKeyData.getObject("BUSI_REQ_BO", BusiSaleInvoiceInfoReqBO.class);
                    if (busiReqBo == null) {
                        log.error("\u624b\u52a8\u5f00\u7968\u786e\u8ba4\u5f00\u7968\u5f02\u6b65\u5bfc\u5165\u53d1\u7968MQ\u6d88\u8d39\u5931\u8d25\uff0c\u7f13\u5b58\u4e3a\u7a7a.content:{}", (Object)message.getContent());
                    } else {
                        BusiSaleInvoiceInfoRspBO busiRspBo = this.fscSaleInvoiceInfoCombService.dealManualInvoice(busiReqBo);
                        this.updateBillApplyManualInvoiceStatus(busiReqBo.getApplyNo(), busiRspBo.getRespCode(), busiRspBo.getRespDesc());
                    }
                    if (redisKey != null) {
                        this.cacheClient.delete(redisKey);
                    }
                } else {
                    log.error("MQ\u6d88\u8d39\u5931\u8d25\uff0cACTION_CATEGORY.content:{}", (Object)message.getContent());
                }
            } else {
                log.error("MQ\u6d88\u8d39\u5931\u8d25.content\u4e3a\u7a7a:{}", (Object)message.getContent());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void updateBillApplyManualInvoiceStatus(String applyNo, String manualInvoiceStatus, String manualInvoiceFailMessage) {
        if (StringUtils.hasText((String)applyNo)) {
            FscBillApplyManualInvoiceUpdateBusiReqBO busiReqBo = new FscBillApplyManualInvoiceUpdateBusiReqBO();
            busiReqBo.setApplyNo(applyNo);
            busiReqBo.setManualInvoiceStatus(manualInvoiceStatus);
            busiReqBo.setManualInvoiceFailMessage(manualInvoiceFailMessage);
            FscBillApplyManualInvoiceUpdateBusiRspBO busiRspBo = this.fscBillApplyInfoBusiService.updateBillApplyManualInvoice(busiReqBo);
            if (FscRu.isFailed(busiRspBo.getRespCode()).booleanValue()) {
                log.error("\u66f4\u65b0\u5f00\u7968\u7533\u8bf7\u786e\u8ba4\u5f00\u7968\u72b6\u6001\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)((Object)busiRspBo)));
            }
        } else {
            log.error("\u66f4\u65b0\u5f00\u7968\u7533\u8bf7\u786e\u8ba4\u5f00\u7968\u72b6\u6001\u5931\u8d25\uff0c\u7533\u8bf7\u5355\u53f7\u4e3a\u7a7a");
        }
    }
}

