/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.pfscext.api.ability.FscCreditControlTipsTaskAbilityService;
import com.tydic.pfscext.api.ability.bo.FscCreditControlTipsUserTaskAbilityReqBO;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.service.busi.FscCreditControlBusiService;
import com.tydic.pfscext.service.busi.FscOrderCheckUserControlConfigBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditControlUserInspectionBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlUserInspectionBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCheckUserControlConfigBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCheckUserControlConfigBusiRspBO;
import com.tydic.pfscext.service.comb.api.FscCreditControlUserOverdueCombService;
import com.tydic.pfscext.service.comb.bo.FscCreditControlUserOverdueCombReqBO;
import com.tydic.pfscext.service.comb.bo.FscCreditControlUserOverdueCombRspBO;
import com.tydic.pfscext.utils.FscRu;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class FscCreditControlUserConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscCreditControlUserConsumer.class);
    @Autowired
    private FscCreditControlBusiService fscCreditControlBusiService;
    @Autowired
    private FscCreditControlTipsTaskAbilityService fscCreditControlTipsTaskAbilityService;
    @Autowired
    private FscOrderCheckUserControlConfigBusiService fscOrderCheckUserControlConfigBusiService;
    @Autowired
    private FscCreditControlUserOverdueCombService fscCreditControlUserOverdueCombService;
    @Value(value="${FSC_ORDER_ADD_UPDATE_USER_CONTROL_CONFIG_FLAG:1}")
    private String fscOrderAddUpdateUserControlConfigFlag;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            JSONObject data = JSON.parseObject((String)message.getContent());
            String type = data.getString("type");
            if ("TYPE_CONTROL_USER_INSPECTION".equals(type)) {
                return this.dealUpdateInspectionUserOverdueOrderNum(message, data);
            }
            if ("TYPE_CONTROL_USER_ALL".equals(type)) {
                return this.dealUpdateAllUserOverdueOrderNum(message, data);
            }
            if ("TYPE_CONTROL_USER_LIST".equals(type)) {
                return this.dealUpdateListUserOverdueOrderNum(message, data);
            }
            if ("TYPE_CONTROL_USER_CREATE_ORDER".equals(type)) {
                return this.dealUpdateUserOverdueOrderNumCreateOrder(message, data);
            }
            log.debug("\u5165\u53c2\u7c7b\u578btype\u9519\u8bef:{}", (Object)type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private ProxyConsumerStatus dealUpdateUserOverdueOrderNumCreateOrder(ProxyMessage message, JSONObject data) {
        FscOrderCheckUserControlConfigBusiReqBO reqBo = (FscOrderCheckUserControlConfigBusiReqBO)((Object)data.getObject("busiReqBo", FscOrderCheckUserControlConfigBusiReqBO.class));
        if (reqBo != null && reqBo.getUmcUserId() != null) {
            FscOrderCheckUserControlConfigBusiRspBO busiRspBo = this.fscOrderCheckUserControlConfigBusiService.dealOrderCheckUserControlConfig(reqBo);
            log.debug("\u51fa\u53c2\uff1a{}.\u914d\u7f6e\u503c\uff1a{}", (Object)JSON.toJSONString((Object)((Object)busiRspBo)), (Object)this.fscOrderAddUpdateUserControlConfigFlag);
            if (FscRu.isSuccess(busiRspBo.getRespCode()).booleanValue() && YesNo.YES.getCode().equals(this.fscOrderAddUpdateUserControlConfigFlag)) {
                FscCreditControlUserOverdueCombReqBO busiReqBo = new FscCreditControlUserOverdueCombReqBO();
                busiReqBo.setConfigUserIdList(Collections.singletonList(reqBo.getUmcUserId()));
                busiReqBo.setOperationFlag("3");
                FscCreditControlUserOverdueCombRspBO fscCreditControlUserOverdueCombRspBO = this.fscCreditControlUserOverdueCombService.dealCreditControlUser(busiReqBo);
            }
        } else {
            log.error("\u6388\u4fe1\u7ba1\u63a7\u5f02\u6b65\u66f4\u65b0\u7528\u6237\u903e\u671f\u8ba2\u5355\u6570\u548c\u72b6\u6001\u6d88\u8d39\u5931\u8d25\u3002\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)reqBo)));
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private ProxyConsumerStatus dealUpdateAllUserOverdueOrderNum(ProxyMessage message, JSONObject data) {
        FscCreditControlTipsUserTaskAbilityReqBO reqBo = (FscCreditControlTipsUserTaskAbilityReqBO)data.getObject("busiReqBo", FscCreditControlTipsUserTaskAbilityReqBO.class);
        if (reqBo != null) {
            this.fscCreditControlTipsTaskAbilityService.dealCreditControlTipsUserTask(reqBo);
        } else {
            log.error("\u6388\u4fe1\u7ba1\u63a7\u5f02\u6b65\u66f4\u65b0\u7528\u6237\u903e\u671f\u8ba2\u5355\u6570\u548c\u72b6\u6001\u6d88\u8d39\u5931\u8d25\uff1a\u5165\u53c2\u4e3a\u7a7a");
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private ProxyConsumerStatus dealUpdateListUserOverdueOrderNum(ProxyMessage message, JSONObject data) {
        FscCreditControlTipsUserTaskAbilityReqBO reqBo = (FscCreditControlTipsUserTaskAbilityReqBO)data.getObject("busiReqBo", FscCreditControlTipsUserTaskAbilityReqBO.class);
        if (reqBo != null && !CollectionUtils.isEmpty((Collection)reqBo.getConfigUserIdList())) {
            this.fscCreditControlTipsTaskAbilityService.dealCreditControlTipsUserTask(reqBo);
        } else {
            log.error("\u6388\u4fe1\u7ba1\u63a7\u5f02\u6b65\u66f4\u65b0\u7528\u6237\u903e\u671f\u8ba2\u5355\u6570\u548c\u72b6\u6001\u6d88\u8d39\u5931\u8d25\uff1a\u5165\u53c2\u4e3a\u7a7a");
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private ProxyConsumerStatus dealUpdateInspectionUserOverdueOrderNum(ProxyMessage message, JSONObject data) {
        FscCreditControlUserInspectionBusiReqBO reqBo = (FscCreditControlUserInspectionBusiReqBO)((Object)data.getObject("busiReqBo", FscCreditControlUserInspectionBusiReqBO.class));
        if (reqBo != null) {
            FscCreditControlUserInspectionBusiRspBO fscCreditControlUserInspectionBusiRspBO = this.fscCreditControlBusiService.dealUserCreditControlInspection(reqBo);
        } else {
            log.error("\u6388\u4fe1\u7ba1\u63a7\u5f02\u6b65\u66f4\u65b0\u7528\u6237\u903e\u671f\u8ba2\u5355\u6570\u548c\u72b6\u6001\u6d88\u8d39\u5931\u8d25\uff1a\u5165\u53c2\u4e3a\u7a7a");
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

