/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.pfscext.service.busi.FscCreditControlLogBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditControlLogBusiReqBO;
import com.tydic.pfscext.service.comb.api.FscPayConfigBasicSaveCombService;
import com.tydic.pfscext.service.comb.bo.FscPayConfigSaveBasicCombReqBO;
import com.tydic.pfscext.service.comb.bo.FscPayConfigSaveBasicCombRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscPayConfigSaveConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscPayConfigSaveConsumer.class);
    @Autowired
    private FscCreditControlLogBusiService fscCreditControlLogBusiService;
    @Autowired
    private FscPayConfigBasicSaveCombService fscPayConfigBasicSaveCombService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            JSONObject data = JSON.parseObject((String)message.getContent());
            String type = data.getString("type");
            if ("ADD".equals(type)) {
                return this.dealPayConfigBasicSave(message, data, "1");
            }
            if ("EDIT".equals(type)) {
                return this.dealPayConfigBasicSave(message, data, "2");
            }
            if ("CONTROL_LOG".equals(type)) {
                return this.dealAddCreditControlLog(message, data);
            }
            log.debug("\u5165\u53c2\u7c7b\u578btype\u9519\u8bef:{}", (Object)type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private ProxyConsumerStatus dealAddCreditControlLog(ProxyMessage message, JSONObject data) {
        FscCreditControlLogBusiReqBO reqBo = (FscCreditControlLogBusiReqBO)((Object)data.getObject("busiReqBo", FscCreditControlLogBusiReqBO.class));
        if (reqBo != null) {
            this.fscCreditControlLogBusiService.dealAddCreditControlLog(reqBo);
        } else {
            log.error("\u6388\u4fe1\u7ba1\u63a7\u8bb0\u5f55\u7ba1\u63a7\u53d8\u66f4\u65e5\u5fd7\u6d88\u8d39\u5931\u8d25\uff1a\u5165\u53c2\u4e3a\u7a7a");
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private ProxyConsumerStatus dealPayConfigBasicSave(ProxyMessage message, JSONObject data, String type) {
        FscPayConfigSaveBasicCombReqBO reqBo = (FscPayConfigSaveBasicCombReqBO)((Object)data.getObject("busiReqBo", FscPayConfigSaveBasicCombReqBO.class));
        if (reqBo != null) {
            reqBo.setOpeType(type);
            FscPayConfigSaveBasicCombRspBO rspBo = this.fscPayConfigBasicSaveCombService.dealPayConfigBasicSave(reqBo);
            log.debug("\u6d88\u8d39\u8005\u6267\u884c\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)((Object)rspBo)));
        } else {
            log.error("\u652f\u4ed8\u914d\u7f6e\u6d88\u8d39\u5931\u8d25\uff1a\u5165\u53c2\u4e3a\u7a7a");
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

