/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.active.app.ability.ActQryActivitiesByConditionAbilityService;
import com.tydic.active.app.ability.bo.ActQryActivitiesByConditionAbilityReqBO;
import com.tydic.active.app.ability.bo.ActQryActivitiesByConditionAbilityRspBO;
import com.tydic.active.app.common.bo.ActivitiesBO;
import com.tydic.order.pec.bo.pay.UocPebUpdateBillStatusReqBO;
import com.tydic.pfscext.api.aisino.FscSendApplyAdviceMsgService;
import com.tydic.pfscext.api.aisino.bo.BusiMakeNotificationReqBO;
import com.tydic.pfscext.api.aisino.bo.SendApplyAdviceMsgReqBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoAwaitReqBO;
import com.tydic.pfscext.api.busi.vo.InvoiceHeaderVO;
import com.tydic.pfscext.api.busi.vo.InvoiceMailAddrInfoVO;
import com.tydic.pfscext.base.AuthorityInfo;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.enums.SendApplyAdviceType;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.uoc.api.FscUocPebUpdateBillStatusExternalService;
import com.tydic.pfscext.service.atom.SplitNotificationService;
import com.tydic.pfscext.service.busi.BusiGenerateNotificationService;
import com.tydic.pfscext.service.busi.BusiNotifyEcommerceInvoiceService;
import com.tydic.pfscext.service.busi.bo.BusiGenerateNotificationReqBO;
import com.tydic.pfscext.service.busi.bo.BusiGenerateNotificationRspBO;
import com.tydic.pfscext.service.busi.bo.BusiNotifyEcommerceInvoiceServiceReqBo;
import com.tydic.pfscext.service.busi.bo.BusiNotifyEcommerceInvoiceServiceRspBo;
import com.tydic.pfscext.utils.DateUtil;
import com.tydic.umcext.ability.invoice.UmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityService;
import com.tydic.umcext.ability.invoice.bo.UmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityReqBO;
import com.tydic.umcext.ability.invoice.bo.UmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityRspBO;
import com.tydic.umcext.common.AccountInvoiceBO;
import com.tydic.umcext.common.UmcInvoiceAddressBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MakeNotificationConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(MakeNotificationConsumer.class);
    @Autowired
    private SplitNotificationService splitNotificationService;
    @Autowired
    private BusiGenerateNotificationService busiGenerateNotificationService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BusiNotifyEcommerceInvoiceService busiNotifyEcommerceInvoiceService;
    @Autowired
    private UmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityService umcQryInvoiceAndAddressByOrgIdService;
    @Autowired
    private FscUocPebUpdateBillStatusExternalService fscUocPebUpdateBillStatusExternalService;
    @Autowired
    private FscSendApplyAdviceMsgService fscSendApplyAdviceMsgService;
    @Autowired
    private ActQryActivitiesByConditionAbilityService actQryActivitiesByConditionAbilityService;
    private final String APPLY_DRIVE_NOTI = "1";
    private final String PURCHASE = "purchaser";
    @Value(value="${UNC_MESSAGE_SENDING_FLAG:0}")
    private String UNC_MESSAGE_SENDING_FLAG;
    @Value(value="${FSC_MATCH_UP_FL_GLY_ROLE:119,020}")
    private String fscMatchFlRoles;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            String content = message.getContent();
            JSONObject jsonObject = JSONObject.parseObject((String)content);
            String s = jsonObject.get((Object)"makeNotification").toString();
            BusiMakeNotificationReqBO busiMakeNotificationReqBO = (BusiMakeNotificationReqBO)JSONObject.parseObject((String)s, BusiMakeNotificationReqBO.class);
            this.makeNotification(busiMakeNotificationReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5f00\u7968\u901a\u77e5\u53d1\u8d77\u6d88\u8d39\u8005\u62a5\u9519" + e);
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    public void makeNotification(BusiMakeNotificationReqBO busiMakeNotificationReqBO) {
        List<Long> inspectionIdList = this.queryNotificationInspectionIds(busiMakeNotificationReqBO);
        if (CollectionUtils.isEmpty(inspectionIdList)) {
            throw new PfscExtBusinessException("18000", "\u65e0\u53ef\u5f00\u7968\u8ba2\u5355");
        }
        if ("1".equals(busiMakeNotificationReqBO.getIsApplyDriveNoti()) && StringUtils.isEmpty((Object)busiMakeNotificationReqBO.getOperUnitNo())) {
            log.error("\u4e0b\u6e38\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968\u5fc5\u987b\u8981\u6709OperUnitNo");
            return;
        }
        if ("1".equals(busiMakeNotificationReqBO.getIsApplyDriveNoti())) {
            busiMakeNotificationReqBO = this.applyDriveNoti(busiMakeNotificationReqBO);
        }
        PayPurchaseOrderInfoVO orderInfoVO = new PayPurchaseOrderInfoVO();
        orderInfoVO.setOrderStatus(OrderStatus.SENDING.getCode());
        orderInfoVO.setInspectionIds(inspectionIdList);
        orderInfoVO.setApplyDate(new Date());
        this.payPurchaseOrderInfoMapper.updateStatusBatchByOrderIds(orderInfoVO);
        PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
        vo.setInspectionIds(inspectionIdList);
        vo.setOrderStatus(OrderStatus.SENDING.getCode());
        List<PayPurchaseOrderInfoVO> purchaseOrderList = this.payPurchaseOrderInfoMapper.getListByCondition2(vo);
        if (!CollectionUtils.isEmpty(purchaseOrderList)) {
            List<List<PayPurchaseOrderInfo>> splitOrders = this.splitNotificationService.splitNotification(purchaseOrderList, busiMakeNotificationReqBO.getGroupWay());
            for (List<PayPurchaseOrderInfo> splitOrder : splitOrders) {
                try {
                    BusiGenerateNotificationReqBO reqBO = new BusiGenerateNotificationReqBO();
                    BeanUtils.copyProperties((Object)busiMakeNotificationReqBO, (Object)((Object)reqBO));
                    reqBO.setInvoiceInfo(busiMakeNotificationReqBO.getInvoiceInfo());
                    reqBO.setMailAddrInfo(busiMakeNotificationReqBO.getMailAddrInfo());
                    reqBO.setOrderInfoList(splitOrder);
                    if (StringUtils.isEmpty((Object)busiMakeNotificationReqBO.getIsApplyDriveNoti())) {
                        reqBO.setIsApply(0);
                    } else {
                        reqBO.setIsApply(Integer.valueOf(busiMakeNotificationReqBO.getIsApplyDriveNoti()));
                    }
                    BusiGenerateNotificationRspBO rspBO = this.busiGenerateNotificationService.generateNotification(reqBO);
                    BusiNotifyEcommerceInvoiceServiceRspBo ecommerceInvoiceServiceRspBo = null;
                    if ("0000".equals(rspBO.getRespCode()) && OrderSource.ELECTRIC_MARKET.getCode().equals(splitOrder.get(0).getSource())) {
                        BusiNotifyEcommerceInvoiceServiceReqBo invoiceServiceReqBo = new BusiNotifyEcommerceInvoiceServiceReqBo();
                        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)invoiceServiceReqBo));
                        invoiceServiceReqBo.setBillNotificationInfoExt(rspBO.getBillNotificationInfoExt());
                        invoiceServiceReqBo.setPayPurchaseOrderInfoList(splitOrder);
                        ecommerceInvoiceServiceRspBo = this.busiNotifyEcommerceInvoiceService.notifyEcommerceForInvoice(invoiceServiceReqBo);
                    }
                    if (BusiModel.MATCH_UP_MODEL.getCode().equals(splitOrder.get(0).getBusiModel()) && (!OrderSource.ELECTRIC_MARKET.getCode().equals(splitOrder.get(0).getSource()) && "0000".equals(rspBO.getRespCode()) || OrderSource.ELECTRIC_MARKET.getCode().equals(splitOrder.get(0).getSource()) && "0000".equals(ecommerceInvoiceServiceRspBo.getRespCode()))) {
                        try {
                            List orderIds = splitOrder.stream().map(PayPurchaseOrderInfo::getOrderId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                            if (!CollectionUtils.isEmpty(orderIds)) {
                                UocPebUpdateBillStatusReqBO ubsreqBO = new UocPebUpdateBillStatusReqBO();
                                ubsreqBO.setOrderIds(orderIds);
                                ubsreqBO.setBillState(Integer.valueOf(OrderStatus.APPLIED.getCode()));
                                log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u72b6\u6001\u5165\u53c2\uff1a" + JSON.toJSONString((Object)ubsreqBO));
                                this.fscUocPebUpdateBillStatusExternalService.updateBillStatus(ubsreqBO);
                            }
                        }
                        catch (Exception e) {
                            log.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u72b6\u6001\u5f02\u5e38", (Throwable)e);
                        }
                    }
                    if (StringUtils.isEmpty((Object)busiMakeNotificationReqBO.getVerifyFrom()) || ObjectUtils.isEmpty((Object)splitOrder.get(0)) || StringUtils.isEmpty((Object)rspBO.getNotificationNo())) continue;
                    this.sendAdvice(busiMakeNotificationReqBO.getVerifyFrom(), splitOrder.get(0), rspBO.getNotificationNo());
                }
                catch (Exception e) {
                    log.error("\u5f00\u7968\u901a\u77e5\u53d1\u8d77\u62a5\u9519\uff1a" + e);
                }
            }
        }
    }

    private void sendAdvice(String verifyFrom, PayPurchaseOrderInfo splitOrder, String notificationNo) {
        try {
            if (!YesOrNo.YES.getCodeAsString().equals(this.UNC_MESSAGE_SENDING_FLAG)) {
                log.info("\u901a\u77e5\u914d\u7f6e\u4e0d\u53d1\u9001\u901a\u77e5\uff0c\u76f4\u63a5\u7ed3\u675f");
                return;
            }
            SendApplyAdviceMsgReqBO adviceMsgReqBO = new SendApplyAdviceMsgReqBO();
            adviceMsgReqBO.setNotificationNo(notificationNo);
            adviceMsgReqBO.setBusinessDate(DateUtil.dateToStr(new Date()));
            adviceMsgReqBO.setTemplateName("\u5f85\u5f00\u7968\u7ed3\u7b97\u901a\u77e5");
            if ("1".equals(verifyFrom)) {
                adviceMsgReqBO.setReceiver(SendApplyAdviceType.SUBCONTRACTING_STAY_INVOICED.getReceiver());
                adviceMsgReqBO.setTitle(SendApplyAdviceType.SUBCONTRACTING_STAY_INVOICED.getAdviceName());
                adviceMsgReqBO.setOrgId(splitOrder.getSupplierNo());
            } else if ("2".equals(verifyFrom)) {
                adviceMsgReqBO.setReceiver(SendApplyAdviceType.REDUNDANCY_STAY_INVOICED.getReceiver());
                adviceMsgReqBO.setTitle(SendApplyAdviceType.REDUNDANCY_STAY_INVOICED.getAdviceName());
                adviceMsgReqBO.setOrgId(splitOrder.getPurchaseNo());
            } else if ("3".equals(verifyFrom)) {
                adviceMsgReqBO.setReceiver(SendApplyAdviceType.UNIFIED_SIGNATURE_UP_STAY_INVOICED.getReceiver());
                adviceMsgReqBO.setTitle(SendApplyAdviceType.UNIFIED_SIGNATURE_UP_STAY_INVOICED.getAdviceName());
                adviceMsgReqBO.setOrgId(splitOrder.getSupplierNo());
            }
            this.fscSendApplyAdviceMsgService.sendApplyAdvice(adviceMsgReqBO);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u5f00\u7968\u901a\u77e5\u5931\u8d25\uff01");
        }
    }

    private BusiMakeNotificationReqBO applyDriveNoti(BusiMakeNotificationReqBO busiMakeNotificationReqBO) {
        InvoiceMailAddrInfoVO mailAddrInfoVO;
        UmcInvoiceAddressBO addressBO;
        UmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityReqBO reqBO = new UmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityReqBO();
        reqBO.setOrgId(Long.valueOf(busiMakeNotificationReqBO.getOperUnitNo()));
        UmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityRspBO rspBO = this.umcQryInvoiceAndAddressByOrgIdService.qryMainAccountInvocieAndInvoiceAddressByOrgId(reqBO);
        log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u5f00\u7968\u4fe1\u606f\u548c\u90ae\u5bc4\u5730\u5740\u8fd4\u56de\u53c2\u6570:" + JSON.toJSONString((Object)rspBO));
        if (rspBO != null && "0000".equals(rspBO.getRespCode()) && rspBO.getAccountInvoiceBO() != null && rspBO.getUmcInvoiceAddressBO() != null) {
            busiMakeNotificationReqBO.setGroupWay("0");
            AccountInvoiceBO invoiceBO = rspBO.getAccountInvoiceBO();
            InvoiceHeaderVO invoiceHeaderVO = new InvoiceHeaderVO();
            BeanUtils.copyProperties((Object)invoiceBO, (Object)invoiceHeaderVO);
            if ("00".equals(invoiceBO.getInvoiceType())) {
                invoiceHeaderVO.setInvoiceType(Integer.valueOf(0));
            } else {
                invoiceHeaderVO.setInvoiceType(Integer.valueOf(1));
            }
            if (busiMakeNotificationReqBO.getInvoiceInfo() != null) {
                invoiceHeaderVO.setInvoiceRemark(busiMakeNotificationReqBO.getInvoiceInfo().getInvoiceRemark());
            }
            busiMakeNotificationReqBO.setInvoiceInfo(invoiceHeaderVO);
            addressBO = rspBO.getUmcInvoiceAddressBO();
            mailAddrInfoVO = new InvoiceMailAddrInfoVO();
            mailAddrInfoVO.setName(addressBO.getContactNameWeb());
            mailAddrInfoVO.setProvince(addressBO.getProvinceName());
            mailAddrInfoVO.setCity(addressBO.getCityName());
            mailAddrInfoVO.setCounty(addressBO.getCountyName());
            mailAddrInfoVO.setTown(addressBO.getTownName());
            if (!StringUtils.isEmpty((Object)addressBO.getProvinceId())) {
                mailAddrInfoVO.setProvId(Long.valueOf(addressBO.getProvinceId()));
            }
            if (!StringUtils.isEmpty((Object)addressBO.getCityId())) {
                mailAddrInfoVO.setCityId(Long.valueOf(addressBO.getCityId()));
            }
            if (!StringUtils.isEmpty((Object)addressBO.getCountyId())) {
                mailAddrInfoVO.setCountyId(Long.valueOf(addressBO.getCountyId()));
            }
            if (!StringUtils.isEmpty((Object)addressBO.getTownId())) {
                mailAddrInfoVO.setTownId(Long.valueOf(addressBO.getTownId()));
            }
        } else {
            log.error("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u5f00\u7968\u4fe1\u606f\u548c\u90ae\u5bc4\u5730\u5740\u5931\u8d25\uff1a" + rspBO.getRespDesc());
            throw new PfscExtBusinessException("18000", rspBO.getRespDesc());
        }
        mailAddrInfoVO.setAddrDesc(addressBO.getAddrDesc());
        mailAddrInfoVO.setTel(addressBO.getTel());
        mailAddrInfoVO.setSpecialPlane(addressBO.getSpecialPlane());
        mailAddrInfoVO.setPostCode(addressBO.getPostCode());
        mailAddrInfoVO.setReceiveInvoiceEmail(addressBO.getElcInvoiceEmail());
        mailAddrInfoVO.setReceiveInvoicePhone(addressBO.getElcInvoiceMobile());
        busiMakeNotificationReqBO.setMailAddrInfo(mailAddrInfoVO);
        return busiMakeNotificationReqBO;
    }

    private List<Long> queryNotificationInspectionIds(BusiMakeNotificationReqBO reqBO) {
        List<Long> inspectionIdList;
        if ("1".equals(reqBO.getIsSelectOrder()) && !CollectionUtils.isEmpty((Collection)reqBO.getInspectionIdList())) {
            PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
            LinkedList<Long> inspectionIds = new LinkedList<Long>();
            for (String id : reqBO.getInspectionIdList()) {
                inspectionIds.add(Long.valueOf(id));
            }
            vo.setInspectionIds(inspectionIds);
            vo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            vo.setReconcilitionStatus(ReconciliationStatus.AGREEMENT.getCode());
            inspectionIdList = this.payPurchaseOrderInfoMapper.getInspectionIdListByCondition(vo);
        } else {
            QueryPayPurchaseOrderInfoAwaitReqBO queryPayPurchaseOrderInfoAwaitReqBO = reqBO.getQueryPayPurchaseOrderInfoAwaitReqBO();
            PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
            BeanUtils.copyProperties((Object)queryPayPurchaseOrderInfoAwaitReqBO, (Object)payPurchaseOrderInfoVO);
            if (!StringUtils.isEmpty((Object)queryPayPurchaseOrderInfoAwaitReqBO.getSupplierNo())) {
                payPurchaseOrderInfoVO.setSupplierNo(Long.valueOf(queryPayPurchaseOrderInfoAwaitReqBO.getSupplierNo()));
            }
            if (!StringUtils.isEmpty((Object)queryPayPurchaseOrderInfoAwaitReqBO.getPurchaseNo())) {
                payPurchaseOrderInfoVO.setPurchaseNo(Long.valueOf(queryPayPurchaseOrderInfoAwaitReqBO.getPurchaseNo()));
            }
            if (!StringUtils.isEmpty((Object)queryPayPurchaseOrderInfoAwaitReqBO.getInspectionId())) {
                payPurchaseOrderInfoVO.setInspectionId(Long.valueOf(queryPayPurchaseOrderInfoAwaitReqBO.getInspectionId()));
            }
            if (!StringUtils.isEmpty((Object)queryPayPurchaseOrderInfoAwaitReqBO.getPurchaserId())) {
                payPurchaseOrderInfoVO.setPurchaserId(Long.valueOf(queryPayPurchaseOrderInfoAwaitReqBO.getPurchaserId()));
            }
            if (!StringUtils.isEmpty((Object)queryPayPurchaseOrderInfoAwaitReqBO.getActivityId())) {
                payPurchaseOrderInfoVO.setActivityId(Long.valueOf(queryPayPurchaseOrderInfoAwaitReqBO.getActivityId()));
            }
            if (!StringUtils.isEmpty((Object)queryPayPurchaseOrderInfoAwaitReqBO.getPurchaseProjectId())) {
                payPurchaseOrderInfoVO.setPurchaseProjectId(Long.valueOf(queryPayPurchaseOrderInfoAwaitReqBO.getPurchaseProjectId()));
            }
            if ("purchaser".equals(reqBO.getSettleModel())) {
                payPurchaseOrderInfoVO.setPurchaserId(reqBO.getUserId());
            }
            if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
                payPurchaseOrderInfoVO.setBusiModel(BusiModel.TRADE_MODEL.getCode());
                payPurchaseOrderInfoVO.setOperUnitNo(reqBO.getCompanyId());
            } else if ("1".equals(reqBO.getIsProfessionalOrgExt())) {
                payPurchaseOrderInfoVO.setPurchaseNo(reqBO.getCompanyId());
                payPurchaseOrderInfoVO.setBusiModel(BusiModel.MATCH_UP_MODEL.getCode());
                if ("2".equals(reqBO.getVerifyFrom())) {
                    payPurchaseOrderInfoVO.setIsNotActivity(YesNo.YES.getCode());
                }
                if ("1".equals(reqBO.getVerifyFrom())) {
                    if (YesNo.YES.getCode().equals(queryPayPurchaseOrderInfoAwaitReqBO.getIsActivity())) {
                        List<String> activityIds = this.getActivityIds(reqBO, queryPayPurchaseOrderInfoAwaitReqBO);
                        if (CollectionUtils.isEmpty(activityIds)) {
                            throw new PfscExtBusinessException("0001", "\u6d3b\u52a8ID\u67e5\u8be2\u4e3a\u7a7a");
                        }
                        payPurchaseOrderInfoVO.setActivityIdList(activityIds);
                        if (!CollectionUtils.isEmpty((Collection)reqBO.getPermission()) && StringUtils.hasText((String)this.fscMatchFlRoles)) {
                            List<String> fscMatchFlRoleList = Arrays.asList(this.fscMatchFlRoles.split(","));
                            if (reqBO.getPermission().stream().map(AuthorityInfo::getKey).anyMatch(fscMatchFlRoleList::contains)) {
                                payPurchaseOrderInfoVO.setPurchaserId(null);
                            }
                        }
                    } else {
                        payPurchaseOrderInfoVO.setIsNotActivity(YesNo.YES.getCode());
                    }
                }
            } else if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
                throw new PfscExtBusinessException("0001", "\u4f9b\u5e94\u5546\u4e0d\u80fd\u53d1\u8d77\u5f00\u7968\u7533\u8bf7");
            }
            payPurchaseOrderInfoVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            payPurchaseOrderInfoVO.setReconcilitionStatus(ReconciliationStatus.AGREEMENT.getCode());
            inspectionIdList = this.payPurchaseOrderInfoMapper.getInspectionIdListByCondition(payPurchaseOrderInfoVO);
        }
        return inspectionIdList;
    }

    private List<String> getActivityIds(BusiMakeNotificationReqBO reqBO, QueryPayPurchaseOrderInfoAwaitReqBO pageReqBO) {
        ArrayList<String> activityIds = new ArrayList<String>();
        ActQryActivitiesByConditionAbilityReqBO activitiesByConditionAbilityReqBO = new ActQryActivitiesByConditionAbilityReqBO();
        activitiesByConditionAbilityReqBO.setCreateLoginId(reqBO.getMemIdExt().toString());
        if (StringUtils.hasText((String)pageReqBO.getActivityId())) {
            activitiesByConditionAbilityReqBO.setActiveId(Long.valueOf(Long.parseLong(pageReqBO.getActivityId())));
        }
        activitiesByConditionAbilityReqBO.setPageNo(Integer.valueOf(-1));
        activitiesByConditionAbilityReqBO.setPageSize(Integer.valueOf(-1));
        log.error("\u5458\u5de5\u798f\u5229\u5206\u7b7e\u6d3b\u52a8\u7ed3\u7b97\u5f00\u7968\u67e5\u8be2\u8c03\u7528\u6d3b\u52a8\u4e2d\u5fc3\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSON((Object)activitiesByConditionAbilityReqBO));
        ActQryActivitiesByConditionAbilityRspBO actQryActivitiesByConditionAbilityRspBO = this.actQryActivitiesByConditionAbilityService.qryActivitiesByCondition(activitiesByConditionAbilityReqBO);
        log.error("\u5458\u5de5\u798f\u5229\u5206\u7b7e\u6d3b\u52a8\u7ed3\u7b97\u5f00\u7968\u67e5\u8be2\u8c03\u7528\u6d3b\u52a8\u4e2d\u5fc3\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSON((Object)actQryActivitiesByConditionAbilityRspBO.getRecordsTotal()));
        if (actQryActivitiesByConditionAbilityRspBO != null && "0000".equals(actQryActivitiesByConditionAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)actQryActivitiesByConditionAbilityRspBO.getRows())) {
            for (ActivitiesBO activitiesBO : actQryActivitiesByConditionAbilityRspBO.getRows()) {
                if (activitiesBO.getActiveId() == null) continue;
                activityIds.add(activitiesBO.getActiveId() + "");
            }
        }
        return activityIds;
    }
}

