/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import com.tydic.pfscext.annotation.constant.LogConstant;
import com.tydic.pfscext.annotation.log.FscExtSysLog;
import com.tydic.pfscext.api.ability.FscActivityCreditRecordAbilityService;
import com.tydic.pfscext.api.ability.bo.FscActCreditRecordAddUserInfoBO;
import com.tydic.pfscext.api.ability.bo.FscActivityCreditCheckAmountAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscActivityCreditCheckAmountAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscActivityCreditRecordAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscActivityCreditRecordAbilityRspBO;
import com.tydic.pfscext.dao.FscCreditRecordMapper;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.FscCreditBusiCategory;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.FscPayConfigSubClass;
import com.tydic.pfscext.enums.FscPayConfigSubType;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscCreditRecordBusiService;
import com.tydic.pfscext.service.busi.bo.FscActCreditRecordAddBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscActCreditRecordAddBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscActivityCreditRecordAbilityService"})
public class FscActivityCreditRecordAbilityServiceImpl
implements FscActivityCreditRecordAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscActivityCreditRecordAbilityServiceImpl.class);
    @Autowired
    private FscPayConfigMapper fscPayConfigMapper;
    @Autowired
    private FscCreditRecordMapper fscCreditRecordMapper;
    @Autowired
    private FscCreditRecordBusiService fscCreditRecordBusiService;

    @FscExtSysLog(params={"activityId"}, source=LogConstant.SysCode.ACT, target=LogConstant.SysCode.FSC, rspBase=LogConstant.RspBase.CENTER)
    @PostMapping(value={"dealActCreditRecord"})
    public FscActivityCreditRecordAbilityRspBO dealActCreditRecord(@RequestBody FscActivityCreditRecordAbilityReqBO reqBo) {
        ValUtil.isEmpty(reqBo).exception("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getUserId()).exception("\u7528\u6237ID\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getUsername()).exception("\u7528\u6237\u540d\u79f0\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getPurOrgId()).exception("\u5165\u53c2[purOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getAccountId()).exception("\u5165\u53c2[accountId]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getActivityId()).exception("\u5165\u53c2[activityId]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getActivityNo()).exception("\u5165\u53c2[activityNo]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getBusiModel()).exception("\u5165\u53c2[busiModel]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(BusiModel.getInstance((String)reqBo.getBusiModel().toString())).exception("\u7ed3\u7b97\u6a21\u5f0f\u503c\u9519\u8bef");
        ValUtil.isEmpty(reqBo.getBusiCategory()).exception("\u5165\u53c2[busiCategory]\u4e0d\u80fd\u4e3a\u7a7a");
        if (!Arrays.asList(FscCreditBusiCategory.ACT_ADD.getCode(), FscCreditBusiCategory.ACT_CHANGE.getCode(), FscCreditBusiCategory.ACT_OVER.getCode()).contains(reqBo.getBusiCategory())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2[busiCategory]\u503c\u9519\u8bef");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getUserInfos())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2[userInfos]\u6388\u4fe1\u4f7f\u7528\u7528\u6237\u6570\u636e\u4e3a\u7a7a");
        }
        for (FscActCreditRecordAddUserInfoBO userInfo : reqBo.getUserInfos()) {
            ValUtil.isEmpty(userInfo.getActUserId()).exception("\u5165\u53c2[userInfos.actUserId]\u4e0d\u80fd\u4e3a\u7a7a");
            ValUtil.isEmpty(userInfo.getActUserName()).exception("\u5165\u53c2[userInfos.actUserName]\u4e0d\u80fd\u4e3a\u7a7a");
            ValUtil.isEmpty(userInfo.getAfterAmount()).exception("\u5165\u53c2[userInfos.afterAmount]\u4e0d\u80fd\u4e3a\u7a7a");
            if (FscCreditBusiCategory.ACT_ADD.getCode().equals(reqBo.getBusiCategory())) {
                userInfo.setBeforeAmount(Optional.ofNullable(userInfo.getBeforeAmount()).orElse(BigDecimal.ZERO));
                if (userInfo.getBeforeAmount().compareTo(BigDecimal.ZERO) < 0) {
                    throw new PfscExtBusinessException("0001", "\u5165\u53c2[userInfos.beforeAmount]\u4e0d\u80fd\u5c0f\u4e8e0");
                }
            }
            ValUtil.isEmpty(userInfo.getBeforeAmount()).exception("\u5165\u53c2[userInfos.beforeAmount]\u4e0d\u80fd\u4e3a\u7a7a");
            if (userInfo.getBeforeAmount().compareTo(BigDecimal.ZERO) < 0) {
                throw new PfscExtBusinessException("0001", "\u5165\u53c2[userInfos.beforeAmount]\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            if (userInfo.getAfterAmount().compareTo(BigDecimal.ZERO) >= 0) continue;
            throw new PfscExtBusinessException("0001", "\u5165\u53c2[userInfos.afterAmount]\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        FscActCreditRecordAddBusiReqBO busiReqBo = FscRu.js(reqBo, FscActCreditRecordAddBusiReqBO.class);
        if (FscCreditBusiCategory.ACT_ADD.getCode().equals(reqBo.getBusiCategory())) {
            ValUtil.isEmpty(reqBo.getActUserType()).exception("\u5165\u53c2[actUserType]\u4e0d\u80fd\u4e3a\u7a7a");
            if ("1".equals(reqBo.getActUserType())) {
                busiReqBo.setPaySubClass(FscPayConfigSubClass.OUT.getCode());
                busiReqBo.setPaySubType(FscPayConfigSubType.GR.getCode());
            } else if ("2".equals(reqBo.getActUserType())) {
                busiReqBo.setPaySubClass(FscPayConfigSubClass.OUT.getCode());
                busiReqBo.setPaySubType(FscPayConfigSubType.QY.getCode());
            } else if ("3".equals(reqBo.getActUserType())) {
                busiReqBo.setPaySubClass(FscPayConfigSubClass.IN.getCode());
                busiReqBo.setPaySubType(FscPayConfigSubType.GR.getCode());
            } else if ("4".equals(reqBo.getActUserType())) {
                busiReqBo.setPaySubClass(FscPayConfigSubClass.IN.getCode());
                busiReqBo.setPaySubType(FscPayConfigSubType.QY.getCode());
            } else {
                throw new PfscExtBusinessException("0001", "\u5165\u53c2[actUserType]\u503c\u9519\u8bef");
            }
            if (FscPayConfigSubType.GR.getCode().equals(busiReqBo.getPaySubType())) {
                busiReqBo.setPaySubType(FscPayConfigSubType.QY.getCode());
            }
        }
        FscActCreditRecordAddBusiRspBO busiRspBo = this.fscCreditRecordBusiService.dealActCreditRecord(busiReqBo);
        return FscRu.js((Object)busiRspBo, FscActivityCreditRecordAbilityRspBO.class);
    }

    @PostMapping(value={"dealActCreditCheckAmount"})
    public FscActivityCreditCheckAmountAbilityRspBO dealActCreditCheckAmount(@RequestBody FscActivityCreditCheckAmountAbilityReqBO reqBo) {
        ValUtil.isEmpty(reqBo).exception("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getPurOrgId()).exception("\u5165\u53c2[purOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal activityAmount = reqBo.getActivityAmount();
        ValUtil.isEmpty(activityAmount).exception("\u5165\u53c2[activityAmount]\u4e0d\u80fd\u4e3a\u7a7a");
        if (BigDecimal.ZERO.compareTo(activityAmount) > 0) {
            throw new PfscExtBusinessException("0001", "\u6d3b\u52a8\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        ValUtil.isEmpty(reqBo.getActUserType()).exception("\u5165\u53c2[actUserType]\u4e0d\u80fd\u4e3a\u7a7a");
        FscPayConfigPO fscPayConfigPo = new FscPayConfigPO();
        fscPayConfigPo.setPayOrgId(reqBo.getPurOrgId());
        fscPayConfigPo.setPayBusiType(FscPayConfigBusiType.FL.getCode());
        if ("1".equals(reqBo.getActUserType())) {
            fscPayConfigPo.setPaySubClass(FscPayConfigSubClass.OUT.getCode());
            fscPayConfigPo.setPaySubType(FscPayConfigSubType.GR.getCode());
        } else if ("2".equals(reqBo.getActUserType())) {
            fscPayConfigPo.setPaySubClass(FscPayConfigSubClass.OUT.getCode());
            fscPayConfigPo.setPaySubType(FscPayConfigSubType.QY.getCode());
        } else if ("3".equals(reqBo.getActUserType())) {
            fscPayConfigPo.setPaySubClass(FscPayConfigSubClass.IN.getCode());
            fscPayConfigPo.setPaySubType(FscPayConfigSubType.GR.getCode());
        } else if ("4".equals(reqBo.getActUserType())) {
            fscPayConfigPo.setPaySubClass(FscPayConfigSubClass.IN.getCode());
            fscPayConfigPo.setPaySubType(FscPayConfigSubType.QY.getCode());
        } else {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2[actUserType]\u503c\u9519\u8bef");
        }
        if (FscPayConfigSubType.GR.getCode().equals(fscPayConfigPo.getPaySubType())) {
            fscPayConfigPo.setPaySubType(FscPayConfigSubType.QY.getCode());
        }
        if ((fscPayConfigPo = this.fscPayConfigMapper.getModelBy(fscPayConfigPo)) == null) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u4e3a\u7a7a");
        }
        if (FscPayConfigControlStatus.RESTRICTED.getCode().equals(fscPayConfigPo.getCurrentOrgControlStatus())) {
            throw new PfscExtBusinessException("18000", "\u8be5\u673a\u6784\u5f53\u524d\u4e3a\u6388\u4fe1\u7ba1\u63a7\u72b6\u6001");
        }
        if (!FscPayConfigType.EXT_ORG.getCode().equals(fscPayConfigPo.getPayConfigType()) && !FscPayConfigType.DEF.getCode().equals(fscPayConfigPo.getPayConfigType())) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u7ed3\u679c\u9519\u8bef\uff0c\u4e0d\u662f\u5355\u4f4d\u652f\u4ed8\u914d\u7f6e");
        }
        if (!YesOrNo.YES.getCode().equals(fscPayConfigPo.getPayUsedPeriodFlag())) {
            throw new PfscExtBusinessException("18000", "\u8be5\u652f\u4ed8\u914d\u7f6e\u672a\u914d\u7f6e\u8fc7\u6388\u4fe1,\u8bf7\u68c0\u67e5\u914d\u7f6e\u540e\u518d\u4f7f\u7528\u6388\u4fe1");
        }
        BigDecimal creditAmount = fscPayConfigPo.getCreditAmount();
        BigDecimal usedAmount = Optional.ofNullable(fscPayConfigPo.getUsedAmount()).orElse(BigDecimal.ZERO);
        BigDecimal balanceAmount = Optional.ofNullable(fscPayConfigPo.getBalanceAmount()).orElse(BigDecimal.ZERO);
        log.warn("\u6d3b\u52a8\u6388\u4fe1\u989d\u5ea6\u68c0\u67e5\u670d\u52a1.\u68c0\u67e5\u603b\u989d\u5ea6\uff1a{},\u6388\u4fe1\u603b\u989d\u5ea6\uff1a{},\u5df2\u4f7f\u7528\u989d\u5ea6\uff1a{},\u5269\u4f59\u989d\u5ea6\uff1a{},\u914d\u7f6e\u4e3b\u952e\uff1a{}", new Object[]{activityAmount, creditAmount, usedAmount, balanceAmount, fscPayConfigPo.getPayConfigId()});
        if (creditAmount == null) {
            throw new PfscExtBusinessException("18000", "\u6388\u4fe1\u989d\u5ea6\u4e3a\u7a7a");
        }
        if (usedAmount.compareTo(BigDecimal.ZERO) < 0) {
            throw new PfscExtBusinessException("18000", "\u6388\u4fe1\u989d\u5ea6\u4f7f\u7528\u5f02\u5e38\uff0c\u5df2\u4f7f\u7528\u989d\u5ea6\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        if (activityAmount.add(usedAmount.abs()).compareTo(creditAmount) > 0) {
            throw new PfscExtBusinessException("18000", "\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3");
        }
        FscActivityCreditCheckAmountAbilityRspBO rspBo = FscRu.success(FscActivityCreditCheckAmountAbilityRspBO.class);
        rspBo.setCreditAmount(creditAmount);
        rspBo.setBalanceAmount(balanceAmount);
        rspBo.setUsedAmount(usedAmount);
        return rspBo;
    }
}

