/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.pfscext.api.ability.FscApplyPayAbilityService;
import com.tydic.pfscext.api.busi.BusiApplyPayService;
import com.tydic.pfscext.api.busi.bo.ApplyPayBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyPayServiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyPayServiceRspBO;
import com.tydic.pfscext.api.busi.bo.ContinuePayCheckReqBO;
import com.tydic.pfscext.api.busi.bo.ContinuePayCheckRspBO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.RedisLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscApplyPayAbilityService"})
public class FscApplyPayAbilityServiceImpl
implements FscApplyPayAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscApplyPayAbilityServiceImpl.class);
    @Autowired
    private BusiApplyPayService busiApplyPayService;
    @Resource
    private RedisLock redisLock;
    @Resource(name="fscApplyPayResultUocCallbackProvider")
    private ProxyMessageProducer fscApplyPayResultUocCallbackProvider;
    @Value(value="${FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TOPIC:FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TOPIC}")
    private String FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TOPIC;
    @Value(value="${FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TAG:*}")
    private String FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TAG;

    @PostMapping(value={"applyPay"})
    public BusiApplyPayServiceRspBO applyPay(@RequestBody BusiApplyPayServiceReqBO reqBo) {
        return this.busiApplyPayService.applyPay(reqBo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"applyExpetionPay"})
    public BusiApplyPayServiceRspBO applyExpetionPay(@RequestBody BusiApplyPayServiceReqBO reqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getApplyPayBOList())) {
            throw new PfscExtBusinessException("18000", "\u6765\u6e90\u3001\u5f00\u7968\u7f16\u53f7\u3001\u4ed8\u6b3e\u91d1\u989d\u548c\u5e94\u4ed8\u5355\u53f7\u7ec4\u6210\u7684\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getApplyPayBOList().stream().anyMatch(i -> StrUtil.isBlank((CharSequence)i.getPayableNo()))) {
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355\u53f7\u5b58\u5728\u4e3a\u7a7a");
        }
        List payableNoList = reqBo.getApplyPayBOList().stream().map(ApplyPayBO::getPayableNo).distinct().collect(Collectors.toList());
        ArrayList<String> unLockKeyList = new ArrayList<String>();
        try {
            for (String payableNo : payableNoList) {
                String redisLockKey = "FSC_PAY_IMPORT_EXCEPTION_LOCK_PREFIX_" + payableNo;
                if (this.redisLock.getLock(redisLockKey, 1200)) {
                    throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355\u53f7[" + payableNo + "]\u6b63\u5728\u6838\u9500\u4e2d,\u8bf7\u7a0d\u540e\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
                }
                unLockKeyList.add(redisLockKey);
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38\u6838\u9500\u5e94\u4ed8\u5355\u53f7\u89e3\u9501\uff1a{}", unLockKeyList);
            if (!CollectionUtils.isEmpty(unLockKeyList)) {
                for (String unLockKey : unLockKeyList) {
                    this.redisLock.unLock(unLockKey);
                }
            }
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        log.error("\u5f02\u5e38\u6838\u9500\u5e94\u4ed8\u5355\u53f7\u9501\uff1a{}", unLockKeyList);
        try {
            BusiApplyPayServiceRspBO busiApplyPayServiceRspBo;
            String payableNo;
            reqBo.setUocEsSyncVersionId(Long.valueOf(Sequence.getInstance().nextId()));
            if (reqBo.getDown() != null && reqBo.getDown().booleanValue()) {
                busiApplyPayServiceRspBo = this.busiApplyPayService.applyExceptionPayOperator(reqBo);
                this.sendMqSyncUocOrder(reqBo.getUocEsSyncVersionId());
                payableNo = busiApplyPayServiceRspBo;
                return payableNo;
            }
            busiApplyPayServiceRspBo = this.busiApplyPayService.applyExpetionPay(reqBo);
            this.sendMqSyncUocOrder(reqBo.getUocEsSyncVersionId());
            payableNo = busiApplyPayServiceRspBo;
            return payableNo;
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38\u6838\u9500\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
            BusiApplyPayServiceRspBO rspBo = new BusiApplyPayServiceRspBO();
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u5f02\u5e38\u6838\u9500\u5f02\u5e38:" + e.getMessage());
            BusiApplyPayServiceRspBO busiApplyPayServiceRspBO = rspBo;
            return busiApplyPayServiceRspBO;
        }
        finally {
            log.error("\u5f02\u5e38\u6838\u9500\u5e94\u4ed8\u5355\u53f7\u89e3\u9501\uff1a{}", unLockKeyList);
            if (!CollectionUtils.isEmpty(unLockKeyList)) {
                for (String unLockKey : unLockKeyList) {
                    this.redisLock.unLock(unLockKey);
                }
            }
        }
    }

    @PostMapping(value={"applyExceptionPayOperator"})
    public BusiApplyPayServiceRspBO applyExceptionPayOperator(@RequestBody BusiApplyPayServiceReqBO reqBo) {
        reqBo.setUocEsSyncVersionId(Long.valueOf(Sequence.getInstance().nextId()));
        BusiApplyPayServiceRspBO busiApplyPayServiceRspBo = this.busiApplyPayService.applyExceptionPayOperator(reqBo);
        this.sendMqSyncUocOrder(reqBo.getUocEsSyncVersionId());
        return busiApplyPayServiceRspBo;
    }

    @PostMapping(value={"continuePayCheck"})
    public ContinuePayCheckRspBO continuePayCheck(@RequestBody ContinuePayCheckReqBO reqBo) {
        return this.busiApplyPayService.continuePayCheck(reqBo);
    }

    private void sendMqSyncUocOrder(Long uocEsSyncVersionId) {
        JSONObject data = new JSONObject();
        data.put("type", (Object)"ORDER_SYNC_ES");
        data.put("uocEsSyncVersionId", (Object)uocEsSyncVersionId);
        ProxyMessage message = new ProxyMessage(this.FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TOPIC, this.FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TAG, data.toJSONString());
        ProxySendResult sendResult = this.fscApplyPayResultUocCallbackProvider.send(message);
    }
}

