/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.ability.FscApplyPayInfoQryAbilityService;
import com.tydic.pfscext.api.ability.bo.FscApplyPayInfoQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscApplyPayInfoQryAbilityRspBO;
import com.tydic.pfscext.api.busi.bo.ApplyPayInfoBO;
import com.tydic.pfscext.api.busi.bo.BusiTabNumbersQryBO;
import com.tydic.pfscext.api.busi.bo.CountTabVO;
import com.tydic.pfscext.base.AuthorityInfo;
import com.tydic.pfscext.constants.FscConstants;
import com.tydic.pfscext.dao.ConfTabStateMapper;
import com.tydic.pfscext.dao.DApplyPayInfoExtMapMapper;
import com.tydic.pfscext.dao.FscApplyPayInfoMapper;
import com.tydic.pfscext.dao.po.ConfTabStatePO;
import com.tydic.pfscext.dao.po.DApplyPayInfoExtMapPO;
import com.tydic.pfscext.dao.po.FscApplyPayInfoExtendPO;
import com.tydic.pfscext.dao.po.FscApplyPayInfoPO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.FinancialStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscApplyPayInfoQryAbilityService"})
public class FscApplyPayInfoQryAbilityServiceImpl
implements FscApplyPayInfoQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscApplyPayInfoQryAbilityServiceImpl.class);
    @Autowired
    private FscApplyPayInfoMapper fscApplyPayInfoMapper;
    @Autowired
    private ConfTabStateMapper confTabStateMapper;
    @Autowired
    private DApplyPayInfoExtMapMapper applyPayInfoExtMapMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Value(value="${FSC_AUTH_PUR_PAYMENT_COMPANY_ROLES:014,019,001}")
    private String FSC_AUTH_PUR_PAYMENT_COMPANY_ROLES;
    @Value(value="${FSC_AUTH_PUR_PAYMENT_PURCHASER_ROLES:002}")
    private String FSC_AUTH_PUR_PAYMENT_PURCHASER_ROLES;

    @Deprecated
    @PostMapping(value={"listPageApplyPayInfo"})
    public FscApplyPayInfoQryAbilityRspBO listPageApplyPayInfo(@RequestBody FscApplyPayInfoQryAbilityReqBO reqBo) {
        this.parameterValidation(reqBo);
        FscApplyPayInfoExtendPO fscApplyPayInfoExtendQry = this.initSelectPo(reqBo);
        Page pager = new Page(Optional.ofNullable(reqBo.getPageNo()).orElse(1).intValue(), Optional.ofNullable(reqBo.getPageSize()).orElse(10).intValue());
        List<FscApplyPayInfoExtendPO> list = this.fscApplyPayInfoMapper.getListPagePayableList(fscApplyPayInfoExtendQry, (Page<FscApplyPayInfoPO>)pager);
        FscApplyPayInfoQryAbilityRspBO rspBo = FscRu.success(FscApplyPayInfoQryAbilityRspBO.class);
        rspBo.setPageNo(Integer.valueOf(pager.getPageNo()));
        rspBo.setTotal(Integer.valueOf(pager.getTotalPages()));
        rspBo.setRecordsTotal(Integer.valueOf(pager.getTotalCount()));
        rspBo.setRows(this.initData(list));
        rspBo.setTabCountList(this.initTabCountList(reqBo, FscRu.js(fscApplyPayInfoExtendQry, FscApplyPayInfoExtendPO.class)));
        return rspBo;
    }

    private List<ApplyPayInfoBO> initData(List<FscApplyPayInfoExtendPO> listPo) {
        ArrayList<ApplyPayInfoBO> applyPayInfoList = new ArrayList<ApplyPayInfoBO>();
        if (!CollectionUtils.isEmpty(listPo)) {
            HashMap purchaseMap = new HashMap();
            applyPayInfoList.addAll(listPo.stream().map(item -> {
                PayResultStatus sta;
                ApplyPayInfoBO bo = FscRu.js(item, ApplyPayInfoBO.class);
                bo.setPaytableTypeStr((String)Optional.ofNullable(bo.getPaytableType()).map(payableType -> PayableType.desc(payableType.toString())).orElse(null));
                bo.setSourceStr(OrderSource.desc((String)bo.getSource()));
                bo.setSupplierStr(bo.getSupplierName());
                bo.setPayStatusStr(ApplyPayStatus.desc(item.getPayStatus()));
                bo.setFinancialStatusDescr(FinancialStatus.desc(bo.getFinancialStatus()));
                if (StrUtil.isNotBlank((CharSequence)item.getPayChannel())) {
                    bo.setPayChannel(Integer.valueOf(item.getPayChannel()));
                    bo.setPayChannelStr(PayChannel.desc(item.getPayChannel()));
                    if (StrUtil.isNotBlank((CharSequence)bo.getPayno())) {
                        Map<String, String> mapCodeValue;
                        if (PayChannel.WECHAT.getCode().equals(item.getPayChannel()) || PayChannel.ZFB.getCode().equals(item.getPayChannel())) {
                            bo.setRecAcctName(item.getSupplierName());
                            bo.setOpenBankName(null);
                            bo.setReceiptAcctNo(null);
                        } else if (PayChannel.GYLJR.getCode().equals(item.getPayChannel())) {
                            mapCodeValue = this.mapApplyPayInfoCodeValue(bo.getPayno());
                            if (!mapCodeValue.isEmpty()) {
                                bo.setRecAcctName(Optional.ofNullable(mapCodeValue.get("corpNameAccept")).orElse(""));
                                bo.setOpenBankName(null);
                                bo.setReceiptAcctNo(null);
                            }
                        } else if (PayChannel.ZGYH.getCode().equals(item.getPayChannel())) {
                            mapCodeValue = this.mapApplyPayInfoCodeValue(bo.getPayno());
                            if (!mapCodeValue.isEmpty()) {
                                bo.setRecAcctName(Optional.ofNullable(mapCodeValue.get("chinaBankAccountName")).orElse(""));
                                bo.setOpenBankName(null);
                                bo.setReceiptAcctNo(Optional.ofNullable(mapCodeValue.get("chinaBankAccountNo")).orElse(""));
                            }
                        } else if (PayChannel.ZGGSYH.getCode().equals(item.getPayChannel())) {
                            mapCodeValue = this.mapApplyPayInfoCodeValue(bo.getPayno());
                            if (!mapCodeValue.isEmpty()) {
                                bo.setRecAcctName(Optional.ofNullable(mapCodeValue.get("accountName")).orElse(""));
                                bo.setOpenBankName(Optional.ofNullable(mapCodeValue.get("icbcBankName")).orElse(""));
                                bo.setReceiptAcctNo(Optional.ofNullable(mapCodeValue.get("accountNo")).orElse(""));
                            }
                        } else if (PayChannel.ZHCQT.getCode().equals(item.getPayChannel()) && !(mapCodeValue = this.mapApplyPayInfoCodeValue(bo.getPayno())).isEmpty()) {
                            bo.setRecAcctName(Optional.ofNullable(mapCodeValue.get("cnncPayeeAcctName")).orElse(""));
                            bo.setOpenBankName(Optional.ofNullable(mapCodeValue.get("cnncRemitBankName")).orElse(""));
                            bo.setReceiptAcctNo(Optional.ofNullable(mapCodeValue.get("cnncPayeeAcctNo")).orElse(""));
                        }
                    }
                }
                if (item.getPurchaseNo() != null) {
                    String purchaseName = (String)purchaseMap.get(item.getPurchaseNo());
                    if (purchaseName != null) {
                        bo.setPurchaseName(purchaseName);
                    } else {
                        String purcahseName = this.organizationInfoService.queryOrgName(item.getPurchaseNo());
                        purchaseMap.put(item.getPurchaseNo(), purcahseName);
                        bo.setPurchaseName(purcahseName);
                    }
                }
                if ((sta = PayResultStatus.getInstance(item.getPayStatus())) == PayResultStatus.CANCEL || sta == PayResultStatus.SUCCESS) {
                    bo.setApplyClosed("Y");
                } else {
                    bo.setApplyClosed("N");
                }
                return bo;
            }).collect(Collectors.toList()));
        }
        return applyPayInfoList;
    }

    private FscApplyPayInfoExtendPO initSelectPo(FscApplyPayInfoQryAbilityReqBO reqBo) {
        FscApplyPayInfoExtendPO fscApplyPayInfoExtendQry = new FscApplyPayInfoExtendPO();
        fscApplyPayInfoExtendQry.setPaynoLike(reqBo.getBillNo());
        fscApplyPayInfoExtendQry.setPayno(reqBo.getPayno());
        fscApplyPayInfoExtendQry.setPaynoList(reqBo.getPayNoList());
        fscApplyPayInfoExtendQry.setApplyNoLike(reqBo.getApplyNo());
        fscApplyPayInfoExtendQry.setNotificationNoLike(reqBo.getNotificationNo());
        fscApplyPayInfoExtendQry.setStartDate(reqBo.getStartDate());
        fscApplyPayInfoExtendQry.setEndDate(reqBo.getEndDate());
        fscApplyPayInfoExtendQry.setApplyDateStart(reqBo.getApplyDateStart());
        fscApplyPayInfoExtendQry.setApplyDateEnd(reqBo.getApplyDateEnd());
        fscApplyPayInfoExtendQry.setSource(reqBo.getSource());
        fscApplyPayInfoExtendQry.setPayStatus(reqBo.getPayStatus());
        fscApplyPayInfoExtendQry.setSupplierId(reqBo.getSupplierId());
        fscApplyPayInfoExtendQry.setPurchaseNo(reqBo.getPurchaseNo());
        fscApplyPayInfoExtendQry.setContactName(reqBo.getCompanyNameNew());
        fscApplyPayInfoExtendQry.setPurchaseOrderCode(reqBo.getPurchaseOrderCode());
        fscApplyPayInfoExtendQry.setPurchaseOrderCodeLike(reqBo.getPurchaseOrderCodeLike());
        if (!StringUtils.hasText((String)reqBo.getPayStatus()) && StringUtils.hasText((String)reqBo.getTabId())) {
            fscApplyPayInfoExtendQry.setPayStatusList(this.getTabIdPayStatusList(reqBo.getTabId()));
        }
        if (reqBo.getPurchaseId() != null) {
            fscApplyPayInfoExtendQry.setPurchaseNo(reqBo.getPurchaseId());
        }
        if ("0".equals(reqBo.getIsProfessionalOrgExt())) {
            fscApplyPayInfoExtendQry.setBusiModel(FscConstants.BusiModel.TRADE_MODEL);
            fscApplyPayInfoExtendQry.setPayableTypeList(Arrays.asList(2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12));
            if ("2".equals(reqBo.getPurchaseOrSupplier())) {
                fscApplyPayInfoExtendQry.setReceiptCompany(reqBo.getCompanyId());
            }
        } else if ("1".equals(reqBo.getIsProfessionalOrgExt())) {
            fscApplyPayInfoExtendQry.setPurchaseNo(reqBo.getCompanyId());
            if ("2".equals(reqBo.getPurchaseOrSupplier())) {
                fscApplyPayInfoExtendQry.setPurchaseNo(Optional.ofNullable(reqBo.getPurchaseId()).orElse(null));
                fscApplyPayInfoExtendQry.setSupplierId(reqBo.getOrgId());
            } else if (this.checkPurchaserId(reqBo)) {
                fscApplyPayInfoExtendQry.setPurchaserIdLike(reqBo.getUserId().toString());
            }
        } else if ("2".equals(reqBo.getIsProfessionalOrgExt())) {
            fscApplyPayInfoExtendQry.setBusiModel(FscConstants.BusiModel.MATCH_UP_MODEL);
            fscApplyPayInfoExtendQry.setPayableType(1);
            fscApplyPayInfoExtendQry.setSupplierId(reqBo.getSupId());
        }
        fscApplyPayInfoExtendQry.setOrderBy(" g.PAYNO DESC ");
        fscApplyPayInfoExtendQry.setGroupBy(" g.PAYNO ");
        return fscApplyPayInfoExtendQry;
    }

    private boolean checkPurchaserId(FscApplyPayInfoQryAbilityReqBO reqBo) {
        List roleIds;
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPermission()) && !CollectionUtils.isEmpty(roleIds = reqBo.getPermission().stream().map(AuthorityInfo::getKey).distinct().collect(Collectors.toList()))) {
            if (StrUtil.isBlank((CharSequence)this.FSC_AUTH_PUR_PAYMENT_PURCHASER_ROLES)) {
                return false;
            }
            List purchaserRoles = Arrays.stream(this.FSC_AUTH_PUR_PAYMENT_PURCHASER_ROLES.split("[,\uff0c]")).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
            if (roleIds.stream().anyMatch(purchaserRoles::contains)) {
                if (StrUtil.isBlank((CharSequence)this.FSC_AUTH_PUR_PAYMENT_COMPANY_ROLES)) {
                    return true;
                }
                List companyRoles = Arrays.stream(this.FSC_AUTH_PUR_PAYMENT_COMPANY_ROLES.split("[,\uff0c]")).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
                return roleIds.stream().noneMatch(companyRoles::contains);
            }
        }
        return false;
    }

    private Map<String, String> mapApplyPayInfoCodeValue(String payno) {
        DApplyPayInfoExtMapPO applyPayInfoExtMapQry = new DApplyPayInfoExtMapPO();
        applyPayInfoExtMapQry.setObjId(payno);
        applyPayInfoExtMapQry.setObjType(1);
        List<DApplyPayInfoExtMapPO> payInfoExtMapList = this.applyPayInfoExtMapMapper.getList(applyPayInfoExtMapQry);
        HashMap<String, String> mapCodeValue = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(payInfoExtMapList)) {
            mapCodeValue.putAll(payInfoExtMapList.stream().collect(Collectors.toMap(DApplyPayInfoExtMapPO::getFieldCode, DApplyPayInfoExtMapPO::getFieldValue, (c, n) -> c)));
        }
        return mapCodeValue;
    }

    private List<String> getTabIdPayStatusList(String tabId) {
        List<String> payStatusList;
        try {
            ConfTabStatePO confTabStatePo = this.confTabStateMapper.selectByTabId(Integer.valueOf(tabId));
            payStatusList = Arrays.stream(confTabStatePo.getStatusCode().split("[,\uff0c]")).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u6839\u636etabId\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001\u5f02\u5e38:{}", (Object)e.toString());
            throw new PfscExtBusinessException("18000", "\u6839\u636etabId\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001\u5f02\u5e38");
        }
        return payStatusList;
    }

    private List<BusiTabNumbersQryBO> initTabCountList(FscApplyPayInfoQryAbilityReqBO reqBo, FscApplyPayInfoExtendPO fscApplyPayInfoExtendQry) {
        ArrayList<BusiTabNumbersQryBO> tabCountList = new ArrayList<BusiTabNumbersQryBO>();
        if (!YesNo.YES.getCode().equals(reqBo.getIsExport()) && !CollectionUtils.isEmpty((Collection)reqBo.getTabIdList())) {
            ConfTabStatePO po = new ConfTabStatePO();
            po.setTabIdList(reqBo.getTabIdList());
            po.setObjType(4);
            List<ConfTabStatePO> tabStatePOS = this.confTabStateMapper.getList(po);
            if (!CollectionUtils.isEmpty(tabStatePOS)) {
                List<String> payStatusList = Arrays.stream(tabStatePOS.stream().map(ConfTabStatePO::getStatusCode).collect(Collectors.joining(",")).split("[,\uff0c]")).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
                log.debug("tab\u5bf9\u5e94payStatus\u96c6\u5408:{}", payStatusList);
                if (!CollectionUtils.isEmpty(payStatusList)) {
                    fscApplyPayInfoExtendQry.setPayStatus(null);
                    fscApplyPayInfoExtendQry.setPayStatusList(payStatusList);
                    List<CountTabVO> countTabVOList = this.fscApplyPayInfoMapper.getListPagePayableListTabCount(fscApplyPayInfoExtendQry);
                    for (ConfTabStatePO tabStatePO : tabStatePOS) {
                        BusiTabNumbersQryBO bo = new BusiTabNumbersQryBO();
                        bo.setTabId(tabStatePO.getTabId());
                        bo.setTabName(tabStatePO.getTabName());
                        bo.setTabsCount(Integer.valueOf(0));
                        tabCountList.add(bo);
                        if (CollectionUtils.isEmpty(countTabVOList)) continue;
                        for (CountTabVO countTabVO : countTabVOList) {
                            if (!tabStatePO.getStatusCode().contains(countTabVO.getPayStatus())) continue;
                            if (bo.getTabsCount() != null) {
                                bo.setTabsCount(Integer.valueOf(bo.getTabsCount() + Optional.ofNullable(countTabVO.getCountNum()).orElse(0)));
                                continue;
                            }
                            bo.setTabsCount(Optional.ofNullable(countTabVO.getCountNum()).orElse(0));
                        }
                    }
                }
            }
        }
        return tabCountList;
    }

    private void parameterValidation(FscApplyPayInfoQryAbilityReqBO reqBo) {
        ValUtil.isBlank(reqBo.getIsProfessionalOrgExt()).exception("\u7528\u6237\u673a\u6784\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (YesNo.YES.getCode().equals(reqBo.getIsSelect()) && CollectionUtils.isEmpty((Collection)reqBo.getPayNoList())) {
            throw new PfscExtBusinessException("18000", "\u5bfc\u51fa\u53c2\u6570\u5f02\u5e38");
        }
    }
}

