/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.pfscext.api.ability.FscApplyPayResultUocCallbackAbilityService;
import com.tydic.pfscext.api.ability.bo.FscApplyPayResultUocCallbackAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscApplyPayResultUocCallbackAbilityRspBO;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.utils.FscRu;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscApplyPayResultUocCallbackAbilityService"})
public class FscApplyPayResultUocCallbackAbilityServiceImpl
implements FscApplyPayResultUocCallbackAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscApplyPayResultUocCallbackAbilityServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Resource(name="fscApplyPayResultUocCallbackProvider")
    private ProxyMessageProducer fscApplyPayResultUocCallbackProvider;
    @Value(value="${FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TOPIC:FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TOPIC}")
    private String FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TOPIC;
    @Value(value="${FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TAG:*}")
    private String FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TAG;

    @PostMapping(value={"dealApplyPayResultUocCallback"})
    public FscApplyPayResultUocCallbackAbilityRspBO dealApplyPayResultUocCallback(@RequestBody FscApplyPayResultUocCallbackAbilityReqBO reqBo) {
        FscApplyPayResultUocCallbackAbilityRspBO rspBo = FscRu.success("\u5904\u7406\u5b8c\u6210", FscApplyPayResultUocCallbackAbilityRspBO.class);
        if (CollUtil.isEmpty((Collection)reqBo.getPayableNoList())) {
            return rspBo;
        }
        for (String payableNo : reqBo.getPayableNoList()) {
            if (!StrUtil.isNotBlank((CharSequence)payableNo)) continue;
            PayableDetailPO payableDetailPo = this.payableDetailMapper.getModelById(payableNo);
            if (payableDetailPo != null && payableDetailPo.getBusiModel() != null && payableDetailPo.getPayableStatus() != null) {
                if (PayableStatus.SUCCESS.getCode().equals(payableDetailPo.getPayableStatus())) {
                    try {
                        ProxySendResult sendResult;
                        ProxyMessage message;
                        JSONObject data;
                        if (BusiModel.MATCH_UP_MODEL.getCode().equals(payableDetailPo.getBusiModel().toString())) {
                            payableDetailPo.setPurchaseOrderCode(null);
                            data = new JSONObject();
                            data.put("type", (Object)"SUP");
                            data.put("payableDetailPos", (Object)JSON.toJSONString(Collections.singleton(payableDetailPo)));
                            data.put("payApplyDate", (Object)new Date());
                            message = new ProxyMessage(this.FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TOPIC, this.FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TAG, data.toJSONString());
                            sendResult = this.fscApplyPayResultUocCallbackProvider.send(message);
                            log.info("{}.mq\u53d1\u9001\u7ed3\u679c\uff1a{}", (Object)payableNo, (Object)sendResult);
                            continue;
                        }
                        if (BusiModel.TRADE_MODEL.getCode().equals(payableDetailPo.getBusiModel().toString())) {
                            payableDetailPo.setPurchaseOrderCode(null);
                            data = new JSONObject();
                            data.put("type", (Object)"PRO");
                            data.put("payableDetailPos", (Object)JSON.toJSONString(Collections.singleton(payableDetailPo)));
                            data.put("payApplyDate", (Object)new Date());
                            message = new ProxyMessage(this.FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TOPIC, this.FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TAG, data.toJSONString());
                            sendResult = this.fscApplyPayResultUocCallbackProvider.send(message);
                            log.info("{}.mq\u53d1\u9001\u7ed3\u679c\uff1a{}", (Object)payableNo, (Object)sendResult);
                            continue;
                        }
                        log.error("\u7ed3\u7b97\u6a21\u5f0f\u9519\u8bef\u3002payableNo:{}.bo:{}", (Object)payableNo, (Object)JSON.toJSONString((Object)payableDetailPo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
                    }
                    catch (Exception e) {
                        log.error("\u53d1\u9001MQ\u5931\u8d25\u3002payableNo:{}.error:{}", (Object)payableNo, (Object)e.toString());
                    }
                    continue;
                }
                log.error("\u4e0d\u662f\u4ed8\u6b3e\u5b8c\u6210\u72b6\u6001\u672a\u5904\u7406\u3002payableNo:{}.bo:{}", (Object)payableNo, (Object)JSON.toJSONString((Object)payableDetailPo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
                continue;
            }
            log.error("\u67e5\u8be2\u7ed3\u679c\u7ed3\u7b97\u6a21\u5f0f\u6216\u8005\u4ed8\u6b3e\u72b6\u6001\u4e3a\u7a7a\u3002payableNo:{}.bo:{}", (Object)payableNo, (Object)JSON.toJSONString((Object)payableDetailPo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        }
        return rspBo;
    }
}

