/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.pfscext.api.ability.FscBillOutPersonSaleOrderAbilityService;
import com.tydic.pfscext.api.ability.bo.FscBillOutPersonAutoTaskAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscBillOutPersonAutoTaskAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscBillOutPersonSaleOrderAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscBillOutPersonSaleOrderAbilityRspBO;
import com.tydic.pfscext.api.busi.BusiApplyCreateNotificationService;
import com.tydic.pfscext.api.busi.bo.BusiNotificationReqBO;
import com.tydic.pfscext.api.busi.bo.BusiNotificationRspBO;
import com.tydic.pfscext.api.busi.bo.BusiReconcilitionRspBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoReqBO;
import com.tydic.pfscext.api.busi.vo.InvoiceHeaderVO;
import com.tydic.pfscext.api.busi.vo.InvoiceMailAddrInfoVO;
import com.tydic.pfscext.api.trade.BillApplyInfoService;
import com.tydic.pfscext.api.trade.PurchaseInvoiceApplySponsorService;
import com.tydic.pfscext.api.zm.bo.AddBillApplyInfoReqBO;
import com.tydic.pfscext.api.zm.bo.MakeBillApplyInfoMsgReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.consumer.MakeApplyConsumer;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.umc.api.FscUmcQryEnterpriseAccountListExternalService;
import com.tydic.pfscext.external.umc.bo.FscUmcQryEnterpriseAccountListAbilityReqBO;
import com.tydic.pfscext.external.umc.bo.FscUmcQryEnterpriseAccountListAbilityRspBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.RedisLock;
import com.tydic.umcext.ability.account.bo.UmcEnterpriseAccountAbilityBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscBillOutPersonSaleOrderAbilityService"})
public class FscAutoBillOutPersonSaleOrderAbilityServiceImpl
implements FscBillOutPersonSaleOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscAutoBillOutPersonSaleOrderAbilityServiceImpl.class);
    @Resource
    private RedisLock redisLock;
    @Resource
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Resource
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Resource
    private MakeApplyConsumer makeApplyConsumer;
    @Autowired
    private BillApplyInfoService billApplyInfoService;
    @Autowired
    private PurchaseInvoiceApplySponsorService purchaseInvoiceApplySponsorService;
    @Autowired
    private BusiApplyCreateNotificationService busiApplyCreateNotificationService;
    @Resource
    private FscUmcQryEnterpriseAccountListExternalService fscUmcQryEnterpriseAccountListExternalService;
    @Resource(name="fscMakeBillOutPersonProvider")
    private ProxyMessageProducer fscMakeBillOutPersonProvider;
    @Value(value="${FSC_MAKE_BILL_OUT_PERSON_TOPIC:FSC_MAKE_BILL_OUT_PERSON_TOPIC}")
    private String makeBillOutPersonTopic;
    @Value(value="${FSC_MAKE_BILL_OUT_PERSON_TAG:*}")
    private String makeBillOutPersonTag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"dealTaskOutPersonAutoBill"})
    public FscBillOutPersonAutoTaskAbilityRspBO dealTaskOutPersonAutoBill(@RequestBody FscBillOutPersonAutoTaskAbilityReqBO reqBo) {
        FscBillOutPersonAutoTaskAbilityRspBO rspBo = FscRu.success(FscBillOutPersonAutoTaskAbilityRspBO.class);
        if (reqBo == null) {
            rspBo.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBo;
        }
        if (this.redisLock.getLock("FSC_TASK_OUT_PERSON_AUTO_BILL_LOCK", 3600)) {
            log.error("\u5916\u90e8\u4e2a\u4eba\u9a8c\u6536\u540e\u81ea\u52a8\u5f00\u7968\u670d\u52a1\u5b9a\u65f6\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d" + DateUtil.formatBetween((long)this.redisLock.getExpireTime("FSC_TASK_OUT_PERSON_AUTO_BILL_LOCK")));
            rspBo.setRespDesc("\u5916\u90e8\u4e2a\u4eba\u9a8c\u6536\u540e\u81ea\u52a8\u5f00\u7968\u670d\u52a1\u5b9a\u65f6\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d");
            return rspBo;
        }
        try {
            ArrayList<Long> supplierIds = new ArrayList<Long>();
            ArrayList<Long> inspectionIds = new ArrayList<Long>();
            Integer intervalDay = null;
            Long limitSize = Optional.ofNullable(reqBo.getLimitSize()).orElse(1000L);
            if (!CollectionUtils.isEmpty((Collection)reqBo.getSupplierIdList())) {
                supplierIds.addAll(reqBo.getSupplierIdList().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()));
            }
            if (!CollectionUtils.isEmpty((Collection)reqBo.getInspectionIdList())) {
                inspectionIds.addAll(reqBo.getInspectionIdList().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()));
            }
            boolean isGoOn = true;
            int index = 0;
            Long inspectionIdStart = 0L;
            do {
                List<SaleOrderInfo> saleOrderInfos;
                if (CollectionUtils.isEmpty(saleOrderInfos = this.saleOrderInfoMapper.getListByLimitSize(inspectionIds, supplierIds, inspectionIdStart, intervalDay, limitSize))) {
                    isGoOn = false;
                    continue;
                }
                long startTime = System.currentTimeMillis();
                log.info("\u5916\u90e8\u4e2a\u4eba\u5f00\u7968\u7b2c{}\u7247\u5f00\u59cb\u5904\u7406\uff0c\u5171\u5904\u7406{}\u6761\u6570\u636e", (Object)(++index), (Object)saleOrderInfos.size());
                inspectionIdStart = saleOrderInfos.stream().map(SaleOrderInfo::getInspectionId).filter(Objects::nonNull).max(Comparator.comparing(Long::longValue)).orElse(Long.MAX_VALUE);
                for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                    try {
                        this.dealBillApplyNew(saleOrderInfo);
                    }
                    catch (Exception e) {
                        log.error("\u5916\u90e8\u4e2a\u4eba\u81ea\u52a8\u5f00\u7968\u5f02\u5e38\uff0c\u9a8c\u6536\u5355id\uff1a{}\u3002{}", (Object)saleOrderInfo.getInspectionId(), (Object)e.getMessage());
                    }
                }
                log.info("\u5916\u90e8\u4e2a\u4eba\u5f00\u7968\u7b2c{}\u7247\u5904\u7406\u5b8c\u6210\uff0c\u7528\u65f6:{}", (Object)index, (Object)DateUtil.formatBetween((long)(System.currentTimeMillis() - startTime)));
            } while (isGoOn);
        }
        catch (Exception e) {
            log.error("\u5916\u90e8\u4e2a\u4eba\u81ea\u52a8\u5f00\u7968\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.redisLock.unLock("FSC_TASK_OUT_PERSON_AUTO_BILL_LOCK");
        }
        rspBo.setRespDesc("\u5916\u90e8\u4e2a\u4eba\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
        return rspBo;
    }

    private void dealBillApplyNew(SaleOrderInfo saleOrderInfo) {
        MakeBillApplyInfoMsgReqBO fscMakeBillReqBo = new MakeBillApplyInfoMsgReqBO();
        fscMakeBillReqBo.setGroupWay("1");
        fscMakeBillReqBo.setRemarkWay("0");
        fscMakeBillReqBo.setIsSelectOrder("1");
        fscMakeBillReqBo.setOperUnitNo(saleOrderInfo.getOperUnitNo().toString());
        fscMakeBillReqBo.setCompanyId(saleOrderInfo.getOperUnitNo());
        fscMakeBillReqBo.setVerifyFrom("3");
        fscMakeBillReqBo.setUsername("\u4e2a\u4eba\u4e70\u5bb6\u81ea\u52a8\u5f00\u7968");
        fscMakeBillReqBo.setIsApplyDriveNoti("1");
        fscMakeBillReqBo.setInspectionIdList(Stream.of(saleOrderInfo.getInspectionId().toString()).collect(Collectors.toList()));
        InvoiceHeaderVO invoiceHeaderVo = new InvoiceHeaderVO();
        BeanUtils.copyProperties((Object)saleOrderInfo, (Object)invoiceHeaderVo);
        invoiceHeaderVo.setInvoiceTitle(saleOrderInfo.getInvoceName());
        invoiceHeaderVo.setTaxpayerId(saleOrderInfo.getTaxNo());
        invoiceHeaderVo.setAddress(saleOrderInfo.getAddr());
        invoiceHeaderVo.setAccount(saleOrderInfo.getBankAcctNo());
        invoiceHeaderVo.setBank(saleOrderInfo.getBankName());
        invoiceHeaderVo.setInvoiceId((String)Optional.ofNullable(saleOrderInfo.getInvoiceId()).map(String::valueOf).orElse(null));
        invoiceHeaderVo.setPhone(saleOrderInfo.getPhone());
        fscMakeBillReqBo.setInvoiceInfo(invoiceHeaderVo);
        InvoiceMailAddrInfoVO invoiceMailAddrInfoVo = new InvoiceMailAddrInfoVO();
        BeanUtils.copyProperties((Object)saleOrderInfo, (Object)invoiceMailAddrInfoVo);
        fscMakeBillReqBo.setMailAddrInfo(invoiceMailAddrInfoVo);
        fscMakeBillReqBo.setAutoInvoiceFlag("1");
        this.makeApplyConsumer.makeApply(fscMakeBillReqBo);
    }

    private void dealBillApply(Map<Long, String> mapAccount, SaleOrderInfo saleOrderInfo) {
        boolean isApply;
        String purchaseProjectName = this.getPurchaseProjectName(saleOrderInfo.getPurchaseProjectId(), mapAccount);
        if (StrUtil.isBlank((CharSequence)saleOrderInfo.getSource())) {
            log.error("\u5916\u90e8\u4e2a\u4eba\u81ea\u52a8\u5f00\u7968\u5f02\u5e38\uff1a\u8ba2\u5355\u6765\u6e90\u4e3a\u7a7a");
            isApply = false;
        } else {
            isApply = "2".equals(saleOrderInfo.getSource()) ? this.applyCreateNotification(saleOrderInfo, purchaseProjectName) : this.invoiceApplySponsor(saleOrderInfo);
        }
        if (isApply) {
            PfscExtRspBaseBO pfscExtRspBaseBO = this.addBillApplyInfo(saleOrderInfo, purchaseProjectName);
        } else {
            log.error("\u5916\u90e8\u4e2a\u4eba\u81ea\u52a8\u5f00\u7968\u5f02\u5e38\uff1a\u4e0a\u6e38\u5f00\u7968\u5f02\u5e38,\u672a\u6267\u884c\u4e0b\u6e38\u5f00\u7968");
        }
    }

    private PfscExtRspBaseBO addBillApplyInfo(SaleOrderInfo saleOrderInfo, String purchaseProjectName) {
        AddBillApplyInfoReqBO addBillApplyInfoReqBo = new AddBillApplyInfoReqBO();
        BeanUtils.copyProperties((Object)saleOrderInfo, (Object)addBillApplyInfoReqBo);
        addBillApplyInfoReqBo.setSource(Integer.valueOf(Integer.parseInt(saleOrderInfo.getSource())));
        InvoiceHeaderVO invoiceHeaderVO = new InvoiceHeaderVO();
        BeanUtils.copyProperties((Object)saleOrderInfo, (Object)invoiceHeaderVO);
        invoiceHeaderVO.setInvoiceTitle(saleOrderInfo.getInvoceName());
        invoiceHeaderVO.setTaxpayerId(saleOrderInfo.getTaxNo());
        invoiceHeaderVO.setAddress(saleOrderInfo.getAddr());
        invoiceHeaderVO.setBank(saleOrderInfo.getBankName());
        invoiceHeaderVO.setAccount(saleOrderInfo.getBankAcctNo());
        invoiceHeaderVO.setPhone(saleOrderInfo.getPhone());
        invoiceHeaderVO.setInvoiceId((String)Optional.ofNullable(saleOrderInfo.getInvoiceId()).map(String::valueOf).orElse(null));
        addBillApplyInfoReqBo.setInvoiceInfo(invoiceHeaderVO);
        InvoiceMailAddrInfoVO invoiceMailAddrInfoVO = new InvoiceMailAddrInfoVO();
        BeanUtils.copyProperties((Object)saleOrderInfo, (Object)invoiceMailAddrInfoVO);
        addBillApplyInfoReqBo.setMailAddrInfo(invoiceMailAddrInfoVO);
        QueryPayPurchaseOrderInfoReqBO item = new QueryPayPurchaseOrderInfoReqBO();
        item.setInspectionId(saleOrderInfo.getInspectionId());
        item.setOrderId(saleOrderInfo.getOrderId());
        item.setPurchaseOrderCode(saleOrderInfo.getSaleOrderCode());
        addBillApplyInfoReqBo.setQueryPayPurchaseOrderInfoReqBOs(Stream.of(item).collect(Collectors.toList()));
        addBillApplyInfoReqBo.setAmt(saleOrderInfo.getOrderAmt());
        addBillApplyInfoReqBo.setStrPurchaseProjectId(purchaseProjectName);
        return this.billApplyInfoService.addBillApplyInfo(addBillApplyInfoReqBo);
    }

    private boolean invoiceApplySponsor(SaleOrderInfo saleOrderInfo) {
        QueryPayPurchaseOrderInfoReqBO item = new QueryPayPurchaseOrderInfoReqBO();
        item.setInspectionId(saleOrderInfo.getInspectionId());
        item.setOrderId(saleOrderInfo.getOrderId());
        item.setPurchaseOrderCode(saleOrderInfo.getSaleOrderCode());
        QueryPayPurchaseOrderInfoReqBO queryPayPurchaseOrderInfoReqBO = new QueryPayPurchaseOrderInfoReqBO();
        queryPayPurchaseOrderInfoReqBO.setSupplierNo(saleOrderInfo.getSupplierNo());
        queryPayPurchaseOrderInfoReqBO.setSupplierName(saleOrderInfo.getSupplierName());
        queryPayPurchaseOrderInfoReqBO.setQueryPayPurchaseOrderInfoReqBOs(Stream.of(item).collect(Collectors.toList()));
        queryPayPurchaseOrderInfoReqBO.setOperUnitNo(saleOrderInfo.getOperUnitNo());
        queryPayPurchaseOrderInfoReqBO.setCompanyId(saleOrderInfo.getOperUnitNo());
        queryPayPurchaseOrderInfoReqBO.setSource(Long.valueOf(saleOrderInfo.getSource()));
        queryPayPurchaseOrderInfoReqBO.setIsProfessionalOrgExt("0");
        BusiReconcilitionRspBO busiReconcilitionRspBO = this.purchaseInvoiceApplySponsorService.invoiceApplySponsor(queryPayPurchaseOrderInfoReqBO);
        return FscRu.isSuccess(busiReconcilitionRspBO.getRespCode());
    }

    private boolean applyCreateNotification(SaleOrderInfo saleOrderInfo, String purchaseProjectName) {
        if (StrUtil.isNotBlank((CharSequence)saleOrderInfo.getUpOrderStatus()) && !OrderStatus.NO_APPLY.getCode().equals(saleOrderInfo.getUpOrderStatus())) {
            log.info("\u9a8c\u6536\u5355\u4e0a\u6e38\u5f00\u7968\u72b6\u6001[{}]\u4e0d\u662f\u672a\u63d0\u4ea4\uff0c\u76f4\u63a5\u4e0b\u6e38\u5f00\u7968\u3002{}", (Object)saleOrderInfo.getUpOrderStatus(), (Object)saleOrderInfo.getInspectionId());
            return true;
        }
        BusiNotificationReqBO busiNotificationReqBo = new BusiNotificationReqBO();
        busiNotificationReqBo.setOrderCodes(Stream.of(saleOrderInfo.getSaleOrderCode()).collect(Collectors.toList()));
        busiNotificationReqBo.setOperUnitNo(saleOrderInfo.getOperUnitNo());
        busiNotificationReqBo.setSupplierNo(saleOrderInfo.getSupplierNo());
        busiNotificationReqBo.setSupplierName(saleOrderInfo.getSupplierName());
        busiNotificationReqBo.setSource(saleOrderInfo.getSource());
        busiNotificationReqBo.setPurchaseNo(saleOrderInfo.getPurchaseNo());
        busiNotificationReqBo.setPurchaseName(saleOrderInfo.getPurchaseName());
        busiNotificationReqBo.setPurchaseProjectId(saleOrderInfo.getPurchaseProjectId());
        busiNotificationReqBo.setPurchaseProjectName(purchaseProjectName);
        busiNotificationReqBo.setInvoiceRemark(saleOrderInfo.getSaleOrderCode());
        busiNotificationReqBo.setUserId(null);
        busiNotificationReqBo.setName("\u5b9a\u65f6\u4efb\u52a1");
        BusiNotificationRspBO busiNotificationRspBo = this.busiApplyCreateNotificationService.applyCreateNotification(busiNotificationReqBo);
        return FscRu.isSuccess(busiNotificationRspBo.getRespCode());
    }

    private String getPurchaseProjectName(Long purchaseProjectId, Map<Long, String> mapAccount) {
        if (purchaseProjectId == null) {
            return "";
        }
        if (mapAccount.containsKey(purchaseProjectId)) {
            return mapAccount.get(purchaseProjectId);
        }
        FscUmcQryEnterpriseAccountListAbilityReqBO umcReqBo = new FscUmcQryEnterpriseAccountListAbilityReqBO();
        umcReqBo.setInAccountIds(Stream.of(purchaseProjectId).collect(Collectors.toList()));
        FscUmcQryEnterpriseAccountListAbilityRspBO umcRspBo = this.fscUmcQryEnterpriseAccountListExternalService.qryEnterpriseAccountAll(umcReqBo);
        if (umcRspBo != null && !CollectionUtils.isEmpty((Collection)umcRspBo.getRows())) {
            String accountName = ((UmcEnterpriseAccountAbilityBO)umcRspBo.getRows().get(0)).getAccountName();
            mapAccount.put(purchaseProjectId, accountName);
            return accountName;
        }
        return "";
    }

    @PostMapping(value={"dealOutPersonBillInspection"})
    public FscBillOutPersonSaleOrderAbilityRspBO dealOutPersonBillInspection(@RequestBody FscBillOutPersonSaleOrderAbilityReqBO reqBo) {
        FscBillOutPersonSaleOrderAbilityRspBO rspBo = FscRu.success(FscBillOutPersonSaleOrderAbilityRspBO.class);
        if (reqBo.getInspectionId() == null || reqBo.getOrderId() == null) {
            rspBo.setRespDesc("\u5165\u53c2\u9a8c\u6536\u5355ID\u6216\u8ba2\u5355ID\u4e3a\u7a7a\uff0c\u4e0d\u5904\u7406");
            return rspBo;
        }
        try {
            String content = JSON.toJSONString((Object)reqBo);
            ProxyMessage message = new ProxyMessage(this.makeBillOutPersonTopic, this.makeBillOutPersonTag, content);
            ProxySendResult sendResult = this.fscMakeBillOutPersonProvider.send(message);
            if (!"SEND_OK".equals(sendResult.getStatus())) {
                throw new PfscExtBusinessException("18000", "\u5f02\u6b65\u5904\u7406\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff0cMQ\u53d1\u9001\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001MQ\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            throw new PfscExtBusinessException("18000", "\u5f02\u6b65\u5904\u7406\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff0cMQ\u53d1\u9001\u5931\u8d25");
        }
        return rspBo;
    }

    @PostMapping(value={"dealOutPersonBillInspectionConsumer"})
    public FscBillOutPersonSaleOrderAbilityRspBO dealOutPersonBillInspectionConsumer(@RequestBody FscBillOutPersonSaleOrderAbilityReqBO reqBo) {
        Long inspectionId = reqBo.getInspectionId();
        if (inspectionId == null || inspectionId == 0L) {
            throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355ID\u4e3a\u7a7a");
        }
        FscBillOutPersonAutoTaskAbilityReqBO fscReqBo = new FscBillOutPersonAutoTaskAbilityReqBO();
        fscReqBo.setInspectionIdList(Stream.of(reqBo.getInspectionId()).collect(Collectors.toList()));
        FscBillOutPersonAutoTaskAbilityRspBO fscRspBo = this.dealTaskOutPersonAutoBill(fscReqBo);
        return FscRu.js(fscRspBo, FscBillOutPersonSaleOrderAbilityRspBO.class);
    }
}

