/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.pfscext.api.ability.FscCreditCompanyExcelAbilityService;
import com.tydic.pfscext.api.ability.FscCreditCompanyQryAbilityService;
import com.tydic.pfscext.api.ability.bo.FscCreditCompanyQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscCreditCompanyQryAbilityRspBO;
import com.tydic.pfscext.utils.DateUtil;
import com.tydic.pfscext.utils.FileUtil;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.excel.bo.FscCreditCompanyExcelInfoBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscCreditCompanyExcelAbilityService"})
public class FscCreditCompanyExcelAbilityServiceImpl
implements FscCreditCompanyExcelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscCreditCompanyExcelAbilityServiceImpl.class);
    @Autowired
    private FscCreditCompanyQryAbilityService fscCreditCompanyQryAbilityService;
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers}")
    private String fastdfsTrackerServers;
    @Value(value="${export.file.public.url}")
    private String exportFilePublicUrl;

    @PostMapping(value={"listPageCreditCompanyExcel"})
    public FscCreditCompanyQryAbilityRspBO listPageCreditCompanyExcel(@RequestBody FscCreditCompanyQryAbilityReqBO reqBo) {
        String excelFile = this.exportExcel(reqBo);
        String obsFile = this.uploadOss(excelFile);
        FscCreditCompanyQryAbilityRspBO rspBo = new FscCreditCompanyQryAbilityRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc(obsFile);
        return rspBo;
    }

    private String exportExcel(FscCreditCompanyQryAbilityReqBO reqBo) {
        int pageSize = 1000;
        String fileName = FileUtil.getPath() + "\u5bfc\u51fa\u6388\u4fe1\u989d\u5ea6" + System.currentTimeMillis() + ".xlsx";
        FscCreditCompanyQryAbilityReqBO abilityReqBo = FscRu.js(reqBo, FscCreditCompanyQryAbilityReqBO.class);
        abilityReqBo.setPageNo(Integer.valueOf(1));
        abilityReqBo.setPageSize(Integer.valueOf(pageSize));
        FscCreditCompanyQryAbilityRspBO abilityRspBO = this.fscCreditCompanyQryAbilityService.listPageCreditCompany(abilityReqBo);
        if (!CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
            try (ExcelWriter excelWriter = EasyExcel.write((String)fileName, FscCreditCompanyExcelInfoBO.class).build();){
                WriteSheet writeSheet = EasyExcel.writerSheet((String)"\u6388\u4fe1\u989d\u5ea6\u5bfc\u51fa").build();
                List<FscCreditCompanyExcelInfoBO> rows = FscRu.jsl(abilityRspBO.getRows(), FscCreditCompanyExcelInfoBO.class);
                excelWriter.write(rows, writeSheet);
                if (abilityRspBO.getTotal() != null && abilityRspBO.getTotal() > 1) {
                    for (int pageNo = 2; pageNo <= abilityRspBO.getTotal(); ++pageNo) {
                        abilityReqBo.setPageNo(Integer.valueOf(pageNo));
                        abilityReqBo.setPageSize(Integer.valueOf(pageSize));
                        FscCreditCompanyQryAbilityRspBO suibAbilityRspBO = this.fscCreditCompanyQryAbilityService.listPageCreditCompany(abilityReqBo);
                        if (CollectionUtils.isEmpty((Collection)suibAbilityRspBO.getRows())) continue;
                        List<FscCreditCompanyExcelInfoBO> subRows = FscRu.jsl(suibAbilityRspBO.getRows(), FscCreditCompanyExcelInfoBO.class);
                        excelWriter.write(subRows, writeSheet);
                    }
                }
            }
            return fileName;
        }
        return null;
    }

    private String uploadOss(String excelFileName) {
        log.error("\u5bfc\u51fa\u6587\u4ef6\u672c\u5730\u7f13\u7f13\u5b58\uff1a{}", (Object)excelFileName);
        String fullFilePath = "";
        if (StringUtils.hasText((String)excelFileName)) {
            Object out = null;
            Object in = null;
            Object fileInputStream = null;
            String uploadPath = "fsc";
            String name = "\u624b\u52a8\u5f00\u7968\u6a21\u677f\u5bfc\u51fa" + DateUtil.dateToStr(new Date(), "yyyyMMddHHmmss");
            String fileName = name + ".xlsx";
            String result = "";
            try {
                File file = new File(excelFileName);
                result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)new FileInputStream(file));
                log.debug("\u6210\u529f\u5bfc\u51faExcel\uff0c\u6587\u4ef6\u5730\u5740\uff1a" + result);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u5bfc\u51faExcel\u6570\u636e\u5931\u8d25,", (Throwable)e);
            }
            if ("OSS".equals(this.fileType)) {
                fullFilePath = result;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)result);
                fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            }
        }
        return fullFilePath;
    }
}

