/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.order.extend.bo.saleorder.PebExtGrantCreditUsedQueryReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtGrantCreditUsedQueryRspBO;
import com.tydic.order.extend.bo.saleorder.PebExtOrderOverdueDetailQueryReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtOrderOverdueDetailQueryRspBO;
import com.tydic.order.extend.bo.saleorder.PebExtOrderOverdueRecordQueryReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtOrderOverdueRecordQueryRspBO;
import com.tydic.pfscext.api.ability.FscCreditCompanyQryAbilityService;
import com.tydic.pfscext.api.ability.bo.FscCreditCompanyInfoBO;
import com.tydic.pfscext.api.ability.bo.FscCreditCompanyQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscCreditCompanyQryAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscPayConfigChannelBO;
import com.tydic.pfscext.base.AuthorityInfo;
import com.tydic.pfscext.dao.FscCreditControlLogMapper;
import com.tydic.pfscext.dao.FscCreditMenuConfigMapper;
import com.tydic.pfscext.dao.FscPayConfigChannelMapper;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscCreditControlLogPO;
import com.tydic.pfscext.dao.po.FscCreditMenuConfigPO;
import com.tydic.pfscext.dao.po.FscPayConfigChannelPO;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.FscPayConfigPayNodeRule;
import com.tydic.pfscext.enums.FscPayConfigPayType;
import com.tydic.pfscext.enums.FscPayConfigSubClass;
import com.tydic.pfscext.enums.FscPayConfigSubType;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.FscPayCreditControlTag;
import com.tydic.pfscext.enums.FscPayCreditWarningTag;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.external.uoc.api.FscPebExtGrantCreditUsedQueryExternalService;
import com.tydic.pfscext.external.uoc.api.FscPebExtOrderOverdueDetailQueryExternalService;
import com.tydic.pfscext.external.uoc.api.FscPebExtOrderOverdueRecordQueryExternalService;
import com.tydic.pfscext.utils.FscRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscCreditCompanyQryAbilityService"})
public class FscCreditCompanyQryAbilityServiceImpl
implements FscCreditCompanyQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscCreditCompanyQryAbilityServiceImpl.class);
    @Resource
    private FscPayConfigMapper fscPayConfigMapper;
    @Resource
    private FscCreditMenuConfigMapper fscCreditMenuConfigMapper;
    @Resource
    private FscPayConfigChannelMapper fscPayConfigChannelMapper;
    @Resource
    private FscCreditControlLogMapper fscCreditControlLogMapper;
    @Resource
    private FscPebExtGrantCreditUsedQueryExternalService pebExtGrantCreditUsedQueryExternalService;
    @Resource
    private FscPebExtOrderOverdueRecordQueryExternalService fscPebExtOrderOverdueRecordQueryExternalService;
    @Resource
    private FscPebExtOrderOverdueDetailQueryExternalService fscPebExtOrderOverdueDetailQueryExternalService;
    @Value(value="${FSC_AUTH_SYSTEM_MANAGE:auth:system:manage}")
    private String FSC_AUTH_SYSTEM_MANAGE;
    @Value(value="${FSC_AUTH_PRO_CREDIT_MANAGE:overall:yunyingshouxinguanlizhuanyuan}")
    private String FSC_AUTH_PRO_CREDIT_MANAGE;
    @Value(value="${FSC_AUTH_SECONDARY_COMPANY_MANAGE:overall:erjidanweiguanliyuan}")
    private String FSC_AUTH_SECONDARY_COMPANY_MANAGE;
    @Value(value="${FSC_AUTH_PUR_COMPANY_MANAGE:001}")
    private String FSC_AUTH_PUR_COMPANY_MANAGE;
    @Value(value="${FSC_AUTH_PUR_COMPANY_BUYER:002}")
    private String FSC_AUTH_PUR_COMPANY_BUYER;
    @Value(value="${FSC_AUTH_SUP_MANAGE:201}")
    private String FSC_AUTH_SUP_MANAGE;
    @Value(value="${FSC_AUTH_SUP_MANAGE:890}")
    private String FSC_AUTH_ESTORE_SUP_MANAGE;
    @Value(value="${FSC_AUTH_PURCHASING_MANAGER:004}")
    private String FSC_AUTH_PURCHASING_MANAGER;
    @Value(value="${FSC_AUTH_DEPARTMENT_PURCHASING_MANAGER:003}")
    private String FSC_AUTH_DEPARTMENT_PURCHASING_MANAGER;
    @Value(value="${FSC_AUTH_PUR_WELFARE_MANAGER:119}")
    private String FSC_AUTH_PUR_WELFARE_MANAGER;
    @Value(value="${FSC_AUTH_PRO_WELFARE_MANAGER:020}")
    private String FSC_AUTH_PRO_WELFARE_MANAGER;
    @Value(value="${FSC_CREDIT_COMPANY_ONLY_SHOW_QY:0}")
    private String FSC_CREDIT_COMPANY_ONLY_SHOW_QY;
    @Value(value="${FSC_CREDIT_NONE_DATA_SHIELD_BUTTON:1}")
    private String FSC_CREDIT_NONE_DATA_SHIELD_BUTTON;

    @PostMapping(value={"listPageCreditCompany"})
    public FscCreditCompanyQryAbilityRspBO listPageCreditCompany(@RequestBody FscCreditCompanyQryAbilityReqBO reqBo) {
        String regexp;
        FscCreditCompanyQryAbilityRspBO rspBo = FscRu.success(FscCreditCompanyQryAbilityRspBO.class);
        rspBo.setPageNo(Integer.valueOf(1));
        rspBo.setRecordsTotal(Integer.valueOf(0));
        rspBo.setTotal(Integer.valueOf(0));
        rspBo.setRows(new ArrayList());
        if (CollectionUtils.isEmpty((Collection)reqBo.getPermission())) {
            rspBo.setRespDesc("\u89d2\u8272\u96c6\u5408\u4e3a\u7a7a");
            return rspBo;
        }
        List<String> roleList = reqBo.getPermission().stream().map(AuthorityInfo::getKey).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(roleList)) {
            rspBo.setRespDesc("\u89d2\u8272\u96c6\u5408key\u4e3a\u7a7a");
            return rspBo;
        }
        String exportFlag = reqBo.getExportFlag();
        FscCreditMenuConfigPO fscCreditMenuConfigQry = new FscCreditMenuConfigPO();
        fscCreditMenuConfigQry.setMenuName("FSC_CREDIT_CONTROL_TAB");
        fscCreditMenuConfigQry.setAuthRoleList(roleList);
        fscCreditMenuConfigQry.setCenter("FSC");
        fscCreditMenuConfigQry.setTabId("7001");
        fscCreditMenuConfigQry.setOrderBy(" AUTH_TYPE ASC");
        List<FscCreditMenuConfigPO> fscCreditMenuList = this.fscCreditMenuConfigMapper.getList(fscCreditMenuConfigQry);
        if (CollectionUtils.isEmpty(fscCreditMenuList)) {
            rspBo.setRespDesc("\u67e5\u8be2\u89d2\u8272\u6743\u9650\u914d\u7f6e\u4e3a\u7a7a");
            return rspBo;
        }
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        fscPayConfigQry.setPayConfigIdList(reqBo.getPayConfigIdList());
        fscPayConfigQry.setPayBusiType(reqBo.getPayBusiType());
        fscPayConfigQry.setPayBusiTypeList(reqBo.getPayBusiTypeList());
        fscPayConfigQry.setPaySubClass(reqBo.getPaySubClass());
        fscPayConfigQry.setPaySubType(reqBo.getPaySubType());
        fscPayConfigQry.setPayConfigTypeList(Arrays.asList(FscPayConfigType.DEF.getCode(), FscPayConfigType.EXT_ORG.getCode()));
        fscPayConfigQry.setPayType(reqBo.getPayType());
        fscPayConfigQry.setCreditAmountStart(reqBo.getCreditAmountStart());
        fscPayConfigQry.setCreditAmountEnd(reqBo.getCreditAmountEnd());
        fscPayConfigQry.setUsedAmountStart(reqBo.getUsedAmountStart());
        fscPayConfigQry.setUsedAmountEnd(reqBo.getUsedAmountEnd());
        fscPayConfigQry.setOverdueControlRatioStart(reqBo.getOverdueControlRatioStart());
        fscPayConfigQry.setOverdueControlRatioEnd(reqBo.getOverdueControlRatioEnd());
        fscPayConfigQry.setCurrentOverdueRatioStart(reqBo.getCurrentOverdueRatioStart());
        fscPayConfigQry.setCurrentOverdueRatioEnd(reqBo.getCurrentOverdueRatioEnd());
        fscPayConfigQry.setOverdueControlIndexStart(reqBo.getOverdueControlIndexStart());
        fscPayConfigQry.setOverdueControlIndexEnd(reqBo.getOverdueControlIndexEnd());
        fscPayConfigQry.setCurrentOverdueIndexStart(reqBo.getCurrentOverdueIndexStart());
        fscPayConfigQry.setCurrentOverdueIndexEnd(reqBo.getCurrentOverdueIndexEnd());
        fscPayConfigQry.setCurrentOrgControlTagLike(reqBo.getCurrentOrgControlTag());
        fscPayConfigQry.setSecondaryCompanyTreePath(reqBo.getSecondaryCompanyTreePath());
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCurrentOrgControlTagList()) && StringUtils.hasText((String)(regexp = reqBo.getCurrentOrgControlTagList().stream().filter(StringUtils::hasText).collect(Collectors.joining("|"))))) {
            fscPayConfigQry.setControlTagListRegexp(regexp);
        }
        if ("10".equals(reqBo.getCurrentOrgControlStatus())) {
            fscPayConfigQry.setPayBusiType(FscPayConfigBusiType.FL.getCode());
            fscPayConfigQry.setCurrentOrgControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
        } else if ("11".equals(reqBo.getCurrentOrgControlStatus())) {
            fscPayConfigQry.setPayBusiType(FscPayConfigBusiType.FL.getCode());
            fscPayConfigQry.setCurrentOrgControlStatus(FscPayConfigControlStatus.WARNING.getCode());
        } else if ("12".equals(reqBo.getCurrentOrgControlStatus())) {
            fscPayConfigQry.setPayBusiType(FscPayConfigBusiType.FL.getCode());
            fscPayConfigQry.setCurrentOrgControlStatus(FscPayConfigControlStatus.RESTRICTED.getCode());
        } else if ("00".equals(reqBo.getCurrentOrgControlStatus())) {
            fscPayConfigQry.setPayBusiTypeNotEqual(FscPayConfigBusiType.FL.getCode());
            fscPayConfigQry.setCurrentOrgControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
        } else if ("01".equals(reqBo.getCurrentOrgControlStatus())) {
            fscPayConfigQry.setPayBusiTypeNotEqual(FscPayConfigBusiType.FL.getCode());
            fscPayConfigQry.setCurrentOrgControlStatus(FscPayConfigControlStatus.WARNING.getCode());
        } else if ("02".equals(reqBo.getCurrentOrgControlStatus())) {
            fscPayConfigQry.setPayBusiTypeNotEqual(FscPayConfigBusiType.FL.getCode());
            fscPayConfigQry.setCurrentOrgControlStatus(FscPayConfigControlStatus.RESTRICTED.getCode());
        }
        fscPayConfigQry.setPayOrgIdList(reqBo.getPayOrgIdList());
        fscPayConfigQry.setPayOrgNameLike(reqBo.getPayOrgName());
        fscPayConfigQry.setOrderBy(" PAY_BUSI_TYPE ASC ");
        String authType = fscCreditMenuList.get(0).getAuthType();
        if (log.isDebugEnabled()) {
            log.debug("\u6743\u9650\uff1a{}", (Object)authType);
        }
        if ("0".equals(authType)) {
            if (log.isDebugEnabled()) {
                log.debug("\u67e5\u8be2\u5168\u91cf" + authType);
            }
        } else if ("1".equals(authType)) {
            String orgPath = reqBo.getOrgPath();
            Long companyId = reqBo.getCompanyId();
            String orgType = "03";
            if (StrUtil.equals((CharSequence)orgType, (CharSequence)reqBo.getOrgTypeIn()) && StringUtils.hasText((String)orgPath) && companyId != null) {
                orgPath = StrUtil.subBefore((CharSequence)orgPath, (CharSequence)(companyId + ""), (boolean)true) + companyId;
            }
            if (log.isDebugEnabled()) {
                log.debug("orgPath old:{}.new:{}", (Object)reqBo.getOrgPath(), (Object)orgPath);
            }
            fscPayConfigQry.setPayOrgPathLike(orgPath);
        } else if ("2".equals(authType)) {
            fscPayConfigQry.setPayOrgPathLike(reqBo.getOrgPath());
        } else if ("3".equals(authType)) {
            fscPayConfigQry.setPayOrgId(reqBo.getCompanyId());
        } else if ("4".equals(authType)) {
            fscPayConfigQry.setPayUserId(reqBo.getUserId());
        }
        if (YesNo.YES.getCode().equals(this.FSC_CREDIT_COMPANY_ONLY_SHOW_QY)) {
            fscPayConfigQry.setPaySubType(FscPayConfigSubType.QY.getCode());
        }
        List<FscPayConfigPO> listPage = this.fscPayConfigMapper.getListPage(fscPayConfigQry, (Page<FscPayConfigPO>)page);
        FscPayConfigPO creditCompanyAmountSum = this.fscPayConfigMapper.getCreditCompanyAmountSum(fscPayConfigQry);
        rspBo.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        if (!CollectionUtils.isEmpty(listPage)) {
            Map<Long, List<FscPayConfigChannelBO>> mapPayConfigChannel = this.mapPayConfigChannel(listPage);
            rspBo.getRows().addAll(listPage.stream().map(i -> {
                List payConfigChannels;
                FscPayConfigPO target = new FscPayConfigPO();
                this.initFscPayConfigPo((FscPayConfigPO)i, target);
                FscCreditCompanyInfoBO infoBo = FscRu.js(target, FscCreditCompanyInfoBO.class);
                if (FscPayConfigType.EXT_ORG.getCode().equals(i.getPayConfigType())) {
                    payConfigChannels = (List)mapPayConfigChannel.get(i.getPayConfigId());
                    infoBo.setPayConfigChannels(payConfigChannels);
                    if (!CollectionUtils.isEmpty((Collection)payConfigChannels)) {
                        infoBo.setPayChannelsStr(payConfigChannels.stream().map(FscPayConfigChannelBO::getRemark).collect(Collectors.joining(",")));
                    }
                }
                if (FscPayConfigType.DEF.getCode().equals(i.getPayConfigType())) {
                    payConfigChannels = (List)mapPayConfigChannel.get(i.getParentConfigId());
                    infoBo.setPayConfigChannels(payConfigChannels);
                    if (!CollectionUtils.isEmpty((Collection)payConfigChannels)) {
                        infoBo.setPayChannelsStr(payConfigChannels.stream().map(FscPayConfigChannelBO::getRemark).collect(Collectors.joining(",")));
                    }
                }
                this.initStrAndOpeItem(infoBo, roleList, exportFlag);
                return infoBo;
            }).collect(Collectors.toList()));
        }
        if (creditCompanyAmountSum != null) {
            rspBo.setCreditAmountAll(creditCompanyAmountSum.getCreditAmount());
            rspBo.setUsedAmountAll(creditCompanyAmountSum.getUsedAmount());
            rspBo.setBalanceAmountAll(creditCompanyAmountSum.getBalanceAmount());
            rspBo.setCurrentOverdueAmountAll(creditCompanyAmountSum.getCurrentOverdueAmount());
            rspBo.setCurrentPenaltyAmountAll(creditCompanyAmountSum.getCurrentPenaltyAmount());
        }
        return rspBo;
    }

    private void initStrAndOpeItem(FscCreditCompanyInfoBO infoBo, List<String> roleList, String exportFlag) {
        StringJoiner joiner;
        infoBo.setPayBusiTypeStr(FscPayConfigBusiType.desc((String)infoBo.getPayBusiType()));
        infoBo.setPaySubClassStr(FscPayConfigSubClass.desc((String)infoBo.getPaySubClass()));
        infoBo.setPaySubTypeStr(FscPayConfigSubType.desc((String)infoBo.getPaySubType()));
        infoBo.setPayConfigModeStr(Optional.ofNullable(infoBo.getPayConfigMode()).map(i -> "\u7edf\u4e00\u914d\u7f6e").orElse(""));
        infoBo.setPayTypeStr(FscPayConfigPayType.desc((String)infoBo.getPayType()));
        infoBo.setPayAllowExceptionFlagStr(YesOrNo.desc((Integer)infoBo.getPayAllowExceptionFlag()));
        infoBo.setPayNodeRuleStr(FscPayConfigPayNodeRule.desc((Integer)infoBo.getPayNodeRule()));
        String prefix = "\u5355\u4f4d\u4e0b\u5355\u6743\u9650";
        if (FscPayConfigBusiType.FL.getCode().equals(infoBo.getPayBusiType())) {
            prefix = "\u6d3b\u52a8\u521b\u5efa\u6743\u9650";
        }
        infoBo.setCurrentOrgControlStatusStr(prefix + FscPayConfigControlStatus.desc((String)infoBo.getCurrentOrgControlStatus()));
        if (FscPayConfigSubType.GR.getCode().equals(infoBo.getPaySubType())) {
            StringJoiner joiner2 = new StringJoiner("-");
            joiner2.add(infoBo.getPayOrgName()).add(infoBo.getPayUserName());
            infoBo.setPayOrgName(joiner2.toString());
        }
        StringJoiner joinerTagAll = new StringJoiner(",");
        if (StringUtils.hasText((String)infoBo.getCurrentOrgControlTag())) {
            List currentOrgControlTag = JSON.parseArray((String)infoBo.getCurrentOrgControlTag(), String.class);
            joiner = new StringJoiner(",");
            for (String tag : currentOrgControlTag) {
                joiner.add(FscPayCreditControlTag.desc((String)tag));
                joinerTagAll.add(FscPayCreditControlTag.desc((String)tag));
            }
            infoBo.setCurrentOrgControlTagStr(joiner.toString());
        }
        if (StringUtils.hasText((String)infoBo.getCurrentOrgWarningTag())) {
            List currentOrgWarningTag = JSON.parseArray((String)infoBo.getCurrentOrgWarningTag(), String.class);
            joiner = new StringJoiner(",");
            for (String tag : currentOrgWarningTag) {
                joiner.add(FscPayCreditWarningTag.desc((String)tag));
                joinerTagAll.add(FscPayCreditWarningTag.desc((String)tag));
            }
            infoBo.setCurrentOrgWarningTagStr(joiner.toString());
        }
        infoBo.setCurrentOrgTagStr(joinerTagAll.toString());
        if (roleList.contains(this.FSC_AUTH_SYSTEM_MANAGE) || roleList.contains(this.FSC_AUTH_PRO_CREDIT_MANAGE)) {
            infoBo.setOpeCreditUseDetail(YesNo.YES.getCode());
            infoBo.setOpeCreditChangeRecord(YesNo.YES.getCode());
            infoBo.setOpeCreditUseRecord(YesNo.YES.getCode());
            infoBo.setOpePayConfig(YesNo.YES.getCode());
            infoBo.setOpeOrderOverdueDetail(YesNo.YES.getCode());
            infoBo.setOpeOrderOverdueRecord(YesNo.YES.getCode());
        } else if (roleList.contains(this.FSC_AUTH_PUR_COMPANY_MANAGE) || roleList.contains(this.FSC_AUTH_SECONDARY_COMPANY_MANAGE)) {
            infoBo.setOpeCreditUseDetail(YesNo.YES.getCode());
            infoBo.setOpeCreditChangeRecord(YesNo.YES.getCode());
            infoBo.setOpeCreditUseRecord(YesNo.YES.getCode());
            infoBo.setOpePayConfig(YesNo.NO.getCode());
            infoBo.setOpeOrderOverdueDetail(YesNo.NO.getCode());
            infoBo.setOpeOrderOverdueRecord(YesNo.NO.getCode());
        } else if (roleList.contains(this.FSC_AUTH_PUR_COMPANY_BUYER)) {
            infoBo.setOpeCreditUseDetail(YesNo.YES.getCode());
            infoBo.setOpeCreditChangeRecord(YesNo.NO.getCode());
            infoBo.setOpeCreditUseRecord(YesNo.NO.getCode());
            infoBo.setOpePayConfig(YesNo.NO.getCode());
            infoBo.setOpeOrderOverdueDetail(YesNo.NO.getCode());
            infoBo.setOpeOrderOverdueRecord(YesNo.NO.getCode());
        } else if (roleList.contains(this.FSC_AUTH_SUP_MANAGE)) {
            infoBo.setOpeCreditUseDetail(YesNo.YES.getCode());
            infoBo.setOpeCreditChangeRecord(YesNo.NO.getCode());
            infoBo.setOpeCreditUseRecord(YesNo.NO.getCode());
            infoBo.setOpePayConfig(YesNo.NO.getCode());
            infoBo.setOpeOrderOverdueDetail(YesNo.YES.getCode());
            infoBo.setOpeOrderOverdueRecord(YesNo.YES.getCode());
        } else {
            infoBo.setOpeCreditUseDetail(YesNo.YES.getCode());
            infoBo.setOpeCreditChangeRecord(YesNo.NO.getCode());
            infoBo.setOpeCreditUseRecord(YesNo.NO.getCode());
            infoBo.setOpePayConfig(YesNo.NO.getCode());
            infoBo.setOpeOrderOverdueDetail(YesNo.NO.getCode());
            infoBo.setOpeOrderOverdueRecord(YesNo.NO.getCode());
        }
        if (!YesNo.YES.getCode().equals(exportFlag) && YesNo.YES.getCode().equals(this.FSC_CREDIT_NONE_DATA_SHIELD_BUTTON)) {
            if (YesNo.YES.getCode().equals(infoBo.getOpeCreditUseDetail())) {
                infoBo.setOpeCreditUseDetail(this.checkOpeCreditUseDetail(infoBo.getPayConfigId(), infoBo.getUsedAmount()));
            }
            if (YesNo.YES.getCode().equals(infoBo.getOpeCreditChangeRecord())) {
                infoBo.setOpeCreditChangeRecord(this.checkOpeCreditChangeRecord(infoBo.getPayConfigId()));
            }
            if (YesNo.YES.getCode().equals(infoBo.getOpeCreditUseRecord())) {
                infoBo.setOpeCreditUseRecord(this.checkOpeCreditUseRecord(infoBo.getPayConfigId()));
            }
            if (YesNo.YES.getCode().equals(infoBo.getOpeOrderOverdueDetail())) {
                infoBo.setOpeOrderOverdueDetail(this.checkOpeOrderOverdueDetail(infoBo.getPayConfigId()));
            }
            if (YesNo.YES.getCode().equals(infoBo.getOpeOrderOverdueRecord())) {
                infoBo.setOpeOrderOverdueRecord(this.checkOpeOrderOverdueRecord(infoBo.getPayConfigId()));
            }
        }
    }

    private String checkOpeOrderOverdueRecord(Long payConfigId) {
        if (payConfigId == null) {
            return YesNo.NO.getCode();
        }
        PebExtOrderOverdueRecordQueryReqBO uocReqBo = new PebExtOrderOverdueRecordQueryReqBO();
        uocReqBo.setFscPayConfigId(payConfigId);
        uocReqBo.setPageNo(1);
        uocReqBo.setPageSize(0);
        PebExtOrderOverdueRecordQueryRspBO uocRspBo = this.fscPebExtOrderOverdueRecordQueryExternalService.queryOrderOverdueRecordList(uocReqBo);
        return uocRspBo.getRecordsTotal() > 0 ? YesNo.YES.getCode() : YesNo.NO.getCode();
    }

    private String checkOpeOrderOverdueDetail(Long payConfigId) {
        if (payConfigId == null) {
            return YesNo.NO.getCode();
        }
        PebExtOrderOverdueDetailQueryReqBO uocReqBo = new PebExtOrderOverdueDetailQueryReqBO();
        uocReqBo.setFscPayConfigId(payConfigId);
        uocReqBo.setPageNo(1);
        uocReqBo.setPageSize(0);
        PebExtOrderOverdueDetailQueryRspBO uocRspBo = this.fscPebExtOrderOverdueDetailQueryExternalService.queryOrderOverdueDetailList(uocReqBo);
        return uocRspBo.getRecordsTotal() > 0 ? YesNo.YES.getCode() : YesNo.NO.getCode();
    }

    private String checkOpeCreditUseRecord(Long payConfigId) {
        if (payConfigId == null) {
            return YesNo.NO.getCode();
        }
        PebExtGrantCreditUsedQueryReqBO uocReqBo = new PebExtGrantCreditUsedQueryReqBO();
        uocReqBo.setPageNo(1);
        uocReqBo.setPageSize(0);
        uocReqBo.setFscPayConfigId(payConfigId);
        PebExtGrantCreditUsedQueryRspBO uocRspBo = this.pebExtGrantCreditUsedQueryExternalService.getPebExtGrantCreditUsedList(uocReqBo);
        return uocRspBo.getRecordsTotal() > 0 ? YesNo.YES.getCode() : YesNo.NO.getCode();
    }

    private String checkOpeCreditChangeRecord(Long payConfigId) {
        if (payConfigId == null) {
            return YesNo.NO.getCode();
        }
        FscCreditControlLogPO fscCreditControlLogQry = new FscCreditControlLogPO();
        fscCreditControlLogQry.setPayConfigId(payConfigId);
        int checkBy = this.fscCreditControlLogMapper.getCheckBy(fscCreditControlLogQry);
        return checkBy > 0 ? YesNo.YES.getCode() : YesNo.NO.getCode();
    }

    private String checkOpeCreditUseDetail(Long payConfigId, BigDecimal usedAmount) {
        if (payConfigId == null) {
            return YesNo.NO.getCode();
        }
        if (usedAmount != null && BigDecimal.ZERO.compareTo(usedAmount) != 0) {
            return YesNo.YES.getCode();
        }
        return YesNo.NO.getCode();
    }

    private Map<Long, List<FscPayConfigChannelBO>> mapPayConfigChannel(List<FscPayConfigPO> listPage) {
        List<FscPayConfigChannelPO> payChannels;
        FscPayConfigChannelPO fscPayConfigChannelQry;
        List<Long> payConfigIdExcList = listPage.stream().filter(i -> FscPayConfigType.EXT_ORG.getCode().equals(i.getPayConfigType())).map(FscPayConfigPO::getPayConfigId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> payConfigIdMainList = listPage.stream().filter(i -> FscPayConfigType.DEF.getCode().equals(i.getPayConfigType())).map(FscPayConfigPO::getParentConfigId).filter(i -> i != null && i != 0L).distinct().collect(Collectors.toList());
        HashMap<Long, List<FscPayConfigChannelBO>> map = new HashMap<Long, List<FscPayConfigChannelBO>>();
        if (!CollectionUtils.isEmpty(payConfigIdExcList)) {
            fscPayConfigChannelQry = new FscPayConfigChannelPO();
            fscPayConfigChannelQry.setPayConfigIdList(payConfigIdExcList);
            payChannels = this.fscPayConfigChannelMapper.getList(fscPayConfigChannelQry);
            if (!CollectionUtils.isEmpty(payChannels)) {
                map.putAll(payChannels.stream().map(i -> {
                    FscPayConfigChannelBO bo = FscRu.js(i, FscPayConfigChannelBO.class);
                    bo.setPayChannelsStr(PayChannel.desc(bo.getPayChannels()));
                    return bo;
                }).collect(Collectors.groupingBy(FscPayConfigChannelBO::getPayConfigId)));
            }
        }
        if (!CollectionUtils.isEmpty(payConfigIdMainList)) {
            fscPayConfigChannelQry = new FscPayConfigChannelPO();
            fscPayConfigChannelQry.setPayConfigIdList(payConfigIdMainList);
            payChannels = this.fscPayConfigChannelMapper.getList(fscPayConfigChannelQry);
            if (!CollectionUtils.isEmpty(payChannels)) {
                map.putAll(payChannels.stream().map(i -> {
                    FscPayConfigChannelBO bo = FscRu.js(i, FscPayConfigChannelBO.class);
                    bo.setPayChannelsStr(PayChannel.desc(bo.getPayChannels()));
                    return bo;
                }).collect(Collectors.groupingBy(FscPayConfigChannelBO::getPayConfigId)));
            }
        }
        return map;
    }

    private void initFscPayConfigPo(FscPayConfigPO sourcePo, FscPayConfigPO targetPo) {
        targetPo.setPayConfigId(sourcePo.getPayConfigId());
        targetPo.setParentConfigId(sourcePo.getParentConfigId());
        targetPo.setVersionNo(sourcePo.getVersionNo());
        targetPo.setPayBusiType(sourcePo.getPayBusiType());
        targetPo.setPaySubClass(sourcePo.getPaySubClass());
        targetPo.setPaySubType(sourcePo.getPaySubType());
        targetPo.setPayConfigMode(sourcePo.getPayConfigMode());
        targetPo.setPayConfigType(sourcePo.getPayConfigType());
        targetPo.setPayUsedPeriodFlag(sourcePo.getPayUsedPeriodFlag());
        targetPo.setPayAllowExceptionFlag(sourcePo.getPayAllowExceptionFlag());
        targetPo.setExceptionOrgNum(sourcePo.getExceptionOrgNum());
        targetPo.setExceptionAgrNum(sourcePo.getExceptionAgrNum());
        targetPo.setExceptionConnNum(sourcePo.getExceptionConnNum());
        targetPo.setPayType(sourcePo.getPayType());
        if (FscPayConfigPayType.YF_RATIO.getCode().equals(sourcePo.getPayType())) {
            targetPo.setDownPaymentRatio(sourcePo.getDownPaymentRatio());
            targetPo.setCheckPaymentRatio(sourcePo.getCheckPaymentRatio());
        }
        if (FscPayConfigPayType.XY.getCode().equals(sourcePo.getPayType()) || FscPayConfigPayType.ZQ.getCode().equals(sourcePo.getPayType())) {
            if (!FscPayConfigBusiType.AGR_DW.getCode().equals(sourcePo.getPayBusiType())) {
                targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
                targetPo.setPaymentDays(sourcePo.getPaymentDays());
                targetPo.setDelayDays(sourcePo.getDelayDays());
            }
            targetPo.setCreditAmount(sourcePo.getCreditAmount());
            targetPo.setUsedAmount(sourcePo.getUsedAmount());
            targetPo.setBalanceAmount(sourcePo.getBalanceAmount());
            targetPo.setUsedWarningAmount(sourcePo.getUsedWarningAmount());
            targetPo.setOverdueStartAmount(sourcePo.getOverdueStartAmount());
            targetPo.setOverdueWarningRatio(sourcePo.getOverdueWarningRatio());
            targetPo.setOverdueControlRatio(sourcePo.getOverdueControlRatio());
            targetPo.setOverdueRecoveryRatio(sourcePo.getOverdueRecoveryRatio());
            targetPo.setOverdueIndexRatio(sourcePo.getOverdueIndexRatio());
            targetPo.setOverdueWarningIndex(sourcePo.getOverdueWarningIndex());
            targetPo.setOverdueControlIndex(sourcePo.getOverdueControlIndex());
            targetPo.setOverdueRecoveryIndex(sourcePo.getOverdueRecoveryIndex());
        }
        if (FscPayConfigType.EXT_ORG.getCode().equals(sourcePo.getPayConfigType()) || FscPayConfigType.DEF.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayOrgId(sourcePo.getPayOrgId());
            targetPo.setPayOrgName(sourcePo.getPayOrgName());
            targetPo.setPayOrgPath(sourcePo.getPayOrgPath());
            targetPo.setPayUserId(sourcePo.getPayUserId());
            targetPo.setPayUserName(sourcePo.getPayUserName());
            targetPo.setCurrentOrgControlStatus(sourcePo.getCurrentOrgControlStatus());
            targetPo.setCurrentOrgControlTag(sourcePo.getCurrentOrgControlTag());
            targetPo.setCurrentOrgWarningTag(sourcePo.getCurrentOrgWarningTag());
            targetPo.setCurrentOverdueRatio(sourcePo.getCurrentOverdueRatio());
            targetPo.setCurrentOverdueAmount(sourcePo.getCurrentOverdueAmount());
            targetPo.setCurrentPenaltyAmount(sourcePo.getCurrentPenaltyAmount());
            targetPo.setCurrentOverdueIndex(sourcePo.getCurrentOverdueIndex());
        }
        if (FscPayConfigType.EXT_AGR.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
            targetPo.setPaymentDays(sourcePo.getPaymentDays());
            targetPo.setDelayDays(sourcePo.getDelayDays());
            targetPo.setPayAgrName(sourcePo.getPayAgrName());
            targetPo.setPayAgrNo(sourcePo.getPayAgrNo());
            targetPo.setPayAgrId(sourcePo.getPayAgrId());
            targetPo.setPayAgrEcpNo(sourcePo.getPayAgrEcpNo());
            targetPo.setPayAgrOrgNo(sourcePo.getPayAgrOrgNo());
            targetPo.setPayAgrSupName(sourcePo.getPayAgrSupName());
            targetPo.setPayAgrSupId(sourcePo.getPayAgrSupId());
            targetPo.setPayAgrProName(sourcePo.getPayAgrProName());
            targetPo.setPayAgrProId(sourcePo.getPayAgrProId());
            targetPo.setAgreementType(sourcePo.getAgreementType());
            targetPo.setAgreementTypeStr(sourcePo.getAgreementTypeStr());
            targetPo.setAgreementVariety(sourcePo.getAgreementVariety());
            targetPo.setAgreementVarietyStr(sourcePo.getAgreementVarietyStr());
        }
        if (FscPayConfigType.EXT_CONN.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
            targetPo.setPaymentDays(sourcePo.getPaymentDays());
            targetPo.setDelayDays(sourcePo.getDelayDays());
            targetPo.setPayContractName(sourcePo.getPayContractName());
            targetPo.setPayContractNo(sourcePo.getPayContractNo());
            targetPo.setPayContractId(sourcePo.getPayContractId());
            targetPo.setPayContractSignOrgId(sourcePo.getPayContractSignOrgId());
            targetPo.setPayContractSignOrgName(sourcePo.getPayContractSignOrgName());
        }
        targetPo.setCreateTime(sourcePo.getCreateTime());
        targetPo.setCreateUserId(sourcePo.getCreateUserId());
        targetPo.setCreateUserName(sourcePo.getCreateUserName());
        targetPo.setUpdateTime(sourcePo.getUpdateTime());
        targetPo.setUpdateUserId(sourcePo.getUpdateUserId());
        targetPo.setUpdateUserName(sourcePo.getUpdateUserName());
        targetPo.setRemark(sourcePo.getRemark());
        targetPo.setStatus(sourcePo.getStatus());
        targetPo.setDeleteFlag(sourcePo.getDeleteFlag());
    }
}

