/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import com.tydic.pfscext.api.ability.FscCreditControlTabQryAbilityService;
import com.tydic.pfscext.api.ability.bo.FscCreditControlTabInfoBO;
import com.tydic.pfscext.api.ability.bo.FscCreditControlTabItemInfoBO;
import com.tydic.pfscext.api.ability.bo.FscCreditControlTabItemQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscCreditControlTabItemQryAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscCreditControlTabQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscCreditControlTabQryAbilityRspBO;
import com.tydic.pfscext.base.AuthorityInfo;
import com.tydic.pfscext.dao.FscCreditMenuConfigMapper;
import com.tydic.pfscext.dao.po.FscCreditMenuConfigPO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscCreditControlTabQryAbilityService"})
public class FscCreditControlTabQryAbilityServiceImpl
implements FscCreditControlTabQryAbilityService {
    @Autowired
    private FscCreditMenuConfigMapper fscCreditMenuConfigMapper;

    @PostMapping(value={"listCreditControlTab"})
    public FscCreditControlTabQryAbilityRspBO listCreditControlTab(@RequestBody FscCreditControlTabQryAbilityReqBO reqBo) {
        FscCreditControlTabQryAbilityRspBO rspBo = FscRu.success(FscCreditControlTabQryAbilityRspBO.class);
        ArrayList tabList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)reqBo.getPermission())) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u89d2\u8272\u96c6\u5408\u4e3a\u7a7a");
            return rspBo;
        }
        List<String> roleList = reqBo.getPermission().stream().map(AuthorityInfo::getKey).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(roleList)) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u89d2\u8272\u96c6\u5408key\u4e3a\u7a7a");
            return rspBo;
        }
        FscCreditMenuConfigPO fscCreditMenuConfigQry = new FscCreditMenuConfigPO();
        fscCreditMenuConfigQry.setMenuName("FSC_CREDIT_CONTROL_TAB");
        fscCreditMenuConfigQry.setAuthRoleList(roleList);
        fscCreditMenuConfigQry.setCenter("FSC");
        fscCreditMenuConfigQry.setOrderBy(" AUTH_TYPE ASC");
        List<FscCreditMenuConfigPO> fscCreditMenuList = this.fscCreditMenuConfigMapper.getList(fscCreditMenuConfigQry);
        if (!CollectionUtils.isEmpty(fscCreditMenuList)) {
            Map mapCreditMenu = fscCreditMenuList.stream().collect(Collectors.toMap(FscCreditMenuConfigPO::getTabId, Function.identity(), (old, cur) -> old));
            tabList.addAll(mapCreditMenu.values().stream().map(i -> FscRu.js(i, FscCreditControlTabInfoBO.class)).collect(Collectors.toList()));
        }
        Collections.sort(tabList, Comparator.comparing(FscCreditControlTabInfoBO::getTabId));
        rspBo.setTabList(tabList);
        return rspBo;
    }

    @Deprecated
    @PostMapping(value={"listCreditControlTabItem"})
    public FscCreditControlTabItemQryAbilityRspBO listCreditControlTabItem(@RequestBody FscCreditControlTabItemQryAbilityReqBO reqBo) {
        ValUtil.isBlank(reqBo.getTabId()).exception("\u5165\u53c2[tabId]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isBlank(reqBo.getMenuName()).exception("\u5165\u53c2[menuName]\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> roleList = reqBo.getPermission().stream().map(AuthorityInfo::getKey).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(roleList)) {
            throw new PfscExtBusinessException("0001", "\u89d2\u8272\u96c6\u5408\u4e3a\u7a7a");
        }
        FscCreditControlTabItemQryAbilityRspBO rspBo = FscRu.success(FscCreditControlTabItemQryAbilityRspBO.class);
        ArrayList tabItemList = new ArrayList();
        rspBo.setTabItemList(tabItemList);
        FscCreditMenuConfigPO fscCreditMenuConfigQry = new FscCreditMenuConfigPO();
        fscCreditMenuConfigQry.setMenuName(reqBo.getMenuName());
        fscCreditMenuConfigQry.setAuthRoleList(roleList);
        fscCreditMenuConfigQry.setCenter("FSC");
        fscCreditMenuConfigQry.setOrderBy(" AUTH_TYPE ASC");
        List<FscCreditMenuConfigPO> fscCreditMenuList = this.fscCreditMenuConfigMapper.getList(fscCreditMenuConfigQry);
        if (!CollectionUtils.isEmpty(fscCreditMenuList)) {
            tabItemList.addAll(fscCreditMenuList.stream().map(i -> FscRu.js(i, FscCreditControlTabItemInfoBO.class)).collect(Collectors.toList()));
        }
        return rspBo;
    }
}

