/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.pfscext.api.ability.FscCreditControlTipsQryAbilityService;
import com.tydic.pfscext.api.ability.FscOrderCheckUserControlConfigAbilityService;
import com.tydic.pfscext.api.ability.bo.FscCreditControlTipsInfoBO;
import com.tydic.pfscext.api.ability.bo.FscCreditControlTipsQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscCreditControlTipsQryAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscOrderCheckUserControlConfigAbilityReqBO;
import com.tydic.pfscext.base.AuthorityInfo;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.FscUserOverdueControlConfigMapper;
import com.tydic.pfscext.dao.FscUserOverdueStatisticsMapper;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.dao.po.FscUserOverdueControlConfigPO;
import com.tydic.pfscext.dao.po.FscUserOverdueStatisticsPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.FscPayCreditControlTag;
import com.tydic.pfscext.enums.FscPayCreditWarningTag;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscCreditControlTipsQryAbilityService"})
public class FscCreditControlTipsQryAbilityServiceImpl
implements FscCreditControlTipsQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscCreditControlTipsQryAbilityServiceImpl.class);
    @Autowired
    private FscPayConfigMapper fscPayConfigMapper;
    @Autowired
    private FscUserOverdueStatisticsMapper fscUserOverdueStatisticsMapper;
    @Autowired
    private FscUserOverdueControlConfigMapper fscUserOverdueControlConfigMapper;
    @Autowired
    private FscOrderCheckUserControlConfigAbilityService fscOrderCheckUserControlConfigAbilityService;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${FSC_CREDIT_CONTROL_TIPS_USE_REDIS_FLAG:1}")
    private String fscCreditControlTipsUseRedisFlag;
    @Value(value="${FSC_AUTH_PUR_COMPANY_BUYER:002}")
    private String FSC_AUTH_PUR_COMPANY_BUYER;
    @Value(value="${FSC_AUTH_PUR_COMPANY_MANAGE:001}")
    private String FSC_AUTH_PUR_COMPANY_MANAGE;
    @Value(value="${FSC_AUTH_PURCHASING_MANAGER:004}")
    private String FSC_AUTH_PURCHASING_MANAGER;
    @Value(value="${FSC_AUTH_DEPARTMENT_PURCHASING_MANAGER:003}")
    private String FSC_AUTH_DEPARTMENT_PURCHASING_MANAGER;
    @Value(value="${FSC_AUTH_PUR_WELFARE_MANAGER:119}")
    private String FSC_AUTH_PUR_WELFARE_MANAGER;
    @Value(value="${FSC_AUTH_PRO_WELFARE_MANAGER:020}")
    private String FSC_AUTH_PRO_WELFARE_MANAGER;
    @Value(value="${FSC_AUTH_SECONDARY_COMPANY_MANAGE:overall:erjidanweiguanliyuan}")
    private String FSC_AUTH_SECONDARY_COMPANY_MANAGE;
    @Value(value="${FSC_AUTH_TIPS_SKIP_POPUP_ROLES:002,001,004,003,119,020,overall:erjidanweiguanliyuan}")
    private String FSC_AUTH_TIPS_SKIP_POPUP_ROLES;

    @PostMapping(value={"listCreditControlTips"})
    public FscCreditControlTipsQryAbilityRspBO listCreditControlTips(@RequestBody FscCreditControlTipsQryAbilityReqBO reqBo) {
        ValUtil.isEmpty(reqBo).exception("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isBlank(reqBo.getTipsFlag()).exception("\u5165\u53c2[tipsFlag]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getOrgId()).exception("\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getCompanyId()).exception("\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getOrgTypeIn()).exception("\u673a\u6784\u7c7b\u578b[orgTypeIn]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getMemIdExt()).exception("\u7528\u6237MemId\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getUserId()).exception("\u7528\u6237UserId\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isBlank(reqBo.getUsername()).exception("\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty((Collection)reqBo.getPermission())) {
            throw new PfscExtBusinessException("18000", "\u89d2\u8272\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (!Arrays.asList("1", "2", "3", "4", "5", "6").contains(reqBo.getTipsFlag())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2[tipsFlag]\u503c\u9519\u8bef");
        }
        if (Arrays.asList("3", "4", "5", "6").contains(reqBo.getTipsFlag()) && CollectionUtils.isEmpty((Collection)reqBo.getPayBusiTypeList())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2[payBusiTypeList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscCreditControlTipsQryAbilityRspBO rspBo = FscRu.success(FscCreditControlTipsQryAbilityRspBO.class);
        rspBo.setTipsInfos(new ArrayList(2));
        if (this.checkPermissionSkip(reqBo)) {
            log.error("\u89d2\u8272\u6821\u9a8c\u8df3\u8fc7\u4e86\u5f39\u7a97:{}", (Object)JSON.toJSONString((Object)reqBo));
            rspBo.setRespDesc("\u5f53\u524d\u89d2\u8272\u4e0d\u5305\u542b\u6307\u5b9a\u89d2\u8272,\u9996\u9875\u8df3\u8fc7\u5f39\u7a97");
            return rspBo;
        }
        this.dealCreditControlCompany(reqBo, rspBo);
        this.dealCreditControlUser(reqBo, rspBo);
        return rspBo;
    }

    private boolean checkPermissionSkip(FscCreditControlTipsQryAbilityReqBO reqBo) {
        boolean skipFlag = false;
        if ("1".equals(reqBo.getTipsFlag())) {
            List<String> showBoxRole;
            List roleList = reqBo.getPermission().stream().map(AuthorityInfo::getKey).filter(Objects::nonNull).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(roleList)) {
                throw new PfscExtBusinessException("18000", "\u89d2\u8272\u7f16\u7801\u96c6\u5408\u4e3a\u7a7a");
            }
            log.error("\u914d\u7f6e\u7684\u89d2\u8272\u96c6\u5408\uff1a{}", (Object)this.FSC_AUTH_TIPS_SKIP_POPUP_ROLES);
            log.error("\u8d26\u53f7\u89d2\u8272\u96c6\u5408\uff1a{}", roleList);
            if (StringUtils.hasText((String)this.FSC_AUTH_TIPS_SKIP_POPUP_ROLES) && !CollectionUtils.isEmpty(showBoxRole = Arrays.asList(this.FSC_AUTH_TIPS_SKIP_POPUP_ROLES.split(",")))) {
                if (roleList.stream().noneMatch(showBoxRole::contains)) {
                    skipFlag = true;
                }
            }
        }
        return skipFlag;
    }

    private void dealCreditControlUser(FscCreditControlTipsQryAbilityReqBO reqBo, FscCreditControlTipsQryAbilityRspBO rspBo) {
        ArrayList<FscCreditControlTipsInfoBO> tipsInfos = new ArrayList<FscCreditControlTipsInfoBO>();
        FscUserOverdueControlConfigPO modelBy = this.getFscUserOverdueControlConfigPo(reqBo);
        if (modelBy != null) {
            boolean DEFAULT_ZERO = false;
            Integer currentOrderOverdueNum = Optional.ofNullable(modelBy.getCurrentOrderOverdueNum()).orElse(0);
            Integer orderWarningNum = Optional.ofNullable(modelBy.getOrderWarningNum()).orElse(0);
            Integer orderControlNum = Optional.ofNullable(modelBy.getOrderControlNum()).orElse(0);
            Integer orderRecoveryNum = Optional.ofNullable(modelBy.getOrderRecoveryNum()).orElse(0);
            if (FscPayConfigControlStatus.RESTRICTED.getCode().equals(modelBy.getCurrentUserControlStatus())) {
                if ("1".equals(reqBo.getTipsFlag()) || "2".equals(reqBo.getTipsFlag())) {
                    FscCreditControlTipsInfoBO headInfo = new FscCreditControlTipsInfoBO();
                    headInfo.setTitleText("\u60a8\u7684\u8d26\u6237\u4e1a\u52a1\u4e0b\u5355/\u521b\u5efa\u6d3b\u52a8\u6743\u9650\u5173\u505c\uff1a");
                    headInfo.setTitle("<span style='color:#DA0A24;'>\u60a8\u7684\u8d26\u6237</span>\u4e1a\u52a1<span style='color:#DA0A24;'>\u4e0b\u5355/\u521b\u5efa\u6d3b\u52a8\u6743\u9650</span><span style='color:#DA0A24; font-size:18px;'>\u5173\u505c</span>\uff1a");
                    headInfo.setTitleWechat("<text style='color:#DA0A24;'>\u60a8\u7684\u8d26\u6237</text>\u4e1a\u52a1<text style='color:#DA0A24;'>\u4e0b\u5355/\u521b\u5efa\u6d3b\u52a8\u6743\u9650</text><text style='color:#DA0A24; font-size:36rpx;'>\u5173\u505c</text>\uff1a");
                    headInfo.setTipsType("2");
                    ArrayList<FscCreditControlTipsInfoBO> secondLevel = new ArrayList<FscCreditControlTipsInfoBO>();
                    headInfo.setTipsInfos(secondLevel);
                    FscCreditControlTipsInfoBO secondItem = new FscCreditControlTipsInfoBO();
                    secondLevel.add(secondItem);
                    secondItem.setTitleText(StrUtil.format((CharSequence)"\u903e\u671f\u8ba2\u5355\u8d85\u8fc7\u9608\u503c {} \u6761\uff0c\u5f53\u524d\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761", (Object[])new Object[]{orderControlNum, currentOrderOverdueNum}));
                    secondItem.setTitle(StrUtil.format((CharSequence)"\u903e\u671f\u8ba2\u5355\u8d85\u8fc7\u9608\u503c {} \u6761\uff0c\u5f53\u524d\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761", (Object[])new Object[]{orderControlNum, currentOrderOverdueNum}));
                    secondItem.setTitleWechat(StrUtil.format((CharSequence)"\u903e\u671f\u8ba2\u5355\u8d85\u8fc7\u9608\u503c {} \u6761\uff0c\u5f53\u524d\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761", (Object[])new Object[]{orderControlNum, currentOrderOverdueNum}));
                    tipsInfos.add(headInfo);
                } else if ("3".equals(reqBo.getTipsFlag()) || "4".equals(reqBo.getTipsFlag()) || "5".equals(reqBo.getTipsFlag())) {
                    FscCreditControlTipsInfoBO headInfo = new FscCreditControlTipsInfoBO();
                    headInfo.setTitleText("\u60a8\u7684\u8d26\u6237\u4e0b\u5355\u6743\u9650\u5173\u505c\uff0c\u5173\u505c\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTitle("<span style='color:#DA0A24;'>\u60a8\u7684\u8d26\u6237\u4e0b\u5355\u6743\u9650</span><span style='color:#DA0A24; font-size:18px;'>\u5173\u505c</span>\uff0c\u5173\u505c\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTitleWechat("<text style='color:#DA0A24;'>\u60a8\u7684\u8d26\u6237\u4e0b\u5355\u6743\u9650</text><text style='color:#DA0A24; font-size:36rpx;'>\u5173\u505c</text>\uff0c\u5173\u505c\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTipsType("2");
                    ArrayList<FscCreditControlTipsInfoBO> secondLevel = new ArrayList<FscCreditControlTipsInfoBO>();
                    headInfo.setTipsInfos(secondLevel);
                    FscCreditControlTipsInfoBO secondItem = new FscCreditControlTipsInfoBO();
                    secondLevel.add(secondItem);
                    secondItem.setTitleText(StrUtil.format((CharSequence)"\u903e\u671f\u8ba2\u5355\u8d85\u8fc7\u9608\u503c {} \u6761\uff0c\u5f53\u524d\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761", (Object[])new Object[]{orderControlNum, currentOrderOverdueNum}));
                    secondItem.setTitle(StrUtil.format((CharSequence)"\u903e\u671f\u8ba2\u5355\u8d85\u8fc7\u9608\u503c {} \u6761\uff0c\u5f53\u524d\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761", (Object[])new Object[]{orderControlNum, currentOrderOverdueNum}));
                    secondItem.setTitleWechat(StrUtil.format((CharSequence)"\u903e\u671f\u8ba2\u5355\u8d85\u8fc7\u9608\u503c {} \u6761\uff0c\u5f53\u524d\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761", (Object[])new Object[]{orderControlNum, currentOrderOverdueNum}));
                    tipsInfos.add(headInfo);
                } else {
                    FscCreditControlTipsInfoBO headInfo = new FscCreditControlTipsInfoBO();
                    headInfo.setTitleText("\u60a8\u7684\u8d26\u6237\u6d3b\u52a8\u521b\u5efa\u6743\u9650\u5173\u505c\uff0c\u5173\u505c\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTitle("<span style='color:#DA0A24;'>\u60a8\u7684\u8d26\u6237\u6d3b\u52a8\u521b\u5efa\u6743\u9650</span><span style='color:#DA0A24; font-size:18px;'>\u5173\u505c</span>\uff0c\u5173\u505c\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTitleWechat("<text style='color:#DA0A24;'>\u60a8\u7684\u8d26\u6237\u6d3b\u52a8\u521b\u5efa\u6743\u9650</text><text style='color:#DA0A24; font-size:36rpx;'>\u5173\u505c</text>\uff0c\u5173\u505c\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTipsType("2");
                    ArrayList<FscCreditControlTipsInfoBO> secondLevel = new ArrayList<FscCreditControlTipsInfoBO>();
                    headInfo.setTipsInfos(secondLevel);
                    FscCreditControlTipsInfoBO secondItem = new FscCreditControlTipsInfoBO();
                    secondLevel.add(secondItem);
                    secondItem.setTitleText(StrUtil.format((CharSequence)"\u903e\u671f\u8ba2\u5355\u8d85\u8fc7\u9608\u503c {} \u6761\uff0c\u5f53\u524d\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761", (Object[])new Object[]{orderControlNum, currentOrderOverdueNum}));
                    secondItem.setTitle(StrUtil.format((CharSequence)"\u903e\u671f\u8ba2\u5355\u8d85\u8fc7\u9608\u503c {} \u6761\uff0c\u5f53\u524d\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761", (Object[])new Object[]{orderControlNum, currentOrderOverdueNum}));
                    secondItem.setTitleWechat(StrUtil.format((CharSequence)"\u903e\u671f\u8ba2\u5355\u8d85\u8fc7\u9608\u503c {} \u6761\uff0c\u5f53\u524d\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761", (Object[])new Object[]{orderControlNum, currentOrderOverdueNum}));
                    tipsInfos.add(headInfo);
                }
            } else if (FscPayConfigControlStatus.WARNING.getCode().equals(modelBy.getCurrentUserControlStatus())) {
                if ("1".equals(reqBo.getTipsFlag()) || "2".equals(reqBo.getTipsFlag())) {
                    FscCreditControlTipsInfoBO headInfo = new FscCreditControlTipsInfoBO();
                    headInfo.setTitleText("\u60a8\u7684\u8d26\u6237\u4e1a\u52a1\u4e0b\u5355/\u521b\u5efa\u6d3b\u52a8\u6743\u9650\u8ba2\u5355\u903e\u671f\u60c5\u51b5\u9884\u8b66\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTitle("<span style='color:#FF9900;'>\u60a8\u7684\u8d26\u6237</span>\u4e1a\u52a1<span style='color:#FF9900;'>\u4e0b\u5355/\u521b\u5efa\u6d3b\u52a8\u6743\u9650</span>\u8ba2\u5355\u903e\u671f\u60c5\u51b5<span style='color:#FF9900; font-size:18px;'>\u9884\u8b66</span>\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTitleWechat("<text style='color:#FF9900;'>\u60a8\u7684\u8d26\u6237</text>\u4e1a\u52a1<text style='color:#FF9900;'>\u4e0b\u5355/\u521b\u5efa\u6d3b\u52a8\u6743\u9650</text>\u8ba2\u5355\u903e\u671f\u60c5\u51b5<text style='color:#FF9900; font-size:36rpx;'>\u9884\u8b66</text>\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTipsType("2");
                    ArrayList<FscCreditControlTipsInfoBO> secondLevel = new ArrayList<FscCreditControlTipsInfoBO>();
                    headInfo.setTipsInfos(secondLevel);
                    FscCreditControlTipsInfoBO secondItem = new FscCreditControlTipsInfoBO();
                    secondLevel.add(secondItem);
                    secondItem.setTitleText(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761\uff0c\u5982\u679c\u8d85\u8fc7 {} \u6761\uff0c\u5c06\u5173\u505c\u4e0b\u5355\u6743\u9650", (Object[])new Object[]{currentOrderOverdueNum, orderControlNum}));
                    secondItem.setTitle(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761\uff0c\u5982\u679c\u8d85\u8fc7 {} \u6761\uff0c\u5c06\u5173\u505c\u4e0b\u5355\u6743\u9650", (Object[])new Object[]{currentOrderOverdueNum, orderControlNum}));
                    secondItem.setTitleWechat(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761\uff0c\u5982\u679c\u8d85\u8fc7 {} \u6761\uff0c\u5c06\u5173\u505c\u4e0b\u5355\u6743\u9650", (Object[])new Object[]{currentOrderOverdueNum, orderControlNum}));
                    tipsInfos.add(headInfo);
                } else if ("3".equals(reqBo.getTipsFlag()) || "4".equals(reqBo.getTipsFlag()) || "5".equals(reqBo.getTipsFlag())) {
                    FscCreditControlTipsInfoBO headInfo = new FscCreditControlTipsInfoBO();
                    headInfo.setTitleText("\u60a8\u7684\u8d26\u6237\u4e0b\u5355\u6743\u9650\u8ba2\u5355\u903e\u671f\u60c5\u51b5\u9884\u8b66\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTitle("<span style='color:#FF9900;'>\u60a8\u7684\u8d26\u6237\u4e0b\u5355\u6743\u9650</span>\u8ba2\u5355\u903e\u671f\u60c5\u51b5<span style='color:#FF9900; font-size:18px;'>\u9884\u8b66</span>\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTitleWechat("<text style='color:#FF9900;'>\u60a8\u7684\u8d26\u6237\u4e0b\u5355\u6743\u9650</text>\u8ba2\u5355\u903e\u671f\u60c5\u51b5<text style='color:#FF9900; font-size:36rpx;'>\u9884\u8b66</text>\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTipsType("2");
                    ArrayList<FscCreditControlTipsInfoBO> secondLevel = new ArrayList<FscCreditControlTipsInfoBO>();
                    headInfo.setTipsInfos(secondLevel);
                    FscCreditControlTipsInfoBO secondItem = new FscCreditControlTipsInfoBO();
                    secondLevel.add(secondItem);
                    secondItem.setTitleText(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761\uff0c\u5982\u679c\u8d85\u8fc7 {} \u6761\uff0c\u5c06\u5173\u505c\u4e0b\u5355\u6743\u9650", (Object[])new Object[]{currentOrderOverdueNum, orderControlNum}));
                    secondItem.setTitle(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761\uff0c\u5982\u679c\u8d85\u8fc7 {} \u6761\uff0c\u5c06\u5173\u505c\u4e0b\u5355\u6743\u9650", (Object[])new Object[]{currentOrderOverdueNum, orderControlNum}));
                    secondItem.setTitleWechat(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761\uff0c\u5982\u679c\u8d85\u8fc7 {} \u6761\uff0c\u5c06\u5173\u505c\u4e0b\u5355\u6743\u9650", (Object[])new Object[]{currentOrderOverdueNum, orderControlNum}));
                    tipsInfos.add(headInfo);
                } else {
                    FscCreditControlTipsInfoBO headInfo = new FscCreditControlTipsInfoBO();
                    headInfo.setTitleText("\u60a8\u7684\u8d26\u6237\u521b\u5efa\u6d3b\u52a8\u6743\u9650\u8ba2\u5355\u903e\u671f\u9884\u8b66\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTitle("<span style='color:#FF9900;'>\u60a8\u7684\u8d26\u6237\u521b\u5efa\u6d3b\u52a8\u6743\u9650</span>\u8ba2\u5355\u903e\u671f<span style='color:#FF9900; font-size:18px;'>\u9884\u8b66</span>\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTitleWechat("<text style='color:#FF9900;'>\u60a8\u7684\u8d26\u6237\u521b\u5efa\u6d3b\u52a8\u6743\u9650</text>\u8ba2\u5355\u903e\u671f<text style='color:#FF9900; font-size:36rpx;'>\u9884\u8b66</text>\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a");
                    headInfo.setTipsType("2");
                    ArrayList<FscCreditControlTipsInfoBO> secondLevel = new ArrayList<FscCreditControlTipsInfoBO>();
                    headInfo.setTipsInfos(secondLevel);
                    FscCreditControlTipsInfoBO secondItem = new FscCreditControlTipsInfoBO();
                    secondLevel.add(secondItem);
                    secondItem.setTitleText(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761\uff0c\u5982\u679c\u8d85\u8fc7 {} \u6761\uff0c\u5c06\u5173\u505c\u4e0b\u5355\u6743\u9650", (Object[])new Object[]{currentOrderOverdueNum, orderControlNum}));
                    secondItem.setTitle(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761\uff0c\u5982\u679c\u8d85\u8fc7 {} \u6761\uff0c\u5c06\u5173\u505c\u4e0b\u5355\u6743\u9650", (Object[])new Object[]{currentOrderOverdueNum, orderControlNum}));
                    secondItem.setTitleWechat(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u8ba2\u5355\u6570\u4e3a {} \u6761\uff0c\u5982\u679c\u8d85\u8fc7 {} \u6761\uff0c\u5c06\u5173\u505c\u4e0b\u5355\u6743\u9650", (Object[])new Object[]{currentOrderOverdueNum, orderControlNum}));
                    tipsInfos.add(headInfo);
                }
            }
            rspBo.setCurrentUserControlStatus(modelBy.getCurrentUserControlStatus());
            rspBo.setCurrentUserControlStatusStr(FscPayConfigControlStatus.desc((String)modelBy.getCurrentUserControlStatus()));
        }
        rspBo.getTipsInfos().addAll(tipsInfos);
    }

    private void dealCreditControlCompany(FscCreditControlTipsQryAbilityReqBO reqBo, FscCreditControlTipsQryAbilityRspBO rspBo) {
        ArrayList<Object> tipsInfos = new ArrayList<Object>();
        List<FscPayConfigPO> fscPayConfigList = this.getListFscPayConfig(reqBo);
        if (!CollectionUtils.isEmpty(fscPayConfigList)) {
            FscPayConfigPO ptAgrConfig;
            Object headInfo;
            ArrayList<FscCreditControlTipsInfoBO> secondLevel;
            Object headInfo2;
            List controlConfigList = fscPayConfigList.stream().filter(i -> FscPayConfigControlStatus.RESTRICTED.getCode().equals(i.getCurrentOrgControlStatus())).collect(Collectors.toList());
            List warningConfigList = fscPayConfigList.stream().filter(i -> FscPayConfigControlStatus.WARNING.getCode().equals(i.getCurrentOrgControlStatus())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(controlConfigList)) {
                rspBo.setCurrentOrgControlStatus(FscPayConfigControlStatus.RESTRICTED.getCode());
                rspBo.setCurrentOrgControlStatusStr(FscPayConfigControlStatus.RESTRICTED.getDesc());
                if ("1".equals(reqBo.getTipsFlag()) || "2".equals(reqBo.getTipsFlag())) {
                    headInfo2 = new FscCreditControlTipsInfoBO();
                    headInfo2.setTitleText("\u60a8\u6240\u5728\u7684\u5355\u4f4d\u4ee5\u4e0b\u4e1a\u52a1\u4e0b\u5355/\u521b\u5efa\u6d3b\u52a8\u6743\u9650\u5173\u505c\uff1a");
                    headInfo2.setTitle("<span style='color:#DA0A24;'>\u60a8\u6240\u5728\u7684\u5355\u4f4d</span>\u4ee5\u4e0b\u4e1a\u52a1<span style='color:#DA0A24;'>\u4e0b\u5355/\u521b\u5efa\u6d3b\u52a8\u6743\u9650</span><span style='color:#DA0A24; font-size:18px;'>\u5173\u505c</span>\uff1a");
                    headInfo2.setTitleWechat("<text style='color:#DA0A24;'>\u60a8\u6240\u5728\u7684\u5355\u4f4d</text>\u4ee5\u4e0b\u4e1a\u52a1<text style='color:#DA0A24;'>\u4e0b\u5355/\u521b\u5efa\u6d3b\u52a8\u6743\u9650</text><text style='color:#DA0A24; font-size:36rpx;'>\u5173\u505c</text>\uff1a");
                    headInfo2.setTipsType("1");
                    secondLevel = new ArrayList<FscCreditControlTipsInfoBO>();
                    headInfo2.setTipsInfos(secondLevel);
                    tipsInfos.add(headInfo2);
                    for (FscPayConfigPO po : controlConfigList) {
                        FscCreditControlTipsInfoBO secondItem = new FscCreditControlTipsInfoBO();
                        String payBusiTypeStr = FscPayConfigBusiType.desc((String)po.getPayBusiType());
                        secondItem.setTitleText(StrUtil.format((CharSequence)"{}\uff0c\u5173\u505c\u539f\u56e0\u5982\u4e0b ", (Object[])new Object[]{payBusiTypeStr}));
                        secondItem.setTitle(StrUtil.format((CharSequence)"<span style='color:#DA0A24;'>{}</span>\uff0c\u5173\u505c\u539f\u56e0\u5982\u4e0b", (Object[])new Object[]{payBusiTypeStr}));
                        secondItem.setTitleWechat(StrUtil.format((CharSequence)"<text style='color:#DA0A24;'>{}</text>\uff0c\u5173\u505c\u539f\u56e0\u5982\u4e0b", (Object[])new Object[]{payBusiTypeStr}));
                        secondItem.setPayBusiType(po.getPayBusiType());
                        secondItem.setPayBusiTypeStr(payBusiTypeStr);
                        this.initControlTips(po, secondItem);
                        secondLevel.add(secondItem);
                    }
                } else if ("3".equals(reqBo.getTipsFlag()) || "4".equals(reqBo.getTipsFlag()) || "5".equals(reqBo.getTipsFlag()) || "6".equals(reqBo.getTipsFlag())) {
                    for (FscPayConfigPO po : controlConfigList) {
                        headInfo = new FscCreditControlTipsInfoBO();
                        tipsInfos.add(headInfo);
                        if ("6".equals(reqBo.getTipsFlag())) {
                            headInfo.setTitleText("\u60a8\u6240\u5728\u7684\u5355\u4f4d\u7684\u6d3b\u52a8\u521b\u5efa\u6743\u9650\u5173\u505c\uff0c\u5173\u505c\u539f\u56e0\u5982\u4e0b\uff1a");
                            headInfo.setTitle("<span style='color:#DA0A24;'>\u60a8\u6240\u5728\u7684\u5355\u4f4d</span>\u7684<span style='color:#DA0A24;'>\u6d3b\u52a8\u521b\u5efa\u6743\u9650</span><span style='color:#DA0A24; font-size:18px;'>\u5173\u505c</span>\uff0c\u5173\u505c\u539f\u56e0\u5982\u4e0b\uff1a");
                            headInfo.setTitleWechat("<text style='color:#DA0A24;'>\u60a8\u6240\u5728\u7684\u5355\u4f4d</text>\u7684<text style='color:#DA0A24;'>\u6d3b\u52a8\u521b\u5efa\u6743\u9650</text><text style='color:#DA0A24; font-size:36rpx;'>\u5173\u505c</text>\uff0c\u5173\u505c\u539f\u56e0\u5982\u4e0b\uff1a");
                        } else {
                            headInfo.setTitleText(StrUtil.format((CharSequence)"\u60a8\u6240\u5728\u7684\u5355\u4f4d{}\u4e0b\u5355\u6743\u9650\u53d7\u9650\uff0c\u53d7\u9650\u539f\u56e0\u5982\u4e0b\uff1a", (Object[])new Object[]{FscPayConfigBusiType.desc((String)po.getPayBusiType())}));
                            headInfo.setTitle(StrUtil.format((CharSequence)"<span style='color:#DA0A24;'>\u60a8\u6240\u5728\u7684\u5355\u4f4d{}\u4e0b\u5355\u6743\u9650</span><span style='color:#DA0A24; font-size:18px;'>\u5173\u505c</span>\uff0c\u5173\u505c\u539f\u56e0\u5982\u4e0b\uff1a", (Object[])new Object[]{FscPayConfigBusiType.desc((String)po.getPayBusiType())}));
                            headInfo.setTitleWechat(StrUtil.format((CharSequence)"<text style='color:#DA0A24;'>\u60a8\u6240\u5728\u7684\u5355\u4f4d{}\u4e0b\u5355\u6743\u9650</text><text style='color:#DA0A24; font-size:36rpx;'>\u5173\u505c</text>\uff0c\u5173\u505c\u539f\u56e0\u5982\u4e0b\uff1a", (Object[])new Object[]{FscPayConfigBusiType.desc((String)po.getPayBusiType())}));
                            headInfo.setPayBusiType(po.getPayBusiType());
                            headInfo.setPayBusiTypeStr(FscPayConfigBusiType.desc((String)po.getPayBusiType()));
                        }
                        headInfo.setTipsType("1");
                        this.initControlTips(po, (FscCreditControlTipsInfoBO)headInfo);
                    }
                }
            } else if (!CollectionUtils.isEmpty(warningConfigList)) {
                rspBo.setCurrentOrgControlStatus(FscPayConfigControlStatus.WARNING.getCode());
                rspBo.setCurrentOrgControlStatusStr(FscPayConfigControlStatus.WARNING.getDesc());
                if ("1".equals(reqBo.getTipsFlag()) || "2".equals(reqBo.getTipsFlag())) {
                    headInfo2 = new FscCreditControlTipsInfoBO();
                    headInfo2.setTitleText("\u60a8\u6240\u5728\u7684\u5355\u4f4d\u4ee5\u4e0b\u4e1a\u52a1\u903e\u671f\u60c5\u51b5\u9884\u8b66\uff1a");
                    headInfo2.setTitle("<span style='color:#FF9900;'>\u60a8\u6240\u5728\u7684\u5355\u4f4d</span>\u4ee5\u4e0b\u4e1a\u52a1\u903e\u671f\u60c5\u51b5<span style='color:#FF9900; font-size:18px;'>\u9884\u8b66</span>\uff1a");
                    headInfo2.setTitleWechat("<text style='color:#FF9900;'>\u60a8\u6240\u5728\u7684\u5355\u4f4d</text>\u4ee5\u4e0b\u4e1a\u52a1\u903e\u671f\u60c5\u51b5<text style='color:#FF9900; font-size:36rpx;'>\u9884\u8b66</text>\uff1a");
                    headInfo2.setTipsType("1");
                    secondLevel = new ArrayList();
                    headInfo2.setTipsInfos(secondLevel);
                    tipsInfos.add(headInfo2);
                    for (FscPayConfigPO po : warningConfigList) {
                        FscCreditControlTipsInfoBO secondItem = new FscCreditControlTipsInfoBO();
                        String payBusiTypeStr = FscPayConfigBusiType.desc((String)po.getPayBusiType());
                        secondItem.setTitleText(StrUtil.format((CharSequence)"{}\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b ", (Object[])new Object[]{payBusiTypeStr}));
                        secondItem.setTitle(StrUtil.format((CharSequence)"<span style='color:#FF9900;'>{}</span>\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b ", (Object[])new Object[]{payBusiTypeStr}));
                        secondItem.setTitleWechat(StrUtil.format((CharSequence)"<text style='color:#FF9900;'>{}</text>\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b ", (Object[])new Object[]{payBusiTypeStr}));
                        secondItem.setPayBusiType(po.getPayBusiType());
                        secondItem.setPayBusiTypeStr(payBusiTypeStr);
                        String closeMsg = "\u5173\u505c\u4e0b\u5355";
                        if (FscPayConfigBusiType.FL.getCode().equals(po.getPayBusiType())) {
                            closeMsg = "\u5173\u95ed\u521b\u5efa\u6d3b\u52a8";
                        }
                        this.initWarningTips(po, secondItem, closeMsg);
                        secondLevel.add(secondItem);
                    }
                } else if ("3".equals(reqBo.getTipsFlag()) || "4".equals(reqBo.getTipsFlag()) || "5".equals(reqBo.getTipsFlag()) || "6".equals(reqBo.getTipsFlag())) {
                    for (FscPayConfigPO po : warningConfigList) {
                        headInfo = new FscCreditControlTipsInfoBO();
                        tipsInfos.add(headInfo);
                        if ("6".equals(reqBo.getTipsFlag())) {
                            headInfo.setTitleText("\u60a8\u6240\u5728\u7684\u5355\u4f4d\u7684\u5458\u5de5\u798f\u5229\u4e1a\u52a1\u903e\u671f\u60c5\u51b5\u9884\u8b66\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a");
                            headInfo.setTitle("<span style='color:#FF9900;'>\u60a8\u6240\u5728\u7684\u5355\u4f4d</span>\u7684<span style='color:#FF9900;'>\u5458\u5de5\u798f\u5229\u4e1a\u52a1</span>\u903e\u671f\u60c5\u51b5<span style='color:#FF9900; font-size:18px;'>\u9884\u8b66</span>\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a");
                            headInfo.setTitleWechat("<text style='color:#FF9900;'>\u60a8\u6240\u5728\u7684\u5355\u4f4d</text>\u7684<text style='color:#FF9900;'>\u5458\u5de5\u798f\u5229\u4e1a\u52a1</text>\u903e\u671f\u60c5\u51b5<text style='color:#FF9900; font-size:36rpx;'>\u9884\u8b66</text>\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a");
                            headInfo.setPayBusiType(FscPayConfigBusiType.FL.getCode());
                            headInfo.setPayBusiTypeStr("\u5458\u5de5\u798f\u5229\u4e1a\u52a1");
                        } else {
                            headInfo.setTitleText(StrUtil.format((CharSequence)"\u60a8\u6240\u5728\u7684\u5355\u4f4d{}\u903e\u671f\u60c5\u51b5\u9884\u8b66\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a", (Object[])new Object[]{FscPayConfigBusiType.desc((String)po.getPayBusiType())}));
                            headInfo.setTitle(StrUtil.format((CharSequence)"<span style='color:#FF9900;'>\u60a8\u6240\u5728\u7684\u5355\u4f4d{}</span>\u903e\u671f\u60c5\u51b5<span style='color:#FF9900; font-size:18px;'>\u9884\u8b66</span>\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a", (Object[])new Object[]{FscPayConfigBusiType.desc((String)po.getPayBusiType())}));
                            headInfo.setTitleWechat(StrUtil.format((CharSequence)"<text style='color:#FF9900;'>\u60a8\u6240\u5728\u7684\u5355\u4f4d{}</text>\u903e\u671f\u60c5\u51b5<text style='color:#FF9900; font-size:36rpx;'>\u9884\u8b66</text>\uff0c\u9884\u8b66\u539f\u56e0\u5982\u4e0b\uff1a", (Object[])new Object[]{FscPayConfigBusiType.desc((String)po.getPayBusiType())}));
                            headInfo.setPayBusiType(po.getPayBusiType());
                            headInfo.setPayBusiTypeStr(FscPayConfigBusiType.desc((String)po.getPayBusiType()));
                        }
                        headInfo.setTipsType("1");
                        String closeMsg = "\u5173\u505c\u4e0b\u5355";
                        if (FscPayConfigBusiType.FL.getCode().equals(po.getPayBusiType())) {
                            closeMsg = "\u5173\u95ed\u521b\u5efa\u6d3b\u52a8";
                        }
                        this.initWarningTips(po, (FscCreditControlTipsInfoBO)headInfo, closeMsg);
                    }
                }
            } else {
                log.error("\u673a\u6784\u6388\u4fe1\u7ba1\u63a7\u652f\u4ed8\u914d\u7f6e\u67e5\u8be2\u7ed3\u679c\u6ca1\u6709\u9884\u8b66\u548c\u7ba1\u63a7\uff0c\u8fd4\u56de\u6b63\u5e38.\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
                rspBo.setCurrentOrgControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
                rspBo.setCurrentOrgControlStatusStr(FscPayConfigControlStatus.NORMAL.getDesc());
            }
            if ("1".equals(reqBo.getNoControlFlag()) && (ptAgrConfig = (FscPayConfigPO)fscPayConfigList.stream().filter(i -> FscPayConfigBusiType.AGR_PT.getCode().equals(i.getPayBusiType())).findFirst().orElse(null)) != null && ptAgrConfig.getParentConfigId() != null) {
                FscPayConfigPO fscPayConfigNoControlAgrQry = new FscPayConfigPO();
                fscPayConfigNoControlAgrQry.setParentConfigId(ptAgrConfig.getParentConfigId());
                fscPayConfigNoControlAgrQry.setPayConfigType(FscPayConfigType.NO_CREDIT_AGR.getCode());
                List<Long> listNoControlAgrIds = this.fscPayConfigMapper.getListNoControlAgrIdById(fscPayConfigNoControlAgrQry);
                if (!CollectionUtils.isEmpty(listNoControlAgrIds)) {
                    rspBo.setNoControlAgrIdList(listNoControlAgrIds);
                }
            }
        } else {
            log.error("\u673a\u6784\u6388\u4fe1\u7ba1\u63a7\u652f\u4ed8\u914d\u7f6e\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8fd4\u56de\u6b63\u5e38.\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
            rspBo.setCurrentOrgControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
            rspBo.setCurrentOrgControlStatusStr(FscPayConfigControlStatus.NORMAL.getDesc());
        }
        rspBo.getTipsInfos().addAll(tipsInfos);
    }

    private void initControlTips(FscPayConfigPO po, FscCreditControlTipsInfoBO upItem) {
        upItem.setPayBusiType(po.getPayBusiType());
        upItem.setPayBusiTypeStr(FscPayConfigBusiType.desc((String)po.getPayBusiType()));
        upItem.setPaySubClass(po.getPaySubClass());
        upItem.setPaySubType(po.getPaySubType());
        List controlTagList = JSON.parseArray((String)po.getCurrentOrgControlTag(), String.class);
        if (!CollectionUtils.isEmpty((Collection)controlTagList)) {
            ArrayList<FscCreditControlTipsInfoBO> nextLevel = new ArrayList<FscCreditControlTipsInfoBO>();
            upItem.setTipsInfos(nextLevel);
            for (String controlTag : controlTagList) {
                FscCreditControlTipsInfoBO thirdItem = new FscCreditControlTipsInfoBO();
                nextLevel.add(thirdItem);
                if (FscPayCreditControlTag.CONTROL_QUOTA.getCode().equals(controlTag)) {
                    BigDecimal usedAmount = Optional.ofNullable(po.getUsedAmount()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal balanceAmount = Optional.ofNullable(po.getBalanceAmount()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal currentOverdueAmount = Optional.ofNullable(po.getCurrentOverdueAmount()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                    thirdItem.setTitleText(StrUtil.format((CharSequence)"\u5f53\u524d\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u4e3a {},\u5269\u4f59\u6388\u4fe1\u989d\u5ea6 {}\uff0c\u903e\u671f\u91d1\u989d {}", (Object[])new Object[]{usedAmount.toPlainString(), balanceAmount.toPlainString(), currentOverdueAmount.toPlainString()}));
                    thirdItem.setTitle(StrUtil.format((CharSequence)"\u5f53\u524d\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u4e3a {},\u5269\u4f59\u6388\u4fe1\u989d\u5ea6 {}\uff0c\u903e\u671f\u91d1\u989d {}", (Object[])new Object[]{usedAmount.toPlainString(), balanceAmount.toPlainString(), currentOverdueAmount.toPlainString()}));
                    thirdItem.setTitleWechat(StrUtil.format((CharSequence)"\u5f53\u524d\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u4e3a {},\u5269\u4f59\u6388\u4fe1\u989d\u5ea6 {}\uff0c\u903e\u671f\u91d1\u989d {}", (Object[])new Object[]{usedAmount.toPlainString(), balanceAmount.toPlainString(), currentOverdueAmount.toPlainString()}));
                    continue;
                }
                if (FscPayCreditControlTag.CONTROL_OVERDUE_RATIO.getCode().equals(controlTag)) {
                    BigDecimal overdueControlRatio = Optional.ofNullable(po.getOverdueControlRatio()).orElse(BigDecimal.ZERO).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal currentOverdueRatio = Optional.ofNullable(po.getCurrentOverdueRatio()).orElse(BigDecimal.ZERO).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                    thirdItem.setTitleText(StrUtil.format((CharSequence)"\u903e\u671f\u5360\u6bd4\u8d85\u8fc7\u9608\u503c {}%\uff0c\u5f53\u524d\u903e\u671f\u5360\u6bd4\u4e3a {}%", (Object[])new Object[]{overdueControlRatio.toPlainString(), currentOverdueRatio.toPlainString()}));
                    thirdItem.setTitle(StrUtil.format((CharSequence)"\u903e\u671f\u5360\u6bd4\u8d85\u8fc7\u9608\u503c {}%\uff0c\u5f53\u524d\u903e\u671f\u5360\u6bd4\u4e3a {}%", (Object[])new Object[]{overdueControlRatio.toPlainString(), currentOverdueRatio.toPlainString()}));
                    thirdItem.setTitleWechat(StrUtil.format((CharSequence)"\u903e\u671f\u5360\u6bd4\u8d85\u8fc7\u9608\u503c {}%\uff0c\u5f53\u524d\u903e\u671f\u5360\u6bd4\u4e3a {}%", (Object[])new Object[]{overdueControlRatio.toPlainString(), currentOverdueRatio.toPlainString()}));
                    continue;
                }
                if (!FscPayCreditControlTag.CONTROL_OVERDUE_INDEX.getCode().equals(controlTag)) continue;
                BigDecimal overdueControlIndex = Optional.ofNullable(po.getOverdueControlIndex()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                BigDecimal currentOverdueIndex = Optional.ofNullable(po.getCurrentOverdueIndex()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                thirdItem.setTitleText(StrUtil.format((CharSequence)"\u903e\u671f\u6307\u6570\u8d85\u8fc7\u9608\u503c {}\uff0c\u5f53\u524d\u903e\u671f\u6307\u6570\u4e3a {}", (Object[])new Object[]{overdueControlIndex.toPlainString(), currentOverdueIndex.toPlainString()}));
                thirdItem.setTitle(StrUtil.format((CharSequence)"\u903e\u671f\u6307\u6570\u8d85\u8fc7\u9608\u503c {}\uff0c\u5f53\u524d\u903e\u671f\u6307\u6570\u4e3a {}", (Object[])new Object[]{overdueControlIndex.toPlainString(), currentOverdueIndex.toPlainString()}));
                thirdItem.setTitleWechat(StrUtil.format((CharSequence)"\u903e\u671f\u6307\u6570\u8d85\u8fc7\u9608\u503c {}\uff0c\u5f53\u524d\u903e\u671f\u6307\u6570\u4e3a {}", (Object[])new Object[]{overdueControlIndex.toPlainString(), currentOverdueIndex.toPlainString()}));
            }
        }
    }

    private void initWarningTips(FscPayConfigPO po, FscCreditControlTipsInfoBO headInfo, String closeMsg) {
        headInfo.setPayBusiType(po.getPayBusiType());
        headInfo.setPayBusiTypeStr(FscPayConfigBusiType.desc((String)po.getPayBusiType()));
        headInfo.setPaySubClass(po.getPaySubClass());
        headInfo.setPaySubType(po.getPaySubType());
        List warningTagList = JSON.parseArray((String)po.getCurrentOrgWarningTag(), String.class);
        if (!CollectionUtils.isEmpty((Collection)warningTagList)) {
            ArrayList<FscCreditControlTipsInfoBO> secondLevel = new ArrayList<FscCreditControlTipsInfoBO>();
            headInfo.setTipsInfos(secondLevel);
            for (String warningTag : warningTagList) {
                FscCreditControlTipsInfoBO secondItem = new FscCreditControlTipsInfoBO();
                secondLevel.add(secondItem);
                if (FscPayCreditWarningTag.WARNING_QUOTA.getCode().equals(warningTag)) {
                    BigDecimal usedAmount = Optional.ofNullable(po.getUsedAmount()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal balanceAmount = Optional.ofNullable(po.getBalanceAmount()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal currentOverdueAmount = Optional.ofNullable(po.getCurrentOverdueAmount()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                    secondItem.setTitleText(StrUtil.format((CharSequence)"\u5f53\u524d\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u4e3a {}\uff0c\u5269\u4f59\u6388\u4fe1\u989d\u5ea6 {}\uff0c\u903e\u671f\u91d1\u989d {}", (Object[])new Object[]{usedAmount.toPlainString(), balanceAmount.toPlainString(), currentOverdueAmount.toPlainString()}));
                    secondItem.setTitle(StrUtil.format((CharSequence)"\u5f53\u524d\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u4e3a {}\uff0c\u5269\u4f59\u6388\u4fe1\u989d\u5ea6 {}\uff0c\u903e\u671f\u91d1\u989d {}", (Object[])new Object[]{usedAmount.toPlainString(), balanceAmount.toPlainString(), currentOverdueAmount.toPlainString()}));
                    secondItem.setTitleWechat(StrUtil.format((CharSequence)"\u5f53\u524d\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u4e3a {}\uff0c\u5269\u4f59\u6388\u4fe1\u989d\u5ea6 {}\uff0c\u903e\u671f\u91d1\u989d {}", (Object[])new Object[]{usedAmount.toPlainString(), balanceAmount.toPlainString(), currentOverdueAmount.toPlainString()}));
                    continue;
                }
                if (FscPayCreditWarningTag.WARNING_OVERDUE_RATIO.getCode().equals(warningTag)) {
                    BigDecimal currentOverdueRatio = Optional.ofNullable(po.getCurrentOverdueRatio()).orElse(BigDecimal.ZERO).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal overdueWarningRatio = Optional.ofNullable(po.getOverdueWarningRatio()).orElse(BigDecimal.ZERO).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal overdueControlRatio = Optional.ofNullable(po.getOverdueControlRatio()).orElse(BigDecimal.ZERO).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                    secondItem.setTitleText(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u5360\u6bd4\u4e3a {}%\uff0c\u5982\u679c\u8d85\u8fc7 {}%\uff0c\u5c06{}\u6743\u9650", (Object[])new Object[]{currentOverdueRatio.toPlainString(), overdueControlRatio.toPlainString(), closeMsg}));
                    secondItem.setTitle(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u5360\u6bd4\u4e3a {}%\uff0c\u5982\u679c\u8d85\u8fc7 {}%\uff0c\u5c06{}\u6743\u9650", (Object[])new Object[]{currentOverdueRatio.toPlainString(), overdueControlRatio.toPlainString(), closeMsg}));
                    secondItem.setTitleWechat(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u5360\u6bd4\u4e3a {}%\uff0c\u5982\u679c\u8d85\u8fc7 {}%\uff0c\u5c06{}\u6743\u9650", (Object[])new Object[]{currentOverdueRatio.toPlainString(), overdueControlRatio.toPlainString(), closeMsg}));
                    continue;
                }
                if (!FscPayCreditWarningTag.WARNING_OVERDUE_INDEX.getCode().equals(warningTag)) continue;
                BigDecimal currentOverdueIndex = Optional.ofNullable(po.getCurrentOverdueIndex()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                BigDecimal overdueControlIndex = Optional.ofNullable(po.getOverdueControlIndex()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                BigDecimal overdueWarningIndex = Optional.ofNullable(po.getOverdueWarningIndex()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                secondItem.setTitleText(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u6307\u6570\u4e3a {}\uff0c\u5982\u679c\u8d85\u8fc7 {}\uff0c\u5c06{}\u6743\u9650", (Object[])new Object[]{currentOverdueIndex.toPlainString(), overdueControlIndex.toPlainString(), closeMsg}));
                secondItem.setTitle(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u6307\u6570\u4e3a {}\uff0c\u5982\u679c\u8d85\u8fc7 {}\uff0c\u5c06{}\u6743\u9650", (Object[])new Object[]{currentOverdueIndex.toPlainString(), overdueControlIndex.toPlainString(), closeMsg}));
                secondItem.setTitleWechat(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u6307\u6570\u4e3a {}\uff0c\u5982\u679c\u8d85\u8fc7 {}\uff0c\u5c06{}\u6743\u9650", (Object[])new Object[]{currentOverdueIndex.toPlainString(), overdueControlIndex.toPlainString(), closeMsg}));
            }
        }
    }

    private FscUserOverdueControlConfigPO getFscUserOverdueControlConfigPo(FscCreditControlTipsQryAbilityReqBO reqBo) {
        FscUserOverdueControlConfigPO modelBy;
        if (YesNo.YES.getCode().equals(this.fscCreditControlTipsUseRedisFlag)) {
            String key = "TipsUseRedisUser_" + reqBo.getUserId();
            String fscUserOverdueControlConfigJson = (String)this.cacheClient.get(key, String.class);
            log.debug("\u7528\u6237\u6388\u4fe1\u7ba1\u63a7redis\u67e5\u8be2key\uff1a{}.value:{}", (Object)key, (Object)fscUserOverdueControlConfigJson);
            if (StringUtils.hasText((String)fscUserOverdueControlConfigJson)) {
                FscUserOverdueControlConfigPO modelBy2 = (FscUserOverdueControlConfigPO)JSON.parseObject((String)fscUserOverdueControlConfigJson, FscUserOverdueControlConfigPO.class);
                return modelBy2;
            }
        }
        FscUserOverdueControlConfigPO fscUserOverdueControlConfigQry = new FscUserOverdueControlConfigPO();
        fscUserOverdueControlConfigQry.setConfigUserId(reqBo.getUserId());
        try {
            modelBy = this.fscUserOverdueControlConfigMapper.getUserOverdueControlConfig(fscUserOverdueControlConfigQry);
            List roleList = reqBo.getPermission().stream().map(AuthorityInfo::getKey).filter(Objects::nonNull).collect(Collectors.toList());
            if (modelBy == null && roleList.contains("002")) {
                FscUserOverdueStatisticsPO statisticsPo = new FscUserOverdueStatisticsPO();
                statisticsPo.setConfigUserId(reqBo.getUserId());
                int checkBy = this.fscUserOverdueStatisticsMapper.getCheckBy(statisticsPo);
                if (checkBy < 1) {
                    FscOrderCheckUserControlConfigAbilityReqBO checkUserConfigAbilityReqBo = new FscOrderCheckUserControlConfigAbilityReqBO();
                    checkUserConfigAbilityReqBo.setUmcLoginAccount(reqBo.getUserId().toString());
                    this.fscOrderCheckUserControlConfigAbilityService.dealOrderCheckUserControlConfig(checkUserConfigAbilityReqBo);
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7528\u6237\u903e\u671f\u7ba1\u63a7\u6570\u636e\u5f02\u5e38:{}", (Object)e.toString());
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u7528\u6237\u903e\u671f\u7ba1\u63a7\u6570\u636e\u5f02\u5e38");
        }
        if (YesNo.YES.getCode().equals(this.fscCreditControlTipsUseRedisFlag) && modelBy != null) {
            String key = "TipsUseRedisUser_" + reqBo.getUserId();
            log.debug("\u5237\u65b0\u7528\u6237\u6388\u4fe1\u7ba1\u63a7redis\uff1a{}", (Object)key);
            this.cacheClient.set(key, (Object)JSON.toJSONString((Object)modelBy));
        }
        return modelBy;
    }

    private List<FscPayConfigPO> getListFscPayConfig(FscCreditControlTipsQryAbilityReqBO reqBo) {
        ArrayList<FscPayConfigPO> fscPayConfigList = new ArrayList<FscPayConfigPO>();
        Long payOrgId = reqBo.getOrgId();
        if ("03".equals(reqBo.getOrgTypeIn())) {
            payOrgId = reqBo.getCompanyId();
        }
        if (YesNo.YES.getCode().equals(this.fscCreditControlTipsUseRedisFlag)) {
            List fscPayConfigPos;
            String key = "TipsUseRedisCompany_" + payOrgId;
            String fscPayConfigJson = (String)this.cacheClient.get(key, String.class);
            log.debug("\u673a\u6784\u6388\u4fe1\u7ba1\u63a7redis\u67e5\u8be2key\uff1a{}.value:{}", (Object)key, (Object)fscPayConfigJson);
            if (StringUtils.hasText((String)fscPayConfigJson) && !CollectionUtils.isEmpty((Collection)(fscPayConfigPos = JSON.parseArray((String)fscPayConfigJson, FscPayConfigPO.class)))) {
                List<String> payConfigTypeList = Arrays.asList(FscPayConfigType.EXT_ORG.getCode(), FscPayConfigType.DEF.getCode());
                fscPayConfigList.addAll(fscPayConfigPos.stream().filter(i -> payConfigTypeList.contains(i.getPayConfigType())).filter(i -> {
                    if (!CollectionUtils.isEmpty((Collection)reqBo.getPayBusiTypeList())) {
                        return reqBo.getPayBusiTypeList().contains(i.getPayBusiType());
                    }
                    return true;
                }).collect(Collectors.toList()));
            }
        } else {
            FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
            fscPayConfigQry.setPayOrgId(payOrgId);
            fscPayConfigQry.setPayBusiTypeList(reqBo.getPayBusiTypeList());
            fscPayConfigQry.setPayConfigTypeList(Arrays.asList(FscPayConfigType.EXT_ORG.getCode(), FscPayConfigType.DEF.getCode()));
            fscPayConfigList.addAll(this.fscPayConfigMapper.getList(fscPayConfigQry));
        }
        return fscPayConfigList;
    }
}

